/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.decoder;

import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder.TrailerDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;

public interface HopGrpDecoder {
    public int noHopsGroupCounter();

    public boolean hasNoHopsGroupCounter();

    public HopsGroupDecoder hopsGroup();

    public static class HopsGroupDecoder
    implements Decoder {
        public final IntHashSet REQUIRED_FIELDS = new IntHashSet(0);
        private final IntHashSet missingRequiredFields;
        private int invalidTagId;
        private int rejectReason;
        private final TrailerDecoder trailer;
        private final IntHashSet messageFields;
        private HopsGroupDecoder next;
        private IntHashSet seenFields;
        private char[] hopCompID;
        private boolean hasHopCompID;
        private int hopCompIDLength;
        private int hopCompIDOffset;
        private byte[] hopSendingTime;
        private boolean hasHopSendingTime;
        private int hopSendingTimeLength;
        private int hopSendingTimeOffset;
        private int hopRefID;
        private boolean hasHopRefID;
        private AsciiBuffer buffer;

        public int invalidTagId() {
            return this.invalidTagId;
        }

        public int rejectReason() {
            return this.rejectReason;
        }

        public boolean validate() {
            if (this.rejectReason != -1) {
                return false;
            }
            IntHashSet.IntIterator missingFieldsIterator = this.missingRequiredFields.iterator();
            if (missingFieldsIterator.hasNext()) {
                this.invalidTagId = missingFieldsIterator.nextValue();
                this.rejectReason = 1;
                return false;
            }
            return true;
        }

        public HopsGroupDecoder(TrailerDecoder trailer, IntHashSet messageFields) {
            if (Validation.CODEC_VALIDATION_ENABLED) {
                // empty if block
            }
            this.missingRequiredFields = new IntHashSet(0);
            this.invalidTagId = -1;
            this.rejectReason = -1;
            this.next = null;
            this.seenFields = new IntHashSet(6);
            this.hopCompID = new char[1];
            this.hopSendingTime = new byte[24];
            this.trailer = trailer;
            this.messageFields = messageFields;
        }

        public HopsGroupDecoder next() {
            return this.next;
        }

        public char[] hopCompID() {
            if (!this.hasHopCompID) {
                throw new IllegalArgumentException("No value for optional field: HopCompID");
            }
            return this.hopCompID;
        }

        public boolean hasHopCompID() {
            return this.hasHopCompID;
        }

        public int hopCompIDLength() {
            if (!this.hasHopCompID) {
                throw new IllegalArgumentException("No value for optional field: HopCompID");
            }
            return this.hopCompIDLength;
        }

        public String hopCompIDAsString() {
            return this.hasHopCompID ? new String(this.hopCompID, 0, this.hopCompIDLength) : null;
        }

        public void hopCompID(AsciiSequenceView view) {
            if (!this.hasHopCompID) {
                throw new IllegalArgumentException("No value for optional field: HopCompID");
            }
            view.wrap((DirectBuffer)this.buffer, this.hopCompIDOffset, this.hopCompIDLength);
        }

        public byte[] hopSendingTime() {
            if (!this.hasHopSendingTime) {
                throw new IllegalArgumentException("No value for optional field: HopSendingTime");
            }
            return this.hopSendingTime;
        }

        public boolean hasHopSendingTime() {
            return this.hasHopSendingTime;
        }

        public int hopSendingTimeLength() {
            if (!this.hasHopSendingTime) {
                throw new IllegalArgumentException("No value for optional field: HopSendingTime");
            }
            return this.hopSendingTimeLength;
        }

        public String hopSendingTimeAsString() {
            return this.hasHopSendingTime ? new String(this.hopSendingTime, 0, this.hopSendingTimeLength) : null;
        }

        public void hopSendingTime(AsciiSequenceView view) {
            if (!this.hasHopSendingTime) {
                throw new IllegalArgumentException("No value for optional field: HopSendingTime");
            }
            view.wrap((DirectBuffer)this.buffer, this.hopSendingTimeOffset, this.hopSendingTimeLength);
        }

        public int hopRefID() {
            if (!this.hasHopRefID) {
                throw new IllegalArgumentException("No value for optional field: HopRefID");
            }
            return this.hopRefID;
        }

        public boolean hasHopRefID() {
            return this.hasHopRefID;
        }

        public int decode(AsciiBuffer buffer, int offset, int length) {
            int seenFieldCount = 0;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                this.missingRequiredFields.copy(this.REQUIRED_FIELDS);
            }
            this.buffer = buffer;
            int end = offset + length;
            int position = offset;
            this.seenFields.clear();
            while (position < end) {
                int equalsPosition = buffer.scan(position, end, '=');
                int tag = buffer.getInt(position, equalsPosition);
                if (!this.seenFields.add(tag)) {
                    if (this.next == null) {
                        this.next = new HopsGroupDecoder(this.trailer, this.messageFields);
                    }
                    return position - offset;
                }
                int valueOffset = equalsPosition + 1;
                int endOfField = buffer.scan(valueOffset, end, (byte)1);
                int valueLength = endOfField - valueOffset;
                if (Validation.CODEC_VALIDATION_ENABLED) {
                    if (tag <= 0) {
                        this.invalidTagId = tag;
                        this.rejectReason = 0;
                    } else if (valueLength == 0) {
                        this.invalidTagId = tag;
                        this.rejectReason = 4;
                    }
                    this.missingRequiredFields.remove(tag);
                    ++seenFieldCount;
                }
                switch (tag) {
                    case 628: {
                        this.hasHopCompID = true;
                        this.hopCompID = buffer.getChars(this.hopCompID, valueOffset, valueLength);
                        this.hopCompIDOffset = valueOffset;
                        this.hopCompIDLength = valueLength;
                        break;
                    }
                    case 629: {
                        this.hasHopSendingTime = true;
                        this.hopSendingTime = buffer.getBytes(this.hopSendingTime, valueOffset, valueLength);
                        this.hopSendingTimeOffset = valueOffset;
                        this.hopSendingTimeLength = valueLength;
                        break;
                    }
                    case 630: {
                        this.hasHopRefID = true;
                        this.hopRefID = buffer.getInt(valueOffset, endOfField);
                        break;
                    }
                    default: {
                        if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                            this.seenFields.remove(tag);
                        }
                        if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && !this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) break;
                        return position - offset;
                    }
                }
                if (position >= endOfField + 1) continue;
                position = endOfField + 1;
            }
            return position - offset;
        }

        public void reset() {
            this.resetHopCompID();
            this.resetHopSendingTime();
            this.resetHopRefID();
            if (Validation.CODEC_VALIDATION_ENABLED) {
                this.invalidTagId = -1;
                this.rejectReason = -1;
                this.missingRequiredFields.clear();
            }
        }

        public void resetHopCompID() {
            this.hasHopCompID = false;
        }

        public void resetHopSendingTime() {
            this.hasHopSendingTime = false;
        }

        public void resetHopRefID() {
            this.hasHopRefID = false;
        }

        public String toString() {
            String entries = (this.hasHopCompID() ? String.format("  \"HopCompID\": \"%s\",\n", new String(this.hopCompID, 0, this.hopCompIDLength)) : "") + (this.hasHopSendingTime() ? String.format("  \"HopSendingTime\": \"%s\",\n", new String(this.hopSendingTime, 0, this.hopSendingTimeLength)) : "") + (this.hasHopRefID() ? String.format("  \"HopRefID\": \"%s\",\n", this.hopRefID) : "");
            entries = "{\n  \"MessageName\": \"HopsGroup\",\n" + entries + "}";
            if (this.next != null) {
                entries = entries + ",\n" + this.next.toString();
            }
            return entries;
        }
    }
}

