/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class TrailerEncoder {
    private static final int signatureLengthHeaderLength = 3;
    private static final byte[] signatureLengthHeader = new byte[]{57, 51, 61};
    private static final int signatureHeaderLength = 3;
    private static final byte[] signatureHeader = new byte[]{56, 57, 61};
    private static final int checkSumHeaderLength = 3;
    private static final byte[] checkSumHeader = new byte[]{49, 48, 61};
    private int signatureLength;
    private boolean hasSignatureLength;
    private byte[] signature;
    private boolean hasSignature;
    private byte[] checkSum = new byte[1];
    private int checkSumOffset = 0;
    private int checkSumLength = 0;
    public static final byte[] HEADER_PREFIX_STRING = "8=FIXT.1.1\u00019=".getBytes(StandardCharsets.US_ASCII);
    int realStart;

    public boolean hasSignatureLength() {
        return this.hasSignatureLength;
    }

    public TrailerEncoder signatureLength(int value) {
        this.signatureLength = value;
        this.hasSignatureLength = true;
        return this;
    }

    public int signatureLength() {
        return this.signatureLength;
    }

    public boolean hasSignature() {
        return this.hasSignature;
    }

    public TrailerEncoder signature(byte[] value) {
        this.signature = value;
        this.hasSignature = true;
        return this;
    }

    public byte[] signature() {
        return this.signature;
    }

    public TrailerEncoder checkSum(byte[] value, int length) {
        this.checkSum = value;
        this.checkSumOffset = 0;
        this.checkSumLength = length;
        return this;
    }

    public TrailerEncoder checkSum(byte[] value, int offset, int length) {
        this.checkSum = value;
        this.checkSumOffset = offset;
        this.checkSumLength = length;
        return this;
    }

    public TrailerEncoder checkSum(byte[] value) {
        return this.checkSum(value, value.length);
    }

    public boolean hasCheckSum() {
        return this.checkSumLength > 0;
    }

    public byte[] checkSum() {
        return this.checkSum;
    }

    public TrailerEncoder checkSum(CharSequence value) {
        this.checkSum = CodecUtil.toBytes((CharSequence)value, (byte[])this.checkSum);
        this.checkSumOffset = 0;
        this.checkSumLength = value.length();
        return this;
    }

    public TrailerEncoder checkSum(char[] value) {
        return this.checkSum(value, value.length);
    }

    public TrailerEncoder checkSum(char[] value, int length) {
        this.checkSum = CodecUtil.toBytes((char[])value, (byte[])this.checkSum, (int)length);
        this.checkSumOffset = 0;
        this.checkSumLength = length;
        return this;
    }

    public TrailerEncoder checkSum(char[] value, int offset, int length) {
        this.checkSum = CodecUtil.toBytes((char[])value, (byte[])this.checkSum, (int)offset, (int)length);
        this.checkSumOffset = 0;
        this.checkSumLength = length;
        return this;
    }

    public int realStart() {
        return this.realStart;
    }

    public int encode(MutableAsciiBuffer buffer, int offset, int bodyStart) {
        int realStart;
        int position = offset;
        if (this.hasSignatureLength) {
            buffer.putBytes(position, signatureLengthHeader, 0, 3);
            position += 3;
            position += buffer.putAsciiInt(position, this.signatureLength);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasSignature) {
            buffer.putBytes(position, signatureHeader, 0, 3);
            buffer.putBytes(position += 3, this.signature);
            buffer.putSeparator(position += this.signature.length);
            ++position;
        }
        int bodyLength = position - bodyStart;
        buffer.putSeparator(bodyStart - 1);
        int bodyLengthStart = buffer.putNaturalFromEnd(bodyLength, bodyStart - 1);
        this.realStart = realStart = bodyLengthStart - HEADER_PREFIX_STRING.length;
        buffer.putBytes(realStart, HEADER_PREFIX_STRING);
        buffer.putBytes(position, checkSumHeader, 0, 3);
        int checkSum = buffer.computeChecksum(realStart, (position += 3) - 3);
        buffer.putNatural(position, 3, checkSum);
        buffer.putSeparator(position += 3);
        return ++position - offset;
    }

    public void reset() {
        this.resetSignatureLength();
        this.resetSignature();
    }

    public void resetSignatureLength() {
        this.hasSignatureLength = false;
    }

    public void resetSignature() {
        this.hasSignature = false;
    }

    public String toString() {
        String entries = (this.hasSignatureLength() ? String.format("  \"SignatureLength\": \"%s\",\n", this.signatureLength) : "") + (this.hasSignature() ? String.format("  \"Signature\": \"%s\",\n", Arrays.toString(this.signature)) : "") + (this.hasCheckSum() ? String.format("  \"CheckSum\": \"%s\",\n", new String(this.checkSum, this.checkSumOffset, this.checkSumLength, StandardCharsets.US_ASCII)) : "");
        entries = "{\n  \"MessageName\": \"Trailer\",\n" + entries + "}";
        return entries;
    }
}

