/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.co.real_logic.artio.ApplVerID;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.MsgType;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class HeaderEncoder {
    private static final int beginStringHeaderLength = 2;
    private static final byte[] beginStringHeader = new byte[]{56, 61};
    private static final int msgTypeHeaderLength = 3;
    private static final byte[] msgTypeHeader = new byte[]{51, 53, 61};
    private static final int applVerIDHeaderLength = 5;
    private static final byte[] applVerIDHeader = new byte[]{49, 49, 50, 56, 61};
    private static final int applExtIDHeaderLength = 5;
    private static final byte[] applExtIDHeader = new byte[]{49, 49, 53, 54, 61};
    private static final int cstmApplVerIDHeaderLength = 5;
    private static final byte[] cstmApplVerIDHeader = new byte[]{49, 49, 50, 57, 61};
    private static final int senderCompIDHeaderLength = 3;
    private static final byte[] senderCompIDHeader = new byte[]{52, 57, 61};
    private static final int targetCompIDHeaderLength = 3;
    private static final byte[] targetCompIDHeader = new byte[]{53, 54, 61};
    private static final int onBehalfOfCompIDHeaderLength = 4;
    private static final byte[] onBehalfOfCompIDHeader = new byte[]{49, 49, 53, 61};
    private static final int deliverToCompIDHeaderLength = 4;
    private static final byte[] deliverToCompIDHeader = new byte[]{49, 50, 56, 61};
    private static final int secureDataLenHeaderLength = 3;
    private static final byte[] secureDataLenHeader = new byte[]{57, 48, 61};
    private static final int secureDataHeaderLength = 3;
    private static final byte[] secureDataHeader = new byte[]{57, 49, 61};
    private static final int msgSeqNumHeaderLength = 3;
    private static final byte[] msgSeqNumHeader = new byte[]{51, 52, 61};
    private static final int senderSubIDHeaderLength = 3;
    private static final byte[] senderSubIDHeader = new byte[]{53, 48, 61};
    private static final int senderLocationIDHeaderLength = 4;
    private static final byte[] senderLocationIDHeader = new byte[]{49, 52, 50, 61};
    private static final int targetSubIDHeaderLength = 3;
    private static final byte[] targetSubIDHeader = new byte[]{53, 55, 61};
    private static final int targetLocationIDHeaderLength = 4;
    private static final byte[] targetLocationIDHeader = new byte[]{49, 52, 51, 61};
    private static final int onBehalfOfSubIDHeaderLength = 4;
    private static final byte[] onBehalfOfSubIDHeader = new byte[]{49, 49, 54, 61};
    private static final int onBehalfOfLocationIDHeaderLength = 4;
    private static final byte[] onBehalfOfLocationIDHeader = new byte[]{49, 52, 52, 61};
    private static final int deliverToSubIDHeaderLength = 4;
    private static final byte[] deliverToSubIDHeader = new byte[]{49, 50, 57, 61};
    private static final int deliverToLocationIDHeaderLength = 4;
    private static final byte[] deliverToLocationIDHeader = new byte[]{49, 52, 53, 61};
    private static final int possDupFlagHeaderLength = 3;
    private static final byte[] possDupFlagHeader = new byte[]{52, 51, 61};
    private static final int possResendHeaderLength = 3;
    private static final byte[] possResendHeader = new byte[]{57, 55, 61};
    private static final int sendingTimeHeaderLength = 3;
    private static final byte[] sendingTimeHeader = new byte[]{53, 50, 61};
    private static final int origSendingTimeHeaderLength = 4;
    private static final byte[] origSendingTimeHeader = new byte[]{49, 50, 50, 61};
    private static final int xmlDataLenHeaderLength = 4;
    private static final byte[] xmlDataLenHeader = new byte[]{50, 49, 50, 61};
    private static final int xmlDataHeaderLength = 4;
    private static final byte[] xmlDataHeader = new byte[]{50, 49, 51, 61};
    private static final int messageEncodingHeaderLength = 4;
    private static final byte[] messageEncodingHeader = new byte[]{51, 52, 55, 61};
    private static final int lastMsgSeqNumProcessedHeaderLength = 4;
    private static final byte[] lastMsgSeqNumProcessedHeader = new byte[]{51, 54, 57, 61};
    private byte[] beginString = new byte[1];
    private int beginStringOffset = 0;
    private int beginStringLength = 0;
    private byte[] msgType = new byte[1];
    private int msgTypeOffset = 0;
    private int msgTypeLength = 0;
    private byte[] applVerID = new byte[1];
    private int applVerIDOffset = 0;
    private int applVerIDLength = 0;
    private int applExtID;
    private boolean hasApplExtID;
    private byte[] cstmApplVerID = new byte[1];
    private int cstmApplVerIDOffset = 0;
    private int cstmApplVerIDLength = 0;
    private byte[] senderCompID = new byte[1];
    private int senderCompIDOffset = 0;
    private int senderCompIDLength = 0;
    private byte[] targetCompID = new byte[1];
    private int targetCompIDOffset = 0;
    private int targetCompIDLength = 0;
    private byte[] onBehalfOfCompID = new byte[1];
    private int onBehalfOfCompIDOffset = 0;
    private int onBehalfOfCompIDLength = 0;
    private byte[] deliverToCompID = new byte[1];
    private int deliverToCompIDOffset = 0;
    private int deliverToCompIDLength = 0;
    private int secureDataLen;
    private boolean hasSecureDataLen;
    private byte[] secureData;
    private boolean hasSecureData;
    private int msgSeqNum;
    private boolean hasMsgSeqNum;
    private byte[] senderSubID = new byte[1];
    private int senderSubIDOffset = 0;
    private int senderSubIDLength = 0;
    private byte[] senderLocationID = new byte[1];
    private int senderLocationIDOffset = 0;
    private int senderLocationIDLength = 0;
    private byte[] targetSubID = new byte[1];
    private int targetSubIDOffset = 0;
    private int targetSubIDLength = 0;
    private byte[] targetLocationID = new byte[1];
    private int targetLocationIDOffset = 0;
    private int targetLocationIDLength = 0;
    private byte[] onBehalfOfSubID = new byte[1];
    private int onBehalfOfSubIDOffset = 0;
    private int onBehalfOfSubIDLength = 0;
    private byte[] onBehalfOfLocationID = new byte[1];
    private int onBehalfOfLocationIDOffset = 0;
    private int onBehalfOfLocationIDLength = 0;
    private byte[] deliverToSubID = new byte[1];
    private int deliverToSubIDOffset = 0;
    private int deliverToSubIDLength = 0;
    private byte[] deliverToLocationID = new byte[1];
    private int deliverToLocationIDOffset = 0;
    private int deliverToLocationIDLength = 0;
    private boolean possDupFlag;
    private boolean hasPossDupFlag;
    private boolean possResend;
    private boolean hasPossResend;
    private byte[] sendingTime = new byte[1];
    private int sendingTimeOffset = 0;
    private int sendingTimeLength = 0;
    private byte[] origSendingTime = new byte[1];
    private int origSendingTimeOffset = 0;
    private int origSendingTimeLength = 0;
    private int xmlDataLen;
    private boolean hasXmlDataLen;
    private byte[] xmlData;
    private boolean hasXmlData;
    private byte[] messageEncoding = new byte[1];
    private int messageEncodingOffset = 0;
    private int messageEncodingLength = 0;
    private int lastMsgSeqNumProcessed;
    private boolean hasLastMsgSeqNumProcessed;

    public HeaderEncoder beginString(byte[] value, int length) {
        this.beginString = value;
        this.beginStringOffset = 0;
        this.beginStringLength = length;
        return this;
    }

    public HeaderEncoder beginString(byte[] value, int offset, int length) {
        this.beginString = value;
        this.beginStringOffset = offset;
        this.beginStringLength = length;
        return this;
    }

    public HeaderEncoder beginString(byte[] value) {
        return this.beginString(value, value.length);
    }

    public boolean hasBeginString() {
        return this.beginStringLength > 0;
    }

    public byte[] beginString() {
        return this.beginString;
    }

    public HeaderEncoder beginString(CharSequence value) {
        this.beginString = CodecUtil.toBytes((CharSequence)value, (byte[])this.beginString);
        this.beginStringOffset = 0;
        this.beginStringLength = value.length();
        return this;
    }

    public HeaderEncoder beginString(char[] value) {
        return this.beginString(value, value.length);
    }

    public HeaderEncoder beginString(char[] value, int length) {
        this.beginString = CodecUtil.toBytes((char[])value, (byte[])this.beginString, (int)length);
        this.beginStringOffset = 0;
        this.beginStringLength = length;
        return this;
    }

    public HeaderEncoder beginString(char[] value, int offset, int length) {
        this.beginString = CodecUtil.toBytes((char[])value, (byte[])this.beginString, (int)offset, (int)length);
        this.beginStringOffset = 0;
        this.beginStringLength = length;
        return this;
    }

    public HeaderEncoder msgType(byte[] value, int length) {
        this.msgType = value;
        this.msgTypeOffset = 0;
        this.msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgType(byte[] value, int offset, int length) {
        this.msgType = value;
        this.msgTypeOffset = offset;
        this.msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgType(byte[] value) {
        return this.msgType(value, value.length);
    }

    public boolean hasMsgType() {
        return this.msgTypeLength > 0;
    }

    public byte[] msgType() {
        return this.msgType;
    }

    public HeaderEncoder msgType(CharSequence value) {
        this.msgType = CodecUtil.toBytes((CharSequence)value, (byte[])this.msgType);
        this.msgTypeOffset = 0;
        this.msgTypeLength = value.length();
        return this;
    }

    public HeaderEncoder msgType(char[] value) {
        return this.msgType(value, value.length);
    }

    public HeaderEncoder msgType(char[] value, int length) {
        this.msgType = CodecUtil.toBytes((char[])value, (byte[])this.msgType, (int)length);
        this.msgTypeOffset = 0;
        this.msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgType(char[] value, int offset, int length) {
        this.msgType = CodecUtil.toBytes((char[])value, (byte[])this.msgType, (int)offset, (int)length);
        this.msgTypeOffset = 0;
        this.msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgType(MsgType value) {
        return this.msgType(value.representation());
    }

    public HeaderEncoder applVerID(byte[] value, int length) {
        this.applVerID = value;
        this.applVerIDOffset = 0;
        this.applVerIDLength = length;
        return this;
    }

    public HeaderEncoder applVerID(byte[] value, int offset, int length) {
        this.applVerID = value;
        this.applVerIDOffset = offset;
        this.applVerIDLength = length;
        return this;
    }

    public HeaderEncoder applVerID(byte[] value) {
        return this.applVerID(value, value.length);
    }

    public boolean hasApplVerID() {
        return this.applVerIDLength > 0;
    }

    public byte[] applVerID() {
        return this.applVerID;
    }

    public HeaderEncoder applVerID(CharSequence value) {
        this.applVerID = CodecUtil.toBytes((CharSequence)value, (byte[])this.applVerID);
        this.applVerIDOffset = 0;
        this.applVerIDLength = value.length();
        return this;
    }

    public HeaderEncoder applVerID(char[] value) {
        return this.applVerID(value, value.length);
    }

    public HeaderEncoder applVerID(char[] value, int length) {
        this.applVerID = CodecUtil.toBytes((char[])value, (byte[])this.applVerID, (int)length);
        this.applVerIDOffset = 0;
        this.applVerIDLength = length;
        return this;
    }

    public HeaderEncoder applVerID(char[] value, int offset, int length) {
        this.applVerID = CodecUtil.toBytes((char[])value, (byte[])this.applVerID, (int)offset, (int)length);
        this.applVerIDOffset = 0;
        this.applVerIDLength = length;
        return this;
    }

    public HeaderEncoder applVerID(ApplVerID value) {
        return this.applVerID(value.representation());
    }

    public boolean hasApplExtID() {
        return this.hasApplExtID;
    }

    public HeaderEncoder applExtID(int value) {
        this.applExtID = value;
        this.hasApplExtID = true;
        return this;
    }

    public int applExtID() {
        return this.applExtID;
    }

    public HeaderEncoder cstmApplVerID(byte[] value, int length) {
        this.cstmApplVerID = value;
        this.cstmApplVerIDOffset = 0;
        this.cstmApplVerIDLength = length;
        return this;
    }

    public HeaderEncoder cstmApplVerID(byte[] value, int offset, int length) {
        this.cstmApplVerID = value;
        this.cstmApplVerIDOffset = offset;
        this.cstmApplVerIDLength = length;
        return this;
    }

    public HeaderEncoder cstmApplVerID(byte[] value) {
        return this.cstmApplVerID(value, value.length);
    }

    public boolean hasCstmApplVerID() {
        return this.cstmApplVerIDLength > 0;
    }

    public byte[] cstmApplVerID() {
        return this.cstmApplVerID;
    }

    public HeaderEncoder cstmApplVerID(CharSequence value) {
        this.cstmApplVerID = CodecUtil.toBytes((CharSequence)value, (byte[])this.cstmApplVerID);
        this.cstmApplVerIDOffset = 0;
        this.cstmApplVerIDLength = value.length();
        return this;
    }

    public HeaderEncoder cstmApplVerID(char[] value) {
        return this.cstmApplVerID(value, value.length);
    }

    public HeaderEncoder cstmApplVerID(char[] value, int length) {
        this.cstmApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.cstmApplVerID, (int)length);
        this.cstmApplVerIDOffset = 0;
        this.cstmApplVerIDLength = length;
        return this;
    }

    public HeaderEncoder cstmApplVerID(char[] value, int offset, int length) {
        this.cstmApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.cstmApplVerID, (int)offset, (int)length);
        this.cstmApplVerIDOffset = 0;
        this.cstmApplVerIDLength = length;
        return this;
    }

    public HeaderEncoder senderCompID(byte[] value, int length) {
        this.senderCompID = value;
        this.senderCompIDOffset = 0;
        this.senderCompIDLength = length;
        return this;
    }

    public HeaderEncoder senderCompID(byte[] value, int offset, int length) {
        this.senderCompID = value;
        this.senderCompIDOffset = offset;
        this.senderCompIDLength = length;
        return this;
    }

    public HeaderEncoder senderCompID(byte[] value) {
        return this.senderCompID(value, value.length);
    }

    public boolean hasSenderCompID() {
        return this.senderCompIDLength > 0;
    }

    public byte[] senderCompID() {
        return this.senderCompID;
    }

    public HeaderEncoder senderCompID(CharSequence value) {
        this.senderCompID = CodecUtil.toBytes((CharSequence)value, (byte[])this.senderCompID);
        this.senderCompIDOffset = 0;
        this.senderCompIDLength = value.length();
        return this;
    }

    public HeaderEncoder senderCompID(char[] value) {
        return this.senderCompID(value, value.length);
    }

    public HeaderEncoder senderCompID(char[] value, int length) {
        this.senderCompID = CodecUtil.toBytes((char[])value, (byte[])this.senderCompID, (int)length);
        this.senderCompIDOffset = 0;
        this.senderCompIDLength = length;
        return this;
    }

    public HeaderEncoder senderCompID(char[] value, int offset, int length) {
        this.senderCompID = CodecUtil.toBytes((char[])value, (byte[])this.senderCompID, (int)offset, (int)length);
        this.senderCompIDOffset = 0;
        this.senderCompIDLength = length;
        return this;
    }

    public HeaderEncoder targetCompID(byte[] value, int length) {
        this.targetCompID = value;
        this.targetCompIDOffset = 0;
        this.targetCompIDLength = length;
        return this;
    }

    public HeaderEncoder targetCompID(byte[] value, int offset, int length) {
        this.targetCompID = value;
        this.targetCompIDOffset = offset;
        this.targetCompIDLength = length;
        return this;
    }

    public HeaderEncoder targetCompID(byte[] value) {
        return this.targetCompID(value, value.length);
    }

    public boolean hasTargetCompID() {
        return this.targetCompIDLength > 0;
    }

    public byte[] targetCompID() {
        return this.targetCompID;
    }

    public HeaderEncoder targetCompID(CharSequence value) {
        this.targetCompID = CodecUtil.toBytes((CharSequence)value, (byte[])this.targetCompID);
        this.targetCompIDOffset = 0;
        this.targetCompIDLength = value.length();
        return this;
    }

    public HeaderEncoder targetCompID(char[] value) {
        return this.targetCompID(value, value.length);
    }

    public HeaderEncoder targetCompID(char[] value, int length) {
        this.targetCompID = CodecUtil.toBytes((char[])value, (byte[])this.targetCompID, (int)length);
        this.targetCompIDOffset = 0;
        this.targetCompIDLength = length;
        return this;
    }

    public HeaderEncoder targetCompID(char[] value, int offset, int length) {
        this.targetCompID = CodecUtil.toBytes((char[])value, (byte[])this.targetCompID, (int)offset, (int)length);
        this.targetCompIDOffset = 0;
        this.targetCompIDLength = length;
        return this;
    }

    public HeaderEncoder onBehalfOfCompID(byte[] value, int length) {
        this.onBehalfOfCompID = value;
        this.onBehalfOfCompIDOffset = 0;
        this.onBehalfOfCompIDLength = length;
        return this;
    }

    public HeaderEncoder onBehalfOfCompID(byte[] value, int offset, int length) {
        this.onBehalfOfCompID = value;
        this.onBehalfOfCompIDOffset = offset;
        this.onBehalfOfCompIDLength = length;
        return this;
    }

    public HeaderEncoder onBehalfOfCompID(byte[] value) {
        return this.onBehalfOfCompID(value, value.length);
    }

    public boolean hasOnBehalfOfCompID() {
        return this.onBehalfOfCompIDLength > 0;
    }

    public byte[] onBehalfOfCompID() {
        return this.onBehalfOfCompID;
    }

    public HeaderEncoder onBehalfOfCompID(CharSequence value) {
        this.onBehalfOfCompID = CodecUtil.toBytes((CharSequence)value, (byte[])this.onBehalfOfCompID);
        this.onBehalfOfCompIDOffset = 0;
        this.onBehalfOfCompIDLength = value.length();
        return this;
    }

    public HeaderEncoder onBehalfOfCompID(char[] value) {
        return this.onBehalfOfCompID(value, value.length);
    }

    public HeaderEncoder onBehalfOfCompID(char[] value, int length) {
        this.onBehalfOfCompID = CodecUtil.toBytes((char[])value, (byte[])this.onBehalfOfCompID, (int)length);
        this.onBehalfOfCompIDOffset = 0;
        this.onBehalfOfCompIDLength = length;
        return this;
    }

    public HeaderEncoder onBehalfOfCompID(char[] value, int offset, int length) {
        this.onBehalfOfCompID = CodecUtil.toBytes((char[])value, (byte[])this.onBehalfOfCompID, (int)offset, (int)length);
        this.onBehalfOfCompIDOffset = 0;
        this.onBehalfOfCompIDLength = length;
        return this;
    }

    public HeaderEncoder deliverToCompID(byte[] value, int length) {
        this.deliverToCompID = value;
        this.deliverToCompIDOffset = 0;
        this.deliverToCompIDLength = length;
        return this;
    }

    public HeaderEncoder deliverToCompID(byte[] value, int offset, int length) {
        this.deliverToCompID = value;
        this.deliverToCompIDOffset = offset;
        this.deliverToCompIDLength = length;
        return this;
    }

    public HeaderEncoder deliverToCompID(byte[] value) {
        return this.deliverToCompID(value, value.length);
    }

    public boolean hasDeliverToCompID() {
        return this.deliverToCompIDLength > 0;
    }

    public byte[] deliverToCompID() {
        return this.deliverToCompID;
    }

    public HeaderEncoder deliverToCompID(CharSequence value) {
        this.deliverToCompID = CodecUtil.toBytes((CharSequence)value, (byte[])this.deliverToCompID);
        this.deliverToCompIDOffset = 0;
        this.deliverToCompIDLength = value.length();
        return this;
    }

    public HeaderEncoder deliverToCompID(char[] value) {
        return this.deliverToCompID(value, value.length);
    }

    public HeaderEncoder deliverToCompID(char[] value, int length) {
        this.deliverToCompID = CodecUtil.toBytes((char[])value, (byte[])this.deliverToCompID, (int)length);
        this.deliverToCompIDOffset = 0;
        this.deliverToCompIDLength = length;
        return this;
    }

    public HeaderEncoder deliverToCompID(char[] value, int offset, int length) {
        this.deliverToCompID = CodecUtil.toBytes((char[])value, (byte[])this.deliverToCompID, (int)offset, (int)length);
        this.deliverToCompIDOffset = 0;
        this.deliverToCompIDLength = length;
        return this;
    }

    public boolean hasSecureDataLen() {
        return this.hasSecureDataLen;
    }

    public HeaderEncoder secureDataLen(int value) {
        this.secureDataLen = value;
        this.hasSecureDataLen = true;
        return this;
    }

    public int secureDataLen() {
        return this.secureDataLen;
    }

    public boolean hasSecureData() {
        return this.hasSecureData;
    }

    public HeaderEncoder secureData(byte[] value) {
        this.secureData = value;
        this.hasSecureData = true;
        return this;
    }

    public byte[] secureData() {
        return this.secureData;
    }

    public boolean hasMsgSeqNum() {
        return this.hasMsgSeqNum;
    }

    public HeaderEncoder msgSeqNum(int value) {
        this.msgSeqNum = value;
        this.hasMsgSeqNum = true;
        return this;
    }

    public int msgSeqNum() {
        return this.msgSeqNum;
    }

    public HeaderEncoder senderSubID(byte[] value, int length) {
        this.senderSubID = value;
        this.senderSubIDOffset = 0;
        this.senderSubIDLength = length;
        return this;
    }

    public HeaderEncoder senderSubID(byte[] value, int offset, int length) {
        this.senderSubID = value;
        this.senderSubIDOffset = offset;
        this.senderSubIDLength = length;
        return this;
    }

    public HeaderEncoder senderSubID(byte[] value) {
        return this.senderSubID(value, value.length);
    }

    public boolean hasSenderSubID() {
        return this.senderSubIDLength > 0;
    }

    public byte[] senderSubID() {
        return this.senderSubID;
    }

    public HeaderEncoder senderSubID(CharSequence value) {
        this.senderSubID = CodecUtil.toBytes((CharSequence)value, (byte[])this.senderSubID);
        this.senderSubIDOffset = 0;
        this.senderSubIDLength = value.length();
        return this;
    }

    public HeaderEncoder senderSubID(char[] value) {
        return this.senderSubID(value, value.length);
    }

    public HeaderEncoder senderSubID(char[] value, int length) {
        this.senderSubID = CodecUtil.toBytes((char[])value, (byte[])this.senderSubID, (int)length);
        this.senderSubIDOffset = 0;
        this.senderSubIDLength = length;
        return this;
    }

    public HeaderEncoder senderSubID(char[] value, int offset, int length) {
        this.senderSubID = CodecUtil.toBytes((char[])value, (byte[])this.senderSubID, (int)offset, (int)length);
        this.senderSubIDOffset = 0;
        this.senderSubIDLength = length;
        return this;
    }

    public HeaderEncoder senderLocationID(byte[] value, int length) {
        this.senderLocationID = value;
        this.senderLocationIDOffset = 0;
        this.senderLocationIDLength = length;
        return this;
    }

    public HeaderEncoder senderLocationID(byte[] value, int offset, int length) {
        this.senderLocationID = value;
        this.senderLocationIDOffset = offset;
        this.senderLocationIDLength = length;
        return this;
    }

    public HeaderEncoder senderLocationID(byte[] value) {
        return this.senderLocationID(value, value.length);
    }

    public boolean hasSenderLocationID() {
        return this.senderLocationIDLength > 0;
    }

    public byte[] senderLocationID() {
        return this.senderLocationID;
    }

    public HeaderEncoder senderLocationID(CharSequence value) {
        this.senderLocationID = CodecUtil.toBytes((CharSequence)value, (byte[])this.senderLocationID);
        this.senderLocationIDOffset = 0;
        this.senderLocationIDLength = value.length();
        return this;
    }

    public HeaderEncoder senderLocationID(char[] value) {
        return this.senderLocationID(value, value.length);
    }

    public HeaderEncoder senderLocationID(char[] value, int length) {
        this.senderLocationID = CodecUtil.toBytes((char[])value, (byte[])this.senderLocationID, (int)length);
        this.senderLocationIDOffset = 0;
        this.senderLocationIDLength = length;
        return this;
    }

    public HeaderEncoder senderLocationID(char[] value, int offset, int length) {
        this.senderLocationID = CodecUtil.toBytes((char[])value, (byte[])this.senderLocationID, (int)offset, (int)length);
        this.senderLocationIDOffset = 0;
        this.senderLocationIDLength = length;
        return this;
    }

    public HeaderEncoder targetSubID(byte[] value, int length) {
        this.targetSubID = value;
        this.targetSubIDOffset = 0;
        this.targetSubIDLength = length;
        return this;
    }

    public HeaderEncoder targetSubID(byte[] value, int offset, int length) {
        this.targetSubID = value;
        this.targetSubIDOffset = offset;
        this.targetSubIDLength = length;
        return this;
    }

    public HeaderEncoder targetSubID(byte[] value) {
        return this.targetSubID(value, value.length);
    }

    public boolean hasTargetSubID() {
        return this.targetSubIDLength > 0;
    }

    public byte[] targetSubID() {
        return this.targetSubID;
    }

    public HeaderEncoder targetSubID(CharSequence value) {
        this.targetSubID = CodecUtil.toBytes((CharSequence)value, (byte[])this.targetSubID);
        this.targetSubIDOffset = 0;
        this.targetSubIDLength = value.length();
        return this;
    }

    public HeaderEncoder targetSubID(char[] value) {
        return this.targetSubID(value, value.length);
    }

    public HeaderEncoder targetSubID(char[] value, int length) {
        this.targetSubID = CodecUtil.toBytes((char[])value, (byte[])this.targetSubID, (int)length);
        this.targetSubIDOffset = 0;
        this.targetSubIDLength = length;
        return this;
    }

    public HeaderEncoder targetSubID(char[] value, int offset, int length) {
        this.targetSubID = CodecUtil.toBytes((char[])value, (byte[])this.targetSubID, (int)offset, (int)length);
        this.targetSubIDOffset = 0;
        this.targetSubIDLength = length;
        return this;
    }

    public HeaderEncoder targetLocationID(byte[] value, int length) {
        this.targetLocationID = value;
        this.targetLocationIDOffset = 0;
        this.targetLocationIDLength = length;
        return this;
    }

    public HeaderEncoder targetLocationID(byte[] value, int offset, int length) {
        this.targetLocationID = value;
        this.targetLocationIDOffset = offset;
        this.targetLocationIDLength = length;
        return this;
    }

    public HeaderEncoder targetLocationID(byte[] value) {
        return this.targetLocationID(value, value.length);
    }

    public boolean hasTargetLocationID() {
        return this.targetLocationIDLength > 0;
    }

    public byte[] targetLocationID() {
        return this.targetLocationID;
    }

    public HeaderEncoder targetLocationID(CharSequence value) {
        this.targetLocationID = CodecUtil.toBytes((CharSequence)value, (byte[])this.targetLocationID);
        this.targetLocationIDOffset = 0;
        this.targetLocationIDLength = value.length();
        return this;
    }

    public HeaderEncoder targetLocationID(char[] value) {
        return this.targetLocationID(value, value.length);
    }

    public HeaderEncoder targetLocationID(char[] value, int length) {
        this.targetLocationID = CodecUtil.toBytes((char[])value, (byte[])this.targetLocationID, (int)length);
        this.targetLocationIDOffset = 0;
        this.targetLocationIDLength = length;
        return this;
    }

    public HeaderEncoder targetLocationID(char[] value, int offset, int length) {
        this.targetLocationID = CodecUtil.toBytes((char[])value, (byte[])this.targetLocationID, (int)offset, (int)length);
        this.targetLocationIDOffset = 0;
        this.targetLocationIDLength = length;
        return this;
    }

    public HeaderEncoder onBehalfOfSubID(byte[] value, int length) {
        this.onBehalfOfSubID = value;
        this.onBehalfOfSubIDOffset = 0;
        this.onBehalfOfSubIDLength = length;
        return this;
    }

    public HeaderEncoder onBehalfOfSubID(byte[] value, int offset, int length) {
        this.onBehalfOfSubID = value;
        this.onBehalfOfSubIDOffset = offset;
        this.onBehalfOfSubIDLength = length;
        return this;
    }

    public HeaderEncoder onBehalfOfSubID(byte[] value) {
        return this.onBehalfOfSubID(value, value.length);
    }

    public boolean hasOnBehalfOfSubID() {
        return this.onBehalfOfSubIDLength > 0;
    }

    public byte[] onBehalfOfSubID() {
        return this.onBehalfOfSubID;
    }

    public HeaderEncoder onBehalfOfSubID(CharSequence value) {
        this.onBehalfOfSubID = CodecUtil.toBytes((CharSequence)value, (byte[])this.onBehalfOfSubID);
        this.onBehalfOfSubIDOffset = 0;
        this.onBehalfOfSubIDLength = value.length();
        return this;
    }

    public HeaderEncoder onBehalfOfSubID(char[] value) {
        return this.onBehalfOfSubID(value, value.length);
    }

    public HeaderEncoder onBehalfOfSubID(char[] value, int length) {
        this.onBehalfOfSubID = CodecUtil.toBytes((char[])value, (byte[])this.onBehalfOfSubID, (int)length);
        this.onBehalfOfSubIDOffset = 0;
        this.onBehalfOfSubIDLength = length;
        return this;
    }

    public HeaderEncoder onBehalfOfSubID(char[] value, int offset, int length) {
        this.onBehalfOfSubID = CodecUtil.toBytes((char[])value, (byte[])this.onBehalfOfSubID, (int)offset, (int)length);
        this.onBehalfOfSubIDOffset = 0;
        this.onBehalfOfSubIDLength = length;
        return this;
    }

    public HeaderEncoder onBehalfOfLocationID(byte[] value, int length) {
        this.onBehalfOfLocationID = value;
        this.onBehalfOfLocationIDOffset = 0;
        this.onBehalfOfLocationIDLength = length;
        return this;
    }

    public HeaderEncoder onBehalfOfLocationID(byte[] value, int offset, int length) {
        this.onBehalfOfLocationID = value;
        this.onBehalfOfLocationIDOffset = offset;
        this.onBehalfOfLocationIDLength = length;
        return this;
    }

    public HeaderEncoder onBehalfOfLocationID(byte[] value) {
        return this.onBehalfOfLocationID(value, value.length);
    }

    public boolean hasOnBehalfOfLocationID() {
        return this.onBehalfOfLocationIDLength > 0;
    }

    public byte[] onBehalfOfLocationID() {
        return this.onBehalfOfLocationID;
    }

    public HeaderEncoder onBehalfOfLocationID(CharSequence value) {
        this.onBehalfOfLocationID = CodecUtil.toBytes((CharSequence)value, (byte[])this.onBehalfOfLocationID);
        this.onBehalfOfLocationIDOffset = 0;
        this.onBehalfOfLocationIDLength = value.length();
        return this;
    }

    public HeaderEncoder onBehalfOfLocationID(char[] value) {
        return this.onBehalfOfLocationID(value, value.length);
    }

    public HeaderEncoder onBehalfOfLocationID(char[] value, int length) {
        this.onBehalfOfLocationID = CodecUtil.toBytes((char[])value, (byte[])this.onBehalfOfLocationID, (int)length);
        this.onBehalfOfLocationIDOffset = 0;
        this.onBehalfOfLocationIDLength = length;
        return this;
    }

    public HeaderEncoder onBehalfOfLocationID(char[] value, int offset, int length) {
        this.onBehalfOfLocationID = CodecUtil.toBytes((char[])value, (byte[])this.onBehalfOfLocationID, (int)offset, (int)length);
        this.onBehalfOfLocationIDOffset = 0;
        this.onBehalfOfLocationIDLength = length;
        return this;
    }

    public HeaderEncoder deliverToSubID(byte[] value, int length) {
        this.deliverToSubID = value;
        this.deliverToSubIDOffset = 0;
        this.deliverToSubIDLength = length;
        return this;
    }

    public HeaderEncoder deliverToSubID(byte[] value, int offset, int length) {
        this.deliverToSubID = value;
        this.deliverToSubIDOffset = offset;
        this.deliverToSubIDLength = length;
        return this;
    }

    public HeaderEncoder deliverToSubID(byte[] value) {
        return this.deliverToSubID(value, value.length);
    }

    public boolean hasDeliverToSubID() {
        return this.deliverToSubIDLength > 0;
    }

    public byte[] deliverToSubID() {
        return this.deliverToSubID;
    }

    public HeaderEncoder deliverToSubID(CharSequence value) {
        this.deliverToSubID = CodecUtil.toBytes((CharSequence)value, (byte[])this.deliverToSubID);
        this.deliverToSubIDOffset = 0;
        this.deliverToSubIDLength = value.length();
        return this;
    }

    public HeaderEncoder deliverToSubID(char[] value) {
        return this.deliverToSubID(value, value.length);
    }

    public HeaderEncoder deliverToSubID(char[] value, int length) {
        this.deliverToSubID = CodecUtil.toBytes((char[])value, (byte[])this.deliverToSubID, (int)length);
        this.deliverToSubIDOffset = 0;
        this.deliverToSubIDLength = length;
        return this;
    }

    public HeaderEncoder deliverToSubID(char[] value, int offset, int length) {
        this.deliverToSubID = CodecUtil.toBytes((char[])value, (byte[])this.deliverToSubID, (int)offset, (int)length);
        this.deliverToSubIDOffset = 0;
        this.deliverToSubIDLength = length;
        return this;
    }

    public HeaderEncoder deliverToLocationID(byte[] value, int length) {
        this.deliverToLocationID = value;
        this.deliverToLocationIDOffset = 0;
        this.deliverToLocationIDLength = length;
        return this;
    }

    public HeaderEncoder deliverToLocationID(byte[] value, int offset, int length) {
        this.deliverToLocationID = value;
        this.deliverToLocationIDOffset = offset;
        this.deliverToLocationIDLength = length;
        return this;
    }

    public HeaderEncoder deliverToLocationID(byte[] value) {
        return this.deliverToLocationID(value, value.length);
    }

    public boolean hasDeliverToLocationID() {
        return this.deliverToLocationIDLength > 0;
    }

    public byte[] deliverToLocationID() {
        return this.deliverToLocationID;
    }

    public HeaderEncoder deliverToLocationID(CharSequence value) {
        this.deliverToLocationID = CodecUtil.toBytes((CharSequence)value, (byte[])this.deliverToLocationID);
        this.deliverToLocationIDOffset = 0;
        this.deliverToLocationIDLength = value.length();
        return this;
    }

    public HeaderEncoder deliverToLocationID(char[] value) {
        return this.deliverToLocationID(value, value.length);
    }

    public HeaderEncoder deliverToLocationID(char[] value, int length) {
        this.deliverToLocationID = CodecUtil.toBytes((char[])value, (byte[])this.deliverToLocationID, (int)length);
        this.deliverToLocationIDOffset = 0;
        this.deliverToLocationIDLength = length;
        return this;
    }

    public HeaderEncoder deliverToLocationID(char[] value, int offset, int length) {
        this.deliverToLocationID = CodecUtil.toBytes((char[])value, (byte[])this.deliverToLocationID, (int)offset, (int)length);
        this.deliverToLocationIDOffset = 0;
        this.deliverToLocationIDLength = length;
        return this;
    }

    public boolean hasPossDupFlag() {
        return this.hasPossDupFlag;
    }

    public HeaderEncoder possDupFlag(boolean value) {
        this.possDupFlag = value;
        this.hasPossDupFlag = true;
        return this;
    }

    public boolean possDupFlag() {
        return this.possDupFlag;
    }

    public boolean hasPossResend() {
        return this.hasPossResend;
    }

    public HeaderEncoder possResend(boolean value) {
        this.possResend = value;
        this.hasPossResend = true;
        return this;
    }

    public boolean possResend() {
        return this.possResend;
    }

    public HeaderEncoder sendingTime(byte[] value, int length) {
        this.sendingTime = value;
        this.sendingTimeOffset = 0;
        this.sendingTimeLength = length;
        return this;
    }

    public HeaderEncoder sendingTime(byte[] value, int offset, int length) {
        this.sendingTime = value;
        this.sendingTimeOffset = offset;
        this.sendingTimeLength = length;
        return this;
    }

    public HeaderEncoder sendingTime(byte[] value) {
        return this.sendingTime(value, value.length);
    }

    public boolean hasSendingTime() {
        return this.sendingTimeLength > 0;
    }

    public byte[] sendingTime() {
        return this.sendingTime;
    }

    public HeaderEncoder origSendingTime(byte[] value, int length) {
        this.origSendingTime = value;
        this.origSendingTimeOffset = 0;
        this.origSendingTimeLength = length;
        return this;
    }

    public HeaderEncoder origSendingTime(byte[] value, int offset, int length) {
        this.origSendingTime = value;
        this.origSendingTimeOffset = offset;
        this.origSendingTimeLength = length;
        return this;
    }

    public HeaderEncoder origSendingTime(byte[] value) {
        return this.origSendingTime(value, value.length);
    }

    public boolean hasOrigSendingTime() {
        return this.origSendingTimeLength > 0;
    }

    public byte[] origSendingTime() {
        return this.origSendingTime;
    }

    public boolean hasXmlDataLen() {
        return this.hasXmlDataLen;
    }

    public HeaderEncoder xmlDataLen(int value) {
        this.xmlDataLen = value;
        this.hasXmlDataLen = true;
        return this;
    }

    public int xmlDataLen() {
        return this.xmlDataLen;
    }

    public boolean hasXmlData() {
        return this.hasXmlData;
    }

    public HeaderEncoder xmlData(byte[] value) {
        this.xmlData = value;
        this.hasXmlData = true;
        return this;
    }

    public byte[] xmlData() {
        return this.xmlData;
    }

    public HeaderEncoder messageEncoding(byte[] value, int length) {
        this.messageEncoding = value;
        this.messageEncodingOffset = 0;
        this.messageEncodingLength = length;
        return this;
    }

    public HeaderEncoder messageEncoding(byte[] value, int offset, int length) {
        this.messageEncoding = value;
        this.messageEncodingOffset = offset;
        this.messageEncodingLength = length;
        return this;
    }

    public HeaderEncoder messageEncoding(byte[] value) {
        return this.messageEncoding(value, value.length);
    }

    public boolean hasMessageEncoding() {
        return this.messageEncodingLength > 0;
    }

    public byte[] messageEncoding() {
        return this.messageEncoding;
    }

    public HeaderEncoder messageEncoding(CharSequence value) {
        this.messageEncoding = CodecUtil.toBytes((CharSequence)value, (byte[])this.messageEncoding);
        this.messageEncodingOffset = 0;
        this.messageEncodingLength = value.length();
        return this;
    }

    public HeaderEncoder messageEncoding(char[] value) {
        return this.messageEncoding(value, value.length);
    }

    public HeaderEncoder messageEncoding(char[] value, int length) {
        this.messageEncoding = CodecUtil.toBytes((char[])value, (byte[])this.messageEncoding, (int)length);
        this.messageEncodingOffset = 0;
        this.messageEncodingLength = length;
        return this;
    }

    public HeaderEncoder messageEncoding(char[] value, int offset, int length) {
        this.messageEncoding = CodecUtil.toBytes((char[])value, (byte[])this.messageEncoding, (int)offset, (int)length);
        this.messageEncodingOffset = 0;
        this.messageEncodingLength = length;
        return this;
    }

    public boolean hasLastMsgSeqNumProcessed() {
        return this.hasLastMsgSeqNumProcessed;
    }

    public HeaderEncoder lastMsgSeqNumProcessed(int value) {
        this.lastMsgSeqNumProcessed = value;
        this.hasLastMsgSeqNumProcessed = true;
        return this;
    }

    public int lastMsgSeqNumProcessed() {
        return this.lastMsgSeqNumProcessed;
    }

    public int encode(MutableAsciiBuffer buffer, int offset) {
        int position = offset;
        if (this.msgTypeLength > 0) {
            buffer.putBytes(position, msgTypeHeader, 0, 3);
            buffer.putBytes(position += 3, this.msgType, this.msgTypeOffset, this.msgTypeLength);
            buffer.putSeparator(position += this.msgTypeLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: MsgType");
        }
        if (this.applVerIDLength > 0) {
            buffer.putBytes(position, applVerIDHeader, 0, 5);
            buffer.putBytes(position += 5, this.applVerID, this.applVerIDOffset, this.applVerIDLength);
            buffer.putSeparator(position += this.applVerIDLength);
            ++position;
        }
        if (this.hasApplExtID) {
            buffer.putBytes(position, applExtIDHeader, 0, 5);
            position += 5;
            position += buffer.putAsciiInt(position, this.applExtID);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.cstmApplVerIDLength > 0) {
            buffer.putBytes(position, cstmApplVerIDHeader, 0, 5);
            buffer.putBytes(position += 5, this.cstmApplVerID, this.cstmApplVerIDOffset, this.cstmApplVerIDLength);
            buffer.putSeparator(position += this.cstmApplVerIDLength);
            ++position;
        }
        if (this.senderCompIDLength > 0) {
            buffer.putBytes(position, senderCompIDHeader, 0, 3);
            buffer.putBytes(position += 3, this.senderCompID, this.senderCompIDOffset, this.senderCompIDLength);
            buffer.putSeparator(position += this.senderCompIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: SenderCompID");
        }
        if (this.targetCompIDLength > 0) {
            buffer.putBytes(position, targetCompIDHeader, 0, 3);
            buffer.putBytes(position += 3, this.targetCompID, this.targetCompIDOffset, this.targetCompIDLength);
            buffer.putSeparator(position += this.targetCompIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: TargetCompID");
        }
        if (this.onBehalfOfCompIDLength > 0) {
            buffer.putBytes(position, onBehalfOfCompIDHeader, 0, 4);
            buffer.putBytes(position += 4, this.onBehalfOfCompID, this.onBehalfOfCompIDOffset, this.onBehalfOfCompIDLength);
            buffer.putSeparator(position += this.onBehalfOfCompIDLength);
            ++position;
        }
        if (this.deliverToCompIDLength > 0) {
            buffer.putBytes(position, deliverToCompIDHeader, 0, 4);
            buffer.putBytes(position += 4, this.deliverToCompID, this.deliverToCompIDOffset, this.deliverToCompIDLength);
            buffer.putSeparator(position += this.deliverToCompIDLength);
            ++position;
        }
        if (this.hasSecureDataLen) {
            buffer.putBytes(position, secureDataLenHeader, 0, 3);
            position += 3;
            position += buffer.putAsciiInt(position, this.secureDataLen);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasSecureData) {
            buffer.putBytes(position, secureDataHeader, 0, 3);
            buffer.putBytes(position += 3, this.secureData);
            buffer.putSeparator(position += this.secureData.length);
            ++position;
        }
        if (this.hasMsgSeqNum) {
            buffer.putBytes(position, msgSeqNumHeader, 0, 3);
            position += 3;
            position += buffer.putAsciiInt(position, this.msgSeqNum);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.senderSubIDLength > 0) {
            buffer.putBytes(position, senderSubIDHeader, 0, 3);
            buffer.putBytes(position += 3, this.senderSubID, this.senderSubIDOffset, this.senderSubIDLength);
            buffer.putSeparator(position += this.senderSubIDLength);
            ++position;
        }
        if (this.senderLocationIDLength > 0) {
            buffer.putBytes(position, senderLocationIDHeader, 0, 4);
            buffer.putBytes(position += 4, this.senderLocationID, this.senderLocationIDOffset, this.senderLocationIDLength);
            buffer.putSeparator(position += this.senderLocationIDLength);
            ++position;
        }
        if (this.targetSubIDLength > 0) {
            buffer.putBytes(position, targetSubIDHeader, 0, 3);
            buffer.putBytes(position += 3, this.targetSubID, this.targetSubIDOffset, this.targetSubIDLength);
            buffer.putSeparator(position += this.targetSubIDLength);
            ++position;
        }
        if (this.targetLocationIDLength > 0) {
            buffer.putBytes(position, targetLocationIDHeader, 0, 4);
            buffer.putBytes(position += 4, this.targetLocationID, this.targetLocationIDOffset, this.targetLocationIDLength);
            buffer.putSeparator(position += this.targetLocationIDLength);
            ++position;
        }
        if (this.onBehalfOfSubIDLength > 0) {
            buffer.putBytes(position, onBehalfOfSubIDHeader, 0, 4);
            buffer.putBytes(position += 4, this.onBehalfOfSubID, this.onBehalfOfSubIDOffset, this.onBehalfOfSubIDLength);
            buffer.putSeparator(position += this.onBehalfOfSubIDLength);
            ++position;
        }
        if (this.onBehalfOfLocationIDLength > 0) {
            buffer.putBytes(position, onBehalfOfLocationIDHeader, 0, 4);
            buffer.putBytes(position += 4, this.onBehalfOfLocationID, this.onBehalfOfLocationIDOffset, this.onBehalfOfLocationIDLength);
            buffer.putSeparator(position += this.onBehalfOfLocationIDLength);
            ++position;
        }
        if (this.deliverToSubIDLength > 0) {
            buffer.putBytes(position, deliverToSubIDHeader, 0, 4);
            buffer.putBytes(position += 4, this.deliverToSubID, this.deliverToSubIDOffset, this.deliverToSubIDLength);
            buffer.putSeparator(position += this.deliverToSubIDLength);
            ++position;
        }
        if (this.deliverToLocationIDLength > 0) {
            buffer.putBytes(position, deliverToLocationIDHeader, 0, 4);
            buffer.putBytes(position += 4, this.deliverToLocationID, this.deliverToLocationIDOffset, this.deliverToLocationIDLength);
            buffer.putSeparator(position += this.deliverToLocationIDLength);
            ++position;
        }
        if (this.hasPossDupFlag) {
            buffer.putBytes(position, possDupFlagHeader, 0, 3);
            position += 3;
            position += buffer.putAsciiBoolean(position, this.possDupFlag);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasPossResend) {
            buffer.putBytes(position, possResendHeader, 0, 3);
            position += 3;
            position += buffer.putAsciiBoolean(position, this.possResend);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.sendingTimeLength > 0) {
            buffer.putBytes(position, sendingTimeHeader, 0, 3);
            buffer.putBytes(position += 3, this.sendingTime, this.sendingTimeOffset, this.sendingTimeLength);
            buffer.putSeparator(position += this.sendingTimeLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: SendingTime");
        }
        if (this.origSendingTimeLength > 0) {
            buffer.putBytes(position, origSendingTimeHeader, 0, 4);
            buffer.putBytes(position += 4, this.origSendingTime, this.origSendingTimeOffset, this.origSendingTimeLength);
            buffer.putSeparator(position += this.origSendingTimeLength);
            ++position;
        }
        if (this.hasXmlDataLen) {
            buffer.putBytes(position, xmlDataLenHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiInt(position, this.xmlDataLen);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasXmlData) {
            buffer.putBytes(position, xmlDataHeader, 0, 4);
            buffer.putBytes(position += 4, this.xmlData);
            buffer.putSeparator(position += this.xmlData.length);
            ++position;
        }
        if (this.messageEncodingLength > 0) {
            buffer.putBytes(position, messageEncodingHeader, 0, 4);
            buffer.putBytes(position += 4, this.messageEncoding, this.messageEncodingOffset, this.messageEncodingLength);
            buffer.putSeparator(position += this.messageEncodingLength);
            ++position;
        }
        if (this.hasLastMsgSeqNumProcessed) {
            buffer.putBytes(position, lastMsgSeqNumProcessedHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiInt(position, this.lastMsgSeqNumProcessed);
            buffer.putSeparator(position);
            ++position;
        }
        return position - offset;
    }

    public void reset() {
        this.resetApplVerID();
        this.resetApplExtID();
        this.resetCstmApplVerID();
        this.resetSenderCompID();
        this.resetTargetCompID();
        this.resetOnBehalfOfCompID();
        this.resetDeliverToCompID();
        this.resetSecureDataLen();
        this.resetSecureData();
        this.resetMsgSeqNum();
        this.resetSenderSubID();
        this.resetSenderLocationID();
        this.resetTargetSubID();
        this.resetTargetLocationID();
        this.resetOnBehalfOfSubID();
        this.resetOnBehalfOfLocationID();
        this.resetDeliverToSubID();
        this.resetDeliverToLocationID();
        this.resetPossDupFlag();
        this.resetPossResend();
        this.resetSendingTime();
        this.resetOrigSendingTime();
        this.resetXmlDataLen();
        this.resetXmlData();
        this.resetMessageEncoding();
        this.resetLastMsgSeqNumProcessed();
    }

    public void resetApplVerID() {
        this.applVerIDLength = 0;
    }

    public void resetApplExtID() {
        this.hasApplExtID = false;
    }

    public void resetCstmApplVerID() {
        this.cstmApplVerIDLength = 0;
    }

    public void resetSenderCompID() {
        this.senderCompIDLength = 0;
    }

    public void resetTargetCompID() {
        this.targetCompIDLength = 0;
    }

    public void resetOnBehalfOfCompID() {
        this.onBehalfOfCompIDLength = 0;
    }

    public void resetDeliverToCompID() {
        this.deliverToCompIDLength = 0;
    }

    public void resetSecureDataLen() {
        this.hasSecureDataLen = false;
    }

    public void resetSecureData() {
        this.hasSecureData = false;
    }

    public void resetMsgSeqNum() {
        this.hasMsgSeqNum = false;
    }

    public void resetSenderSubID() {
        this.senderSubIDLength = 0;
    }

    public void resetSenderLocationID() {
        this.senderLocationIDLength = 0;
    }

    public void resetTargetSubID() {
        this.targetSubIDLength = 0;
    }

    public void resetTargetLocationID() {
        this.targetLocationIDLength = 0;
    }

    public void resetOnBehalfOfSubID() {
        this.onBehalfOfSubIDLength = 0;
    }

    public void resetOnBehalfOfLocationID() {
        this.onBehalfOfLocationIDLength = 0;
    }

    public void resetDeliverToSubID() {
        this.deliverToSubIDLength = 0;
    }

    public void resetDeliverToLocationID() {
        this.deliverToLocationIDLength = 0;
    }

    public void resetPossDupFlag() {
        this.hasPossDupFlag = false;
    }

    public void resetPossResend() {
        this.hasPossResend = false;
    }

    public void resetSendingTime() {
        this.sendingTimeLength = 0;
    }

    public void resetOrigSendingTime() {
        this.origSendingTimeLength = 0;
    }

    public void resetXmlDataLen() {
        this.hasXmlDataLen = false;
    }

    public void resetXmlData() {
        this.hasXmlData = false;
    }

    public void resetMessageEncoding() {
        this.messageEncodingLength = 0;
    }

    public void resetLastMsgSeqNumProcessed() {
        this.hasLastMsgSeqNumProcessed = false;
    }

    public String toString() {
        String entries = (this.hasBeginString() ? String.format("  \"BeginString\": \"%s\",\n", new String(this.beginString, this.beginStringOffset, this.beginStringLength, StandardCharsets.US_ASCII)) : "") + "" + (this.hasMsgType() ? String.format("  \"MsgType\": \"%s\",\n", new String(this.msgType, this.msgTypeOffset, this.msgTypeLength, StandardCharsets.US_ASCII)) : "") + (this.hasApplVerID() ? String.format("  \"ApplVerID\": \"%s\",\n", new String(this.applVerID, this.applVerIDOffset, this.applVerIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasApplExtID() ? String.format("  \"ApplExtID\": \"%s\",\n", this.applExtID) : "") + (this.hasCstmApplVerID() ? String.format("  \"CstmApplVerID\": \"%s\",\n", new String(this.cstmApplVerID, this.cstmApplVerIDOffset, this.cstmApplVerIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasSenderCompID() ? String.format("  \"SenderCompID\": \"%s\",\n", new String(this.senderCompID, this.senderCompIDOffset, this.senderCompIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasTargetCompID() ? String.format("  \"TargetCompID\": \"%s\",\n", new String(this.targetCompID, this.targetCompIDOffset, this.targetCompIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasOnBehalfOfCompID() ? String.format("  \"OnBehalfOfCompID\": \"%s\",\n", new String(this.onBehalfOfCompID, this.onBehalfOfCompIDOffset, this.onBehalfOfCompIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasDeliverToCompID() ? String.format("  \"DeliverToCompID\": \"%s\",\n", new String(this.deliverToCompID, this.deliverToCompIDOffset, this.deliverToCompIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasSecureDataLen() ? String.format("  \"SecureDataLen\": \"%s\",\n", this.secureDataLen) : "") + (this.hasSecureData() ? String.format("  \"SecureData\": \"%s\",\n", Arrays.toString(this.secureData)) : "") + (this.hasMsgSeqNum() ? String.format("  \"MsgSeqNum\": \"%s\",\n", this.msgSeqNum) : "") + (this.hasSenderSubID() ? String.format("  \"SenderSubID\": \"%s\",\n", new String(this.senderSubID, this.senderSubIDOffset, this.senderSubIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasSenderLocationID() ? String.format("  \"SenderLocationID\": \"%s\",\n", new String(this.senderLocationID, this.senderLocationIDOffset, this.senderLocationIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasTargetSubID() ? String.format("  \"TargetSubID\": \"%s\",\n", new String(this.targetSubID, this.targetSubIDOffset, this.targetSubIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasTargetLocationID() ? String.format("  \"TargetLocationID\": \"%s\",\n", new String(this.targetLocationID, this.targetLocationIDOffset, this.targetLocationIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasOnBehalfOfSubID() ? String.format("  \"OnBehalfOfSubID\": \"%s\",\n", new String(this.onBehalfOfSubID, this.onBehalfOfSubIDOffset, this.onBehalfOfSubIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasOnBehalfOfLocationID() ? String.format("  \"OnBehalfOfLocationID\": \"%s\",\n", new String(this.onBehalfOfLocationID, this.onBehalfOfLocationIDOffset, this.onBehalfOfLocationIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasDeliverToSubID() ? String.format("  \"DeliverToSubID\": \"%s\",\n", new String(this.deliverToSubID, this.deliverToSubIDOffset, this.deliverToSubIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasDeliverToLocationID() ? String.format("  \"DeliverToLocationID\": \"%s\",\n", new String(this.deliverToLocationID, this.deliverToLocationIDOffset, this.deliverToLocationIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasPossDupFlag() ? String.format("  \"PossDupFlag\": \"%s\",\n", this.possDupFlag) : "") + (this.hasPossResend() ? String.format("  \"PossResend\": \"%s\",\n", this.possResend) : "") + (this.hasSendingTime() ? String.format("  \"SendingTime\": \"%s\",\n", new String(this.sendingTime, this.sendingTimeOffset, this.sendingTimeLength, StandardCharsets.US_ASCII)) : "") + (this.hasOrigSendingTime() ? String.format("  \"OrigSendingTime\": \"%s\",\n", new String(this.origSendingTime, this.origSendingTimeOffset, this.origSendingTimeLength, StandardCharsets.US_ASCII)) : "") + (this.hasXmlDataLen() ? String.format("  \"XmlDataLen\": \"%s\",\n", this.xmlDataLen) : "") + (this.hasXmlData() ? String.format("  \"XmlData\": \"%s\",\n", Arrays.toString(this.xmlData)) : "") + (this.hasMessageEncoding() ? String.format("  \"MessageEncoding\": \"%s\",\n", new String(this.messageEncoding, this.messageEncodingOffset, this.messageEncodingLength, StandardCharsets.US_ASCII)) : "") + (this.hasLastMsgSeqNumProcessed() ? String.format("  \"LastMsgSeqNumProcessed\": \"%s\",\n", this.lastMsgSeqNumProcessed) : "");
        entries = "{\n  \"MessageName\": \"Header\",\n" + entries + "}";
        return entries;
    }
}

