/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.decoder;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.Constants;
import uk.co.real_logic.artio.EncryptMethod;
import uk.co.real_logic.artio.MsgDirection;
import uk.co.real_logic.artio.SessionStatus;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder.HeaderDecoder;
import uk.co.real_logic.artio.decoder.TrailerDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;

public class LogonDecoder
implements Decoder {
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(6);
    public final IntHashSet GROUP_FIELDS;
    private final IntHashSet alreadyVisitedFields;
    private final IntHashSet unknownFields;
    private final IntHashSet missingRequiredFields;
    private int invalidTagId;
    private int rejectReason;
    public static final int MESSAGE_TYPE = 65;
    public static final String MESSAGE_TYPE_AS_STRING = "A";
    public static final byte[] MESSAGE_TYPE_BYTES = "A".getBytes(StandardCharsets.US_ASCII);
    public final IntHashSet messageFields;
    private TrailerDecoder trailer;
    private HeaderDecoder header;
    private int encryptMethod;
    private int heartBtInt;
    private int rawDataLength;
    private boolean hasRawDataLength;
    private byte[] rawData;
    private boolean hasRawData;
    private boolean resetSeqNumFlag;
    private boolean hasResetSeqNumFlag;
    private int nextExpectedMsgSeqNum;
    private boolean hasNextExpectedMsgSeqNum;
    private int maxMessageSize;
    private boolean hasMaxMessageSize;
    private MsgTypesGroupDecoder msgTypesGroup;
    private int noMsgTypesGroupCounter;
    private boolean hasNoMsgTypesGroupCounter;
    private MsgTypesGroupIterator msgTypesGroupIterator;
    private boolean testMessageIndicator;
    private boolean hasTestMessageIndicator;
    private char[] username;
    private boolean hasUsername;
    private int usernameLength;
    private int usernameOffset;
    private char[] password;
    private boolean hasPassword;
    private int passwordLength;
    private int passwordOffset;
    private char[] newPassword;
    private boolean hasNewPassword;
    private int newPasswordLength;
    private int newPasswordOffset;
    private int encryptedPasswordMethod;
    private boolean hasEncryptedPasswordMethod;
    private int encryptedPasswordLen;
    private boolean hasEncryptedPasswordLen;
    private byte[] encryptedPassword;
    private boolean hasEncryptedPassword;
    private int encryptedNewPasswordLen;
    private boolean hasEncryptedNewPasswordLen;
    private byte[] encryptedNewPassword;
    private boolean hasEncryptedNewPassword;
    private int sessionStatus;
    private boolean hasSessionStatus;
    private char[] defaultApplVerID;
    private int defaultApplVerIDLength;
    private int defaultApplVerIDOffset;
    private int defaultApplExtID;
    private boolean hasDefaultApplExtID;
    private char[] defaultCstmApplVerID;
    private boolean hasDefaultCstmApplVerID;
    private int defaultCstmApplVerIDLength;
    private int defaultCstmApplVerIDOffset;
    private char[] text;
    private boolean hasText;
    private int textLength;
    private int textOffset;
    private int encodedTextLen;
    private boolean hasEncodedTextLen;
    private byte[] encodedText;
    private boolean hasEncodedText;
    private AsciiBuffer buffer;

    public LogonDecoder() {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.REQUIRED_FIELDS.add(98);
            this.REQUIRED_FIELDS.add(108);
            this.REQUIRED_FIELDS.add(1137);
        }
        this.GROUP_FIELDS = new IntHashSet(46);
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.GROUP_FIELDS.add(98);
            this.GROUP_FIELDS.add(108);
            this.GROUP_FIELDS.add(95);
            this.GROUP_FIELDS.add(96);
            this.GROUP_FIELDS.add(141);
            this.GROUP_FIELDS.add(789);
            this.GROUP_FIELDS.add(383);
            this.GROUP_FIELDS.add(464);
            this.GROUP_FIELDS.add(553);
            this.GROUP_FIELDS.add(554);
            this.GROUP_FIELDS.add(925);
            this.GROUP_FIELDS.add(1400);
            this.GROUP_FIELDS.add(1401);
            this.GROUP_FIELDS.add(1402);
            this.GROUP_FIELDS.add(1403);
            this.GROUP_FIELDS.add(1404);
            this.GROUP_FIELDS.add(1409);
            this.GROUP_FIELDS.add(1137);
            this.GROUP_FIELDS.add(1407);
            this.GROUP_FIELDS.add(1408);
            this.GROUP_FIELDS.add(58);
            this.GROUP_FIELDS.add(354);
            this.GROUP_FIELDS.add(355);
        }
        this.alreadyVisitedFields = new IntHashSet(46);
        this.unknownFields = new IntHashSet(10);
        this.missingRequiredFields = new IntHashSet(6);
        this.invalidTagId = -1;
        this.rejectReason = -1;
        this.messageFields = new IntHashSet(124);
        this.messageFields.add(8);
        this.messageFields.add(9);
        this.messageFields.add(35);
        this.messageFields.add(1128);
        this.messageFields.add(1156);
        this.messageFields.add(1129);
        this.messageFields.add(49);
        this.messageFields.add(56);
        this.messageFields.add(115);
        this.messageFields.add(128);
        this.messageFields.add(90);
        this.messageFields.add(91);
        this.messageFields.add(34);
        this.messageFields.add(50);
        this.messageFields.add(142);
        this.messageFields.add(57);
        this.messageFields.add(143);
        this.messageFields.add(116);
        this.messageFields.add(144);
        this.messageFields.add(129);
        this.messageFields.add(145);
        this.messageFields.add(43);
        this.messageFields.add(97);
        this.messageFields.add(52);
        this.messageFields.add(122);
        this.messageFields.add(212);
        this.messageFields.add(213);
        this.messageFields.add(347);
        this.messageFields.add(369);
        this.messageFields.add(98);
        this.messageFields.add(108);
        this.messageFields.add(95);
        this.messageFields.add(96);
        this.messageFields.add(141);
        this.messageFields.add(789);
        this.messageFields.add(383);
        this.messageFields.add(384);
        this.messageFields.add(372);
        this.messageFields.add(385);
        this.messageFields.add(1130);
        this.messageFields.add(1406);
        this.messageFields.add(1131);
        this.messageFields.add(1410);
        this.messageFields.add(464);
        this.messageFields.add(553);
        this.messageFields.add(554);
        this.messageFields.add(925);
        this.messageFields.add(1400);
        this.messageFields.add(1401);
        this.messageFields.add(1402);
        this.messageFields.add(1403);
        this.messageFields.add(1404);
        this.messageFields.add(1409);
        this.messageFields.add(1137);
        this.messageFields.add(1407);
        this.messageFields.add(1408);
        this.messageFields.add(58);
        this.messageFields.add(354);
        this.messageFields.add(355);
        this.messageFields.add(93);
        this.messageFields.add(89);
        this.messageFields.add(10);
        this.trailer = new TrailerDecoder();
        this.header = new HeaderDecoder(this.trailer);
        this.rawData = new byte[1];
        this.msgTypesGroup = null;
        this.msgTypesGroupIterator = new MsgTypesGroupIterator();
        this.username = new char[1];
        this.password = new char[1];
        this.newPassword = new char[1];
        this.encryptedPassword = new byte[1];
        this.encryptedNewPassword = new byte[1];
        this.defaultApplVerID = new char[1];
        this.defaultCstmApplVerID = new char[1];
        this.text = new char[1];
        this.encodedText = new byte[1];
    }

    public int invalidTagId() {
        return this.invalidTagId;
    }

    public int rejectReason() {
        return this.rejectReason;
    }

    public boolean validate() {
        if (this.rejectReason != -1) {
            return false;
        }
        IntHashSet.IntIterator missingFieldsIterator = this.missingRequiredFields.iterator();
        IntHashSet.IntIterator unknownFieldsIterator = this.unknownFields.iterator();
        if (RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext()) {
            this.invalidTagId = unknownFieldsIterator.nextValue();
            this.rejectReason = Constants.ALL_FIELDS.contains(this.invalidTagId) ? 2 : 0;
            return false;
        }
        if (!this.header.validate()) {
            this.invalidTagId = this.header.invalidTagId();
            this.rejectReason = this.header.rejectReason();
            return false;
        }
        if (!this.trailer.validate()) {
            this.invalidTagId = this.trailer.invalidTagId();
            this.rejectReason = this.trailer.rejectReason();
            return false;
        }
        if (missingFieldsIterator.hasNext()) {
            this.invalidTagId = missingFieldsIterator.nextValue();
            this.rejectReason = 1;
            return false;
        }
        if (!EncryptMethod.isValid(this.encryptMethod)) {
            this.invalidTagId = 98;
            this.rejectReason = 5;
            return false;
        }
        if (this.hasSessionStatus && !SessionStatus.isValid(this.sessionStatus)) {
            this.invalidTagId = 1409;
            this.rejectReason = 5;
            return false;
        }
        if (this.hasNoMsgTypesGroupCounter) {
            for (MsgTypesGroupDecoder iterator : this.msgTypesGroupIterator.iterator()) {
                if (iterator.validate()) continue;
                this.invalidTagId = iterator.invalidTagId();
                this.rejectReason = iterator.rejectReason();
                return false;
            }
        }
        return true;
    }

    public TrailerDecoder trailer() {
        return this.trailer;
    }

    public HeaderDecoder header() {
        return this.header;
    }

    public int encryptMethod() {
        return this.encryptMethod;
    }

    public EncryptMethod encryptMethodAsEnum() {
        return EncryptMethod.decode(this.encryptMethod);
    }

    public int heartBtInt() {
        return this.heartBtInt;
    }

    public int rawDataLength() {
        if (!this.hasRawDataLength) {
            throw new IllegalArgumentException("No value for optional field: RawDataLength");
        }
        return this.rawDataLength;
    }

    public boolean hasRawDataLength() {
        return this.hasRawDataLength;
    }

    public byte[] rawData() {
        if (!this.hasRawData) {
            throw new IllegalArgumentException("No value for optional field: RawData");
        }
        return this.rawData;
    }

    public boolean hasRawData() {
        return this.hasRawData;
    }

    public boolean resetSeqNumFlag() {
        if (!this.hasResetSeqNumFlag) {
            throw new IllegalArgumentException("No value for optional field: ResetSeqNumFlag");
        }
        return this.resetSeqNumFlag;
    }

    public boolean hasResetSeqNumFlag() {
        return this.hasResetSeqNumFlag;
    }

    public int nextExpectedMsgSeqNum() {
        if (!this.hasNextExpectedMsgSeqNum) {
            throw new IllegalArgumentException("No value for optional field: NextExpectedMsgSeqNum");
        }
        return this.nextExpectedMsgSeqNum;
    }

    public boolean hasNextExpectedMsgSeqNum() {
        return this.hasNextExpectedMsgSeqNum;
    }

    public int maxMessageSize() {
        if (!this.hasMaxMessageSize) {
            throw new IllegalArgumentException("No value for optional field: MaxMessageSize");
        }
        return this.maxMessageSize;
    }

    public boolean hasMaxMessageSize() {
        return this.hasMaxMessageSize;
    }

    public MsgTypesGroupDecoder msgTypesGroup() {
        return this.msgTypesGroup;
    }

    public int noMsgTypesGroupCounter() {
        if (!this.hasNoMsgTypesGroupCounter) {
            throw new IllegalArgumentException("No value for optional field: NoMsgTypesGroupCounter");
        }
        return this.noMsgTypesGroupCounter;
    }

    public boolean hasNoMsgTypesGroupCounter() {
        return this.hasNoMsgTypesGroupCounter;
    }

    public MsgTypesGroupIterator msgTypesGroupIterator() {
        return this.msgTypesGroupIterator.iterator();
    }

    public boolean testMessageIndicator() {
        if (!this.hasTestMessageIndicator) {
            throw new IllegalArgumentException("No value for optional field: TestMessageIndicator");
        }
        return this.testMessageIndicator;
    }

    public boolean hasTestMessageIndicator() {
        return this.hasTestMessageIndicator;
    }

    public char[] username() {
        if (!this.hasUsername) {
            throw new IllegalArgumentException("No value for optional field: Username");
        }
        return this.username;
    }

    public boolean hasUsername() {
        return this.hasUsername;
    }

    public int usernameLength() {
        if (!this.hasUsername) {
            throw new IllegalArgumentException("No value for optional field: Username");
        }
        return this.usernameLength;
    }

    public String usernameAsString() {
        return this.hasUsername ? new String(this.username, 0, this.usernameLength) : null;
    }

    public void username(AsciiSequenceView view) {
        if (!this.hasUsername) {
            throw new IllegalArgumentException("No value for optional field: Username");
        }
        view.wrap((DirectBuffer)this.buffer, this.usernameOffset, this.usernameLength);
    }

    public char[] password() {
        if (!this.hasPassword) {
            throw new IllegalArgumentException("No value for optional field: Password");
        }
        return this.password;
    }

    public boolean hasPassword() {
        return this.hasPassword;
    }

    public int passwordLength() {
        if (!this.hasPassword) {
            throw new IllegalArgumentException("No value for optional field: Password");
        }
        return this.passwordLength;
    }

    public String passwordAsString() {
        return this.hasPassword ? new String(this.password, 0, this.passwordLength) : null;
    }

    public void password(AsciiSequenceView view) {
        if (!this.hasPassword) {
            throw new IllegalArgumentException("No value for optional field: Password");
        }
        view.wrap((DirectBuffer)this.buffer, this.passwordOffset, this.passwordLength);
    }

    public char[] newPassword() {
        if (!this.hasNewPassword) {
            throw new IllegalArgumentException("No value for optional field: NewPassword");
        }
        return this.newPassword;
    }

    public boolean hasNewPassword() {
        return this.hasNewPassword;
    }

    public int newPasswordLength() {
        if (!this.hasNewPassword) {
            throw new IllegalArgumentException("No value for optional field: NewPassword");
        }
        return this.newPasswordLength;
    }

    public String newPasswordAsString() {
        return this.hasNewPassword ? new String(this.newPassword, 0, this.newPasswordLength) : null;
    }

    public void newPassword(AsciiSequenceView view) {
        if (!this.hasNewPassword) {
            throw new IllegalArgumentException("No value for optional field: NewPassword");
        }
        view.wrap((DirectBuffer)this.buffer, this.newPasswordOffset, this.newPasswordLength);
    }

    public int encryptedPasswordMethod() {
        if (!this.hasEncryptedPasswordMethod) {
            throw new IllegalArgumentException("No value for optional field: EncryptedPasswordMethod");
        }
        return this.encryptedPasswordMethod;
    }

    public boolean hasEncryptedPasswordMethod() {
        return this.hasEncryptedPasswordMethod;
    }

    public int encryptedPasswordLen() {
        if (!this.hasEncryptedPasswordLen) {
            throw new IllegalArgumentException("No value for optional field: EncryptedPasswordLen");
        }
        return this.encryptedPasswordLen;
    }

    public boolean hasEncryptedPasswordLen() {
        return this.hasEncryptedPasswordLen;
    }

    public byte[] encryptedPassword() {
        if (!this.hasEncryptedPassword) {
            throw new IllegalArgumentException("No value for optional field: EncryptedPassword");
        }
        return this.encryptedPassword;
    }

    public boolean hasEncryptedPassword() {
        return this.hasEncryptedPassword;
    }

    public int encryptedNewPasswordLen() {
        if (!this.hasEncryptedNewPasswordLen) {
            throw new IllegalArgumentException("No value for optional field: EncryptedNewPasswordLen");
        }
        return this.encryptedNewPasswordLen;
    }

    public boolean hasEncryptedNewPasswordLen() {
        return this.hasEncryptedNewPasswordLen;
    }

    public byte[] encryptedNewPassword() {
        if (!this.hasEncryptedNewPassword) {
            throw new IllegalArgumentException("No value for optional field: EncryptedNewPassword");
        }
        return this.encryptedNewPassword;
    }

    public boolean hasEncryptedNewPassword() {
        return this.hasEncryptedNewPassword;
    }

    public int sessionStatus() {
        if (!this.hasSessionStatus) {
            throw new IllegalArgumentException("No value for optional field: SessionStatus");
        }
        return this.sessionStatus;
    }

    public boolean hasSessionStatus() {
        return this.hasSessionStatus;
    }

    public SessionStatus sessionStatusAsEnum() {
        return this.hasSessionStatus ? SessionStatus.decode(this.sessionStatus) : SessionStatus.NULL_VAL;
    }

    public char[] defaultApplVerID() {
        return this.defaultApplVerID;
    }

    public int defaultApplVerIDLength() {
        return this.defaultApplVerIDLength;
    }

    public String defaultApplVerIDAsString() {
        return new String(this.defaultApplVerID, 0, this.defaultApplVerIDLength);
    }

    public void defaultApplVerID(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.defaultApplVerIDOffset, this.defaultApplVerIDLength);
    }

    public int defaultApplExtID() {
        if (!this.hasDefaultApplExtID) {
            throw new IllegalArgumentException("No value for optional field: DefaultApplExtID");
        }
        return this.defaultApplExtID;
    }

    public boolean hasDefaultApplExtID() {
        return this.hasDefaultApplExtID;
    }

    public char[] defaultCstmApplVerID() {
        if (!this.hasDefaultCstmApplVerID) {
            throw new IllegalArgumentException("No value for optional field: DefaultCstmApplVerID");
        }
        return this.defaultCstmApplVerID;
    }

    public boolean hasDefaultCstmApplVerID() {
        return this.hasDefaultCstmApplVerID;
    }

    public int defaultCstmApplVerIDLength() {
        if (!this.hasDefaultCstmApplVerID) {
            throw new IllegalArgumentException("No value for optional field: DefaultCstmApplVerID");
        }
        return this.defaultCstmApplVerIDLength;
    }

    public String defaultCstmApplVerIDAsString() {
        return this.hasDefaultCstmApplVerID ? new String(this.defaultCstmApplVerID, 0, this.defaultCstmApplVerIDLength) : null;
    }

    public void defaultCstmApplVerID(AsciiSequenceView view) {
        if (!this.hasDefaultCstmApplVerID) {
            throw new IllegalArgumentException("No value for optional field: DefaultCstmApplVerID");
        }
        view.wrap((DirectBuffer)this.buffer, this.defaultCstmApplVerIDOffset, this.defaultCstmApplVerIDLength);
    }

    public char[] text() {
        if (!this.hasText) {
            throw new IllegalArgumentException("No value for optional field: Text");
        }
        return this.text;
    }

    public boolean hasText() {
        return this.hasText;
    }

    public int textLength() {
        if (!this.hasText) {
            throw new IllegalArgumentException("No value for optional field: Text");
        }
        return this.textLength;
    }

    public String textAsString() {
        return this.hasText ? new String(this.text, 0, this.textLength) : null;
    }

    public void text(AsciiSequenceView view) {
        if (!this.hasText) {
            throw new IllegalArgumentException("No value for optional field: Text");
        }
        view.wrap((DirectBuffer)this.buffer, this.textOffset, this.textLength);
    }

    public int encodedTextLen() {
        if (!this.hasEncodedTextLen) {
            throw new IllegalArgumentException("No value for optional field: EncodedTextLen");
        }
        return this.encodedTextLen;
    }

    public boolean hasEncodedTextLen() {
        return this.hasEncodedTextLen;
    }

    public byte[] encodedText() {
        if (!this.hasEncodedText) {
            throw new IllegalArgumentException("No value for optional field: EncodedText");
        }
        return this.encodedText;
    }

    public boolean hasEncodedText() {
        return this.hasEncodedText;
    }

    public int decode(AsciiBuffer buffer, int offset, int length) {
        int seenFieldCount = 0;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.missingRequiredFields.copy(this.REQUIRED_FIELDS);
            this.alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        int end = offset + length;
        int position = offset;
        position += this.header.decode(buffer, position, length);
        while (position < end) {
            int equalsPosition = buffer.scan(position, end, '=');
            int tag = buffer.getInt(position, equalsPosition);
            int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, (byte)1);
            int valueLength = endOfField - valueOffset;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                if (tag <= 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 0;
                } else if (valueLength == 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 4;
                }
                if (!this.alreadyVisitedFields.add(tag)) {
                    this.invalidTagId = tag;
                    this.rejectReason = 13;
                }
                this.missingRequiredFields.remove(tag);
                ++seenFieldCount;
            }
            switch (tag) {
                case 98: {
                    this.encryptMethod = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 108: {
                    this.heartBtInt = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 95: {
                    this.hasRawDataLength = true;
                    this.rawDataLength = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 96: {
                    this.hasRawData = true;
                    this.rawData = buffer.getBytes(this.rawData, valueOffset, valueLength);
                    break;
                }
                case 141: {
                    this.hasResetSeqNumFlag = true;
                    this.resetSeqNumFlag = buffer.getBoolean(valueOffset);
                    break;
                }
                case 789: {
                    this.hasNextExpectedMsgSeqNum = true;
                    this.nextExpectedMsgSeqNum = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 383: {
                    this.hasMaxMessageSize = true;
                    this.maxMessageSize = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 384: {
                    this.hasNoMsgTypesGroupCounter = true;
                    this.noMsgTypesGroupCounter = buffer.getInt(valueOffset, endOfField);
                    if (this.msgTypesGroup == null) {
                        this.msgTypesGroup = new MsgTypesGroupDecoder(this.trailer, this.messageFields);
                    }
                    MsgTypesGroupDecoder msgTypesGroupCurrent = this.msgTypesGroup;
                    position = endOfField + 1;
                    for (int i = 0; i < this.noMsgTypesGroupCounter && position < end; ++i) {
                        if (msgTypesGroupCurrent == null) continue;
                        position += msgTypesGroupCurrent.decode(buffer, position, end - position);
                        msgTypesGroupCurrent = msgTypesGroupCurrent.next();
                    }
                    break;
                }
                case 464: {
                    this.hasTestMessageIndicator = true;
                    this.testMessageIndicator = buffer.getBoolean(valueOffset);
                    break;
                }
                case 553: {
                    this.hasUsername = true;
                    this.username = buffer.getChars(this.username, valueOffset, valueLength);
                    this.usernameOffset = valueOffset;
                    this.usernameLength = valueLength;
                    break;
                }
                case 554: {
                    this.hasPassword = true;
                    this.password = buffer.getChars(this.password, valueOffset, valueLength);
                    this.passwordOffset = valueOffset;
                    this.passwordLength = valueLength;
                    break;
                }
                case 925: {
                    this.hasNewPassword = true;
                    this.newPassword = buffer.getChars(this.newPassword, valueOffset, valueLength);
                    this.newPasswordOffset = valueOffset;
                    this.newPasswordLength = valueLength;
                    break;
                }
                case 1400: {
                    this.hasEncryptedPasswordMethod = true;
                    this.encryptedPasswordMethod = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 1401: {
                    this.hasEncryptedPasswordLen = true;
                    this.encryptedPasswordLen = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 1402: {
                    this.hasEncryptedPassword = true;
                    this.encryptedPassword = buffer.getBytes(this.encryptedPassword, valueOffset, valueLength);
                    break;
                }
                case 1403: {
                    this.hasEncryptedNewPasswordLen = true;
                    this.encryptedNewPasswordLen = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 1404: {
                    this.hasEncryptedNewPassword = true;
                    this.encryptedNewPassword = buffer.getBytes(this.encryptedNewPassword, valueOffset, valueLength);
                    break;
                }
                case 1409: {
                    this.hasSessionStatus = true;
                    this.sessionStatus = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 1137: {
                    this.defaultApplVerID = buffer.getChars(this.defaultApplVerID, valueOffset, valueLength);
                    this.defaultApplVerIDOffset = valueOffset;
                    this.defaultApplVerIDLength = valueLength;
                    break;
                }
                case 1407: {
                    this.hasDefaultApplExtID = true;
                    this.defaultApplExtID = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 1408: {
                    this.hasDefaultCstmApplVerID = true;
                    this.defaultCstmApplVerID = buffer.getChars(this.defaultCstmApplVerID, valueOffset, valueLength);
                    this.defaultCstmApplVerIDOffset = valueOffset;
                    this.defaultCstmApplVerIDLength = valueLength;
                    break;
                }
                case 58: {
                    this.hasText = true;
                    this.text = buffer.getChars(this.text, valueOffset, valueLength);
                    this.textOffset = valueOffset;
                    this.textLength = valueLength;
                    break;
                }
                case 354: {
                    this.hasEncodedTextLen = true;
                    this.encodedTextLen = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 355: {
                    this.hasEncodedText = true;
                    this.encodedText = buffer.getBytes(this.encodedText, valueOffset, valueLength);
                    break;
                }
                default: {
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                        this.alreadyVisitedFields.remove(tag);
                    } else if (!this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) {
                        this.unknownFields.add(tag);
                    }
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && !this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) break;
                    position += this.trailer.decode(buffer, position, end - position);
                    return position - offset;
                }
            }
            if (position >= endOfField + 1) continue;
            position = endOfField + 1;
        }
        position += this.trailer.decode(buffer, position, end - position);
        return position - offset;
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.invalidTagId = -1;
            this.rejectReason = -1;
            this.missingRequiredFields.clear();
            this.unknownFields.clear();
            this.alreadyVisitedFields.clear();
        }
    }

    public void resetMessage() {
        this.resetEncryptMethod();
        this.resetHeartBtInt();
        this.resetRawDataLength();
        this.resetRawData();
        this.resetResetSeqNumFlag();
        this.resetNextExpectedMsgSeqNum();
        this.resetMaxMessageSize();
        this.resetTestMessageIndicator();
        this.resetUsername();
        this.resetPassword();
        this.resetNewPassword();
        this.resetEncryptedPasswordMethod();
        this.resetEncryptedPasswordLen();
        this.resetEncryptedPassword();
        this.resetEncryptedNewPasswordLen();
        this.resetEncryptedNewPassword();
        this.resetSessionStatus();
        this.resetDefaultApplVerID();
        this.resetDefaultApplExtID();
        this.resetDefaultCstmApplVerID();
        this.resetText();
        this.resetEncodedTextLen();
        this.resetEncodedText();
        this.resetMsgTypesGroup();
    }

    public void resetEncryptMethod() {
        this.encryptMethod = Integer.MIN_VALUE;
    }

    public void resetHeartBtInt() {
        this.heartBtInt = Integer.MIN_VALUE;
    }

    public void resetRawDataLength() {
        this.hasRawDataLength = false;
    }

    public void resetRawData() {
        this.hasRawData = false;
    }

    public void resetResetSeqNumFlag() {
        this.hasResetSeqNumFlag = false;
    }

    public void resetNextExpectedMsgSeqNum() {
        this.hasNextExpectedMsgSeqNum = false;
    }

    public void resetMaxMessageSize() {
        this.hasMaxMessageSize = false;
    }

    public void resetTestMessageIndicator() {
        this.hasTestMessageIndicator = false;
    }

    public void resetUsername() {
        this.hasUsername = false;
    }

    public void resetPassword() {
        this.hasPassword = false;
    }

    public void resetNewPassword() {
        this.hasNewPassword = false;
    }

    public void resetEncryptedPasswordMethod() {
        this.hasEncryptedPasswordMethod = false;
    }

    public void resetEncryptedPasswordLen() {
        this.hasEncryptedPasswordLen = false;
    }

    public void resetEncryptedPassword() {
        this.hasEncryptedPassword = false;
    }

    public void resetEncryptedNewPasswordLen() {
        this.hasEncryptedNewPasswordLen = false;
    }

    public void resetEncryptedNewPassword() {
        this.hasEncryptedNewPassword = false;
    }

    public void resetSessionStatus() {
        this.hasSessionStatus = false;
    }

    public void resetDefaultApplVerID() {
        this.defaultApplVerIDOffset = 0;
        this.defaultApplVerIDLength = 0;
    }

    public void resetDefaultApplExtID() {
        this.hasDefaultApplExtID = false;
    }

    public void resetDefaultCstmApplVerID() {
        this.hasDefaultCstmApplVerID = false;
    }

    public void resetText() {
        this.hasText = false;
    }

    public void resetEncodedTextLen() {
        this.hasEncodedTextLen = false;
    }

    public void resetEncodedText() {
        this.hasEncodedText = false;
    }

    public void resetMsgTypesGroup() {
        for (MsgTypesGroupDecoder msgTypesGroupDecoder : this.msgTypesGroupIterator.iterator()) {
            msgTypesGroupDecoder.reset();
            if (msgTypesGroupDecoder.next() != null) continue;
            break;
        }
        this.noMsgTypesGroupCounter = 0;
        this.hasNoMsgTypesGroupCounter = false;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + String.format("  \"EncryptMethod\": \"%s\",\n", this.encryptMethod) + String.format("  \"HeartBtInt\": \"%s\",\n", this.heartBtInt) + (this.hasRawDataLength() ? String.format("  \"RawDataLength\": \"%s\",\n", this.rawDataLength) : "") + (this.hasRawData() ? String.format("  \"RawData\": \"%s\",\n", Arrays.toString(this.rawData)) : "") + (this.hasResetSeqNumFlag() ? String.format("  \"ResetSeqNumFlag\": \"%s\",\n", this.resetSeqNumFlag) : "") + (this.hasNextExpectedMsgSeqNum() ? String.format("  \"NextExpectedMsgSeqNum\": \"%s\",\n", this.nextExpectedMsgSeqNum) : "") + (this.hasMaxMessageSize() ? String.format("  \"MaxMessageSize\": \"%s\",\n", this.maxMessageSize) : "") + (this.hasNoMsgTypesGroupCounter ? String.format("  \"MsgTypesGroup\": [\n  %s\n  ]\n", this.msgTypesGroup.toString().replace("\n", "\n  ")) : "") + (this.hasTestMessageIndicator() ? String.format("  \"TestMessageIndicator\": \"%s\",\n", this.testMessageIndicator) : "") + (this.hasUsername() ? String.format("  \"Username\": \"%s\",\n", new String(this.username, 0, this.usernameLength)) : "") + (this.hasPassword() ? String.format("  \"Password\": \"%s\",\n", new String(this.password, 0, this.passwordLength)) : "") + (this.hasNewPassword() ? String.format("  \"NewPassword\": \"%s\",\n", new String(this.newPassword, 0, this.newPasswordLength)) : "") + (this.hasEncryptedPasswordMethod() ? String.format("  \"EncryptedPasswordMethod\": \"%s\",\n", this.encryptedPasswordMethod) : "") + (this.hasEncryptedPasswordLen() ? String.format("  \"EncryptedPasswordLen\": \"%s\",\n", this.encryptedPasswordLen) : "") + (this.hasEncryptedPassword() ? String.format("  \"EncryptedPassword\": \"%s\",\n", Arrays.toString(this.encryptedPassword)) : "") + (this.hasEncryptedNewPasswordLen() ? String.format("  \"EncryptedNewPasswordLen\": \"%s\",\n", this.encryptedNewPasswordLen) : "") + (this.hasEncryptedNewPassword() ? String.format("  \"EncryptedNewPassword\": \"%s\",\n", Arrays.toString(this.encryptedNewPassword)) : "") + (this.hasSessionStatus() ? String.format("  \"SessionStatus\": \"%s\",\n", this.sessionStatus) : "") + String.format("  \"DefaultApplVerID\": \"%s\",\n", new String(this.defaultApplVerID, 0, this.defaultApplVerIDLength)) + (this.hasDefaultApplExtID() ? String.format("  \"DefaultApplExtID\": \"%s\",\n", this.defaultApplExtID) : "") + (this.hasDefaultCstmApplVerID() ? String.format("  \"DefaultCstmApplVerID\": \"%s\",\n", new String(this.defaultCstmApplVerID, 0, this.defaultCstmApplVerIDLength)) : "") + (this.hasText() ? String.format("  \"Text\": \"%s\",\n", new String(this.text, 0, this.textLength)) : "") + (this.hasEncodedTextLen() ? String.format("  \"EncodedTextLen\": \"%s\",\n", this.encodedTextLen) : "") + (this.hasEncodedText() ? String.format("  \"EncodedText\": \"%s\",\n", Arrays.toString(this.encodedText)) : "");
        entries = "{\n  \"MessageName\": \"Logon\",\n" + entries + "}";
        return entries;
    }

    public class MsgTypesGroupIterator
    implements Iterable<MsgTypesGroupDecoder>,
    Iterator<MsgTypesGroupDecoder> {
        private int remainder;
        private MsgTypesGroupDecoder current;

        @Override
        public boolean hasNext() {
            return this.remainder > 0;
        }

        @Override
        public MsgTypesGroupDecoder next() {
            --this.remainder;
            MsgTypesGroupDecoder value = this.current;
            this.current = this.current.next();
            return value;
        }

        public void reset() {
            this.remainder = LogonDecoder.this.noMsgTypesGroupCounter;
            this.current = LogonDecoder.this.msgTypesGroup();
        }

        public MsgTypesGroupIterator iterator() {
            this.reset();
            return this;
        }
    }

    public class MsgTypesGroupDecoder
    implements Decoder {
        public final IntHashSet REQUIRED_FIELDS = new IntHashSet(0);
        private final IntHashSet missingRequiredFields;
        private int invalidTagId;
        private int rejectReason;
        private final TrailerDecoder trailer;
        private final IntHashSet messageFields;
        private MsgTypesGroupDecoder next;
        private IntHashSet seenFields;
        private char[] refMsgType;
        private boolean hasRefMsgType;
        private int refMsgTypeLength;
        private int refMsgTypeOffset;
        private char msgDirection;
        private boolean hasMsgDirection;
        private char[] refApplVerID;
        private boolean hasRefApplVerID;
        private int refApplVerIDLength;
        private int refApplVerIDOffset;
        private int refApplExtID;
        private boolean hasRefApplExtID;
        private char[] refCstmApplVerID;
        private boolean hasRefCstmApplVerID;
        private int refCstmApplVerIDLength;
        private int refCstmApplVerIDOffset;
        private boolean defaultVerIndicator;
        private boolean hasDefaultVerIndicator;
        private AsciiBuffer buffer;

        public int invalidTagId() {
            return this.invalidTagId;
        }

        public int rejectReason() {
            return this.rejectReason;
        }

        public boolean validate() {
            if (this.rejectReason != -1) {
                return false;
            }
            IntHashSet.IntIterator missingFieldsIterator = this.missingRequiredFields.iterator();
            if (missingFieldsIterator.hasNext()) {
                this.invalidTagId = missingFieldsIterator.nextValue();
                this.rejectReason = 1;
                return false;
            }
            if (this.hasMsgDirection && !MsgDirection.isValid(this.msgDirection)) {
                this.invalidTagId = 385;
                this.rejectReason = 5;
                return false;
            }
            return true;
        }

        public MsgTypesGroupDecoder(TrailerDecoder trailer, IntHashSet messageFields) {
            if (Validation.CODEC_VALIDATION_ENABLED) {
                // empty if block
            }
            this.missingRequiredFields = new IntHashSet(0);
            this.invalidTagId = -1;
            this.rejectReason = -1;
            this.next = null;
            this.seenFields = new IntHashSet(12);
            this.refMsgType = new char[1];
            this.refApplVerID = new char[1];
            this.refCstmApplVerID = new char[1];
            this.trailer = trailer;
            this.messageFields = messageFields;
        }

        public MsgTypesGroupDecoder next() {
            return this.next;
        }

        public char[] refMsgType() {
            if (!this.hasRefMsgType) {
                throw new IllegalArgumentException("No value for optional field: RefMsgType");
            }
            return this.refMsgType;
        }

        public boolean hasRefMsgType() {
            return this.hasRefMsgType;
        }

        public int refMsgTypeLength() {
            if (!this.hasRefMsgType) {
                throw new IllegalArgumentException("No value for optional field: RefMsgType");
            }
            return this.refMsgTypeLength;
        }

        public String refMsgTypeAsString() {
            return this.hasRefMsgType ? new String(this.refMsgType, 0, this.refMsgTypeLength) : null;
        }

        public void refMsgType(AsciiSequenceView view) {
            if (!this.hasRefMsgType) {
                throw new IllegalArgumentException("No value for optional field: RefMsgType");
            }
            view.wrap((DirectBuffer)this.buffer, this.refMsgTypeOffset, this.refMsgTypeLength);
        }

        public char msgDirection() {
            if (!this.hasMsgDirection) {
                throw new IllegalArgumentException("No value for optional field: MsgDirection");
            }
            return this.msgDirection;
        }

        public boolean hasMsgDirection() {
            return this.hasMsgDirection;
        }

        public MsgDirection msgDirectionAsEnum() {
            return this.hasMsgDirection ? MsgDirection.decode(this.msgDirection) : MsgDirection.NULL_VAL;
        }

        public char[] refApplVerID() {
            if (!this.hasRefApplVerID) {
                throw new IllegalArgumentException("No value for optional field: RefApplVerID");
            }
            return this.refApplVerID;
        }

        public boolean hasRefApplVerID() {
            return this.hasRefApplVerID;
        }

        public int refApplVerIDLength() {
            if (!this.hasRefApplVerID) {
                throw new IllegalArgumentException("No value for optional field: RefApplVerID");
            }
            return this.refApplVerIDLength;
        }

        public String refApplVerIDAsString() {
            return this.hasRefApplVerID ? new String(this.refApplVerID, 0, this.refApplVerIDLength) : null;
        }

        public void refApplVerID(AsciiSequenceView view) {
            if (!this.hasRefApplVerID) {
                throw new IllegalArgumentException("No value for optional field: RefApplVerID");
            }
            view.wrap((DirectBuffer)this.buffer, this.refApplVerIDOffset, this.refApplVerIDLength);
        }

        public int refApplExtID() {
            if (!this.hasRefApplExtID) {
                throw new IllegalArgumentException("No value for optional field: RefApplExtID");
            }
            return this.refApplExtID;
        }

        public boolean hasRefApplExtID() {
            return this.hasRefApplExtID;
        }

        public char[] refCstmApplVerID() {
            if (!this.hasRefCstmApplVerID) {
                throw new IllegalArgumentException("No value for optional field: RefCstmApplVerID");
            }
            return this.refCstmApplVerID;
        }

        public boolean hasRefCstmApplVerID() {
            return this.hasRefCstmApplVerID;
        }

        public int refCstmApplVerIDLength() {
            if (!this.hasRefCstmApplVerID) {
                throw new IllegalArgumentException("No value for optional field: RefCstmApplVerID");
            }
            return this.refCstmApplVerIDLength;
        }

        public String refCstmApplVerIDAsString() {
            return this.hasRefCstmApplVerID ? new String(this.refCstmApplVerID, 0, this.refCstmApplVerIDLength) : null;
        }

        public void refCstmApplVerID(AsciiSequenceView view) {
            if (!this.hasRefCstmApplVerID) {
                throw new IllegalArgumentException("No value for optional field: RefCstmApplVerID");
            }
            view.wrap((DirectBuffer)this.buffer, this.refCstmApplVerIDOffset, this.refCstmApplVerIDLength);
        }

        public boolean defaultVerIndicator() {
            if (!this.hasDefaultVerIndicator) {
                throw new IllegalArgumentException("No value for optional field: DefaultVerIndicator");
            }
            return this.defaultVerIndicator;
        }

        public boolean hasDefaultVerIndicator() {
            return this.hasDefaultVerIndicator;
        }

        public int decode(AsciiBuffer buffer, int offset, int length) {
            int seenFieldCount = 0;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                this.missingRequiredFields.copy(this.REQUIRED_FIELDS);
            }
            this.buffer = buffer;
            int end = offset + length;
            int position = offset;
            this.seenFields.clear();
            while (position < end) {
                int equalsPosition = buffer.scan(position, end, '=');
                int tag = buffer.getInt(position, equalsPosition);
                if (!this.seenFields.add(tag)) {
                    if (this.next == null) {
                        this.next = new MsgTypesGroupDecoder(this.trailer, this.messageFields);
                    }
                    return position - offset;
                }
                int valueOffset = equalsPosition + 1;
                int endOfField = buffer.scan(valueOffset, end, (byte)1);
                int valueLength = endOfField - valueOffset;
                if (Validation.CODEC_VALIDATION_ENABLED) {
                    if (tag <= 0) {
                        this.invalidTagId = tag;
                        this.rejectReason = 0;
                    } else if (valueLength == 0) {
                        this.invalidTagId = tag;
                        this.rejectReason = 4;
                    }
                    this.missingRequiredFields.remove(tag);
                    ++seenFieldCount;
                }
                switch (tag) {
                    case 372: {
                        this.hasRefMsgType = true;
                        this.refMsgType = buffer.getChars(this.refMsgType, valueOffset, valueLength);
                        this.refMsgTypeOffset = valueOffset;
                        this.refMsgTypeLength = valueLength;
                        break;
                    }
                    case 385: {
                        this.hasMsgDirection = true;
                        this.msgDirection = buffer.getChar(valueOffset);
                        break;
                    }
                    case 1130: {
                        this.hasRefApplVerID = true;
                        this.refApplVerID = buffer.getChars(this.refApplVerID, valueOffset, valueLength);
                        this.refApplVerIDOffset = valueOffset;
                        this.refApplVerIDLength = valueLength;
                        break;
                    }
                    case 1406: {
                        this.hasRefApplExtID = true;
                        this.refApplExtID = buffer.getInt(valueOffset, endOfField);
                        break;
                    }
                    case 1131: {
                        this.hasRefCstmApplVerID = true;
                        this.refCstmApplVerID = buffer.getChars(this.refCstmApplVerID, valueOffset, valueLength);
                        this.refCstmApplVerIDOffset = valueOffset;
                        this.refCstmApplVerIDLength = valueLength;
                        break;
                    }
                    case 1410: {
                        this.hasDefaultVerIndicator = true;
                        this.defaultVerIndicator = buffer.getBoolean(valueOffset);
                        break;
                    }
                    default: {
                        if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                            this.seenFields.remove(tag);
                        }
                        if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && !this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) break;
                        return position - offset;
                    }
                }
                if (position >= endOfField + 1) continue;
                position = endOfField + 1;
            }
            return position - offset;
        }

        public void reset() {
            this.resetRefMsgType();
            this.resetMsgDirection();
            this.resetRefApplVerID();
            this.resetRefApplExtID();
            this.resetRefCstmApplVerID();
            this.resetDefaultVerIndicator();
            if (Validation.CODEC_VALIDATION_ENABLED) {
                this.invalidTagId = -1;
                this.rejectReason = -1;
                this.missingRequiredFields.clear();
            }
        }

        public void resetRefMsgType() {
            this.hasRefMsgType = false;
        }

        public void resetMsgDirection() {
            this.hasMsgDirection = false;
        }

        public void resetRefApplVerID() {
            this.hasRefApplVerID = false;
        }

        public void resetRefApplExtID() {
            this.hasRefApplExtID = false;
        }

        public void resetRefCstmApplVerID() {
            this.hasRefCstmApplVerID = false;
        }

        public void resetDefaultVerIndicator() {
            this.hasDefaultVerIndicator = false;
        }

        public String toString() {
            String entries = (this.hasRefMsgType() ? String.format("  \"RefMsgType\": \"%s\",\n", new String(this.refMsgType, 0, this.refMsgTypeLength)) : "") + (this.hasMsgDirection() ? String.format("  \"MsgDirection\": \"%s\",\n", Character.valueOf(this.msgDirection)) : "") + (this.hasRefApplVerID() ? String.format("  \"RefApplVerID\": \"%s\",\n", new String(this.refApplVerID, 0, this.refApplVerIDLength)) : "") + (this.hasRefApplExtID() ? String.format("  \"RefApplExtID\": \"%s\",\n", this.refApplExtID) : "") + (this.hasRefCstmApplVerID() ? String.format("  \"RefCstmApplVerID\": \"%s\",\n", new String(this.refCstmApplVerID, 0, this.refCstmApplVerIDLength)) : "") + (this.hasDefaultVerIndicator() ? String.format("  \"DefaultVerIndicator\": \"%s\",\n", this.defaultVerIndicator) : "");
            entries = "{\n  \"MessageName\": \"MsgTypesGroup\",\n" + entries + "}";
            if (this.next != null) {
                entries = entries + ",\n" + this.next.toString();
            }
            return entries;
        }
    }
}

