/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class TestRequestEncoder
implements Encoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int testReqIDHeaderLength = 4;
    private static final byte[] testReqIDHeader = new byte[]{49, 49, 50, 61};
    private byte[] testReqID = new byte[1];
    private int testReqIDOffset = 0;
    private int testReqIDLength = 0;
    public static int MAX_HEADER_PREFIX_LENGTH = 23;

    public int messageType() {
        return 49;
    }

    public TestRequestEncoder() {
        this.header.msgType("1");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public TestRequestEncoder testReqID(byte[] value, int length) {
        this.testReqID = value;
        this.testReqIDOffset = 0;
        this.testReqIDLength = length;
        return this;
    }

    public TestRequestEncoder testReqID(byte[] value, int offset, int length) {
        this.testReqID = value;
        this.testReqIDOffset = offset;
        this.testReqIDLength = length;
        return this;
    }

    public TestRequestEncoder testReqID(byte[] value) {
        return this.testReqID(value, value.length);
    }

    public boolean hasTestReqID() {
        return this.testReqIDLength > 0;
    }

    public byte[] testReqID() {
        return this.testReqID;
    }

    public TestRequestEncoder testReqID(CharSequence value) {
        this.testReqID = CodecUtil.toBytes((CharSequence)value, (byte[])this.testReqID);
        this.testReqIDOffset = 0;
        this.testReqIDLength = value.length();
        return this;
    }

    public TestRequestEncoder testReqID(char[] value) {
        return this.testReqID(value, value.length);
    }

    public TestRequestEncoder testReqID(char[] value, int length) {
        this.testReqID = CodecUtil.toBytes((char[])value, (byte[])this.testReqID, (int)length);
        this.testReqIDOffset = 0;
        this.testReqIDLength = length;
        return this;
    }

    public TestRequestEncoder testReqID(char[] value, int offset, int length) {
        this.testReqID = CodecUtil.toBytes((char[])value, (byte[])this.testReqID, (int)offset, (int)length);
        this.testReqIDOffset = 0;
        this.testReqIDLength = length;
        return this;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        int start;
        int position = start = offset + MAX_HEADER_PREFIX_LENGTH;
        position += this.header.encode(buffer, position);
        if (this.testReqIDLength > 0) {
            buffer.putBytes(position, testReqIDHeader, 0, 4);
            buffer.putBytes(position += 4, this.testReqID, this.testReqIDOffset, this.testReqIDLength);
            buffer.putSeparator(position += this.testReqIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: TestReqID");
        }
        position += this.trailer.encode(buffer, position, start);
        int realStart = this.trailer.realStart;
        return Encoder.result((int)(position - realStart), (int)realStart);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetTestReqID();
    }

    public void resetTestReqID() {
        this.testReqIDLength = 0;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasTestReqID() ? String.format("  \"TestReqID\": \"%s\",\n", new String(this.testReqID, this.testReqIDOffset, this.testReqIDLength, StandardCharsets.US_ASCII)) : "");
        entries = "{\n  \"MessageName\": \"TestRequest\",\n" + entries + "}";
        return entries;
    }
}

