/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.SessionRejectReason;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class RejectEncoder
implements Encoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int refSeqNumHeaderLength = 3;
    private static final byte[] refSeqNumHeader = new byte[]{52, 53, 61};
    private static final int refTagIDHeaderLength = 4;
    private static final byte[] refTagIDHeader = new byte[]{51, 55, 49, 61};
    private static final int refMsgTypeHeaderLength = 4;
    private static final byte[] refMsgTypeHeader = new byte[]{51, 55, 50, 61};
    private static final int refApplVerIDHeaderLength = 5;
    private static final byte[] refApplVerIDHeader = new byte[]{49, 49, 51, 48, 61};
    private static final int refApplExtIDHeaderLength = 5;
    private static final byte[] refApplExtIDHeader = new byte[]{49, 52, 48, 54, 61};
    private static final int refCstmApplVerIDHeaderLength = 5;
    private static final byte[] refCstmApplVerIDHeader = new byte[]{49, 49, 51, 49, 61};
    private static final int sessionRejectReasonHeaderLength = 4;
    private static final byte[] sessionRejectReasonHeader = new byte[]{51, 55, 51, 61};
    private static final int textHeaderLength = 3;
    private static final byte[] textHeader = new byte[]{53, 56, 61};
    private static final int encodedTextLenHeaderLength = 4;
    private static final byte[] encodedTextLenHeader = new byte[]{51, 53, 52, 61};
    private static final int encodedTextHeaderLength = 4;
    private static final byte[] encodedTextHeader = new byte[]{51, 53, 53, 61};
    private int refSeqNum;
    private boolean hasRefSeqNum;
    private int refTagID;
    private boolean hasRefTagID;
    private byte[] refMsgType = new byte[1];
    private int refMsgTypeOffset = 0;
    private int refMsgTypeLength = 0;
    private byte[] refApplVerID = new byte[1];
    private int refApplVerIDOffset = 0;
    private int refApplVerIDLength = 0;
    private int refApplExtID;
    private boolean hasRefApplExtID;
    private byte[] refCstmApplVerID = new byte[1];
    private int refCstmApplVerIDOffset = 0;
    private int refCstmApplVerIDLength = 0;
    private int sessionRejectReason;
    private boolean hasSessionRejectReason;
    private byte[] text = new byte[1];
    private int textOffset = 0;
    private int textLength = 0;
    private int encodedTextLen;
    private boolean hasEncodedTextLen;
    private byte[] encodedText;
    private boolean hasEncodedText;
    public static int MAX_HEADER_PREFIX_LENGTH = 23;

    public int messageType() {
        return 51;
    }

    public RejectEncoder() {
        this.header.msgType("3");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public boolean hasRefSeqNum() {
        return this.hasRefSeqNum;
    }

    public RejectEncoder refSeqNum(int value) {
        this.refSeqNum = value;
        this.hasRefSeqNum = true;
        return this;
    }

    public int refSeqNum() {
        return this.refSeqNum;
    }

    public boolean hasRefTagID() {
        return this.hasRefTagID;
    }

    public RejectEncoder refTagID(int value) {
        this.refTagID = value;
        this.hasRefTagID = true;
        return this;
    }

    public int refTagID() {
        return this.refTagID;
    }

    public RejectEncoder refMsgType(byte[] value, int length) {
        this.refMsgType = value;
        this.refMsgTypeOffset = 0;
        this.refMsgTypeLength = length;
        return this;
    }

    public RejectEncoder refMsgType(byte[] value, int offset, int length) {
        this.refMsgType = value;
        this.refMsgTypeOffset = offset;
        this.refMsgTypeLength = length;
        return this;
    }

    public RejectEncoder refMsgType(byte[] value) {
        return this.refMsgType(value, value.length);
    }

    public boolean hasRefMsgType() {
        return this.refMsgTypeLength > 0;
    }

    public byte[] refMsgType() {
        return this.refMsgType;
    }

    public RejectEncoder refMsgType(CharSequence value) {
        this.refMsgType = CodecUtil.toBytes((CharSequence)value, (byte[])this.refMsgType);
        this.refMsgTypeOffset = 0;
        this.refMsgTypeLength = value.length();
        return this;
    }

    public RejectEncoder refMsgType(char[] value) {
        return this.refMsgType(value, value.length);
    }

    public RejectEncoder refMsgType(char[] value, int length) {
        this.refMsgType = CodecUtil.toBytes((char[])value, (byte[])this.refMsgType, (int)length);
        this.refMsgTypeOffset = 0;
        this.refMsgTypeLength = length;
        return this;
    }

    public RejectEncoder refMsgType(char[] value, int offset, int length) {
        this.refMsgType = CodecUtil.toBytes((char[])value, (byte[])this.refMsgType, (int)offset, (int)length);
        this.refMsgTypeOffset = 0;
        this.refMsgTypeLength = length;
        return this;
    }

    public RejectEncoder refApplVerID(byte[] value, int length) {
        this.refApplVerID = value;
        this.refApplVerIDOffset = 0;
        this.refApplVerIDLength = length;
        return this;
    }

    public RejectEncoder refApplVerID(byte[] value, int offset, int length) {
        this.refApplVerID = value;
        this.refApplVerIDOffset = offset;
        this.refApplVerIDLength = length;
        return this;
    }

    public RejectEncoder refApplVerID(byte[] value) {
        return this.refApplVerID(value, value.length);
    }

    public boolean hasRefApplVerID() {
        return this.refApplVerIDLength > 0;
    }

    public byte[] refApplVerID() {
        return this.refApplVerID;
    }

    public RejectEncoder refApplVerID(CharSequence value) {
        this.refApplVerID = CodecUtil.toBytes((CharSequence)value, (byte[])this.refApplVerID);
        this.refApplVerIDOffset = 0;
        this.refApplVerIDLength = value.length();
        return this;
    }

    public RejectEncoder refApplVerID(char[] value) {
        return this.refApplVerID(value, value.length);
    }

    public RejectEncoder refApplVerID(char[] value, int length) {
        this.refApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.refApplVerID, (int)length);
        this.refApplVerIDOffset = 0;
        this.refApplVerIDLength = length;
        return this;
    }

    public RejectEncoder refApplVerID(char[] value, int offset, int length) {
        this.refApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.refApplVerID, (int)offset, (int)length);
        this.refApplVerIDOffset = 0;
        this.refApplVerIDLength = length;
        return this;
    }

    public boolean hasRefApplExtID() {
        return this.hasRefApplExtID;
    }

    public RejectEncoder refApplExtID(int value) {
        this.refApplExtID = value;
        this.hasRefApplExtID = true;
        return this;
    }

    public int refApplExtID() {
        return this.refApplExtID;
    }

    public RejectEncoder refCstmApplVerID(byte[] value, int length) {
        this.refCstmApplVerID = value;
        this.refCstmApplVerIDOffset = 0;
        this.refCstmApplVerIDLength = length;
        return this;
    }

    public RejectEncoder refCstmApplVerID(byte[] value, int offset, int length) {
        this.refCstmApplVerID = value;
        this.refCstmApplVerIDOffset = offset;
        this.refCstmApplVerIDLength = length;
        return this;
    }

    public RejectEncoder refCstmApplVerID(byte[] value) {
        return this.refCstmApplVerID(value, value.length);
    }

    public boolean hasRefCstmApplVerID() {
        return this.refCstmApplVerIDLength > 0;
    }

    public byte[] refCstmApplVerID() {
        return this.refCstmApplVerID;
    }

    public RejectEncoder refCstmApplVerID(CharSequence value) {
        this.refCstmApplVerID = CodecUtil.toBytes((CharSequence)value, (byte[])this.refCstmApplVerID);
        this.refCstmApplVerIDOffset = 0;
        this.refCstmApplVerIDLength = value.length();
        return this;
    }

    public RejectEncoder refCstmApplVerID(char[] value) {
        return this.refCstmApplVerID(value, value.length);
    }

    public RejectEncoder refCstmApplVerID(char[] value, int length) {
        this.refCstmApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.refCstmApplVerID, (int)length);
        this.refCstmApplVerIDOffset = 0;
        this.refCstmApplVerIDLength = length;
        return this;
    }

    public RejectEncoder refCstmApplVerID(char[] value, int offset, int length) {
        this.refCstmApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.refCstmApplVerID, (int)offset, (int)length);
        this.refCstmApplVerIDOffset = 0;
        this.refCstmApplVerIDLength = length;
        return this;
    }

    public boolean hasSessionRejectReason() {
        return this.hasSessionRejectReason;
    }

    public RejectEncoder sessionRejectReason(int value) {
        this.sessionRejectReason = value;
        this.hasSessionRejectReason = true;
        return this;
    }

    public int sessionRejectReason() {
        return this.sessionRejectReason;
    }

    public RejectEncoder sessionRejectReason(SessionRejectReason value) {
        return this.sessionRejectReason(value.representation());
    }

    public RejectEncoder text(byte[] value, int length) {
        this.text = value;
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public RejectEncoder text(byte[] value, int offset, int length) {
        this.text = value;
        this.textOffset = offset;
        this.textLength = length;
        return this;
    }

    public RejectEncoder text(byte[] value) {
        return this.text(value, value.length);
    }

    public boolean hasText() {
        return this.textLength > 0;
    }

    public byte[] text() {
        return this.text;
    }

    public RejectEncoder text(CharSequence value) {
        this.text = CodecUtil.toBytes((CharSequence)value, (byte[])this.text);
        this.textOffset = 0;
        this.textLength = value.length();
        return this;
    }

    public RejectEncoder text(char[] value) {
        return this.text(value, value.length);
    }

    public RejectEncoder text(char[] value, int length) {
        this.text = CodecUtil.toBytes((char[])value, (byte[])this.text, (int)length);
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public RejectEncoder text(char[] value, int offset, int length) {
        this.text = CodecUtil.toBytes((char[])value, (byte[])this.text, (int)offset, (int)length);
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public boolean hasEncodedTextLen() {
        return this.hasEncodedTextLen;
    }

    public RejectEncoder encodedTextLen(int value) {
        this.encodedTextLen = value;
        this.hasEncodedTextLen = true;
        return this;
    }

    public int encodedTextLen() {
        return this.encodedTextLen;
    }

    public boolean hasEncodedText() {
        return this.hasEncodedText;
    }

    public RejectEncoder encodedText(byte[] value) {
        this.encodedText = value;
        this.hasEncodedText = true;
        return this;
    }

    public byte[] encodedText() {
        return this.encodedText;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        int start;
        int position = start = offset + MAX_HEADER_PREFIX_LENGTH;
        position += this.header.encode(buffer, position);
        if (this.hasRefSeqNum) {
            buffer.putBytes(position, refSeqNumHeader, 0, 3);
            position += 3;
            position += buffer.putAsciiInt(position, this.refSeqNum);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: RefSeqNum");
        }
        if (this.hasRefTagID) {
            buffer.putBytes(position, refTagIDHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiInt(position, this.refTagID);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.refMsgTypeLength > 0) {
            buffer.putBytes(position, refMsgTypeHeader, 0, 4);
            buffer.putBytes(position += 4, this.refMsgType, this.refMsgTypeOffset, this.refMsgTypeLength);
            buffer.putSeparator(position += this.refMsgTypeLength);
            ++position;
        }
        if (this.refApplVerIDLength > 0) {
            buffer.putBytes(position, refApplVerIDHeader, 0, 5);
            buffer.putBytes(position += 5, this.refApplVerID, this.refApplVerIDOffset, this.refApplVerIDLength);
            buffer.putSeparator(position += this.refApplVerIDLength);
            ++position;
        }
        if (this.hasRefApplExtID) {
            buffer.putBytes(position, refApplExtIDHeader, 0, 5);
            position += 5;
            position += buffer.putAsciiInt(position, this.refApplExtID);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.refCstmApplVerIDLength > 0) {
            buffer.putBytes(position, refCstmApplVerIDHeader, 0, 5);
            buffer.putBytes(position += 5, this.refCstmApplVerID, this.refCstmApplVerIDOffset, this.refCstmApplVerIDLength);
            buffer.putSeparator(position += this.refCstmApplVerIDLength);
            ++position;
        }
        if (this.hasSessionRejectReason) {
            buffer.putBytes(position, sessionRejectReasonHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiInt(position, this.sessionRejectReason);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.textLength > 0) {
            buffer.putBytes(position, textHeader, 0, 3);
            buffer.putBytes(position += 3, this.text, this.textOffset, this.textLength);
            buffer.putSeparator(position += this.textLength);
            ++position;
        }
        if (this.hasEncodedTextLen) {
            buffer.putBytes(position, encodedTextLenHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiInt(position, this.encodedTextLen);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncodedText) {
            buffer.putBytes(position, encodedTextHeader, 0, 4);
            buffer.putBytes(position += 4, this.encodedText);
            buffer.putSeparator(position += this.encodedText.length);
            ++position;
        }
        position += this.trailer.encode(buffer, position, start);
        int realStart = this.trailer.realStart;
        return Encoder.result((int)(position - realStart), (int)realStart);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetRefSeqNum();
        this.resetRefTagID();
        this.resetRefMsgType();
        this.resetRefApplVerID();
        this.resetRefApplExtID();
        this.resetRefCstmApplVerID();
        this.resetSessionRejectReason();
        this.resetText();
        this.resetEncodedTextLen();
        this.resetEncodedText();
    }

    public void resetRefSeqNum() {
        this.hasRefSeqNum = false;
    }

    public void resetRefTagID() {
        this.hasRefTagID = false;
    }

    public void resetRefMsgType() {
        this.refMsgTypeLength = 0;
    }

    public void resetRefApplVerID() {
        this.refApplVerIDLength = 0;
    }

    public void resetRefApplExtID() {
        this.hasRefApplExtID = false;
    }

    public void resetRefCstmApplVerID() {
        this.refCstmApplVerIDLength = 0;
    }

    public void resetSessionRejectReason() {
        this.hasSessionRejectReason = false;
    }

    public void resetText() {
        this.textLength = 0;
    }

    public void resetEncodedTextLen() {
        this.hasEncodedTextLen = false;
    }

    public void resetEncodedText() {
        this.hasEncodedText = false;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasRefSeqNum() ? String.format("  \"RefSeqNum\": \"%s\",\n", this.refSeqNum) : "") + (this.hasRefTagID() ? String.format("  \"RefTagID\": \"%s\",\n", this.refTagID) : "") + (this.hasRefMsgType() ? String.format("  \"RefMsgType\": \"%s\",\n", new String(this.refMsgType, this.refMsgTypeOffset, this.refMsgTypeLength, StandardCharsets.US_ASCII)) : "") + (this.hasRefApplVerID() ? String.format("  \"RefApplVerID\": \"%s\",\n", new String(this.refApplVerID, this.refApplVerIDOffset, this.refApplVerIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasRefApplExtID() ? String.format("  \"RefApplExtID\": \"%s\",\n", this.refApplExtID) : "") + (this.hasRefCstmApplVerID() ? String.format("  \"RefCstmApplVerID\": \"%s\",\n", new String(this.refCstmApplVerID, this.refCstmApplVerIDOffset, this.refCstmApplVerIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasSessionRejectReason() ? String.format("  \"SessionRejectReason\": \"%s\",\n", this.sessionRejectReason) : "") + (this.hasText() ? String.format("  \"Text\": \"%s\",\n", new String(this.text, this.textOffset, this.textLength, StandardCharsets.US_ASCII)) : "") + (this.hasEncodedTextLen() ? String.format("  \"EncodedTextLen\": \"%s\",\n", this.encodedTextLen) : "") + (this.hasEncodedText() ? String.format("  \"EncodedText\": \"%s\",\n", Arrays.toString(this.encodedText)) : "");
        entries = "{\n  \"MessageName\": \"Reject\",\n" + entries + "}";
        return entries;
    }
}

