/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.co.real_logic.artio.SessionStatus;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class LogoutEncoder
implements Encoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int sessionStatusHeaderLength = 5;
    private static final byte[] sessionStatusHeader = new byte[]{49, 52, 48, 57, 61};
    private static final int textHeaderLength = 3;
    private static final byte[] textHeader = new byte[]{53, 56, 61};
    private static final int encodedTextLenHeaderLength = 4;
    private static final byte[] encodedTextLenHeader = new byte[]{51, 53, 52, 61};
    private static final int encodedTextHeaderLength = 4;
    private static final byte[] encodedTextHeader = new byte[]{51, 53, 53, 61};
    private int sessionStatus;
    private boolean hasSessionStatus;
    private byte[] text = new byte[1];
    private int textOffset = 0;
    private int textLength = 0;
    private int encodedTextLen;
    private boolean hasEncodedTextLen;
    private byte[] encodedText;
    private boolean hasEncodedText;
    public static int MAX_HEADER_PREFIX_LENGTH = 23;

    public int messageType() {
        return 53;
    }

    public LogoutEncoder() {
        this.header.msgType("5");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public boolean hasSessionStatus() {
        return this.hasSessionStatus;
    }

    public LogoutEncoder sessionStatus(int value) {
        this.sessionStatus = value;
        this.hasSessionStatus = true;
        return this;
    }

    public int sessionStatus() {
        return this.sessionStatus;
    }

    public LogoutEncoder sessionStatus(SessionStatus value) {
        return this.sessionStatus(value.representation());
    }

    public LogoutEncoder text(byte[] value, int length) {
        this.text = value;
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public LogoutEncoder text(byte[] value, int offset, int length) {
        this.text = value;
        this.textOffset = offset;
        this.textLength = length;
        return this;
    }

    public LogoutEncoder text(byte[] value) {
        return this.text(value, value.length);
    }

    public boolean hasText() {
        return this.textLength > 0;
    }

    public byte[] text() {
        return this.text;
    }

    public LogoutEncoder text(CharSequence value) {
        this.text = CodecUtil.toBytes((CharSequence)value, (byte[])this.text);
        this.textOffset = 0;
        this.textLength = value.length();
        return this;
    }

    public LogoutEncoder text(char[] value) {
        return this.text(value, value.length);
    }

    public LogoutEncoder text(char[] value, int length) {
        this.text = CodecUtil.toBytes((char[])value, (byte[])this.text, (int)length);
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public LogoutEncoder text(char[] value, int offset, int length) {
        this.text = CodecUtil.toBytes((char[])value, (byte[])this.text, (int)offset, (int)length);
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public boolean hasEncodedTextLen() {
        return this.hasEncodedTextLen;
    }

    public LogoutEncoder encodedTextLen(int value) {
        this.encodedTextLen = value;
        this.hasEncodedTextLen = true;
        return this;
    }

    public int encodedTextLen() {
        return this.encodedTextLen;
    }

    public boolean hasEncodedText() {
        return this.hasEncodedText;
    }

    public LogoutEncoder encodedText(byte[] value) {
        this.encodedText = value;
        this.hasEncodedText = true;
        return this;
    }

    public byte[] encodedText() {
        return this.encodedText;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        int start;
        int position = start = offset + MAX_HEADER_PREFIX_LENGTH;
        position += this.header.encode(buffer, position);
        if (this.hasSessionStatus) {
            buffer.putBytes(position, sessionStatusHeader, 0, 5);
            position += 5;
            position += buffer.putAsciiInt(position, this.sessionStatus);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.textLength > 0) {
            buffer.putBytes(position, textHeader, 0, 3);
            buffer.putBytes(position += 3, this.text, this.textOffset, this.textLength);
            buffer.putSeparator(position += this.textLength);
            ++position;
        }
        if (this.hasEncodedTextLen) {
            buffer.putBytes(position, encodedTextLenHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiInt(position, this.encodedTextLen);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncodedText) {
            buffer.putBytes(position, encodedTextHeader, 0, 4);
            buffer.putBytes(position += 4, this.encodedText);
            buffer.putSeparator(position += this.encodedText.length);
            ++position;
        }
        position += this.trailer.encode(buffer, position, start);
        int realStart = this.trailer.realStart;
        return Encoder.result((int)(position - realStart), (int)realStart);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetSessionStatus();
        this.resetText();
        this.resetEncodedTextLen();
        this.resetEncodedText();
    }

    public void resetSessionStatus() {
        this.hasSessionStatus = false;
    }

    public void resetText() {
        this.textLength = 0;
    }

    public void resetEncodedTextLen() {
        this.hasEncodedTextLen = false;
    }

    public void resetEncodedText() {
        this.hasEncodedText = false;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasSessionStatus() ? String.format("  \"SessionStatus\": \"%s\",\n", this.sessionStatus) : "") + (this.hasText() ? String.format("  \"Text\": \"%s\",\n", new String(this.text, this.textOffset, this.textLength, StandardCharsets.US_ASCII)) : "") + (this.hasEncodedTextLen() ? String.format("  \"EncodedTextLen\": \"%s\",\n", this.encodedTextLen) : "") + (this.hasEncodedText() ? String.format("  \"EncodedText\": \"%s\",\n", Arrays.toString(this.encodedText)) : "");
        entries = "{\n  \"MessageName\": \"Logout\",\n" + entries + "}";
        return entries;
    }
}

