/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.EncryptMethod;
import uk.co.real_logic.artio.MsgDirection;
import uk.co.real_logic.artio.SessionStatus;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class LogonEncoder
implements Encoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int encryptMethodHeaderLength = 3;
    private static final byte[] encryptMethodHeader = new byte[]{57, 56, 61};
    private static final int heartBtIntHeaderLength = 4;
    private static final byte[] heartBtIntHeader = new byte[]{49, 48, 56, 61};
    private static final int rawDataLengthHeaderLength = 3;
    private static final byte[] rawDataLengthHeader = new byte[]{57, 53, 61};
    private static final int rawDataHeaderLength = 3;
    private static final byte[] rawDataHeader = new byte[]{57, 54, 61};
    private static final int resetSeqNumFlagHeaderLength = 4;
    private static final byte[] resetSeqNumFlagHeader = new byte[]{49, 52, 49, 61};
    private static final int nextExpectedMsgSeqNumHeaderLength = 4;
    private static final byte[] nextExpectedMsgSeqNumHeader = new byte[]{55, 56, 57, 61};
    private static final int maxMessageSizeHeaderLength = 4;
    private static final byte[] maxMessageSizeHeader = new byte[]{51, 56, 51, 61};
    private static final int noMsgTypesGroupCounterHeaderLength = 4;
    private static final byte[] noMsgTypesGroupCounterHeader = new byte[]{51, 56, 52, 61};
    private static final int testMessageIndicatorHeaderLength = 4;
    private static final byte[] testMessageIndicatorHeader = new byte[]{52, 54, 52, 61};
    private static final int usernameHeaderLength = 4;
    private static final byte[] usernameHeader = new byte[]{53, 53, 51, 61};
    private static final int passwordHeaderLength = 4;
    private static final byte[] passwordHeader = new byte[]{53, 53, 52, 61};
    private static final int newPasswordHeaderLength = 4;
    private static final byte[] newPasswordHeader = new byte[]{57, 50, 53, 61};
    private static final int encryptedPasswordMethodHeaderLength = 5;
    private static final byte[] encryptedPasswordMethodHeader = new byte[]{49, 52, 48, 48, 61};
    private static final int encryptedPasswordLenHeaderLength = 5;
    private static final byte[] encryptedPasswordLenHeader = new byte[]{49, 52, 48, 49, 61};
    private static final int encryptedPasswordHeaderLength = 5;
    private static final byte[] encryptedPasswordHeader = new byte[]{49, 52, 48, 50, 61};
    private static final int encryptedNewPasswordLenHeaderLength = 5;
    private static final byte[] encryptedNewPasswordLenHeader = new byte[]{49, 52, 48, 51, 61};
    private static final int encryptedNewPasswordHeaderLength = 5;
    private static final byte[] encryptedNewPasswordHeader = new byte[]{49, 52, 48, 52, 61};
    private static final int sessionStatusHeaderLength = 5;
    private static final byte[] sessionStatusHeader = new byte[]{49, 52, 48, 57, 61};
    private static final int defaultApplVerIDHeaderLength = 5;
    private static final byte[] defaultApplVerIDHeader = new byte[]{49, 49, 51, 55, 61};
    private static final int defaultApplExtIDHeaderLength = 5;
    private static final byte[] defaultApplExtIDHeader = new byte[]{49, 52, 48, 55, 61};
    private static final int defaultCstmApplVerIDHeaderLength = 5;
    private static final byte[] defaultCstmApplVerIDHeader = new byte[]{49, 52, 48, 56, 61};
    private static final int textHeaderLength = 3;
    private static final byte[] textHeader = new byte[]{53, 56, 61};
    private static final int encodedTextLenHeaderLength = 4;
    private static final byte[] encodedTextLenHeader = new byte[]{51, 53, 52, 61};
    private static final int encodedTextHeaderLength = 4;
    private static final byte[] encodedTextHeader = new byte[]{51, 53, 53, 61};
    private int encryptMethod;
    private boolean hasEncryptMethod;
    private int heartBtInt;
    private boolean hasHeartBtInt;
    private int rawDataLength;
    private boolean hasRawDataLength;
    private byte[] rawData;
    private boolean hasRawData;
    private boolean resetSeqNumFlag;
    private boolean hasResetSeqNumFlag;
    private int nextExpectedMsgSeqNum;
    private boolean hasNextExpectedMsgSeqNum;
    private int maxMessageSize;
    private boolean hasMaxMessageSize;
    private int noMsgTypesGroupCounter;
    private boolean hasNoMsgTypesGroupCounter;
    private MsgTypesGroupEncoder msgTypesGroup = null;
    private boolean testMessageIndicator;
    private boolean hasTestMessageIndicator;
    private byte[] username = new byte[1];
    private int usernameOffset = 0;
    private int usernameLength = 0;
    private byte[] password = new byte[1];
    private int passwordOffset = 0;
    private int passwordLength = 0;
    private byte[] newPassword = new byte[1];
    private int newPasswordOffset = 0;
    private int newPasswordLength = 0;
    private int encryptedPasswordMethod;
    private boolean hasEncryptedPasswordMethod;
    private int encryptedPasswordLen;
    private boolean hasEncryptedPasswordLen;
    private byte[] encryptedPassword;
    private boolean hasEncryptedPassword;
    private int encryptedNewPasswordLen;
    private boolean hasEncryptedNewPasswordLen;
    private byte[] encryptedNewPassword;
    private boolean hasEncryptedNewPassword;
    private int sessionStatus;
    private boolean hasSessionStatus;
    private byte[] defaultApplVerID = new byte[1];
    private int defaultApplVerIDOffset = 0;
    private int defaultApplVerIDLength = 0;
    private int defaultApplExtID;
    private boolean hasDefaultApplExtID;
    private byte[] defaultCstmApplVerID = new byte[1];
    private int defaultCstmApplVerIDOffset = 0;
    private int defaultCstmApplVerIDLength = 0;
    private byte[] text = new byte[1];
    private int textOffset = 0;
    private int textLength = 0;
    private int encodedTextLen;
    private boolean hasEncodedTextLen;
    private byte[] encodedText;
    private boolean hasEncodedText;
    public static int MAX_HEADER_PREFIX_LENGTH = 23;

    public int messageType() {
        return 65;
    }

    public LogonEncoder() {
        this.header.msgType("A");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public boolean hasEncryptMethod() {
        return this.hasEncryptMethod;
    }

    public LogonEncoder encryptMethod(int value) {
        this.encryptMethod = value;
        this.hasEncryptMethod = true;
        return this;
    }

    public int encryptMethod() {
        return this.encryptMethod;
    }

    public LogonEncoder encryptMethod(EncryptMethod value) {
        return this.encryptMethod(value.representation());
    }

    public boolean hasHeartBtInt() {
        return this.hasHeartBtInt;
    }

    public LogonEncoder heartBtInt(int value) {
        this.heartBtInt = value;
        this.hasHeartBtInt = true;
        return this;
    }

    public int heartBtInt() {
        return this.heartBtInt;
    }

    public boolean hasRawDataLength() {
        return this.hasRawDataLength;
    }

    public LogonEncoder rawDataLength(int value) {
        this.rawDataLength = value;
        this.hasRawDataLength = true;
        return this;
    }

    public int rawDataLength() {
        return this.rawDataLength;
    }

    public boolean hasRawData() {
        return this.hasRawData;
    }

    public LogonEncoder rawData(byte[] value) {
        this.rawData = value;
        this.hasRawData = true;
        return this;
    }

    public byte[] rawData() {
        return this.rawData;
    }

    public boolean hasResetSeqNumFlag() {
        return this.hasResetSeqNumFlag;
    }

    public LogonEncoder resetSeqNumFlag(boolean value) {
        this.resetSeqNumFlag = value;
        this.hasResetSeqNumFlag = true;
        return this;
    }

    public boolean resetSeqNumFlag() {
        return this.resetSeqNumFlag;
    }

    public boolean hasNextExpectedMsgSeqNum() {
        return this.hasNextExpectedMsgSeqNum;
    }

    public LogonEncoder nextExpectedMsgSeqNum(int value) {
        this.nextExpectedMsgSeqNum = value;
        this.hasNextExpectedMsgSeqNum = true;
        return this;
    }

    public int nextExpectedMsgSeqNum() {
        return this.nextExpectedMsgSeqNum;
    }

    public boolean hasMaxMessageSize() {
        return this.hasMaxMessageSize;
    }

    public LogonEncoder maxMessageSize(int value) {
        this.maxMessageSize = value;
        this.hasMaxMessageSize = true;
        return this;
    }

    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    public boolean hasNoMsgTypesGroupCounter() {
        return this.hasNoMsgTypesGroupCounter;
    }

    public LogonEncoder noMsgTypesGroupCounter(int value) {
        this.noMsgTypesGroupCounter = value;
        this.hasNoMsgTypesGroupCounter = true;
        return this;
    }

    public int noMsgTypesGroupCounter() {
        return this.noMsgTypesGroupCounter;
    }

    public MsgTypesGroupEncoder msgTypesGroup(int numberOfElements) {
        this.hasNoMsgTypesGroupCounter = true;
        this.noMsgTypesGroupCounter = numberOfElements;
        if (this.msgTypesGroup == null) {
            this.msgTypesGroup = new MsgTypesGroupEncoder();
        }
        return this.msgTypesGroup;
    }

    public boolean hasTestMessageIndicator() {
        return this.hasTestMessageIndicator;
    }

    public LogonEncoder testMessageIndicator(boolean value) {
        this.testMessageIndicator = value;
        this.hasTestMessageIndicator = true;
        return this;
    }

    public boolean testMessageIndicator() {
        return this.testMessageIndicator;
    }

    public LogonEncoder username(byte[] value, int length) {
        this.username = value;
        this.usernameOffset = 0;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder username(byte[] value, int offset, int length) {
        this.username = value;
        this.usernameOffset = offset;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder username(byte[] value) {
        return this.username(value, value.length);
    }

    public boolean hasUsername() {
        return this.usernameLength > 0;
    }

    public byte[] username() {
        return this.username;
    }

    public LogonEncoder username(CharSequence value) {
        this.username = CodecUtil.toBytes((CharSequence)value, (byte[])this.username);
        this.usernameOffset = 0;
        this.usernameLength = value.length();
        return this;
    }

    public LogonEncoder username(char[] value) {
        return this.username(value, value.length);
    }

    public LogonEncoder username(char[] value, int length) {
        this.username = CodecUtil.toBytes((char[])value, (byte[])this.username, (int)length);
        this.usernameOffset = 0;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder username(char[] value, int offset, int length) {
        this.username = CodecUtil.toBytes((char[])value, (byte[])this.username, (int)offset, (int)length);
        this.usernameOffset = 0;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder password(byte[] value, int length) {
        this.password = value;
        this.passwordOffset = 0;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder password(byte[] value, int offset, int length) {
        this.password = value;
        this.passwordOffset = offset;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder password(byte[] value) {
        return this.password(value, value.length);
    }

    public boolean hasPassword() {
        return this.passwordLength > 0;
    }

    public byte[] password() {
        return this.password;
    }

    public LogonEncoder password(CharSequence value) {
        this.password = CodecUtil.toBytes((CharSequence)value, (byte[])this.password);
        this.passwordOffset = 0;
        this.passwordLength = value.length();
        return this;
    }

    public LogonEncoder password(char[] value) {
        return this.password(value, value.length);
    }

    public LogonEncoder password(char[] value, int length) {
        this.password = CodecUtil.toBytes((char[])value, (byte[])this.password, (int)length);
        this.passwordOffset = 0;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder password(char[] value, int offset, int length) {
        this.password = CodecUtil.toBytes((char[])value, (byte[])this.password, (int)offset, (int)length);
        this.passwordOffset = 0;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder newPassword(byte[] value, int length) {
        this.newPassword = value;
        this.newPasswordOffset = 0;
        this.newPasswordLength = length;
        return this;
    }

    public LogonEncoder newPassword(byte[] value, int offset, int length) {
        this.newPassword = value;
        this.newPasswordOffset = offset;
        this.newPasswordLength = length;
        return this;
    }

    public LogonEncoder newPassword(byte[] value) {
        return this.newPassword(value, value.length);
    }

    public boolean hasNewPassword() {
        return this.newPasswordLength > 0;
    }

    public byte[] newPassword() {
        return this.newPassword;
    }

    public LogonEncoder newPassword(CharSequence value) {
        this.newPassword = CodecUtil.toBytes((CharSequence)value, (byte[])this.newPassword);
        this.newPasswordOffset = 0;
        this.newPasswordLength = value.length();
        return this;
    }

    public LogonEncoder newPassword(char[] value) {
        return this.newPassword(value, value.length);
    }

    public LogonEncoder newPassword(char[] value, int length) {
        this.newPassword = CodecUtil.toBytes((char[])value, (byte[])this.newPassword, (int)length);
        this.newPasswordOffset = 0;
        this.newPasswordLength = length;
        return this;
    }

    public LogonEncoder newPassword(char[] value, int offset, int length) {
        this.newPassword = CodecUtil.toBytes((char[])value, (byte[])this.newPassword, (int)offset, (int)length);
        this.newPasswordOffset = 0;
        this.newPasswordLength = length;
        return this;
    }

    public boolean hasEncryptedPasswordMethod() {
        return this.hasEncryptedPasswordMethod;
    }

    public LogonEncoder encryptedPasswordMethod(int value) {
        this.encryptedPasswordMethod = value;
        this.hasEncryptedPasswordMethod = true;
        return this;
    }

    public int encryptedPasswordMethod() {
        return this.encryptedPasswordMethod;
    }

    public boolean hasEncryptedPasswordLen() {
        return this.hasEncryptedPasswordLen;
    }

    public LogonEncoder encryptedPasswordLen(int value) {
        this.encryptedPasswordLen = value;
        this.hasEncryptedPasswordLen = true;
        return this;
    }

    public int encryptedPasswordLen() {
        return this.encryptedPasswordLen;
    }

    public boolean hasEncryptedPassword() {
        return this.hasEncryptedPassword;
    }

    public LogonEncoder encryptedPassword(byte[] value) {
        this.encryptedPassword = value;
        this.hasEncryptedPassword = true;
        return this;
    }

    public byte[] encryptedPassword() {
        return this.encryptedPassword;
    }

    public boolean hasEncryptedNewPasswordLen() {
        return this.hasEncryptedNewPasswordLen;
    }

    public LogonEncoder encryptedNewPasswordLen(int value) {
        this.encryptedNewPasswordLen = value;
        this.hasEncryptedNewPasswordLen = true;
        return this;
    }

    public int encryptedNewPasswordLen() {
        return this.encryptedNewPasswordLen;
    }

    public boolean hasEncryptedNewPassword() {
        return this.hasEncryptedNewPassword;
    }

    public LogonEncoder encryptedNewPassword(byte[] value) {
        this.encryptedNewPassword = value;
        this.hasEncryptedNewPassword = true;
        return this;
    }

    public byte[] encryptedNewPassword() {
        return this.encryptedNewPassword;
    }

    public boolean hasSessionStatus() {
        return this.hasSessionStatus;
    }

    public LogonEncoder sessionStatus(int value) {
        this.sessionStatus = value;
        this.hasSessionStatus = true;
        return this;
    }

    public int sessionStatus() {
        return this.sessionStatus;
    }

    public LogonEncoder sessionStatus(SessionStatus value) {
        return this.sessionStatus(value.representation());
    }

    public LogonEncoder defaultApplVerID(byte[] value, int length) {
        this.defaultApplVerID = value;
        this.defaultApplVerIDOffset = 0;
        this.defaultApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultApplVerID(byte[] value, int offset, int length) {
        this.defaultApplVerID = value;
        this.defaultApplVerIDOffset = offset;
        this.defaultApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultApplVerID(byte[] value) {
        return this.defaultApplVerID(value, value.length);
    }

    public boolean hasDefaultApplVerID() {
        return this.defaultApplVerIDLength > 0;
    }

    public byte[] defaultApplVerID() {
        return this.defaultApplVerID;
    }

    public LogonEncoder defaultApplVerID(CharSequence value) {
        this.defaultApplVerID = CodecUtil.toBytes((CharSequence)value, (byte[])this.defaultApplVerID);
        this.defaultApplVerIDOffset = 0;
        this.defaultApplVerIDLength = value.length();
        return this;
    }

    public LogonEncoder defaultApplVerID(char[] value) {
        return this.defaultApplVerID(value, value.length);
    }

    public LogonEncoder defaultApplVerID(char[] value, int length) {
        this.defaultApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.defaultApplVerID, (int)length);
        this.defaultApplVerIDOffset = 0;
        this.defaultApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultApplVerID(char[] value, int offset, int length) {
        this.defaultApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.defaultApplVerID, (int)offset, (int)length);
        this.defaultApplVerIDOffset = 0;
        this.defaultApplVerIDLength = length;
        return this;
    }

    public boolean hasDefaultApplExtID() {
        return this.hasDefaultApplExtID;
    }

    public LogonEncoder defaultApplExtID(int value) {
        this.defaultApplExtID = value;
        this.hasDefaultApplExtID = true;
        return this;
    }

    public int defaultApplExtID() {
        return this.defaultApplExtID;
    }

    public LogonEncoder defaultCstmApplVerID(byte[] value, int length) {
        this.defaultCstmApplVerID = value;
        this.defaultCstmApplVerIDOffset = 0;
        this.defaultCstmApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultCstmApplVerID(byte[] value, int offset, int length) {
        this.defaultCstmApplVerID = value;
        this.defaultCstmApplVerIDOffset = offset;
        this.defaultCstmApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultCstmApplVerID(byte[] value) {
        return this.defaultCstmApplVerID(value, value.length);
    }

    public boolean hasDefaultCstmApplVerID() {
        return this.defaultCstmApplVerIDLength > 0;
    }

    public byte[] defaultCstmApplVerID() {
        return this.defaultCstmApplVerID;
    }

    public LogonEncoder defaultCstmApplVerID(CharSequence value) {
        this.defaultCstmApplVerID = CodecUtil.toBytes((CharSequence)value, (byte[])this.defaultCstmApplVerID);
        this.defaultCstmApplVerIDOffset = 0;
        this.defaultCstmApplVerIDLength = value.length();
        return this;
    }

    public LogonEncoder defaultCstmApplVerID(char[] value) {
        return this.defaultCstmApplVerID(value, value.length);
    }

    public LogonEncoder defaultCstmApplVerID(char[] value, int length) {
        this.defaultCstmApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.defaultCstmApplVerID, (int)length);
        this.defaultCstmApplVerIDOffset = 0;
        this.defaultCstmApplVerIDLength = length;
        return this;
    }

    public LogonEncoder defaultCstmApplVerID(char[] value, int offset, int length) {
        this.defaultCstmApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.defaultCstmApplVerID, (int)offset, (int)length);
        this.defaultCstmApplVerIDOffset = 0;
        this.defaultCstmApplVerIDLength = length;
        return this;
    }

    public LogonEncoder text(byte[] value, int length) {
        this.text = value;
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public LogonEncoder text(byte[] value, int offset, int length) {
        this.text = value;
        this.textOffset = offset;
        this.textLength = length;
        return this;
    }

    public LogonEncoder text(byte[] value) {
        return this.text(value, value.length);
    }

    public boolean hasText() {
        return this.textLength > 0;
    }

    public byte[] text() {
        return this.text;
    }

    public LogonEncoder text(CharSequence value) {
        this.text = CodecUtil.toBytes((CharSequence)value, (byte[])this.text);
        this.textOffset = 0;
        this.textLength = value.length();
        return this;
    }

    public LogonEncoder text(char[] value) {
        return this.text(value, value.length);
    }

    public LogonEncoder text(char[] value, int length) {
        this.text = CodecUtil.toBytes((char[])value, (byte[])this.text, (int)length);
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public LogonEncoder text(char[] value, int offset, int length) {
        this.text = CodecUtil.toBytes((char[])value, (byte[])this.text, (int)offset, (int)length);
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public boolean hasEncodedTextLen() {
        return this.hasEncodedTextLen;
    }

    public LogonEncoder encodedTextLen(int value) {
        this.encodedTextLen = value;
        this.hasEncodedTextLen = true;
        return this;
    }

    public int encodedTextLen() {
        return this.encodedTextLen;
    }

    public boolean hasEncodedText() {
        return this.hasEncodedText;
    }

    public LogonEncoder encodedText(byte[] value) {
        this.encodedText = value;
        this.hasEncodedText = true;
        return this;
    }

    public byte[] encodedText() {
        return this.encodedText;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        int start;
        int position = start = offset + MAX_HEADER_PREFIX_LENGTH;
        position += this.header.encode(buffer, position);
        if (this.hasEncryptMethod) {
            buffer.putBytes(position, encryptMethodHeader, 0, 3);
            position += 3;
            position += buffer.putAsciiInt(position, this.encryptMethod);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: EncryptMethod");
        }
        if (this.hasHeartBtInt) {
            buffer.putBytes(position, heartBtIntHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiInt(position, this.heartBtInt);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: HeartBtInt");
        }
        if (this.hasRawDataLength) {
            buffer.putBytes(position, rawDataLengthHeader, 0, 3);
            position += 3;
            position += buffer.putAsciiInt(position, this.rawDataLength);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasRawData) {
            buffer.putBytes(position, rawDataHeader, 0, 3);
            buffer.putBytes(position += 3, this.rawData);
            buffer.putSeparator(position += this.rawData.length);
            ++position;
        }
        if (this.hasResetSeqNumFlag) {
            buffer.putBytes(position, resetSeqNumFlagHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiBoolean(position, this.resetSeqNumFlag);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasNextExpectedMsgSeqNum) {
            buffer.putBytes(position, nextExpectedMsgSeqNumHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiInt(position, this.nextExpectedMsgSeqNum);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasMaxMessageSize) {
            buffer.putBytes(position, maxMessageSizeHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiInt(position, this.maxMessageSize);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasNoMsgTypesGroupCounter) {
            buffer.putBytes(position, noMsgTypesGroupCounterHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiInt(position, this.noMsgTypesGroupCounter);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.msgTypesGroup != null) {
            position += this.msgTypesGroup.encode(buffer, position, this.noMsgTypesGroupCounter);
        }
        if (this.hasTestMessageIndicator) {
            buffer.putBytes(position, testMessageIndicatorHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiBoolean(position, this.testMessageIndicator);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.usernameLength > 0) {
            buffer.putBytes(position, usernameHeader, 0, 4);
            buffer.putBytes(position += 4, this.username, this.usernameOffset, this.usernameLength);
            buffer.putSeparator(position += this.usernameLength);
            ++position;
        }
        if (this.passwordLength > 0) {
            buffer.putBytes(position, passwordHeader, 0, 4);
            buffer.putBytes(position += 4, this.password, this.passwordOffset, this.passwordLength);
            buffer.putSeparator(position += this.passwordLength);
            ++position;
        }
        if (this.newPasswordLength > 0) {
            buffer.putBytes(position, newPasswordHeader, 0, 4);
            buffer.putBytes(position += 4, this.newPassword, this.newPasswordOffset, this.newPasswordLength);
            buffer.putSeparator(position += this.newPasswordLength);
            ++position;
        }
        if (this.hasEncryptedPasswordMethod) {
            buffer.putBytes(position, encryptedPasswordMethodHeader, 0, 5);
            position += 5;
            position += buffer.putAsciiInt(position, this.encryptedPasswordMethod);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncryptedPasswordLen) {
            buffer.putBytes(position, encryptedPasswordLenHeader, 0, 5);
            position += 5;
            position += buffer.putAsciiInt(position, this.encryptedPasswordLen);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncryptedPassword) {
            buffer.putBytes(position, encryptedPasswordHeader, 0, 5);
            buffer.putBytes(position += 5, this.encryptedPassword);
            buffer.putSeparator(position += this.encryptedPassword.length);
            ++position;
        }
        if (this.hasEncryptedNewPasswordLen) {
            buffer.putBytes(position, encryptedNewPasswordLenHeader, 0, 5);
            position += 5;
            position += buffer.putAsciiInt(position, this.encryptedNewPasswordLen);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncryptedNewPassword) {
            buffer.putBytes(position, encryptedNewPasswordHeader, 0, 5);
            buffer.putBytes(position += 5, this.encryptedNewPassword);
            buffer.putSeparator(position += this.encryptedNewPassword.length);
            ++position;
        }
        if (this.hasSessionStatus) {
            buffer.putBytes(position, sessionStatusHeader, 0, 5);
            position += 5;
            position += buffer.putAsciiInt(position, this.sessionStatus);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.defaultApplVerIDLength > 0) {
            buffer.putBytes(position, defaultApplVerIDHeader, 0, 5);
            buffer.putBytes(position += 5, this.defaultApplVerID, this.defaultApplVerIDOffset, this.defaultApplVerIDLength);
            buffer.putSeparator(position += this.defaultApplVerIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: DefaultApplVerID");
        }
        if (this.hasDefaultApplExtID) {
            buffer.putBytes(position, defaultApplExtIDHeader, 0, 5);
            position += 5;
            position += buffer.putAsciiInt(position, this.defaultApplExtID);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.defaultCstmApplVerIDLength > 0) {
            buffer.putBytes(position, defaultCstmApplVerIDHeader, 0, 5);
            buffer.putBytes(position += 5, this.defaultCstmApplVerID, this.defaultCstmApplVerIDOffset, this.defaultCstmApplVerIDLength);
            buffer.putSeparator(position += this.defaultCstmApplVerIDLength);
            ++position;
        }
        if (this.textLength > 0) {
            buffer.putBytes(position, textHeader, 0, 3);
            buffer.putBytes(position += 3, this.text, this.textOffset, this.textLength);
            buffer.putSeparator(position += this.textLength);
            ++position;
        }
        if (this.hasEncodedTextLen) {
            buffer.putBytes(position, encodedTextLenHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiInt(position, this.encodedTextLen);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasEncodedText) {
            buffer.putBytes(position, encodedTextHeader, 0, 4);
            buffer.putBytes(position += 4, this.encodedText);
            buffer.putSeparator(position += this.encodedText.length);
            ++position;
        }
        position += this.trailer.encode(buffer, position, start);
        int realStart = this.trailer.realStart;
        return Encoder.result((int)(position - realStart), (int)realStart);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetEncryptMethod();
        this.resetHeartBtInt();
        this.resetRawDataLength();
        this.resetRawData();
        this.resetResetSeqNumFlag();
        this.resetNextExpectedMsgSeqNum();
        this.resetMaxMessageSize();
        this.resetTestMessageIndicator();
        this.resetUsername();
        this.resetPassword();
        this.resetNewPassword();
        this.resetEncryptedPasswordMethod();
        this.resetEncryptedPasswordLen();
        this.resetEncryptedPassword();
        this.resetEncryptedNewPasswordLen();
        this.resetEncryptedNewPassword();
        this.resetSessionStatus();
        this.resetDefaultApplVerID();
        this.resetDefaultApplExtID();
        this.resetDefaultCstmApplVerID();
        this.resetText();
        this.resetEncodedTextLen();
        this.resetEncodedText();
        this.resetMsgTypesGroup();
    }

    public void resetEncryptMethod() {
        this.hasEncryptMethod = false;
    }

    public void resetHeartBtInt() {
        this.hasHeartBtInt = false;
    }

    public void resetRawDataLength() {
        this.hasRawDataLength = false;
    }

    public void resetRawData() {
        this.hasRawData = false;
    }

    public void resetResetSeqNumFlag() {
        this.hasResetSeqNumFlag = false;
    }

    public void resetNextExpectedMsgSeqNum() {
        this.hasNextExpectedMsgSeqNum = false;
    }

    public void resetMaxMessageSize() {
        this.hasMaxMessageSize = false;
    }

    public void resetTestMessageIndicator() {
        this.hasTestMessageIndicator = false;
    }

    public void resetUsername() {
        this.usernameLength = 0;
    }

    public void resetPassword() {
        this.passwordLength = 0;
    }

    public void resetNewPassword() {
        this.newPasswordLength = 0;
    }

    public void resetEncryptedPasswordMethod() {
        this.hasEncryptedPasswordMethod = false;
    }

    public void resetEncryptedPasswordLen() {
        this.hasEncryptedPasswordLen = false;
    }

    public void resetEncryptedPassword() {
        this.hasEncryptedPassword = false;
    }

    public void resetEncryptedNewPasswordLen() {
        this.hasEncryptedNewPasswordLen = false;
    }

    public void resetEncryptedNewPassword() {
        this.hasEncryptedNewPassword = false;
    }

    public void resetSessionStatus() {
        this.hasSessionStatus = false;
    }

    public void resetDefaultApplVerID() {
        this.defaultApplVerIDLength = 0;
    }

    public void resetDefaultApplExtID() {
        this.hasDefaultApplExtID = false;
    }

    public void resetDefaultCstmApplVerID() {
        this.defaultCstmApplVerIDLength = 0;
    }

    public void resetText() {
        this.textLength = 0;
    }

    public void resetEncodedTextLen() {
        this.hasEncodedTextLen = false;
    }

    public void resetEncodedText() {
        this.hasEncodedText = false;
    }

    public void resetMsgTypesGroup() {
        if (this.msgTypesGroup != null) {
            this.msgTypesGroup.reset();
        }
        this.noMsgTypesGroupCounter = 0;
        this.hasNoMsgTypesGroupCounter = false;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasEncryptMethod() ? String.format("  \"EncryptMethod\": \"%s\",\n", this.encryptMethod) : "") + (this.hasHeartBtInt() ? String.format("  \"HeartBtInt\": \"%s\",\n", this.heartBtInt) : "") + (this.hasRawDataLength() ? String.format("  \"RawDataLength\": \"%s\",\n", this.rawDataLength) : "") + (this.hasRawData() ? String.format("  \"RawData\": \"%s\",\n", Arrays.toString(this.rawData)) : "") + (this.hasResetSeqNumFlag() ? String.format("  \"ResetSeqNumFlag\": \"%s\",\n", this.resetSeqNumFlag) : "") + (this.hasNextExpectedMsgSeqNum() ? String.format("  \"NextExpectedMsgSeqNum\": \"%s\",\n", this.nextExpectedMsgSeqNum) : "") + (this.hasMaxMessageSize() ? String.format("  \"MaxMessageSize\": \"%s\",\n", this.maxMessageSize) : "") + (this.noMsgTypesGroupCounter > 0 ? String.format("  \"MsgTypesGroup\": [\n  %s\n  ]\n", this.msgTypesGroup.toString(this.noMsgTypesGroupCounter).replace("\n", "\n  ")) : "") + (this.hasTestMessageIndicator() ? String.format("  \"TestMessageIndicator\": \"%s\",\n", this.testMessageIndicator) : "") + (this.hasUsername() ? String.format("  \"Username\": \"%s\",\n", new String(this.username, this.usernameOffset, this.usernameLength, StandardCharsets.US_ASCII)) : "") + (this.hasPassword() ? String.format("  \"Password\": \"%s\",\n", new String(this.password, this.passwordOffset, this.passwordLength, StandardCharsets.US_ASCII)) : "") + (this.hasNewPassword() ? String.format("  \"NewPassword\": \"%s\",\n", new String(this.newPassword, this.newPasswordOffset, this.newPasswordLength, StandardCharsets.US_ASCII)) : "") + (this.hasEncryptedPasswordMethod() ? String.format("  \"EncryptedPasswordMethod\": \"%s\",\n", this.encryptedPasswordMethod) : "") + (this.hasEncryptedPasswordLen() ? String.format("  \"EncryptedPasswordLen\": \"%s\",\n", this.encryptedPasswordLen) : "") + (this.hasEncryptedPassword() ? String.format("  \"EncryptedPassword\": \"%s\",\n", Arrays.toString(this.encryptedPassword)) : "") + (this.hasEncryptedNewPasswordLen() ? String.format("  \"EncryptedNewPasswordLen\": \"%s\",\n", this.encryptedNewPasswordLen) : "") + (this.hasEncryptedNewPassword() ? String.format("  \"EncryptedNewPassword\": \"%s\",\n", Arrays.toString(this.encryptedNewPassword)) : "") + (this.hasSessionStatus() ? String.format("  \"SessionStatus\": \"%s\",\n", this.sessionStatus) : "") + (this.hasDefaultApplVerID() ? String.format("  \"DefaultApplVerID\": \"%s\",\n", new String(this.defaultApplVerID, this.defaultApplVerIDOffset, this.defaultApplVerIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasDefaultApplExtID() ? String.format("  \"DefaultApplExtID\": \"%s\",\n", this.defaultApplExtID) : "") + (this.hasDefaultCstmApplVerID() ? String.format("  \"DefaultCstmApplVerID\": \"%s\",\n", new String(this.defaultCstmApplVerID, this.defaultCstmApplVerIDOffset, this.defaultCstmApplVerIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasText() ? String.format("  \"Text\": \"%s\",\n", new String(this.text, this.textOffset, this.textLength, StandardCharsets.US_ASCII)) : "") + (this.hasEncodedTextLen() ? String.format("  \"EncodedTextLen\": \"%s\",\n", this.encodedTextLen) : "") + (this.hasEncodedText() ? String.format("  \"EncodedText\": \"%s\",\n", Arrays.toString(this.encodedText)) : "");
        entries = "{\n  \"MessageName\": \"Logon\",\n" + entries + "}";
        return entries;
    }

    public static class MsgTypesGroupEncoder {
        private MsgTypesGroupEncoder next = null;
        private static final int refMsgTypeHeaderLength = 4;
        private static final byte[] refMsgTypeHeader = new byte[]{51, 55, 50, 61};
        private static final int msgDirectionHeaderLength = 4;
        private static final byte[] msgDirectionHeader = new byte[]{51, 56, 53, 61};
        private static final int refApplVerIDHeaderLength = 5;
        private static final byte[] refApplVerIDHeader = new byte[]{49, 49, 51, 48, 61};
        private static final int refApplExtIDHeaderLength = 5;
        private static final byte[] refApplExtIDHeader = new byte[]{49, 52, 48, 54, 61};
        private static final int refCstmApplVerIDHeaderLength = 5;
        private static final byte[] refCstmApplVerIDHeader = new byte[]{49, 49, 51, 49, 61};
        private static final int defaultVerIndicatorHeaderLength = 5;
        private static final byte[] defaultVerIndicatorHeader = new byte[]{49, 52, 49, 48, 61};
        private byte[] refMsgType = new byte[1];
        private int refMsgTypeOffset = 0;
        private int refMsgTypeLength = 0;
        private char msgDirection;
        private boolean hasMsgDirection;
        private byte[] refApplVerID = new byte[1];
        private int refApplVerIDOffset = 0;
        private int refApplVerIDLength = 0;
        private int refApplExtID;
        private boolean hasRefApplExtID;
        private byte[] refCstmApplVerID = new byte[1];
        private int refCstmApplVerIDOffset = 0;
        private int refCstmApplVerIDLength = 0;
        private boolean defaultVerIndicator;
        private boolean hasDefaultVerIndicator;

        public MsgTypesGroupEncoder next() {
            if (this.next == null) {
                this.next = new MsgTypesGroupEncoder();
            }
            return this.next;
        }

        public MsgTypesGroupEncoder refMsgType(byte[] value, int length) {
            this.refMsgType = value;
            this.refMsgTypeOffset = 0;
            this.refMsgTypeLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refMsgType(byte[] value, int offset, int length) {
            this.refMsgType = value;
            this.refMsgTypeOffset = offset;
            this.refMsgTypeLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refMsgType(byte[] value) {
            return this.refMsgType(value, value.length);
        }

        public boolean hasRefMsgType() {
            return this.refMsgTypeLength > 0;
        }

        public byte[] refMsgType() {
            return this.refMsgType;
        }

        public MsgTypesGroupEncoder refMsgType(CharSequence value) {
            this.refMsgType = CodecUtil.toBytes((CharSequence)value, (byte[])this.refMsgType);
            this.refMsgTypeOffset = 0;
            this.refMsgTypeLength = value.length();
            return this;
        }

        public MsgTypesGroupEncoder refMsgType(char[] value) {
            return this.refMsgType(value, value.length);
        }

        public MsgTypesGroupEncoder refMsgType(char[] value, int length) {
            this.refMsgType = CodecUtil.toBytes((char[])value, (byte[])this.refMsgType, (int)length);
            this.refMsgTypeOffset = 0;
            this.refMsgTypeLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refMsgType(char[] value, int offset, int length) {
            this.refMsgType = CodecUtil.toBytes((char[])value, (byte[])this.refMsgType, (int)offset, (int)length);
            this.refMsgTypeOffset = 0;
            this.refMsgTypeLength = length;
            return this;
        }

        public boolean hasMsgDirection() {
            return this.hasMsgDirection;
        }

        public MsgTypesGroupEncoder msgDirection(char value) {
            this.msgDirection = value;
            this.hasMsgDirection = true;
            return this;
        }

        public char msgDirection() {
            return this.msgDirection;
        }

        public MsgTypesGroupEncoder msgDirection(MsgDirection value) {
            return this.msgDirection(value.representation());
        }

        public MsgTypesGroupEncoder refApplVerID(byte[] value, int length) {
            this.refApplVerID = value;
            this.refApplVerIDOffset = 0;
            this.refApplVerIDLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refApplVerID(byte[] value, int offset, int length) {
            this.refApplVerID = value;
            this.refApplVerIDOffset = offset;
            this.refApplVerIDLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refApplVerID(byte[] value) {
            return this.refApplVerID(value, value.length);
        }

        public boolean hasRefApplVerID() {
            return this.refApplVerIDLength > 0;
        }

        public byte[] refApplVerID() {
            return this.refApplVerID;
        }

        public MsgTypesGroupEncoder refApplVerID(CharSequence value) {
            this.refApplVerID = CodecUtil.toBytes((CharSequence)value, (byte[])this.refApplVerID);
            this.refApplVerIDOffset = 0;
            this.refApplVerIDLength = value.length();
            return this;
        }

        public MsgTypesGroupEncoder refApplVerID(char[] value) {
            return this.refApplVerID(value, value.length);
        }

        public MsgTypesGroupEncoder refApplVerID(char[] value, int length) {
            this.refApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.refApplVerID, (int)length);
            this.refApplVerIDOffset = 0;
            this.refApplVerIDLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refApplVerID(char[] value, int offset, int length) {
            this.refApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.refApplVerID, (int)offset, (int)length);
            this.refApplVerIDOffset = 0;
            this.refApplVerIDLength = length;
            return this;
        }

        public boolean hasRefApplExtID() {
            return this.hasRefApplExtID;
        }

        public MsgTypesGroupEncoder refApplExtID(int value) {
            this.refApplExtID = value;
            this.hasRefApplExtID = true;
            return this;
        }

        public int refApplExtID() {
            return this.refApplExtID;
        }

        public MsgTypesGroupEncoder refCstmApplVerID(byte[] value, int length) {
            this.refCstmApplVerID = value;
            this.refCstmApplVerIDOffset = 0;
            this.refCstmApplVerIDLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refCstmApplVerID(byte[] value, int offset, int length) {
            this.refCstmApplVerID = value;
            this.refCstmApplVerIDOffset = offset;
            this.refCstmApplVerIDLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refCstmApplVerID(byte[] value) {
            return this.refCstmApplVerID(value, value.length);
        }

        public boolean hasRefCstmApplVerID() {
            return this.refCstmApplVerIDLength > 0;
        }

        public byte[] refCstmApplVerID() {
            return this.refCstmApplVerID;
        }

        public MsgTypesGroupEncoder refCstmApplVerID(CharSequence value) {
            this.refCstmApplVerID = CodecUtil.toBytes((CharSequence)value, (byte[])this.refCstmApplVerID);
            this.refCstmApplVerIDOffset = 0;
            this.refCstmApplVerIDLength = value.length();
            return this;
        }

        public MsgTypesGroupEncoder refCstmApplVerID(char[] value) {
            return this.refCstmApplVerID(value, value.length);
        }

        public MsgTypesGroupEncoder refCstmApplVerID(char[] value, int length) {
            this.refCstmApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.refCstmApplVerID, (int)length);
            this.refCstmApplVerIDOffset = 0;
            this.refCstmApplVerIDLength = length;
            return this;
        }

        public MsgTypesGroupEncoder refCstmApplVerID(char[] value, int offset, int length) {
            this.refCstmApplVerID = CodecUtil.toBytes((char[])value, (byte[])this.refCstmApplVerID, (int)offset, (int)length);
            this.refCstmApplVerIDOffset = 0;
            this.refCstmApplVerIDLength = length;
            return this;
        }

        public boolean hasDefaultVerIndicator() {
            return this.hasDefaultVerIndicator;
        }

        public MsgTypesGroupEncoder defaultVerIndicator(boolean value) {
            this.defaultVerIndicator = value;
            this.hasDefaultVerIndicator = true;
            return this;
        }

        public boolean defaultVerIndicator() {
            return this.defaultVerIndicator;
        }

        public int encode(MutableAsciiBuffer buffer, int offset, int remainingElements) {
            if (remainingElements == 0) {
                return 0;
            }
            int position = offset;
            if (this.refMsgTypeLength > 0) {
                buffer.putBytes(position, refMsgTypeHeader, 0, 4);
                buffer.putBytes(position += 4, this.refMsgType, this.refMsgTypeOffset, this.refMsgTypeLength);
                buffer.putSeparator(position += this.refMsgTypeLength);
                ++position;
            }
            if (this.hasMsgDirection) {
                buffer.putBytes(position, msgDirectionHeader, 0, 4);
                position += 4;
                position += buffer.putAsciiChar(position, this.msgDirection);
                buffer.putSeparator(position);
                ++position;
            }
            if (this.refApplVerIDLength > 0) {
                buffer.putBytes(position, refApplVerIDHeader, 0, 5);
                buffer.putBytes(position += 5, this.refApplVerID, this.refApplVerIDOffset, this.refApplVerIDLength);
                buffer.putSeparator(position += this.refApplVerIDLength);
                ++position;
            }
            if (this.hasRefApplExtID) {
                buffer.putBytes(position, refApplExtIDHeader, 0, 5);
                position += 5;
                position += buffer.putAsciiInt(position, this.refApplExtID);
                buffer.putSeparator(position);
                ++position;
            }
            if (this.refCstmApplVerIDLength > 0) {
                buffer.putBytes(position, refCstmApplVerIDHeader, 0, 5);
                buffer.putBytes(position += 5, this.refCstmApplVerID, this.refCstmApplVerIDOffset, this.refCstmApplVerIDLength);
                buffer.putSeparator(position += this.refCstmApplVerIDLength);
                ++position;
            }
            if (this.hasDefaultVerIndicator) {
                buffer.putBytes(position, defaultVerIndicatorHeader, 0, 5);
                position += 5;
                position += buffer.putAsciiBoolean(position, this.defaultVerIndicator);
                buffer.putSeparator(position);
                ++position;
            }
            if (this.next != null) {
                position += this.next.encode(buffer, position, remainingElements - 1);
            }
            return position - offset;
        }

        public void reset() {
            this.resetRefMsgType();
            this.resetMsgDirection();
            this.resetRefApplVerID();
            this.resetRefApplExtID();
            this.resetRefCstmApplVerID();
            this.resetDefaultVerIndicator();
            if (this.next != null) {
                this.next.reset();
            }
        }

        public void resetRefMsgType() {
            this.refMsgTypeLength = 0;
        }

        public void resetMsgDirection() {
            this.hasMsgDirection = false;
        }

        public void resetRefApplVerID() {
            this.refApplVerIDLength = 0;
        }

        public void resetRefApplExtID() {
            this.hasRefApplExtID = false;
        }

        public void resetRefCstmApplVerID() {
            this.refCstmApplVerIDLength = 0;
        }

        public void resetDefaultVerIndicator() {
            this.hasDefaultVerIndicator = false;
        }

        public String toString(int remainingEntries) {
            String entries = (this.hasRefMsgType() ? String.format("  \"RefMsgType\": \"%s\",\n", new String(this.refMsgType, this.refMsgTypeOffset, this.refMsgTypeLength, StandardCharsets.US_ASCII)) : "") + (this.hasMsgDirection() ? String.format("  \"MsgDirection\": \"%s\",\n", Character.valueOf(this.msgDirection)) : "") + (this.hasRefApplVerID() ? String.format("  \"RefApplVerID\": \"%s\",\n", new String(this.refApplVerID, this.refApplVerIDOffset, this.refApplVerIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasRefApplExtID() ? String.format("  \"RefApplExtID\": \"%s\",\n", this.refApplExtID) : "") + (this.hasRefCstmApplVerID() ? String.format("  \"RefCstmApplVerID\": \"%s\",\n", new String(this.refCstmApplVerID, this.refCstmApplVerIDOffset, this.refCstmApplVerIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasDefaultVerIndicator() ? String.format("  \"DefaultVerIndicator\": \"%s\",\n", this.defaultVerIndicator) : "");
            entries = "{\n  \"MessageName\": \"MsgTypesGroup\",\n" + entries + "}";
            if (remainingEntries > 1) {
                entries = entries + ",\n" + this.next.toString(remainingEntries - 1);
            }
            return entries;
        }
    }
}

