/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import org.agrona.collections.IntHashSet;

public enum EncryptMethod {
    NONE_OTHER(0),
    PKCS(1),
    DES(2),
    PKCS_DES(3),
    PGP_DES(4),
    PGP_DES_MD5(5),
    PEM_DES_MD5(6),
    NULL_VAL(Integer.MIN_VALUE),
    ARTIO_UNKNOWN(Integer.MAX_VALUE);

    private final int representation;
    private static final IntHashSet intSet;

    private EncryptMethod(int representation) {
        this.representation = representation;
    }

    public final int representation() {
        return this.representation;
    }

    public static boolean isValid(int representation) {
        return intSet.contains(representation);
    }

    public static EncryptMethod decode(int representation) {
        switch (representation) {
            case 0: {
                return NONE_OTHER;
            }
            case 1: {
                return PKCS;
            }
            case 2: {
                return DES;
            }
            case 3: {
                return PKCS_DES;
            }
            case 4: {
                return PGP_DES;
            }
            case 5: {
                return PGP_DES_MD5;
            }
            case 6: {
                return PEM_DES_MD5;
            }
        }
        return ARTIO_UNKNOWN;
    }

    static {
        intSet = new IntHashSet(14);
        intSet.add(0);
        intSet.add(1);
        intSet.add(2);
        intSet.add(3);
        intSet.add(4);
        intSet.add(5);
        intSet.add(6);
    }
}

