/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixt.decoder;

import java.util.Iterator;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.builder.CommonDecoderImpl;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.fixt.builder.HopGrpEncoder;
import uk.co.real_logic.artio.fixt.decoder.TrailerDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;

public interface HopGrpDecoder {
    public HopsGroupIterator hopsGroupIterator();

    public int noHopsGroupCounter();

    public boolean hasNoHopsGroupCounter();

    public HopsGroupDecoder hopsGroup();

    public static class HopsGroupIterator
    implements Iterable<HopsGroupDecoder>,
    Iterator<HopsGroupDecoder> {
        private final HopGrpDecoder parent;
        private int remainder;
        private HopsGroupDecoder current;

        public HopsGroupIterator(HopGrpDecoder parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasNext() {
            return this.remainder > 0 && this.current != null;
        }

        @Override
        public HopsGroupDecoder next() {
            --this.remainder;
            HopsGroupDecoder value = this.current;
            this.current = this.current.next();
            return value;
        }

        public int numberFieldValue() {
            return this.parent.hasNoHopsGroupCounter() ? this.parent.noHopsGroupCounter() : 0;
        }

        public void reset() {
            this.remainder = this.numberFieldValue();
            this.current = this.parent.hopsGroup();
        }

        public HopsGroupIterator iterator() {
            this.reset();
            return this;
        }
    }

    public static class HopsGroupDecoder
    extends CommonDecoderImpl {
        public final IntHashSet REQUIRED_FIELDS = new IntHashSet(0);
        public final IntHashSet ALL_GROUP_FIELDS;
        private final IntHashSet missingRequiredFields;
        private final TrailerDecoder trailer;
        private final IntHashSet messageFields;
        private HopsGroupDecoder next;
        private IntHashSet seenFields;
        private char[] hopCompID;
        private boolean hasHopCompID;
        private int hopCompIDOffset;
        private int hopCompIDLength;
        private final CharArrayWrapper hopCompIDWrapper;
        private byte[] hopSendingTime;
        private boolean hasHopSendingTime;
        private int hopSendingTimeOffset;
        private int hopSendingTimeLength;
        private int hopRefID;
        private boolean hasHopRefID;

        public boolean validate() {
            if (this.rejectReason != -1) {
                return false;
            }
            IntHashSet.IntIterator missingFieldsIterator = this.missingRequiredFields.iterator();
            if (missingFieldsIterator.hasNext()) {
                this.invalidTagId = missingFieldsIterator.nextValue();
                this.rejectReason = 1;
                return false;
            }
            return true;
        }

        public HopsGroupDecoder(TrailerDecoder trailer, IntHashSet messageFields) {
            if (Validation.CODEC_VALIDATION_ENABLED) {
                // empty if block
            }
            this.ALL_GROUP_FIELDS = new IntHashSet(6);
            if (Validation.CODEC_VALIDATION_ENABLED) {
                this.ALL_GROUP_FIELDS.add(628);
                this.ALL_GROUP_FIELDS.add(629);
                this.ALL_GROUP_FIELDS.add(630);
            }
            this.missingRequiredFields = new IntHashSet(0);
            this.next = null;
            this.seenFields = new IntHashSet(6);
            this.hopCompID = new char[1];
            this.hopCompIDWrapper = new CharArrayWrapper();
            this.hopSendingTime = new byte[24];
            this.hopRefID = Integer.MIN_VALUE;
            this.trailer = trailer;
            this.messageFields = messageFields;
        }

        public HopsGroupDecoder next() {
            return this.next;
        }

        public char[] hopCompID() {
            if (!this.hasHopCompID) {
                throw new IllegalArgumentException("No value for optional field: HopCompID");
            }
            return this.hopCompID;
        }

        public boolean hasHopCompID() {
            return this.hasHopCompID;
        }

        public int hopCompIDLength() {
            if (!this.hasHopCompID) {
                throw new IllegalArgumentException("No value for optional field: HopCompID");
            }
            return this.hopCompIDLength;
        }

        public String hopCompIDAsString() {
            return this.hasHopCompID ? new String(this.hopCompID, 0, this.hopCompIDLength) : null;
        }

        public void hopCompID(AsciiSequenceView view) {
            if (!this.hasHopCompID) {
                throw new IllegalArgumentException("No value for optional field: HopCompID");
            }
            view.wrap((DirectBuffer)this.buffer, this.hopCompIDOffset, this.hopCompIDLength);
        }

        public byte[] hopSendingTime() {
            if (!this.hasHopSendingTime) {
                throw new IllegalArgumentException("No value for optional field: HopSendingTime");
            }
            return this.hopSendingTime;
        }

        public boolean hasHopSendingTime() {
            return this.hasHopSendingTime;
        }

        public int hopSendingTimeLength() {
            if (!this.hasHopSendingTime) {
                throw new IllegalArgumentException("No value for optional field: HopSendingTime");
            }
            return this.hopSendingTimeLength;
        }

        public String hopSendingTimeAsString() {
            return this.hasHopSendingTime ? new String(this.hopSendingTime, 0, this.hopSendingTimeLength) : null;
        }

        public void hopSendingTime(AsciiSequenceView view) {
            if (!this.hasHopSendingTime) {
                throw new IllegalArgumentException("No value for optional field: HopSendingTime");
            }
            view.wrap((DirectBuffer)this.buffer, this.hopSendingTimeOffset, this.hopSendingTimeLength);
        }

        public int hopRefID() {
            if (!this.hasHopRefID) {
                throw new IllegalArgumentException("No value for optional field: HopRefID");
            }
            return this.hopRefID;
        }

        public boolean hasHopRefID() {
            return this.hasHopRefID;
        }

        public int decode(AsciiBuffer buffer, int offset, int length) {
            int seenFieldCount = 0;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                this.missingRequiredFields.copy(this.REQUIRED_FIELDS);
            }
            this.buffer = buffer;
            int end = offset + length;
            int position = offset;
            this.seenFields.clear();
            while (position < end) {
                int equalsPosition = buffer.scan(position, end, '=');
                if (equalsPosition == -1) {
                    return position;
                }
                int tag = buffer.getInt(position, equalsPosition);
                if (!this.seenFields.add(tag)) {
                    if (this.next == null) {
                        this.next = new HopsGroupDecoder(this.trailer, this.messageFields);
                    }
                    return position - offset;
                }
                int valueOffset = equalsPosition + 1;
                int endOfField = buffer.scan(valueOffset, end, (byte)1);
                if (endOfField == -1 || equalsPosition == -1) {
                    this.rejectReason = 5;
                    break;
                }
                int valueLength = endOfField - valueOffset;
                if (Validation.CODEC_VALIDATION_ENABLED) {
                    if (tag <= 0) {
                        this.invalidTagId = tag;
                        this.rejectReason = 0;
                    } else if (valueLength == 0) {
                        this.invalidTagId = tag;
                        this.rejectReason = 4;
                    }
                    this.missingRequiredFields.remove(tag);
                    ++seenFieldCount;
                }
                switch (tag) {
                    case 628: {
                        this.hasHopCompID = true;
                        this.hopCompID = buffer.getChars(this.hopCompID, valueOffset, valueLength);
                        this.hopCompIDOffset = valueOffset;
                        this.hopCompIDLength = valueLength;
                        break;
                    }
                    case 629: {
                        this.hasHopSendingTime = true;
                        this.hopSendingTime = buffer.getBytes(this.hopSendingTime, valueOffset, valueLength);
                        this.hopSendingTimeOffset = valueOffset;
                        this.hopSendingTimeLength = valueLength;
                        break;
                    }
                    case 630: {
                        this.hasHopRefID = true;
                        this.hopRefID = this.getInt(buffer, valueOffset, endOfField, 630, Validation.CODEC_VALIDATION_ENABLED);
                        break;
                    }
                    default: {
                        if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                            this.seenFields.remove(tag);
                        }
                        if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && !this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) break;
                        return position - offset;
                    }
                }
                if (position >= endOfField + 1) continue;
                position = endOfField + 1;
            }
            return position - offset;
        }

        public void reset() {
            this.resetHopCompID();
            this.resetHopSendingTime();
            this.resetHopRefID();
            this.buffer = null;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                this.invalidTagId = -1;
                this.rejectReason = -1;
                this.missingRequiredFields.clear();
            }
        }

        public void resetHopCompID() {
            this.hasHopCompID = false;
        }

        public void resetHopSendingTime() {
            this.hasHopSendingTime = false;
        }

        public void resetHopRefID() {
            this.hasHopRefID = false;
        }

        public String toString() {
            return this.appendTo(new StringBuilder()).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            return this.appendTo(builder, 1);
        }

        public StringBuilder appendTo(StringBuilder builder, int level) {
            builder.append("{\n");
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"MessageName\": \"HopsGroup\",\n");
            if (this.hasHopCompID()) {
                CodecUtil.indent((StringBuilder)builder, (int)level);
                builder.append("\"HopCompID\": \"");
                builder.append(this.hopCompID(), 0, this.hopCompIDLength());
                builder.append("\",\n");
            }
            if (this.hasHopSendingTime()) {
                CodecUtil.indent((StringBuilder)builder, (int)level);
                builder.append("\"HopSendingTime\": \"");
                CodecUtil.appendData((StringBuilder)builder, (byte[])this.hopSendingTime, (int)this.hopSendingTimeLength);
                builder.append("\",\n");
            }
            if (this.hasHopRefID()) {
                CodecUtil.indent((StringBuilder)builder, (int)level);
                builder.append("\"HopRefID\": \"");
                builder.append(this.hopRefID);
                builder.append("\",\n");
            }
            CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
            builder.append("}");
            return builder;
        }

        public HopGrpEncoder.HopsGroupEncoder toEncoder(Encoder encoder) {
            return this.toEncoder((HopGrpEncoder.HopsGroupEncoder)encoder);
        }

        public HopGrpEncoder.HopsGroupEncoder toEncoder(HopGrpEncoder.HopsGroupEncoder encoder) {
            encoder.reset();
            if (this.hasHopCompID()) {
                encoder.hopCompID(this.hopCompID(), 0, this.hopCompIDLength());
            }
            if (this.hasHopSendingTime()) {
                encoder.hopSendingTimeAsCopy(this.hopSendingTime(), 0, this.hopSendingTimeLength());
            }
            if (this.hasHopRefID()) {
                encoder.hopRefID(this.hopRefID());
            }
            return encoder;
        }
    }
}

