/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.builder.AbstractResendRequestEncoder;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class ResendRequestEncoder
implements AbstractResendRequestEncoder {
    private final TrailerEncoder trailer = new TrailerEncoder();
    private final HeaderEncoder header = new HeaderEncoder();
    private static final int beginSeqNoHeaderLength = 2;
    private static final byte[] beginSeqNoHeader = new byte[]{55, 61};
    private static final int endSeqNoHeaderLength = 3;
    private static final byte[] endSeqNoHeader = new byte[]{49, 54, 61};
    private int beginSeqNo;
    private boolean hasBeginSeqNo;
    private int endSeqNo;
    private boolean hasEndSeqNo;

    public long messageType() {
        return 50L;
    }

    public ResendRequestEncoder() {
        this.header.msgType("2");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public boolean hasBeginSeqNo() {
        return this.hasBeginSeqNo;
    }

    public ResendRequestEncoder beginSeqNo(int value) {
        this.beginSeqNo = value;
        this.hasBeginSeqNo = true;
        return this;
    }

    public int beginSeqNo() {
        return this.beginSeqNo;
    }

    public boolean hasEndSeqNo() {
        return this.hasEndSeqNo;
    }

    public ResendRequestEncoder endSeqNo(int value) {
        this.endSeqNo = value;
        this.hasEndSeqNo = true;
        return this;
    }

    public int endSeqNo() {
        return this.endSeqNo;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.hasBeginSeqNo) {
            buffer.putBytes(position, beginSeqNoHeader, 0, 2);
            position += 2;
            position += buffer.putIntAscii(position, this.beginSeqNo);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: BeginSeqNo");
        }
        if (this.hasEndSeqNo) {
            buffer.putBytes(position, endSeqNoHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.endSeqNo);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: EndSeqNo");
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetBeginSeqNo();
        this.resetEndSeqNo();
    }

    public void resetBeginSeqNo() {
        this.hasBeginSeqNo = false;
    }

    public void resetEndSeqNo() {
        this.hasEndSeqNo = false;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendTo(builder, 1);
    }

    public StringBuilder appendTo(StringBuilder builder, int level) {
        builder.append("{\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"MessageName\": \"ResendRequest\",\n");
        builder.append("  \"header\": ");
        this.header.appendTo(builder, level + 1);
        builder.append("\n");
        if (this.hasBeginSeqNo()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"BeginSeqNo\": \"");
            builder.append(this.beginSeqNo);
            builder.append("\",\n");
        }
        if (this.hasEndSeqNo()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"EndSeqNo\": \"");
            builder.append(this.endSeqNo);
            builder.append("\",\n");
        }
        CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
        builder.append("}");
        return builder;
    }

    public ResendRequestEncoder copyTo(Encoder encoder) {
        return this.copyTo((ResendRequestEncoder)encoder);
    }

    public ResendRequestEncoder copyTo(ResendRequestEncoder encoder) {
        encoder.reset();
        if (this.hasBeginSeqNo()) {
            encoder.beginSeqNo(this.beginSeqNo());
        }
        if (this.hasEndSeqNo()) {
            encoder.endSeqNo(this.endSeqNo());
        }
        return encoder;
    }
}

