/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.other.builder;

import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class InstrumentEncoder {
    private static final int symbolHeaderLength = 3;
    private static final byte[] symbolHeader = new byte[]{53, 53, 61};
    private final MutableDirectBuffer symbol = new UnsafeBuffer();
    private int symbolOffset = 0;
    private int symbolLength = 0;

    public InstrumentEncoder symbol(DirectBuffer value, int offset, int length) {
        this.symbol.wrap(value);
        this.symbolOffset = offset;
        this.symbolLength = length;
        return this;
    }

    public InstrumentEncoder symbol(DirectBuffer value, int length) {
        return this.symbol(value, 0, length);
    }

    public InstrumentEncoder symbol(DirectBuffer value) {
        return this.symbol(value, 0, value.capacity());
    }

    public InstrumentEncoder symbol(byte[] value, int offset, int length) {
        this.symbol.wrap(value);
        this.symbolOffset = offset;
        this.symbolLength = length;
        return this;
    }

    public InstrumentEncoder symbolAsCopy(byte[] value, int offset, int length) {
        CodecUtil.copyInto((MutableDirectBuffer)this.symbol, (byte[])value, (int)offset, (int)length);
        this.symbolOffset = offset;
        this.symbolLength = length;
        return this;
    }

    public InstrumentEncoder symbol(byte[] value, int length) {
        return this.symbol(value, 0, length);
    }

    public InstrumentEncoder symbol(byte[] value) {
        return this.symbol(value, 0, value.length);
    }

    public boolean hasSymbol() {
        return this.symbolLength > 0;
    }

    public MutableDirectBuffer symbol() {
        return this.symbol;
    }

    public String symbolAsString() {
        return this.symbol.getStringWithoutLengthAscii(this.symbolOffset, this.symbolLength);
    }

    public InstrumentEncoder symbol(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.symbol);
        this.symbolOffset = 0;
        this.symbolLength = value.length();
        return this;
    }

    public InstrumentEncoder symbol(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.symbol.wrap(buffer);
            this.symbolOffset = value.offset();
            this.symbolLength = value.length();
        }
        return this;
    }

    public InstrumentEncoder symbol(char[] value) {
        return this.symbol(value, 0, value.length);
    }

    public InstrumentEncoder symbol(char[] value, int length) {
        return this.symbol(value, 0, length);
    }

    public InstrumentEncoder symbol(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.symbol, (int)offset, (int)length);
        this.symbolOffset = 0;
        this.symbolLength = length;
        return this;
    }

    public int encode(MutableAsciiBuffer buffer, int offset) {
        int position = offset;
        if (this.symbolLength > 0) {
            buffer.putBytes(position, symbolHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.symbol, this.symbolOffset, this.symbolLength);
            buffer.putSeparator(position += this.symbolLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: Symbol");
        }
        return position - offset;
    }

    public void reset() {
        this.resetSymbol();
    }

    public void resetSymbol() {
        this.symbolLength = 0;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendTo(builder, 1);
    }

    public StringBuilder appendTo(StringBuilder builder, int level) {
        builder.append("{\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"MessageName\": \"Instrument\",\n");
        if (this.hasSymbol()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"Symbol\": \"");
            CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.symbol, (int)this.symbolOffset, (int)this.symbolLength);
            builder.append("\",\n");
        }
        CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
        builder.append("}");
        return builder;
    }
}

