/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class OrderQtyDataEncoder {
    private static final int orderQtyHeaderLength = 3;
    private static final byte[] orderQtyHeader = new byte[]{51, 56, 61};
    private final DecimalFloat orderQty = new DecimalFloat();
    private boolean hasOrderQty;

    public boolean hasOrderQty() {
        return this.hasOrderQty;
    }

    public OrderQtyDataEncoder orderQty(DecimalFloat value) {
        this.orderQty.set(value);
        this.hasOrderQty = true;
        return this;
    }

    public OrderQtyDataEncoder orderQty(long value, int scale) {
        this.orderQty.set(value, scale);
        this.hasOrderQty = true;
        return this;
    }

    public DecimalFloat orderQty() {
        return this.orderQty;
    }

    public int encode(MutableAsciiBuffer buffer, int offset) {
        int position = offset;
        if (this.hasOrderQty) {
            buffer.putBytes(position, orderQtyHeader, 0, 3);
            position += 3;
            position += buffer.putFloatAscii(position, this.orderQty);
            buffer.putSeparator(position);
            ++position;
        }
        return position - offset;
    }

    public void reset() {
        this.resetOrderQty();
    }

    public void resetOrderQty() {
        this.hasOrderQty = false;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendTo(builder, 1);
    }

    public StringBuilder appendTo(StringBuilder builder, int level) {
        builder.append("{\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"MessageName\": \"OrderQtyData\",\n");
        if (this.hasOrderQty()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"OrderQty\": \"");
            this.orderQty.appendTo(builder);
            builder.append("\",\n");
        }
        CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
        builder.append("}");
        return builder;
    }
}

