/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.builder.AbstractTestRequestEncoder;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class TestRequestEncoder
implements AbstractTestRequestEncoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int testReqIDHeaderLength = 4;
    private static final byte[] testReqIDHeader = new byte[]{49, 49, 50, 61};
    private final MutableDirectBuffer testReqID = new UnsafeBuffer();
    private int testReqIDOffset = 0;
    private int testReqIDLength = 0;

    public long messageType() {
        return 49L;
    }

    public TestRequestEncoder() {
        this.header.msgType("1");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public TestRequestEncoder testReqID(DirectBuffer value, int offset, int length) {
        this.testReqID.wrap(value);
        this.testReqIDOffset = offset;
        this.testReqIDLength = length;
        return this;
    }

    public TestRequestEncoder testReqID(DirectBuffer value, int length) {
        return this.testReqID(value, 0, length);
    }

    public TestRequestEncoder testReqID(DirectBuffer value) {
        return this.testReqID(value, 0, value.capacity());
    }

    public TestRequestEncoder testReqID(byte[] value, int offset, int length) {
        this.testReqID.wrap(value);
        this.testReqIDOffset = offset;
        this.testReqIDLength = length;
        return this;
    }

    public TestRequestEncoder testReqID(byte[] value, int length) {
        return this.testReqID(value, 0, length);
    }

    public TestRequestEncoder testReqID(byte[] value) {
        return this.testReqID(value, 0, value.length);
    }

    public boolean hasTestReqID() {
        return this.testReqIDLength > 0;
    }

    public MutableDirectBuffer testReqID() {
        return this.testReqID;
    }

    public String testReqIDAsString() {
        return this.testReqID.getStringWithoutLengthAscii(this.testReqIDOffset, this.testReqIDLength);
    }

    public TestRequestEncoder testReqID(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.testReqID);
        this.testReqIDOffset = 0;
        this.testReqIDLength = value.length();
        return this;
    }

    public TestRequestEncoder testReqID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.testReqID.wrap(buffer);
            this.testReqIDOffset = value.offset();
            this.testReqIDLength = value.length();
        }
        return this;
    }

    public TestRequestEncoder testReqID(char[] value) {
        return this.testReqID(value, 0, value.length);
    }

    public TestRequestEncoder testReqID(char[] value, int length) {
        return this.testReqID(value, 0, length);
    }

    public TestRequestEncoder testReqID(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.testReqID, (int)offset, (int)length);
        this.testReqIDOffset = 0;
        this.testReqIDLength = length;
        return this;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.testReqIDLength > 0) {
            buffer.putBytes(position, testReqIDHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.testReqID, this.testReqIDOffset, this.testReqIDLength);
            buffer.putSeparator(position += this.testReqIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: TestReqID");
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetTestReqID();
    }

    public void resetTestReqID() {
        this.testReqIDLength = 0;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendTo(builder, 1);
    }

    public StringBuilder appendTo(StringBuilder builder, int level) {
        builder.append("{\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"MessageName\": \"TestRequest\",\n");
        builder.append("  \"header\": ");
        this.header.appendTo(builder, level + 1);
        builder.append("\n");
        if (this.hasTestReqID()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"TestReqID\": \"");
            CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.testReqID, (int)this.testReqIDOffset, (int)this.testReqIDLength);
            builder.append("\",\n");
        }
        CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
        builder.append("}");
        return builder;
    }
}

