/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.decoder;

import java.nio.charset.StandardCharsets;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.Constants;
import uk.co.real_logic.artio.OrdType;
import uk.co.real_logic.artio.Side;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder.HeaderDecoder;
import uk.co.real_logic.artio.decoder.InstrumentDecoder;
import uk.co.real_logic.artio.decoder.OrderQtyDataDecoder;
import uk.co.real_logic.artio.decoder.TrailerDecoder;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.AsciiBuffer;

public class NewOrderSingleDecoder
implements InstrumentDecoder,
OrderQtyDataDecoder,
Decoder {
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(10);
    private final IntHashSet alreadyVisitedFields;
    private final IntHashSet unknownFields;
    private final IntHashSet missingRequiredFields;
    private int invalidTagId;
    private int rejectReason;
    public static final int MESSAGE_TYPE = 68;
    public static final String MESSAGE_TYPE_AS_STRING = "D";
    public static final char[] MESSAGE_TYPE_CHARS = "D".toCharArray();
    public static final byte[] MESSAGE_TYPE_BYTES = "D".getBytes(StandardCharsets.US_ASCII);
    public final IntHashSet messageFields;
    private TrailerDecoder trailer;
    private HeaderDecoder header;
    private char[] clOrdID;
    private int clOrdIDLength;
    private int clOrdIDOffset;
    private char[] symbol;
    private int symbolLength;
    private int symbolOffset;
    private char side;
    private byte[] transactTime;
    private int transactTimeLength;
    private int transactTimeOffset;
    private DecimalFloat orderQty;
    private boolean hasOrderQty;
    private char ordType;
    private DecimalFloat price;
    private boolean hasPrice;
    private AsciiBuffer buffer;

    public NewOrderSingleDecoder() {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.REQUIRED_FIELDS.add(11);
            this.REQUIRED_FIELDS.add(55);
            this.REQUIRED_FIELDS.add(54);
            this.REQUIRED_FIELDS.add(60);
            this.REQUIRED_FIELDS.add(40);
        }
        this.alreadyVisitedFields = new IntHashSet(14);
        this.unknownFields = new IntHashSet(10);
        this.missingRequiredFields = new IntHashSet(10);
        this.invalidTagId = -1;
        this.rejectReason = -1;
        this.messageFields = new IntHashSet(46);
        this.messageFields.add(8);
        this.messageFields.add(9);
        this.messageFields.add(35);
        this.messageFields.add(49);
        this.messageFields.add(56);
        this.messageFields.add(34);
        this.messageFields.add(50);
        this.messageFields.add(142);
        this.messageFields.add(57);
        this.messageFields.add(143);
        this.messageFields.add(43);
        this.messageFields.add(97);
        this.messageFields.add(52);
        this.messageFields.add(122);
        this.messageFields.add(369);
        this.messageFields.add(11);
        this.messageFields.add(55);
        this.messageFields.add(54);
        this.messageFields.add(60);
        this.messageFields.add(38);
        this.messageFields.add(40);
        this.messageFields.add(44);
        this.messageFields.add(10);
        this.trailer = new TrailerDecoder();
        this.header = new HeaderDecoder(this.trailer);
        this.clOrdID = new char[1];
        this.symbol = new char[1];
        this.transactTime = new byte[24];
        this.orderQty = new DecimalFloat();
        this.price = new DecimalFloat();
    }

    public int invalidTagId() {
        return this.invalidTagId;
    }

    public int rejectReason() {
        return this.rejectReason;
    }

    public boolean validate() {
        if (this.rejectReason != -1) {
            return false;
        }
        IntHashSet.IntIterator missingFieldsIterator = this.missingRequiredFields.iterator();
        IntHashSet.IntIterator unknownFieldsIterator = this.unknownFields.iterator();
        if (RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext()) {
            this.invalidTagId = unknownFieldsIterator.nextValue();
            this.rejectReason = Constants.ALL_FIELDS.contains(this.invalidTagId) ? 2 : 0;
            return false;
        }
        if (!this.header.validate()) {
            this.invalidTagId = this.header.invalidTagId();
            this.rejectReason = this.header.rejectReason();
            return false;
        }
        if (!this.trailer.validate()) {
            this.invalidTagId = this.trailer.invalidTagId();
            this.rejectReason = this.trailer.rejectReason();
            return false;
        }
        if (missingFieldsIterator.hasNext()) {
            this.invalidTagId = missingFieldsIterator.nextValue();
            this.rejectReason = 1;
            return false;
        }
        if (!Side.isValid(this.side)) {
            this.invalidTagId = 54;
            this.rejectReason = 5;
            return false;
        }
        if (!OrdType.isValid(this.ordType)) {
            this.invalidTagId = 40;
            this.rejectReason = 5;
            return false;
        }
        return true;
    }

    public TrailerDecoder trailer() {
        return this.trailer;
    }

    public HeaderDecoder header() {
        return this.header;
    }

    public char[] clOrdID() {
        return this.clOrdID;
    }

    public int clOrdIDLength() {
        return this.clOrdIDLength;
    }

    public String clOrdIDAsString() {
        return new String(this.clOrdID, 0, this.clOrdIDLength);
    }

    public void clOrdID(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.clOrdIDOffset, this.clOrdIDLength);
    }

    @Override
    public char[] symbol() {
        return this.symbol;
    }

    @Override
    public int symbolLength() {
        return this.symbolLength;
    }

    public String symbolAsString() {
        return new String(this.symbol, 0, this.symbolLength);
    }

    @Override
    public void symbol(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.symbolOffset, this.symbolLength);
    }

    public char side() {
        return this.side;
    }

    public Side sideAsEnum() {
        return Side.decode(this.side);
    }

    public byte[] transactTime() {
        return this.transactTime;
    }

    public int transactTimeLength() {
        return this.transactTimeLength;
    }

    public String transactTimeAsString() {
        return new String(this.transactTime, 0, this.transactTimeLength);
    }

    public void transactTime(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.transactTimeOffset, this.transactTimeLength);
    }

    @Override
    public DecimalFloat orderQty() {
        if (!this.hasOrderQty) {
            throw new IllegalArgumentException("No value for optional field: OrderQty");
        }
        return this.orderQty;
    }

    @Override
    public boolean hasOrderQty() {
        return this.hasOrderQty;
    }

    public char ordType() {
        return this.ordType;
    }

    public OrdType ordTypeAsEnum() {
        return OrdType.decode(this.ordType);
    }

    public DecimalFloat price() {
        if (!this.hasPrice) {
            throw new IllegalArgumentException("No value for optional field: Price");
        }
        return this.price;
    }

    public boolean hasPrice() {
        return this.hasPrice;
    }

    public int decode(AsciiBuffer buffer, int offset, int length) {
        int seenFieldCount = 0;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.missingRequiredFields.copy(this.REQUIRED_FIELDS);
            this.alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        int end = offset + length;
        int position = offset;
        position += this.header.decode(buffer, position, length);
        while (position < end) {
            int equalsPosition = buffer.scan(position, end, '=');
            int tag = buffer.getInt(position, equalsPosition);
            int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, (byte)1);
            if (endOfField == -1 || equalsPosition == -1) {
                this.rejectReason = 5;
                break;
            }
            int valueLength = endOfField - valueOffset;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                if (tag <= 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 0;
                } else if (valueLength == 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 4;
                }
                if (!this.alreadyVisitedFields.add(tag)) {
                    this.invalidTagId = tag;
                    this.rejectReason = 13;
                }
                this.missingRequiredFields.remove(tag);
                ++seenFieldCount;
            }
            switch (tag) {
                case 11: {
                    this.clOrdID = buffer.getChars(this.clOrdID, valueOffset, valueLength);
                    this.clOrdIDOffset = valueOffset;
                    this.clOrdIDLength = valueLength;
                    break;
                }
                case 55: {
                    this.symbol = buffer.getChars(this.symbol, valueOffset, valueLength);
                    this.symbolOffset = valueOffset;
                    this.symbolLength = valueLength;
                    break;
                }
                case 54: {
                    this.side = buffer.getChar(valueOffset);
                    break;
                }
                case 60: {
                    this.transactTime = buffer.getBytes(this.transactTime, valueOffset, valueLength);
                    this.transactTimeOffset = valueOffset;
                    this.transactTimeLength = valueLength;
                    break;
                }
                case 38: {
                    this.hasOrderQty = true;
                    this.orderQty = buffer.getFloat(this.orderQty, valueOffset, valueLength);
                    break;
                }
                case 40: {
                    this.ordType = buffer.getChar(valueOffset);
                    break;
                }
                case 44: {
                    this.hasPrice = true;
                    this.price = buffer.getFloat(this.price, valueOffset, valueLength);
                    break;
                }
                default: {
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                        this.alreadyVisitedFields.remove(tag);
                    } else if (!this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) {
                        this.unknownFields.add(tag);
                    }
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && !this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) break;
                    position += this.trailer.decode(buffer, position, end - position);
                    return position - offset;
                }
            }
            if (position >= endOfField + 1) continue;
            position = endOfField + 1;
        }
        position += this.trailer.decode(buffer, position, end - position);
        return position - offset;
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.invalidTagId = -1;
            this.rejectReason = -1;
            this.missingRequiredFields.clear();
            this.unknownFields.clear();
            this.alreadyVisitedFields.clear();
        }
    }

    public void resetMessage() {
        this.resetClOrdID();
        this.resetSide();
        this.resetTransactTime();
        this.resetOrdType();
        this.resetPrice();
        this.resetSymbol();
        this.resetOrderQty();
    }

    public void resetClOrdID() {
        this.clOrdIDOffset = 0;
        this.clOrdIDLength = 0;
    }

    public void resetSide() {
        this.side = '\u0001';
    }

    public void resetTransactTime() {
    }

    public void resetOrdType() {
        this.ordType = '\u0001';
    }

    public void resetPrice() {
        this.hasPrice = false;
    }

    public void resetSymbol() {
        this.symbolOffset = 0;
        this.symbolLength = 0;
    }

    public void resetOrderQty() {
        this.hasOrderQty = false;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + String.format("  \"ClOrdID\": \"%s\",\n", new String(this.clOrdID, 0, this.clOrdIDLength)) + String.format("  \"Symbol\": \"%s\",\n", new String(this.symbol, 0, this.symbolLength)) + String.format("  \"Side\": \"%s\",\n", Character.valueOf(this.side)) + String.format("  \"TransactTime\": \"%s\",\n", new String(this.transactTime, 0, this.transactTimeLength)) + (this.hasOrderQty() ? String.format("  \"OrderQty\": \"%s\",\n", this.orderQty) : "") + String.format("  \"OrdType\": \"%s\",\n", Character.valueOf(this.ordType)) + (this.hasPrice() ? String.format("  \"Price\": \"%s\",\n", this.price) : "");
        entries = "{\n  \"MessageName\": \"NewOrderSingle\",\n" + entries + "}";
        return entries;
    }
}

