/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.MsgType;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class HeaderEncoder
implements SessionHeaderEncoder {
    private static final byte[] DEFAULT_BEGIN_STRING = "FIX.4.4".getBytes(StandardCharsets.US_ASCII);
    private static final int beginStringHeaderLength = 2;
    private static final byte[] beginStringHeader = new byte[]{56, 61};
    private static final int bodyLengthHeaderLength = 2;
    private static final byte[] bodyLengthHeader = new byte[]{57, 61};
    private static final int msgTypeHeaderLength = 3;
    private static final byte[] msgTypeHeader = new byte[]{51, 53, 61};
    private static final int senderCompIDHeaderLength = 3;
    private static final byte[] senderCompIDHeader = new byte[]{52, 57, 61};
    private static final int targetCompIDHeaderLength = 3;
    private static final byte[] targetCompIDHeader = new byte[]{53, 54, 61};
    private static final int msgSeqNumHeaderLength = 3;
    private static final byte[] msgSeqNumHeader = new byte[]{51, 52, 61};
    private static final int senderSubIDHeaderLength = 3;
    private static final byte[] senderSubIDHeader = new byte[]{53, 48, 61};
    private static final int senderLocationIDHeaderLength = 4;
    private static final byte[] senderLocationIDHeader = new byte[]{49, 52, 50, 61};
    private static final int targetSubIDHeaderLength = 3;
    private static final byte[] targetSubIDHeader = new byte[]{53, 55, 61};
    private static final int targetLocationIDHeaderLength = 4;
    private static final byte[] targetLocationIDHeader = new byte[]{49, 52, 51, 61};
    private static final int possDupFlagHeaderLength = 3;
    private static final byte[] possDupFlagHeader = new byte[]{52, 51, 61};
    private static final int possResendHeaderLength = 3;
    private static final byte[] possResendHeader = new byte[]{57, 55, 61};
    private static final int sendingTimeHeaderLength = 3;
    private static final byte[] sendingTimeHeader = new byte[]{53, 50, 61};
    private static final int origSendingTimeHeaderLength = 4;
    private static final byte[] origSendingTimeHeader = new byte[]{49, 50, 50, 61};
    private static final int lastMsgSeqNumProcessedHeaderLength = 4;
    private static final byte[] lastMsgSeqNumProcessedHeader = new byte[]{51, 54, 57, 61};
    private byte[] beginString = new byte[1];
    private int beginStringOffset = 0;
    private int beginStringLength = 0;
    private byte[] msgType = new byte[1];
    private int msgTypeOffset = 0;
    private int msgTypeLength = 0;
    private byte[] senderCompID = new byte[1];
    private int senderCompIDOffset = 0;
    private int senderCompIDLength = 0;
    private byte[] targetCompID = new byte[1];
    private int targetCompIDOffset = 0;
    private int targetCompIDLength = 0;
    private int msgSeqNum;
    private boolean hasMsgSeqNum;
    private byte[] senderSubID = new byte[1];
    private int senderSubIDOffset = 0;
    private int senderSubIDLength = 0;
    private byte[] senderLocationID = new byte[1];
    private int senderLocationIDOffset = 0;
    private int senderLocationIDLength = 0;
    private byte[] targetSubID = new byte[1];
    private int targetSubIDOffset = 0;
    private int targetSubIDLength = 0;
    private byte[] targetLocationID = new byte[1];
    private int targetLocationIDOffset = 0;
    private int targetLocationIDLength = 0;
    private boolean possDupFlag;
    private boolean hasPossDupFlag;
    private boolean possResend;
    private boolean hasPossResend;
    private byte[] sendingTime = new byte[1];
    private int sendingTimeOffset = 0;
    private int sendingTimeLength = 0;
    private byte[] origSendingTime = new byte[1];
    private int origSendingTimeOffset = 0;
    private int origSendingTimeLength = 0;
    private int lastMsgSeqNumProcessed;
    private boolean hasLastMsgSeqNumProcessed;

    public HeaderEncoder() {
        this.beginString(DEFAULT_BEGIN_STRING);
    }

    public HeaderEncoder beginString(byte[] value, int length) {
        this.beginString = value;
        this.beginStringOffset = 0;
        this.beginStringLength = length;
        return this;
    }

    public HeaderEncoder beginString(byte[] value, int offset, int length) {
        this.beginString = value;
        this.beginStringOffset = offset;
        this.beginStringLength = length;
        return this;
    }

    public HeaderEncoder beginString(byte[] value) {
        return this.beginString(value, value.length);
    }

    public boolean hasBeginString() {
        return this.beginStringLength > 0;
    }

    public byte[] beginString() {
        return this.beginString;
    }

    public HeaderEncoder beginString(CharSequence value) {
        this.beginString = CodecUtil.toBytes((CharSequence)value, (byte[])this.beginString);
        this.beginStringOffset = 0;
        this.beginStringLength = value.length();
        return this;
    }

    public HeaderEncoder beginString(char[] value) {
        return this.beginString(value, value.length);
    }

    public HeaderEncoder beginString(char[] value, int length) {
        this.beginString = CodecUtil.toBytes((char[])value, (byte[])this.beginString, (int)length);
        this.beginStringOffset = 0;
        this.beginStringLength = length;
        return this;
    }

    public HeaderEncoder beginString(char[] value, int offset, int length) {
        this.beginString = CodecUtil.toBytes((char[])value, (byte[])this.beginString, (int)offset, (int)length);
        this.beginStringOffset = 0;
        this.beginStringLength = length;
        return this;
    }

    public HeaderEncoder msgType(byte[] value, int length) {
        this.msgType = value;
        this.msgTypeOffset = 0;
        this.msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgType(byte[] value, int offset, int length) {
        this.msgType = value;
        this.msgTypeOffset = offset;
        this.msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgType(byte[] value) {
        return this.msgType(value, value.length);
    }

    public boolean hasMsgType() {
        return this.msgTypeLength > 0;
    }

    public byte[] msgType() {
        return this.msgType;
    }

    public HeaderEncoder msgType(CharSequence value) {
        this.msgType = CodecUtil.toBytes((CharSequence)value, (byte[])this.msgType);
        this.msgTypeOffset = 0;
        this.msgTypeLength = value.length();
        return this;
    }

    public HeaderEncoder msgType(char[] value) {
        return this.msgType(value, value.length);
    }

    public HeaderEncoder msgType(char[] value, int length) {
        this.msgType = CodecUtil.toBytes((char[])value, (byte[])this.msgType, (int)length);
        this.msgTypeOffset = 0;
        this.msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgType(char[] value, int offset, int length) {
        this.msgType = CodecUtil.toBytes((char[])value, (byte[])this.msgType, (int)offset, (int)length);
        this.msgTypeOffset = 0;
        this.msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgType(MsgType value) {
        return this.msgType(value.representation());
    }

    public HeaderEncoder senderCompID(byte[] value, int length) {
        this.senderCompID = value;
        this.senderCompIDOffset = 0;
        this.senderCompIDLength = length;
        return this;
    }

    public HeaderEncoder senderCompID(byte[] value, int offset, int length) {
        this.senderCompID = value;
        this.senderCompIDOffset = offset;
        this.senderCompIDLength = length;
        return this;
    }

    public HeaderEncoder senderCompID(byte[] value) {
        return this.senderCompID(value, value.length);
    }

    public boolean hasSenderCompID() {
        return this.senderCompIDLength > 0;
    }

    public byte[] senderCompID() {
        return this.senderCompID;
    }

    public HeaderEncoder senderCompID(CharSequence value) {
        this.senderCompID = CodecUtil.toBytes((CharSequence)value, (byte[])this.senderCompID);
        this.senderCompIDOffset = 0;
        this.senderCompIDLength = value.length();
        return this;
    }

    public HeaderEncoder senderCompID(char[] value) {
        return this.senderCompID(value, value.length);
    }

    public HeaderEncoder senderCompID(char[] value, int length) {
        this.senderCompID = CodecUtil.toBytes((char[])value, (byte[])this.senderCompID, (int)length);
        this.senderCompIDOffset = 0;
        this.senderCompIDLength = length;
        return this;
    }

    public HeaderEncoder senderCompID(char[] value, int offset, int length) {
        this.senderCompID = CodecUtil.toBytes((char[])value, (byte[])this.senderCompID, (int)offset, (int)length);
        this.senderCompIDOffset = 0;
        this.senderCompIDLength = length;
        return this;
    }

    public HeaderEncoder targetCompID(byte[] value, int length) {
        this.targetCompID = value;
        this.targetCompIDOffset = 0;
        this.targetCompIDLength = length;
        return this;
    }

    public HeaderEncoder targetCompID(byte[] value, int offset, int length) {
        this.targetCompID = value;
        this.targetCompIDOffset = offset;
        this.targetCompIDLength = length;
        return this;
    }

    public HeaderEncoder targetCompID(byte[] value) {
        return this.targetCompID(value, value.length);
    }

    public boolean hasTargetCompID() {
        return this.targetCompIDLength > 0;
    }

    public byte[] targetCompID() {
        return this.targetCompID;
    }

    public HeaderEncoder targetCompID(CharSequence value) {
        this.targetCompID = CodecUtil.toBytes((CharSequence)value, (byte[])this.targetCompID);
        this.targetCompIDOffset = 0;
        this.targetCompIDLength = value.length();
        return this;
    }

    public HeaderEncoder targetCompID(char[] value) {
        return this.targetCompID(value, value.length);
    }

    public HeaderEncoder targetCompID(char[] value, int length) {
        this.targetCompID = CodecUtil.toBytes((char[])value, (byte[])this.targetCompID, (int)length);
        this.targetCompIDOffset = 0;
        this.targetCompIDLength = length;
        return this;
    }

    public HeaderEncoder targetCompID(char[] value, int offset, int length) {
        this.targetCompID = CodecUtil.toBytes((char[])value, (byte[])this.targetCompID, (int)offset, (int)length);
        this.targetCompIDOffset = 0;
        this.targetCompIDLength = length;
        return this;
    }

    public boolean hasMsgSeqNum() {
        return this.hasMsgSeqNum;
    }

    public HeaderEncoder msgSeqNum(int value) {
        this.msgSeqNum = value;
        this.hasMsgSeqNum = true;
        return this;
    }

    public int msgSeqNum() {
        return this.msgSeqNum;
    }

    public HeaderEncoder senderSubID(byte[] value, int length) {
        this.senderSubID = value;
        this.senderSubIDOffset = 0;
        this.senderSubIDLength = length;
        return this;
    }

    public HeaderEncoder senderSubID(byte[] value, int offset, int length) {
        this.senderSubID = value;
        this.senderSubIDOffset = offset;
        this.senderSubIDLength = length;
        return this;
    }

    public HeaderEncoder senderSubID(byte[] value) {
        return this.senderSubID(value, value.length);
    }

    public boolean hasSenderSubID() {
        return this.senderSubIDLength > 0;
    }

    public byte[] senderSubID() {
        return this.senderSubID;
    }

    public HeaderEncoder senderSubID(CharSequence value) {
        this.senderSubID = CodecUtil.toBytes((CharSequence)value, (byte[])this.senderSubID);
        this.senderSubIDOffset = 0;
        this.senderSubIDLength = value.length();
        return this;
    }

    public HeaderEncoder senderSubID(char[] value) {
        return this.senderSubID(value, value.length);
    }

    public HeaderEncoder senderSubID(char[] value, int length) {
        this.senderSubID = CodecUtil.toBytes((char[])value, (byte[])this.senderSubID, (int)length);
        this.senderSubIDOffset = 0;
        this.senderSubIDLength = length;
        return this;
    }

    public HeaderEncoder senderSubID(char[] value, int offset, int length) {
        this.senderSubID = CodecUtil.toBytes((char[])value, (byte[])this.senderSubID, (int)offset, (int)length);
        this.senderSubIDOffset = 0;
        this.senderSubIDLength = length;
        return this;
    }

    public HeaderEncoder senderLocationID(byte[] value, int length) {
        this.senderLocationID = value;
        this.senderLocationIDOffset = 0;
        this.senderLocationIDLength = length;
        return this;
    }

    public HeaderEncoder senderLocationID(byte[] value, int offset, int length) {
        this.senderLocationID = value;
        this.senderLocationIDOffset = offset;
        this.senderLocationIDLength = length;
        return this;
    }

    public HeaderEncoder senderLocationID(byte[] value) {
        return this.senderLocationID(value, value.length);
    }

    public boolean hasSenderLocationID() {
        return this.senderLocationIDLength > 0;
    }

    public byte[] senderLocationID() {
        return this.senderLocationID;
    }

    public HeaderEncoder senderLocationID(CharSequence value) {
        this.senderLocationID = CodecUtil.toBytes((CharSequence)value, (byte[])this.senderLocationID);
        this.senderLocationIDOffset = 0;
        this.senderLocationIDLength = value.length();
        return this;
    }

    public HeaderEncoder senderLocationID(char[] value) {
        return this.senderLocationID(value, value.length);
    }

    public HeaderEncoder senderLocationID(char[] value, int length) {
        this.senderLocationID = CodecUtil.toBytes((char[])value, (byte[])this.senderLocationID, (int)length);
        this.senderLocationIDOffset = 0;
        this.senderLocationIDLength = length;
        return this;
    }

    public HeaderEncoder senderLocationID(char[] value, int offset, int length) {
        this.senderLocationID = CodecUtil.toBytes((char[])value, (byte[])this.senderLocationID, (int)offset, (int)length);
        this.senderLocationIDOffset = 0;
        this.senderLocationIDLength = length;
        return this;
    }

    public HeaderEncoder targetSubID(byte[] value, int length) {
        this.targetSubID = value;
        this.targetSubIDOffset = 0;
        this.targetSubIDLength = length;
        return this;
    }

    public HeaderEncoder targetSubID(byte[] value, int offset, int length) {
        this.targetSubID = value;
        this.targetSubIDOffset = offset;
        this.targetSubIDLength = length;
        return this;
    }

    public HeaderEncoder targetSubID(byte[] value) {
        return this.targetSubID(value, value.length);
    }

    public boolean hasTargetSubID() {
        return this.targetSubIDLength > 0;
    }

    public byte[] targetSubID() {
        return this.targetSubID;
    }

    public HeaderEncoder targetSubID(CharSequence value) {
        this.targetSubID = CodecUtil.toBytes((CharSequence)value, (byte[])this.targetSubID);
        this.targetSubIDOffset = 0;
        this.targetSubIDLength = value.length();
        return this;
    }

    public HeaderEncoder targetSubID(char[] value) {
        return this.targetSubID(value, value.length);
    }

    public HeaderEncoder targetSubID(char[] value, int length) {
        this.targetSubID = CodecUtil.toBytes((char[])value, (byte[])this.targetSubID, (int)length);
        this.targetSubIDOffset = 0;
        this.targetSubIDLength = length;
        return this;
    }

    public HeaderEncoder targetSubID(char[] value, int offset, int length) {
        this.targetSubID = CodecUtil.toBytes((char[])value, (byte[])this.targetSubID, (int)offset, (int)length);
        this.targetSubIDOffset = 0;
        this.targetSubIDLength = length;
        return this;
    }

    public HeaderEncoder targetLocationID(byte[] value, int length) {
        this.targetLocationID = value;
        this.targetLocationIDOffset = 0;
        this.targetLocationIDLength = length;
        return this;
    }

    public HeaderEncoder targetLocationID(byte[] value, int offset, int length) {
        this.targetLocationID = value;
        this.targetLocationIDOffset = offset;
        this.targetLocationIDLength = length;
        return this;
    }

    public HeaderEncoder targetLocationID(byte[] value) {
        return this.targetLocationID(value, value.length);
    }

    public boolean hasTargetLocationID() {
        return this.targetLocationIDLength > 0;
    }

    public byte[] targetLocationID() {
        return this.targetLocationID;
    }

    public HeaderEncoder targetLocationID(CharSequence value) {
        this.targetLocationID = CodecUtil.toBytes((CharSequence)value, (byte[])this.targetLocationID);
        this.targetLocationIDOffset = 0;
        this.targetLocationIDLength = value.length();
        return this;
    }

    public HeaderEncoder targetLocationID(char[] value) {
        return this.targetLocationID(value, value.length);
    }

    public HeaderEncoder targetLocationID(char[] value, int length) {
        this.targetLocationID = CodecUtil.toBytes((char[])value, (byte[])this.targetLocationID, (int)length);
        this.targetLocationIDOffset = 0;
        this.targetLocationIDLength = length;
        return this;
    }

    public HeaderEncoder targetLocationID(char[] value, int offset, int length) {
        this.targetLocationID = CodecUtil.toBytes((char[])value, (byte[])this.targetLocationID, (int)offset, (int)length);
        this.targetLocationIDOffset = 0;
        this.targetLocationIDLength = length;
        return this;
    }

    public boolean hasPossDupFlag() {
        return this.hasPossDupFlag;
    }

    public HeaderEncoder possDupFlag(boolean value) {
        this.possDupFlag = value;
        this.hasPossDupFlag = true;
        return this;
    }

    public boolean possDupFlag() {
        return this.possDupFlag;
    }

    public boolean hasPossResend() {
        return this.hasPossResend;
    }

    public HeaderEncoder possResend(boolean value) {
        this.possResend = value;
        this.hasPossResend = true;
        return this;
    }

    public boolean possResend() {
        return this.possResend;
    }

    public HeaderEncoder sendingTime(byte[] value, int length) {
        this.sendingTime = value;
        this.sendingTimeOffset = 0;
        this.sendingTimeLength = length;
        return this;
    }

    public HeaderEncoder sendingTime(byte[] value, int offset, int length) {
        this.sendingTime = value;
        this.sendingTimeOffset = offset;
        this.sendingTimeLength = length;
        return this;
    }

    public HeaderEncoder sendingTime(byte[] value) {
        return this.sendingTime(value, value.length);
    }

    public boolean hasSendingTime() {
        return this.sendingTimeLength > 0;
    }

    public byte[] sendingTime() {
        return this.sendingTime;
    }

    public HeaderEncoder origSendingTime(byte[] value, int length) {
        this.origSendingTime = value;
        this.origSendingTimeOffset = 0;
        this.origSendingTimeLength = length;
        return this;
    }

    public HeaderEncoder origSendingTime(byte[] value, int offset, int length) {
        this.origSendingTime = value;
        this.origSendingTimeOffset = offset;
        this.origSendingTimeLength = length;
        return this;
    }

    public HeaderEncoder origSendingTime(byte[] value) {
        return this.origSendingTime(value, value.length);
    }

    public boolean hasOrigSendingTime() {
        return this.origSendingTimeLength > 0;
    }

    public byte[] origSendingTime() {
        return this.origSendingTime;
    }

    public boolean hasLastMsgSeqNumProcessed() {
        return this.hasLastMsgSeqNumProcessed;
    }

    public HeaderEncoder lastMsgSeqNumProcessed(int value) {
        this.lastMsgSeqNumProcessed = value;
        this.hasLastMsgSeqNumProcessed = true;
        return this;
    }

    public int lastMsgSeqNumProcessed() {
        return this.lastMsgSeqNumProcessed;
    }

    int finishHeader(MutableAsciiBuffer buffer, int bodyStart, int bodyLength) {
        int position = bodyStart - 1;
        buffer.putSeparator(position);
        position = buffer.putNaturalIntAsciiFromEnd(bodyLength, position);
        buffer.putBytes(position -= 2, bodyLengthHeader, 0, 2);
        if (this.beginStringLength > 0) {
            buffer.putSeparator(--position);
            buffer.putBytes(position -= this.beginStringLength, this.beginString, this.beginStringOffset, this.beginStringLength);
            buffer.putBytes(position -= 2, beginStringHeader, 0, 2);
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: BeginString");
        }
        return position;
    }

    public long startMessage(MutableAsciiBuffer buffer, int offset) {
        int start;
        int position = start = offset + this.beginStringLength + 16;
        if (this.msgTypeLength > 0) {
            buffer.putBytes(position, msgTypeHeader, 0, 3);
            buffer.putBytes(position += 3, this.msgType, this.msgTypeOffset, this.msgTypeLength);
            buffer.putSeparator(position += this.msgTypeLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: MsgType");
        }
        if (this.senderCompIDLength > 0) {
            buffer.putBytes(position, senderCompIDHeader, 0, 3);
            buffer.putBytes(position += 3, this.senderCompID, this.senderCompIDOffset, this.senderCompIDLength);
            buffer.putSeparator(position += this.senderCompIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: SenderCompID");
        }
        if (this.targetCompIDLength > 0) {
            buffer.putBytes(position, targetCompIDHeader, 0, 3);
            buffer.putBytes(position += 3, this.targetCompID, this.targetCompIDOffset, this.targetCompIDLength);
            buffer.putSeparator(position += this.targetCompIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: TargetCompID");
        }
        if (this.hasMsgSeqNum) {
            buffer.putBytes(position, msgSeqNumHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.msgSeqNum);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.senderSubIDLength > 0) {
            buffer.putBytes(position, senderSubIDHeader, 0, 3);
            buffer.putBytes(position += 3, this.senderSubID, this.senderSubIDOffset, this.senderSubIDLength);
            buffer.putSeparator(position += this.senderSubIDLength);
            ++position;
        }
        if (this.senderLocationIDLength > 0) {
            buffer.putBytes(position, senderLocationIDHeader, 0, 4);
            buffer.putBytes(position += 4, this.senderLocationID, this.senderLocationIDOffset, this.senderLocationIDLength);
            buffer.putSeparator(position += this.senderLocationIDLength);
            ++position;
        }
        if (this.targetSubIDLength > 0) {
            buffer.putBytes(position, targetSubIDHeader, 0, 3);
            buffer.putBytes(position += 3, this.targetSubID, this.targetSubIDOffset, this.targetSubIDLength);
            buffer.putSeparator(position += this.targetSubIDLength);
            ++position;
        }
        if (this.targetLocationIDLength > 0) {
            buffer.putBytes(position, targetLocationIDHeader, 0, 4);
            buffer.putBytes(position += 4, this.targetLocationID, this.targetLocationIDOffset, this.targetLocationIDLength);
            buffer.putSeparator(position += this.targetLocationIDLength);
            ++position;
        }
        if (this.hasPossDupFlag) {
            buffer.putBytes(position, possDupFlagHeader, 0, 3);
            position += 3;
            position += buffer.putBooleanAscii(position, this.possDupFlag);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasPossResend) {
            buffer.putBytes(position, possResendHeader, 0, 3);
            position += 3;
            position += buffer.putBooleanAscii(position, this.possResend);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.sendingTimeLength > 0) {
            buffer.putBytes(position, sendingTimeHeader, 0, 3);
            buffer.putBytes(position += 3, this.sendingTime, this.sendingTimeOffset, this.sendingTimeLength);
            buffer.putSeparator(position += this.sendingTimeLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: SendingTime");
        }
        if (this.origSendingTimeLength > 0) {
            buffer.putBytes(position, origSendingTimeHeader, 0, 4);
            buffer.putBytes(position += 4, this.origSendingTime, this.origSendingTimeOffset, this.origSendingTimeLength);
            buffer.putSeparator(position += this.origSendingTimeLength);
            ++position;
        }
        if (this.hasLastMsgSeqNumProcessed) {
            buffer.putBytes(position, lastMsgSeqNumProcessedHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.lastMsgSeqNumProcessed);
            buffer.putSeparator(position);
            ++position;
        }
        return Encoder.result((int)(position - start), (int)start);
    }

    public void reset() {
        this.resetSenderCompID();
        this.resetTargetCompID();
        this.resetMsgSeqNum();
        this.resetSenderSubID();
        this.resetSenderLocationID();
        this.resetTargetSubID();
        this.resetTargetLocationID();
        this.resetPossDupFlag();
        this.resetPossResend();
        this.resetSendingTime();
        this.resetOrigSendingTime();
        this.resetLastMsgSeqNumProcessed();
        this.beginString(DEFAULT_BEGIN_STRING);
    }

    public void resetSenderCompID() {
        this.senderCompIDLength = 0;
    }

    public void resetTargetCompID() {
        this.targetCompIDLength = 0;
    }

    public void resetMsgSeqNum() {
        this.hasMsgSeqNum = false;
    }

    public void resetSenderSubID() {
        this.senderSubIDLength = 0;
    }

    public void resetSenderLocationID() {
        this.senderLocationIDLength = 0;
    }

    public void resetTargetSubID() {
        this.targetSubIDLength = 0;
    }

    public void resetTargetLocationID() {
        this.targetLocationIDLength = 0;
    }

    public void resetPossDupFlag() {
        this.hasPossDupFlag = false;
    }

    public void resetPossResend() {
        this.hasPossResend = false;
    }

    public void resetSendingTime() {
        this.sendingTimeLength = 0;
    }

    public void resetOrigSendingTime() {
        this.origSendingTimeLength = 0;
    }

    public void resetLastMsgSeqNumProcessed() {
        this.hasLastMsgSeqNumProcessed = false;
    }

    public String toString() {
        String entries = (this.hasBeginString() ? String.format("  \"BeginString\": \"%s\",\n", new String(this.beginString, this.beginStringOffset, this.beginStringLength, StandardCharsets.US_ASCII)) : "") + "" + (this.hasMsgType() ? String.format("  \"MsgType\": \"%s\",\n", new String(this.msgType, this.msgTypeOffset, this.msgTypeLength, StandardCharsets.US_ASCII)) : "") + (this.hasSenderCompID() ? String.format("  \"SenderCompID\": \"%s\",\n", new String(this.senderCompID, this.senderCompIDOffset, this.senderCompIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasTargetCompID() ? String.format("  \"TargetCompID\": \"%s\",\n", new String(this.targetCompID, this.targetCompIDOffset, this.targetCompIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasMsgSeqNum() ? String.format("  \"MsgSeqNum\": \"%s\",\n", this.msgSeqNum) : "") + (this.hasSenderSubID() ? String.format("  \"SenderSubID\": \"%s\",\n", new String(this.senderSubID, this.senderSubIDOffset, this.senderSubIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasSenderLocationID() ? String.format("  \"SenderLocationID\": \"%s\",\n", new String(this.senderLocationID, this.senderLocationIDOffset, this.senderLocationIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasTargetSubID() ? String.format("  \"TargetSubID\": \"%s\",\n", new String(this.targetSubID, this.targetSubIDOffset, this.targetSubIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasTargetLocationID() ? String.format("  \"TargetLocationID\": \"%s\",\n", new String(this.targetLocationID, this.targetLocationIDOffset, this.targetLocationIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasPossDupFlag() ? String.format("  \"PossDupFlag\": \"%s\",\n", this.possDupFlag) : "") + (this.hasPossResend() ? String.format("  \"PossResend\": \"%s\",\n", this.possResend) : "") + (this.hasSendingTime() ? String.format("  \"SendingTime\": \"%s\",\n", new String(this.sendingTime, this.sendingTimeOffset, this.sendingTimeLength, StandardCharsets.US_ASCII)) : "") + (this.hasOrigSendingTime() ? String.format("  \"OrigSendingTime\": \"%s\",\n", new String(this.origSendingTime, this.origSendingTimeOffset, this.origSendingTimeLength, StandardCharsets.US_ASCII)) : "") + (this.hasLastMsgSeqNumProcessed() ? String.format("  \"LastMsgSeqNumProcessed\": \"%s\",\n", this.lastMsgSeqNumProcessed) : "");
        entries = "{\n  \"MessageName\": \"Header\",\n" + entries + "}";
        return entries;
    }
}

