/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class InstrumentEncoder {
    private static final int symbolHeaderLength = 3;
    private static final byte[] symbolHeader = new byte[]{53, 53, 61};
    private byte[] symbol = new byte[1];
    private int symbolOffset = 0;
    private int symbolLength = 0;

    public InstrumentEncoder symbol(byte[] value, int length) {
        this.symbol = value;
        this.symbolOffset = 0;
        this.symbolLength = length;
        return this;
    }

    public InstrumentEncoder symbol(byte[] value, int offset, int length) {
        this.symbol = value;
        this.symbolOffset = offset;
        this.symbolLength = length;
        return this;
    }

    public InstrumentEncoder symbol(byte[] value) {
        return this.symbol(value, value.length);
    }

    public boolean hasSymbol() {
        return this.symbolLength > 0;
    }

    public byte[] symbol() {
        return this.symbol;
    }

    public InstrumentEncoder symbol(CharSequence value) {
        this.symbol = CodecUtil.toBytes((CharSequence)value, (byte[])this.symbol);
        this.symbolOffset = 0;
        this.symbolLength = value.length();
        return this;
    }

    public InstrumentEncoder symbol(char[] value) {
        return this.symbol(value, value.length);
    }

    public InstrumentEncoder symbol(char[] value, int length) {
        this.symbol = CodecUtil.toBytes((char[])value, (byte[])this.symbol, (int)length);
        this.symbolOffset = 0;
        this.symbolLength = length;
        return this;
    }

    public InstrumentEncoder symbol(char[] value, int offset, int length) {
        this.symbol = CodecUtil.toBytes((char[])value, (byte[])this.symbol, (int)offset, (int)length);
        this.symbolOffset = 0;
        this.symbolLength = length;
        return this;
    }

    public int encode(MutableAsciiBuffer buffer, int offset) {
        int position = offset;
        if (this.symbolLength > 0) {
            buffer.putBytes(position, symbolHeader, 0, 3);
            buffer.putBytes(position += 3, this.symbol, this.symbolOffset, this.symbolLength);
            buffer.putSeparator(position += this.symbolLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: Symbol");
        }
        return position - offset;
    }

    public void reset() {
        this.resetSymbol();
    }

    public void resetSymbol() {
        this.symbolLength = 0;
    }

    public String toString() {
        String entries = this.hasSymbol() ? String.format("  \"Symbol\": \"%s\",\n", new String(this.symbol, this.symbolOffset, this.symbolLength, StandardCharsets.US_ASCII)) : "";
        entries = "{\n  \"MessageName\": \"Instrument\",\n" + entries + "}";
        return entries;
    }
}

