/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.decoder;

import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.util.AsciiBuffer;

public class TrailerDecoder
implements Decoder {
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(2);
    private final IntHashSet alreadyVisitedFields;
    private final IntHashSet unknownFields;
    private final IntHashSet missingRequiredFields;
    private int invalidTagId;
    private int rejectReason;
    private char[] checkSum;
    private int checkSumLength;
    private int checkSumOffset;
    private AsciiBuffer buffer;

    public TrailerDecoder() {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.REQUIRED_FIELDS.add(10);
        }
        this.alreadyVisitedFields = new IntHashSet(2);
        this.unknownFields = new IntHashSet(10);
        this.missingRequiredFields = new IntHashSet(2);
        this.invalidTagId = -1;
        this.rejectReason = -1;
        this.checkSum = new char[1];
    }

    public int invalidTagId() {
        return this.invalidTagId;
    }

    public int rejectReason() {
        return this.rejectReason;
    }

    public boolean validate() {
        if (this.rejectReason != -1) {
            return false;
        }
        IntHashSet.IntIterator missingFieldsIterator = this.missingRequiredFields.iterator();
        if (missingFieldsIterator.hasNext()) {
            this.invalidTagId = missingFieldsIterator.nextValue();
            this.rejectReason = 1;
            return false;
        }
        return true;
    }

    public char[] checkSum() {
        return this.checkSum;
    }

    public int checkSumLength() {
        return this.checkSumLength;
    }

    public String checkSumAsString() {
        return new String(this.checkSum, 0, this.checkSumLength);
    }

    public void checkSum(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.checkSumOffset, this.checkSumLength);
    }

    public int decode(AsciiBuffer buffer, int offset, int length) {
        int seenFieldCount = 0;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.missingRequiredFields.copy(this.REQUIRED_FIELDS);
            this.alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        int end = offset + length;
        int position = offset;
        while (position < end) {
            int equalsPosition = buffer.scan(position, end, '=');
            int tag = buffer.getInt(position, equalsPosition);
            int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, (byte)1);
            if (endOfField == -1 || equalsPosition == -1) {
                this.rejectReason = 5;
                break;
            }
            int valueLength = endOfField - valueOffset;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                if (tag <= 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 0;
                } else if (valueLength == 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 4;
                }
                if (!this.alreadyVisitedFields.add(tag)) {
                    this.invalidTagId = tag;
                    this.rejectReason = 13;
                }
                this.missingRequiredFields.remove(tag);
                ++seenFieldCount;
            }
            switch (tag) {
                case 10: {
                    this.checkSum = buffer.getChars(this.checkSum, valueOffset, valueLength);
                    this.checkSumOffset = valueOffset;
                    this.checkSumLength = valueLength;
                    break;
                }
                default: {
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                        this.alreadyVisitedFields.remove(tag);
                    } else if (!this.REQUIRED_FIELDS.contains(tag)) {
                        this.unknownFields.add(tag);
                    }
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && !this.REQUIRED_FIELDS.contains(tag)) break;
                    return position - offset;
                }
            }
            if (position >= endOfField + 1) continue;
            position = endOfField + 1;
        }
        return position - offset;
    }

    public void reset() {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.invalidTagId = -1;
            this.rejectReason = -1;
            this.missingRequiredFields.clear();
            this.unknownFields.clear();
            this.alreadyVisitedFields.clear();
        }
    }

    public String toString() {
        String entries = String.format("  \"CheckSum\": \"%s\",\n", new String(this.checkSum, 0, this.checkSumLength));
        entries = "{\n  \"MessageName\": \"Trailer\",\n" + entries + "}";
        return entries;
    }
}

