/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class SequenceResetEncoder
implements Encoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int gapFillFlagHeaderLength = 4;
    private static final byte[] gapFillFlagHeader = new byte[]{49, 50, 51, 61};
    private static final int newSeqNoHeaderLength = 3;
    private static final byte[] newSeqNoHeader = new byte[]{51, 54, 61};
    private boolean gapFillFlag;
    private boolean hasGapFillFlag;
    private int newSeqNo;
    private boolean hasNewSeqNo;

    public int messageType() {
        return 52;
    }

    public SequenceResetEncoder() {
        this.header.msgType("4");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public boolean hasGapFillFlag() {
        return this.hasGapFillFlag;
    }

    public SequenceResetEncoder gapFillFlag(boolean value) {
        this.gapFillFlag = value;
        this.hasGapFillFlag = true;
        return this;
    }

    public boolean gapFillFlag() {
        return this.gapFillFlag;
    }

    public boolean hasNewSeqNo() {
        return this.hasNewSeqNo;
    }

    public SequenceResetEncoder newSeqNo(int value) {
        this.newSeqNo = value;
        this.hasNewSeqNo = true;
        return this;
    }

    public int newSeqNo() {
        return this.newSeqNo;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.hasGapFillFlag) {
            buffer.putBytes(position, gapFillFlagHeader, 0, 4);
            position += 4;
            position += buffer.putBooleanAscii(position, this.gapFillFlag);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasNewSeqNo) {
            buffer.putBytes(position, newSeqNoHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.newSeqNo);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: NewSeqNo");
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetGapFillFlag();
        this.resetNewSeqNo();
    }

    public void resetGapFillFlag() {
        this.hasGapFillFlag = false;
    }

    public void resetNewSeqNo() {
        this.hasNewSeqNo = false;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasGapFillFlag() ? String.format("  \"GapFillFlag\": \"%s\",\n", this.gapFillFlag) : "") + (this.hasNewSeqNo() ? String.format("  \"NewSeqNo\": \"%s\",\n", this.newSeqNo) : "");
        entries = "{\n  \"MessageName\": \"SequenceReset\",\n" + entries + "}";
        return entries;
    }
}

