/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class ExampleMessageEncoder
implements Encoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int testReqIDHeaderLength = 4;
    private static final byte[] testReqIDHeader = new byte[]{49, 49, 50, 61};
    private byte[] testReqID = new byte[1];
    private int testReqIDOffset = 0;
    private int testReqIDLength = 0;

    public int messageType() {
        return 66;
    }

    public ExampleMessageEncoder() {
        this.header.msgType("B");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public ExampleMessageEncoder testReqID(byte[] value, int length) {
        this.testReqID = value;
        this.testReqIDOffset = 0;
        this.testReqIDLength = length;
        return this;
    }

    public ExampleMessageEncoder testReqID(byte[] value, int offset, int length) {
        this.testReqID = value;
        this.testReqIDOffset = offset;
        this.testReqIDLength = length;
        return this;
    }

    public ExampleMessageEncoder testReqID(byte[] value) {
        return this.testReqID(value, value.length);
    }

    public boolean hasTestReqID() {
        return this.testReqIDLength > 0;
    }

    public byte[] testReqID() {
        return this.testReqID;
    }

    public ExampleMessageEncoder testReqID(CharSequence value) {
        this.testReqID = CodecUtil.toBytes((CharSequence)value, (byte[])this.testReqID);
        this.testReqIDOffset = 0;
        this.testReqIDLength = value.length();
        return this;
    }

    public ExampleMessageEncoder testReqID(char[] value) {
        return this.testReqID(value, value.length);
    }

    public ExampleMessageEncoder testReqID(char[] value, int length) {
        this.testReqID = CodecUtil.toBytes((char[])value, (byte[])this.testReqID, (int)length);
        this.testReqIDOffset = 0;
        this.testReqIDLength = length;
        return this;
    }

    public ExampleMessageEncoder testReqID(char[] value, int offset, int length) {
        this.testReqID = CodecUtil.toBytes((char[])value, (byte[])this.testReqID, (int)offset, (int)length);
        this.testReqIDOffset = 0;
        this.testReqIDLength = length;
        return this;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.testReqIDLength > 0) {
            buffer.putBytes(position, testReqIDHeader, 0, 4);
            buffer.putBytes(position += 4, this.testReqID, this.testReqIDOffset, this.testReqIDLength);
            buffer.putSeparator(position += this.testReqIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: TestReqID");
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetTestReqID();
    }

    public void resetTestReqID() {
        this.testReqIDLength = 0;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasTestReqID() ? String.format("  \"TestReqID\": \"%s\",\n", new String(this.testReqID, this.testReqIDOffset, this.testReqIDLength, StandardCharsets.US_ASCII)) : "");
        entries = "{\n  \"MessageName\": \"ExampleMessage\",\n" + entries + "}";
        return entries;
    }
}

