/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.ExecType;
import uk.co.real_logic.artio.OrdStatus;
import uk.co.real_logic.artio.Side;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.InstrumentEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class ExecutionReportEncoder
implements Encoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int orderIDHeaderLength = 3;
    private static final byte[] orderIDHeader = new byte[]{51, 55, 61};
    private static final int execIDHeaderLength = 3;
    private static final byte[] execIDHeader = new byte[]{49, 55, 61};
    private static final int execTypeHeaderLength = 4;
    private static final byte[] execTypeHeader = new byte[]{49, 53, 48, 61};
    private static final int ordStatusHeaderLength = 3;
    private static final byte[] ordStatusHeader = new byte[]{51, 57, 61};
    private static final int sideHeaderLength = 3;
    private static final byte[] sideHeader = new byte[]{53, 52, 61};
    private byte[] orderID = new byte[1];
    private int orderIDOffset = 0;
    private int orderIDLength = 0;
    private byte[] execID = new byte[1];
    private int execIDOffset = 0;
    private int execIDLength = 0;
    private char execType;
    private boolean hasExecType;
    private char ordStatus;
    private boolean hasOrdStatus;
    private final InstrumentEncoder instrument = new InstrumentEncoder();
    private char side;
    private boolean hasSide;
    public static int MAX_HEADER_PREFIX_LENGTH = 22;

    public int messageType() {
        return 56;
    }

    public ExecutionReportEncoder() {
        this.header.msgType("8");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public ExecutionReportEncoder orderID(byte[] value, int length) {
        this.orderID = value;
        this.orderIDOffset = 0;
        this.orderIDLength = length;
        return this;
    }

    public ExecutionReportEncoder orderID(byte[] value, int offset, int length) {
        this.orderID = value;
        this.orderIDOffset = offset;
        this.orderIDLength = length;
        return this;
    }

    public ExecutionReportEncoder orderID(byte[] value) {
        return this.orderID(value, value.length);
    }

    public boolean hasOrderID() {
        return this.orderIDLength > 0;
    }

    public byte[] orderID() {
        return this.orderID;
    }

    public ExecutionReportEncoder orderID(CharSequence value) {
        this.orderID = CodecUtil.toBytes((CharSequence)value, (byte[])this.orderID);
        this.orderIDOffset = 0;
        this.orderIDLength = value.length();
        return this;
    }

    public ExecutionReportEncoder orderID(char[] value) {
        return this.orderID(value, value.length);
    }

    public ExecutionReportEncoder orderID(char[] value, int length) {
        this.orderID = CodecUtil.toBytes((char[])value, (byte[])this.orderID, (int)length);
        this.orderIDOffset = 0;
        this.orderIDLength = length;
        return this;
    }

    public ExecutionReportEncoder orderID(char[] value, int offset, int length) {
        this.orderID = CodecUtil.toBytes((char[])value, (byte[])this.orderID, (int)offset, (int)length);
        this.orderIDOffset = 0;
        this.orderIDLength = length;
        return this;
    }

    public ExecutionReportEncoder execID(byte[] value, int length) {
        this.execID = value;
        this.execIDOffset = 0;
        this.execIDLength = length;
        return this;
    }

    public ExecutionReportEncoder execID(byte[] value, int offset, int length) {
        this.execID = value;
        this.execIDOffset = offset;
        this.execIDLength = length;
        return this;
    }

    public ExecutionReportEncoder execID(byte[] value) {
        return this.execID(value, value.length);
    }

    public boolean hasExecID() {
        return this.execIDLength > 0;
    }

    public byte[] execID() {
        return this.execID;
    }

    public ExecutionReportEncoder execID(CharSequence value) {
        this.execID = CodecUtil.toBytes((CharSequence)value, (byte[])this.execID);
        this.execIDOffset = 0;
        this.execIDLength = value.length();
        return this;
    }

    public ExecutionReportEncoder execID(char[] value) {
        return this.execID(value, value.length);
    }

    public ExecutionReportEncoder execID(char[] value, int length) {
        this.execID = CodecUtil.toBytes((char[])value, (byte[])this.execID, (int)length);
        this.execIDOffset = 0;
        this.execIDLength = length;
        return this;
    }

    public ExecutionReportEncoder execID(char[] value, int offset, int length) {
        this.execID = CodecUtil.toBytes((char[])value, (byte[])this.execID, (int)offset, (int)length);
        this.execIDOffset = 0;
        this.execIDLength = length;
        return this;
    }

    public boolean hasExecType() {
        return this.hasExecType;
    }

    public ExecutionReportEncoder execType(char value) {
        this.execType = value;
        this.hasExecType = true;
        return this;
    }

    public char execType() {
        return this.execType;
    }

    public ExecutionReportEncoder execType(ExecType value) {
        return this.execType(value.representation());
    }

    public boolean hasOrdStatus() {
        return this.hasOrdStatus;
    }

    public ExecutionReportEncoder ordStatus(char value) {
        this.ordStatus = value;
        this.hasOrdStatus = true;
        return this;
    }

    public char ordStatus() {
        return this.ordStatus;
    }

    public ExecutionReportEncoder ordStatus(OrdStatus value) {
        return this.ordStatus(value.representation());
    }

    public InstrumentEncoder instrument() {
        return this.instrument;
    }

    public boolean hasSide() {
        return this.hasSide;
    }

    public ExecutionReportEncoder side(char value) {
        this.side = value;
        this.hasSide = true;
        return this;
    }

    public char side() {
        return this.side;
    }

    public ExecutionReportEncoder side(Side value) {
        return this.side(value.representation());
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        int start;
        int position = start = offset + MAX_HEADER_PREFIX_LENGTH;
        position += this.header.encode(buffer, position);
        if (this.orderIDLength > 0) {
            buffer.putBytes(position, orderIDHeader, 0, 3);
            buffer.putBytes(position += 3, this.orderID, this.orderIDOffset, this.orderIDLength);
            buffer.putSeparator(position += this.orderIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: OrderID");
        }
        if (this.execIDLength > 0) {
            buffer.putBytes(position, execIDHeader, 0, 3);
            buffer.putBytes(position += 3, this.execID, this.execIDOffset, this.execIDLength);
            buffer.putSeparator(position += this.execIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: ExecID");
        }
        buffer.putBytes(position, execTypeHeader, 0, 4);
        position += 4;
        position += buffer.putAsciiChar(position, this.execType);
        buffer.putSeparator(position);
        buffer.putBytes(++position, ordStatusHeader, 0, 3);
        position += 3;
        position += buffer.putAsciiChar(position, this.ordStatus);
        buffer.putSeparator(position);
        ++position;
        position += this.instrument.encode(buffer, position);
        buffer.putBytes(position, sideHeader, 0, 3);
        position += 3;
        position += buffer.putAsciiChar(position, this.side);
        buffer.putSeparator(position);
        ++position;
        position += this.trailer.encode(buffer, position, start);
        int realStart = this.trailer.realStart;
        return Encoder.result((int)(position - realStart), (int)realStart);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetOrderID();
        this.resetExecID();
        this.resetExecType();
        this.resetOrdStatus();
        this.resetSide();
        this.instrument.reset();
    }

    public void resetOrderID() {
        this.orderIDLength = 0;
    }

    public void resetExecID() {
        this.execIDLength = 0;
    }

    public void resetExecType() {
        this.execType = '\u0001';
    }

    public void resetOrdStatus() {
        this.ordStatus = '\u0001';
    }

    public void resetSide() {
        this.side = '\u0001';
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasOrderID() ? String.format("  \"OrderID\": \"%s\",\n", new String(this.orderID, this.orderIDOffset, this.orderIDLength, StandardCharsets.US_ASCII)) : "") + (this.hasExecID() ? String.format("  \"ExecID\": \"%s\",\n", new String(this.execID, this.execIDOffset, this.execIDLength, StandardCharsets.US_ASCII)) : "") + String.format("  \"ExecType\": \"%s\",\n", Character.valueOf(this.execType)) + String.format("  \"OrdStatus\": \"%s\",\n", Character.valueOf(this.ordStatus)) + String.format("  \"Instrument\":  %s\n", this.instrument.toString().replace("\n", "\n  ")) + String.format("  \"Side\": \"%s\",\n", Character.valueOf(this.side));
        entries = "{\n  \"MessageName\": \"ExecutionReport\",\n" + entries + "}";
        return entries;
    }
}

