/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.other.builder;

import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.dictionary.Generated;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

@Generated(value={"uk.co.real_logic.artio"})
public class TrailerEncoder {
    private static final int checkSumHeaderLength = 3;
    private static final byte[] checkSumHeader = new byte[]{49, 48, 61};
    private final MutableDirectBuffer checkSum = new UnsafeBuffer();
    private byte[] checkSumInternalBuffer = this.checkSum.byteArray();
    private int checkSumOffset = 0;
    private int checkSumLength = 0;

    public TrailerEncoder checkSum(DirectBuffer value, int offset, int length) {
        this.checkSum.wrap(value);
        this.checkSumOffset = offset;
        this.checkSumLength = length;
        return this;
    }

    public TrailerEncoder checkSum(DirectBuffer value, int length) {
        return this.checkSum(value, 0, length);
    }

    public TrailerEncoder checkSum(DirectBuffer value) {
        return this.checkSum(value, 0, value.capacity());
    }

    public TrailerEncoder checkSum(byte[] value, int offset, int length) {
        this.checkSum.wrap(value);
        this.checkSumOffset = offset;
        this.checkSumLength = length;
        return this;
    }

    public TrailerEncoder checkSumAsCopy(byte[] value, int offset, int length) {
        if (CodecUtil.copyInto((MutableDirectBuffer)this.checkSum, (byte[])value, (int)offset, (int)length)) {
            this.checkSumInternalBuffer = this.checkSum.byteArray();
        }
        this.checkSumOffset = 0;
        this.checkSumLength = length;
        return this;
    }

    public TrailerEncoder checkSum(byte[] value, int length) {
        return this.checkSum(value, 0, length);
    }

    public TrailerEncoder checkSum(byte[] value) {
        return this.checkSum(value, 0, value.length);
    }

    public boolean hasCheckSum() {
        return this.checkSumLength > 0;
    }

    public MutableDirectBuffer checkSum() {
        return this.checkSum;
    }

    public String checkSumAsString() {
        return this.checkSum.getStringWithoutLengthAscii(this.checkSumOffset, this.checkSumLength);
    }

    public TrailerEncoder checkSum(CharSequence value) {
        if (CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.checkSum)) {
            this.checkSumInternalBuffer = this.checkSum.byteArray();
        }
        this.checkSumOffset = 0;
        this.checkSumLength = value.length();
        return this;
    }

    public TrailerEncoder checkSum(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.checkSum.wrap(buffer);
            this.checkSumOffset = value.offset();
            this.checkSumLength = value.length();
        }
        return this;
    }

    public TrailerEncoder checkSum(char[] value) {
        return this.checkSum(value, 0, value.length);
    }

    public TrailerEncoder checkSum(char[] value, int length) {
        return this.checkSum(value, 0, length);
    }

    public TrailerEncoder checkSum(char[] value, int offset, int length) {
        if (CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.checkSum, (int)offset, (int)length)) {
            this.checkSumInternalBuffer = this.checkSum.byteArray();
        }
        this.checkSumOffset = 0;
        this.checkSumLength = length;
        return this;
    }

    long finishMessage(MutableAsciiBuffer buffer, int messageStart, int offset) {
        int position = offset;
        int checkSum = buffer.computeChecksum(messageStart, position);
        buffer.putBytes(position, checkSumHeader, 0, 3);
        buffer.putNaturalPaddedIntAscii(position += 3, 3, checkSum);
        buffer.putSeparator(position += 3);
        return Encoder.result((int)(++position - messageStart), (int)messageStart);
    }

    int startTrailer(MutableAsciiBuffer buffer, int offset) {
        int start;
        int position = start = offset;
        return position - start;
    }

    public void reset() {
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendTo(builder, 1);
    }

    public StringBuilder appendTo(StringBuilder builder, int level) {
        builder.append("{\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"MessageName\": \"Trailer\",\n");
        if (this.hasCheckSum()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"CheckSum\": \"");
            CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.checkSum, (int)this.checkSumOffset, (int)this.checkSumLength);
            builder.append("\",\n");
        }
        CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
        builder.append("}");
        return builder;
    }

    public TrailerEncoder copyTo(Encoder encoder) {
        return this.copyTo((TrailerEncoder)encoder);
    }

    public TrailerEncoder copyTo(TrailerEncoder encoder) {
        encoder.reset();
        if (this.hasCheckSum()) {
            encoder.checkSumAsCopy(this.checkSum.byteArray(), 0, this.checkSumLength);
        }
        return encoder;
    }
}

