/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.other.builder;

import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.builder.AbstractSequenceResetEncoder;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.Generated;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.other.builder.HeaderEncoder;
import uk.co.real_logic.artio.other.builder.TrailerEncoder;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

@Generated(value={"uk.co.real_logic.artio"})
public class SequenceResetEncoder
implements AbstractSequenceResetEncoder {
    private final TrailerEncoder trailer = new TrailerEncoder();
    private final HeaderEncoder header = new HeaderEncoder();
    private static final int gapFillFlagHeaderLength = 4;
    private static final byte[] gapFillFlagHeader = new byte[]{49, 50, 51, 61};
    private static final int newSeqNoHeaderLength = 3;
    private static final byte[] newSeqNoHeader = new byte[]{51, 54, 61};
    private boolean gapFillFlag;
    private boolean hasGapFillFlag;
    private int newSeqNo;
    private boolean hasNewSeqNo;

    public long messageType() {
        return 52L;
    }

    public SequenceResetEncoder() {
        this.header.msgType("4");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public boolean hasGapFillFlag() {
        return this.hasGapFillFlag;
    }

    public SequenceResetEncoder gapFillFlag(boolean value) {
        this.gapFillFlag = value;
        this.hasGapFillFlag = true;
        return this;
    }

    public boolean gapFillFlag() {
        return this.gapFillFlag;
    }

    public boolean hasNewSeqNo() {
        return this.hasNewSeqNo;
    }

    public SequenceResetEncoder newSeqNo(int value) {
        this.newSeqNo = value;
        this.hasNewSeqNo = true;
        return this;
    }

    public int newSeqNo() {
        return this.newSeqNo;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.hasGapFillFlag) {
            buffer.putBytes(position, gapFillFlagHeader, 0, 4);
            position += 4;
            position += buffer.putBooleanAscii(position, this.gapFillFlag);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasNewSeqNo) {
            buffer.putBytes(position, newSeqNoHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.newSeqNo);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: NewSeqNo");
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetGapFillFlag();
        this.resetNewSeqNo();
    }

    public void resetGapFillFlag() {
        this.hasGapFillFlag = false;
    }

    public void resetNewSeqNo() {
        this.hasNewSeqNo = false;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendTo(builder, 1);
    }

    public StringBuilder appendTo(StringBuilder builder, int level) {
        builder.append("{\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"MessageName\": \"SequenceReset\",\n");
        builder.append("  \"header\": ");
        this.header.appendTo(builder, level + 1);
        builder.append("\n");
        if (this.hasGapFillFlag()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"GapFillFlag\": \"");
            builder.append(this.gapFillFlag);
            builder.append("\",\n");
        }
        if (this.hasNewSeqNo()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"NewSeqNo\": \"");
            builder.append(this.newSeqNo);
            builder.append("\",\n");
        }
        CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
        builder.append("}");
        return builder;
    }

    public SequenceResetEncoder copyTo(Encoder encoder) {
        return this.copyTo((SequenceResetEncoder)encoder);
    }

    public SequenceResetEncoder copyTo(SequenceResetEncoder encoder) {
        encoder.reset();
        if (this.hasGapFillFlag()) {
            encoder.gapFillFlag(this.gapFillFlag());
        }
        if (this.hasNewSeqNo()) {
            encoder.newSeqNo(this.newSeqNo());
        }
        return encoder;
    }
}

