/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.other.builder;

import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.builder.AbstractLogonEncoder;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.other.EncryptMethod;
import uk.co.real_logic.artio.other.builder.HeaderEncoder;
import uk.co.real_logic.artio.other.builder.TrailerEncoder;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class LogonEncoder
implements AbstractLogonEncoder {
    private final TrailerEncoder trailer = new TrailerEncoder();
    private final HeaderEncoder header = new HeaderEncoder();
    private static final int encryptMethodHeaderLength = 3;
    private static final byte[] encryptMethodHeader = new byte[]{57, 56, 61};
    private static final int heartBtIntHeaderLength = 4;
    private static final byte[] heartBtIntHeader = new byte[]{49, 48, 56, 61};
    private static final int rawDataLengthHeaderLength = 3;
    private static final byte[] rawDataLengthHeader = new byte[]{57, 53, 61};
    private static final int rawDataHeaderLength = 3;
    private static final byte[] rawDataHeader = new byte[]{57, 54, 61};
    private static final int resetSeqNumFlagHeaderLength = 4;
    private static final byte[] resetSeqNumFlagHeader = new byte[]{49, 52, 49, 61};
    private static final int nextExpectedMsgSeqNumHeaderLength = 4;
    private static final byte[] nextExpectedMsgSeqNumHeader = new byte[]{55, 56, 57, 61};
    private static final int maxMessageSizeHeaderLength = 4;
    private static final byte[] maxMessageSizeHeader = new byte[]{51, 56, 51, 61};
    private static final int testMessageIndicatorHeaderLength = 4;
    private static final byte[] testMessageIndicatorHeader = new byte[]{52, 54, 52, 61};
    private static final int usernameHeaderLength = 4;
    private static final byte[] usernameHeader = new byte[]{53, 53, 51, 61};
    private static final int passwordHeaderLength = 4;
    private static final byte[] passwordHeader = new byte[]{53, 53, 52, 61};
    private int encryptMethod;
    private boolean hasEncryptMethod;
    private int heartBtInt;
    private boolean hasHeartBtInt;
    private int rawDataLength;
    private boolean hasRawDataLength;
    private byte[] rawData;
    private boolean hasRawData;
    private boolean resetSeqNumFlag;
    private boolean hasResetSeqNumFlag;
    private int nextExpectedMsgSeqNum;
    private boolean hasNextExpectedMsgSeqNum;
    private int maxMessageSize;
    private boolean hasMaxMessageSize;
    private boolean testMessageIndicator;
    private boolean hasTestMessageIndicator;
    private final MutableDirectBuffer username = new UnsafeBuffer();
    private int usernameOffset = 0;
    private int usernameLength = 0;
    private final MutableDirectBuffer password = new UnsafeBuffer();
    private int passwordOffset = 0;
    private int passwordLength = 0;

    public long messageType() {
        return 65L;
    }

    public LogonEncoder() {
        this.header.msgType("A");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public boolean hasEncryptMethod() {
        return this.hasEncryptMethod;
    }

    public LogonEncoder encryptMethod(int value) {
        this.encryptMethod = value;
        this.hasEncryptMethod = true;
        return this;
    }

    public int encryptMethod() {
        return this.encryptMethod;
    }

    public LogonEncoder encryptMethod(EncryptMethod value) {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            if (value == EncryptMethod.ARTIO_UNKNOWN) {
                throw new EncodingException("Invalid Value Field: encryptMethod Value: " + (Object)((Object)value));
            }
            if (value == EncryptMethod.NULL_VAL) {
                return this;
            }
        }
        return this.encryptMethod(value.representation());
    }

    public boolean hasHeartBtInt() {
        return this.hasHeartBtInt;
    }

    public LogonEncoder heartBtInt(int value) {
        this.heartBtInt = value;
        this.hasHeartBtInt = true;
        return this;
    }

    public int heartBtInt() {
        return this.heartBtInt;
    }

    public boolean hasRawDataLength() {
        return this.hasRawDataLength;
    }

    public LogonEncoder rawDataLength(int value) {
        this.rawDataLength = value;
        this.hasRawDataLength = true;
        return this;
    }

    public int rawDataLength() {
        return this.rawDataLength;
    }

    public boolean hasRawData() {
        return this.hasRawData;
    }

    public LogonEncoder rawData(byte[] value) {
        this.rawData = value;
        this.hasRawData = true;
        return this;
    }

    public byte[] rawData() {
        return this.rawData;
    }

    public LogonEncoder rawDataAsCopy(byte[] value, int offset, int length) {
        this.rawData = CodecUtil.copyInto((byte[])this.rawData, (byte[])value, (int)offset, (int)length);
        this.hasRawData = true;
        return this;
    }

    public boolean hasResetSeqNumFlag() {
        return this.hasResetSeqNumFlag;
    }

    public LogonEncoder resetSeqNumFlag(boolean value) {
        this.resetSeqNumFlag = value;
        this.hasResetSeqNumFlag = true;
        return this;
    }

    public boolean resetSeqNumFlag() {
        return this.resetSeqNumFlag;
    }

    public boolean hasNextExpectedMsgSeqNum() {
        return this.hasNextExpectedMsgSeqNum;
    }

    public LogonEncoder nextExpectedMsgSeqNum(int value) {
        this.nextExpectedMsgSeqNum = value;
        this.hasNextExpectedMsgSeqNum = true;
        return this;
    }

    public int nextExpectedMsgSeqNum() {
        return this.nextExpectedMsgSeqNum;
    }

    public boolean hasMaxMessageSize() {
        return this.hasMaxMessageSize;
    }

    public LogonEncoder maxMessageSize(int value) {
        this.maxMessageSize = value;
        this.hasMaxMessageSize = true;
        return this;
    }

    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    public boolean hasTestMessageIndicator() {
        return this.hasTestMessageIndicator;
    }

    public LogonEncoder testMessageIndicator(boolean value) {
        this.testMessageIndicator = value;
        this.hasTestMessageIndicator = true;
        return this;
    }

    public boolean testMessageIndicator() {
        return this.testMessageIndicator;
    }

    public LogonEncoder username(DirectBuffer value, int offset, int length) {
        this.username.wrap(value);
        this.usernameOffset = offset;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder username(DirectBuffer value, int length) {
        return this.username(value, 0, length);
    }

    public LogonEncoder username(DirectBuffer value) {
        return this.username(value, 0, value.capacity());
    }

    public LogonEncoder username(byte[] value, int offset, int length) {
        this.username.wrap(value);
        this.usernameOffset = offset;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder usernameAsCopy(byte[] value, int offset, int length) {
        CodecUtil.copyInto((MutableDirectBuffer)this.username, (byte[])value, (int)offset, (int)length);
        this.usernameOffset = offset;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder username(byte[] value, int length) {
        return this.username(value, 0, length);
    }

    public LogonEncoder username(byte[] value) {
        return this.username(value, 0, value.length);
    }

    public boolean hasUsername() {
        return this.usernameLength > 0;
    }

    public MutableDirectBuffer username() {
        return this.username;
    }

    public String usernameAsString() {
        return this.username.getStringWithoutLengthAscii(this.usernameOffset, this.usernameLength);
    }

    public LogonEncoder username(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.username);
        this.usernameOffset = 0;
        this.usernameLength = value.length();
        return this;
    }

    public LogonEncoder username(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.username.wrap(buffer);
            this.usernameOffset = value.offset();
            this.usernameLength = value.length();
        }
        return this;
    }

    public LogonEncoder username(char[] value) {
        return this.username(value, 0, value.length);
    }

    public LogonEncoder username(char[] value, int length) {
        return this.username(value, 0, length);
    }

    public LogonEncoder username(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.username, (int)offset, (int)length);
        this.usernameOffset = 0;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder password(DirectBuffer value, int offset, int length) {
        this.password.wrap(value);
        this.passwordOffset = offset;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder password(DirectBuffer value, int length) {
        return this.password(value, 0, length);
    }

    public LogonEncoder password(DirectBuffer value) {
        return this.password(value, 0, value.capacity());
    }

    public LogonEncoder password(byte[] value, int offset, int length) {
        this.password.wrap(value);
        this.passwordOffset = offset;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder passwordAsCopy(byte[] value, int offset, int length) {
        CodecUtil.copyInto((MutableDirectBuffer)this.password, (byte[])value, (int)offset, (int)length);
        this.passwordOffset = offset;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder password(byte[] value, int length) {
        return this.password(value, 0, length);
    }

    public LogonEncoder password(byte[] value) {
        return this.password(value, 0, value.length);
    }

    public boolean hasPassword() {
        return this.passwordLength > 0;
    }

    public MutableDirectBuffer password() {
        return this.password;
    }

    public String passwordAsString() {
        return this.password.getStringWithoutLengthAscii(this.passwordOffset, this.passwordLength);
    }

    public LogonEncoder password(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.password);
        this.passwordOffset = 0;
        this.passwordLength = value.length();
        return this;
    }

    public LogonEncoder password(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.password.wrap(buffer);
            this.passwordOffset = value.offset();
            this.passwordLength = value.length();
        }
        return this;
    }

    public LogonEncoder password(char[] value) {
        return this.password(value, 0, value.length);
    }

    public LogonEncoder password(char[] value, int length) {
        return this.password(value, 0, length);
    }

    public LogonEncoder password(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.password, (int)offset, (int)length);
        this.passwordOffset = 0;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder cancelOnDisconnectType(int value) {
        throw new UnsupportedOperationException();
    }

    public LogonEncoder cODTimeoutWindow(int value) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsUsername() {
        return true;
    }

    public boolean supportsPassword() {
        return true;
    }

    public boolean supportsCancelOnDisconnectType() {
        return false;
    }

    public boolean supportsCODTimeoutWindow() {
        return false;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.hasEncryptMethod) {
            buffer.putBytes(position, encryptMethodHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.encryptMethod);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: EncryptMethod");
        }
        if (this.hasHeartBtInt) {
            buffer.putBytes(position, heartBtIntHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.heartBtInt);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: HeartBtInt");
        }
        if (this.hasRawDataLength) {
            buffer.putBytes(position, rawDataLengthHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.rawDataLength);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasRawData) {
            buffer.putBytes(position, rawDataHeader, 0, 3);
            buffer.putBytes(position += 3, this.rawData);
            buffer.putSeparator(position += this.rawData.length);
            ++position;
        }
        if (this.hasResetSeqNumFlag) {
            buffer.putBytes(position, resetSeqNumFlagHeader, 0, 4);
            position += 4;
            position += buffer.putBooleanAscii(position, this.resetSeqNumFlag);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasNextExpectedMsgSeqNum) {
            buffer.putBytes(position, nextExpectedMsgSeqNumHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.nextExpectedMsgSeqNum);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasMaxMessageSize) {
            buffer.putBytes(position, maxMessageSizeHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.maxMessageSize);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasTestMessageIndicator) {
            buffer.putBytes(position, testMessageIndicatorHeader, 0, 4);
            position += 4;
            position += buffer.putBooleanAscii(position, this.testMessageIndicator);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.usernameLength > 0) {
            buffer.putBytes(position, usernameHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.username, this.usernameOffset, this.usernameLength);
            buffer.putSeparator(position += this.usernameLength);
            ++position;
        }
        if (this.passwordLength > 0) {
            buffer.putBytes(position, passwordHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.password, this.passwordOffset, this.passwordLength);
            buffer.putSeparator(position += this.passwordLength);
            ++position;
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetEncryptMethod();
        this.resetHeartBtInt();
        this.resetRawDataLength();
        this.resetRawData();
        this.resetResetSeqNumFlag();
        this.resetNextExpectedMsgSeqNum();
        this.resetMaxMessageSize();
        this.resetTestMessageIndicator();
        this.resetUsername();
        this.resetPassword();
    }

    public void resetEncryptMethod() {
        this.hasEncryptMethod = false;
    }

    public void resetHeartBtInt() {
        this.hasHeartBtInt = false;
    }

    public void resetRawDataLength() {
        this.hasRawDataLength = false;
    }

    public void resetRawData() {
        this.hasRawData = false;
    }

    public void resetResetSeqNumFlag() {
        this.hasResetSeqNumFlag = false;
    }

    public void resetNextExpectedMsgSeqNum() {
        this.hasNextExpectedMsgSeqNum = false;
    }

    public void resetMaxMessageSize() {
        this.hasMaxMessageSize = false;
    }

    public void resetTestMessageIndicator() {
        this.hasTestMessageIndicator = false;
    }

    public void resetUsername() {
        this.usernameLength = 0;
    }

    public void resetPassword() {
        this.passwordLength = 0;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendTo(builder, 1);
    }

    public StringBuilder appendTo(StringBuilder builder, int level) {
        builder.append("{\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"MessageName\": \"Logon\",\n");
        builder.append("  \"header\": ");
        this.header.appendTo(builder, level + 1);
        builder.append("\n");
        if (this.hasEncryptMethod()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"EncryptMethod\": \"");
            builder.append(this.encryptMethod);
            builder.append("\",\n");
        }
        if (this.hasHeartBtInt()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"HeartBtInt\": \"");
            builder.append(this.heartBtInt);
            builder.append("\",\n");
        }
        if (this.hasRawDataLength()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"RawDataLength\": \"");
            builder.append(this.rawDataLength);
            builder.append("\",\n");
        }
        if (this.hasRawData()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"RawData\": \"");
            CodecUtil.appendData((StringBuilder)builder, (byte[])this.rawData, (int)this.rawDataLength);
            builder.append("\",\n");
        }
        if (this.hasResetSeqNumFlag()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"ResetSeqNumFlag\": \"");
            builder.append(this.resetSeqNumFlag);
            builder.append("\",\n");
        }
        if (this.hasNextExpectedMsgSeqNum()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"NextExpectedMsgSeqNum\": \"");
            builder.append(this.nextExpectedMsgSeqNum);
            builder.append("\",\n");
        }
        if (this.hasMaxMessageSize()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"MaxMessageSize\": \"");
            builder.append(this.maxMessageSize);
            builder.append("\",\n");
        }
        if (this.hasTestMessageIndicator()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"TestMessageIndicator\": \"");
            builder.append(this.testMessageIndicator);
            builder.append("\",\n");
        }
        if (this.hasUsername()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"Username\": \"");
            CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.username, (int)this.usernameOffset, (int)this.usernameLength);
            builder.append("\",\n");
        }
        if (this.hasPassword()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"Password\": \"");
            CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.password, (int)this.passwordOffset, (int)this.passwordLength);
            builder.append("\",\n");
        }
        CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
        builder.append("}");
        return builder;
    }

    public LogonEncoder copyTo(Encoder encoder) {
        return this.copyTo((LogonEncoder)encoder);
    }

    public LogonEncoder copyTo(LogonEncoder encoder) {
        encoder.reset();
        if (this.hasEncryptMethod()) {
            encoder.encryptMethod(this.encryptMethod());
        }
        if (this.hasHeartBtInt()) {
            encoder.heartBtInt(this.heartBtInt());
        }
        if (this.hasRawDataLength()) {
            encoder.rawDataLength(this.rawDataLength());
        }
        if (this.hasRawData()) {
            encoder.rawDataAsCopy(this.rawData(), 0, this.rawDataLength());
            encoder.rawDataLength(this.rawDataLength());
        }
        if (this.hasResetSeqNumFlag()) {
            encoder.resetSeqNumFlag(this.resetSeqNumFlag());
        }
        if (this.hasNextExpectedMsgSeqNum()) {
            encoder.nextExpectedMsgSeqNum(this.nextExpectedMsgSeqNum());
        }
        if (this.hasMaxMessageSize()) {
            encoder.maxMessageSize(this.maxMessageSize());
        }
        if (this.hasTestMessageIndicator()) {
            encoder.testMessageIndicator(this.testMessageIndicator());
        }
        if (this.hasUsername()) {
            encoder.usernameAsCopy(this.username.byteArray(), 0, this.usernameLength);
        }
        if (this.hasPassword()) {
            encoder.passwordAsCopy(this.password.byteArray(), 0, this.passwordLength);
        }
        return encoder;
    }
}

