/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.client;

import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveThreadingMode;
import io.aeron.archive.ArchivingMediaDriver;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import java.io.File;
import java.util.Collections;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SleepingIdleStrategy;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.SampleUtil;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.TestRequestEncoder;
import uk.co.real_logic.artio.client.TestReqIdFinder;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.LibraryUtil;
import uk.co.real_logic.artio.library.SessionConfiguration;
import uk.co.real_logic.artio.library.SessionHandler;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.server.SampleServer;
import uk.co.real_logic.artio.session.Session;

public final class SampleClient {
    private static final TestReqIdFinder TEST_REQ_ID_FINDER = new TestReqIdFinder();
    private static final String AERON_DIR_NAME = "client-aeron";
    private static final String ARCHIVE_DIR_NAME = "client-aeron-archive";
    private static final String CONTROL_REQUEST_CHANNEL = "aeron:udp?endpoint=localhost:7010";
    private static final String CONTROL_RESPONSE_CHANNEL = "aeron:udp?endpoint=localhost:7020";
    private static final String RECORDING_EVENTS_CHANNEL = "aeron:udp?control-mode=dynamic|control=localhost:7030";
    private static final String REPLICATION_CHANNEL = "aeron:udp?endpoint=localhost:0";

    public static void main(String[] args) {
        String aeronChannel = "aeron:udp?endpoint=localhost:10002";
        EngineConfiguration configuration = new EngineConfiguration().libraryAeronChannel("aeron:udp?endpoint=localhost:10002").monitoringFile(CommonConfiguration.optimalTmpDirName() + File.separator + "fix-client" + File.separator + "engineCounters").logFileDir("client-logs");
        configuration.aeronArchiveContext().aeronDirectoryName(AERON_DIR_NAME).controlRequestChannel(CONTROL_REQUEST_CHANNEL).controlResponseChannel(CONTROL_RESPONSE_CHANNEL);
        configuration.aeronContext().aeronDirectoryName(AERON_DIR_NAME);
        SampleServer.cleanupOldLogFileDir(configuration);
        MediaDriver.Context context = new MediaDriver.Context().threadingMode(ThreadingMode.SHARED).dirDeleteOnStart(true).aeronDirectoryName(AERON_DIR_NAME);
        Archive.Context archiveContext = new Archive.Context().threadingMode(ArchiveThreadingMode.SHARED).deleteArchiveOnStart(true).aeronDirectoryName(AERON_DIR_NAME).archiveDirectoryName(ARCHIVE_DIR_NAME);
        archiveContext.controlChannel(CONTROL_REQUEST_CHANNEL).replicationChannel(REPLICATION_CHANNEL).recordingEventsChannel(RECORDING_EVENTS_CHANNEL);
        try (ArchivingMediaDriver driver = ArchivingMediaDriver.launch((MediaDriver.Context)context, (Archive.Context)archiveContext);
             FixEngine ignore = FixEngine.launch((EngineConfiguration)configuration);){
            SessionConfiguration sessionConfig = SessionConfiguration.builder().address("localhost", 9999).targetCompId("acceptor").senderCompId("initiator").build();
            SleepingIdleStrategy idleStrategy = new SleepingIdleStrategy(100L);
            LibraryConfiguration libraryConfiguration = new LibraryConfiguration().sessionAcquireHandler((session, acquiredInfo) -> SampleClient.onConnect(session)).libraryAeronChannels(Collections.singletonList("aeron:udp?endpoint=localhost:10002"));
            libraryConfiguration.aeronContext().aeronDirectoryName(AERON_DIR_NAME);
            try (FixLibrary library = SampleUtil.blockingConnect(libraryConfiguration);){
                Session session2 = LibraryUtil.initiate((FixLibrary)library, (SessionConfiguration)sessionConfig, (int)10000, (IdleStrategy)idleStrategy);
                while (!session2.isActive()) {
                    idleStrategy.idle(library.poll(1));
                }
                TestRequestEncoder testRequest = new TestRequestEncoder();
                testRequest.testReqID((CharSequence)"Hello World");
                session2.trySend((Encoder)testRequest);
                while (!"Hello World".equals(TEST_REQ_ID_FINDER.testReqId())) {
                    idleStrategy.idle(library.poll(1));
                }
                System.out.println("Success, received reply!");
                System.out.println(TEST_REQ_ID_FINDER.testReqId());
                session2.startLogout();
                session2.requestDisconnect();
                while (session2.state() != SessionState.DISCONNECTED) {
                    idleStrategy.idle(library.poll(1));
                }
                System.out.println("Disconnected");
            }
        }
        System.exit(0);
    }

    private static SessionHandler onConnect(Session session) {
        return TEST_REQ_ID_FINDER;
    }
}

