/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.timing;

import org.HdrHistogram.Histogram;
import org.HdrHistogram.SingleWriterRecorder;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.CommonConfiguration;

public class Timer {
    private static final int NUMBER_OF_SIGNIFICANT_VALUE_DIGITS = 3;
    private final SingleWriterRecorder recorder = new SingleWriterRecorder(3);
    private final AtomicCounter negativeTimestamps;
    private final EpochNanoClock clock;
    private final int id;
    private final String name;
    private Histogram histogram;

    public Timer(EpochNanoClock clock, String name, int id, AtomicCounter negativeTimestamps) {
        this.clock = clock;
        this.name = name;
        this.id = id;
        this.negativeTimestamps = negativeTimestamps;
    }

    public long recordSince(long timestamp) {
        if (CommonConfiguration.TIME_MESSAGES) {
            long time = this.clock.nanoTime();
            long duration = time - timestamp;
            this.recordValue(duration);
            return time;
        }
        return 0L;
    }

    void recordValue(long duration) {
        if (duration > 0L) {
            this.recorder.recordValue(duration);
        } else {
            this.negativeTimestamps.increment();
        }
    }

    int id() {
        return this.id;
    }

    String name() {
        return this.name;
    }

    Histogram getTimings() {
        this.histogram = this.recorder.getIntervalHistogram(this.histogram);
        return this.histogram;
    }
}

