/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.library.LibraryPoller;
import uk.co.real_logic.artio.library.LibraryReply;
import uk.co.real_logic.artio.library.MetadataHandler;
import uk.co.real_logic.artio.messages.MetaDataStatus;

class ReadMetaDataReply
extends LibraryReply<MetaDataStatus> {
    private final long sessionId;
    private final MetadataHandler handler;

    ReadMetaDataReply(LibraryPoller libraryPoller, long latestReplyArrivalTime, long sessionId, MetadataHandler handler) {
        super(libraryPoller, latestReplyArrivalTime);
        this.sessionId = sessionId;
        this.handler = handler;
        if (libraryPoller.isConnected()) {
            this.sendMessage();
        }
    }

    @Override
    protected void sendMessage() {
        long position = this.libraryPoller.saveReadMetaData(this.sessionId, this.correlationId);
        this.requiresResend = position < 0L;
    }

    void onComplete(MetaDataStatus status, DirectBuffer srcBuffer, int srcOffset, int srcLength) {
        super.onComplete(status);
        this.handler.onMetaData(this.sessionId, status, srcBuffer, srcOffset, srcLength);
    }
}

