/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.Header;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.ChecksumFramer;
import uk.co.real_logic.artio.engine.MappedFile;
import uk.co.real_logic.artio.engine.SequenceNumberExtractor;
import uk.co.real_logic.artio.engine.framer.FramerContext;
import uk.co.real_logic.artio.engine.framer.WriteMetaDataResponse;
import uk.co.real_logic.artio.engine.logger.ILinkSequenceNumberExtractor;
import uk.co.real_logic.artio.engine.logger.Index;
import uk.co.real_logic.artio.engine.logger.IndexedPositionConsumer;
import uk.co.real_logic.artio.engine.logger.IndexedPositionReader;
import uk.co.real_logic.artio.engine.logger.IndexedPositionWriter;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;
import uk.co.real_logic.artio.engine.logger.RecordingIdLookup;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexDescriptor;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.MetaDataStatus;
import uk.co.real_logic.artio.messages.RedactSequenceUpdateDecoder;
import uk.co.real_logic.artio.messages.ResetSequenceNumberDecoder;
import uk.co.real_logic.artio.messages.WriteMetaDataDecoder;
import uk.co.real_logic.artio.storage.messages.LastKnownSequenceNumberDecoder;
import uk.co.real_logic.artio.storage.messages.LastKnownSequenceNumberEncoder;

public class SequenceNumberIndexWriter
implements Index {
    private static final long MISSING_RECORD = -1L;
    private static final long UNINITIALISED = -1L;
    public static final long NO_REQUIRED_POSITION = -1000L;
    static final int SEQUENCE_NUMBER_OFFSET = LastKnownSequenceNumberEncoder.sequenceNumberEncodingOffset();
    static final int MESSAGE_POSITION_OFFSET = LastKnownSequenceNumberEncoder.messagePositionEncodingOffset();
    static final int META_DATA_OFFSET = LastKnownSequenceNumberEncoder.metaDataPositionEncodingOffset();
    public static final int RESET_SEQUENCE = 0;
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final FixMessageDecoder messageFrame = new FixMessageDecoder();
    private final ResetSequenceNumberDecoder resetSequenceNumber = new ResetSequenceNumberDecoder();
    private final WriteMetaDataDecoder writeMetaData = new WriteMetaDataDecoder();
    private final RedactSequenceUpdateDecoder redactSequenceUpdate = new RedactSequenceUpdateDecoder();
    private final MessageHeaderDecoder fileHeaderDecoder = new MessageHeaderDecoder();
    private final MessageHeaderEncoder fileHeaderEncoder = new MessageHeaderEncoder();
    private final LastKnownSequenceNumberEncoder lastKnownEncoder = new LastKnownSequenceNumberEncoder();
    private final LastKnownSequenceNumberDecoder lastKnownDecoder = new LastKnownSequenceNumberDecoder();
    private final Long2LongHashMap recordOffsets = new Long2LongHashMap(-1L);
    private final File metaDataLocation;
    private final List<WriteMetaDataResponse> responsesToResend = new ArrayList<WriteMetaDataResponse>();
    private final Predicate<WriteMetaDataResponse> sendResponseFunc = this::sendResponse;
    private final RandomAccessFile metaDataFile;
    private byte[] metaDataWriteBuffer = new byte[0];
    private final SequenceNumberExtractor sequenceNumberExtractor;
    private FramerContext framerContext;
    private final ChecksumFramer checksumFramer;
    private final AtomicBuffer inMemoryBuffer;
    private final ErrorHandler errorHandler;
    private final Path indexPath;
    private final Path writablePath;
    private final Path passingPlacePath;
    private final int fileCapacity;
    private final int streamId;
    private final int indexedPositionsOffset;
    private final IndexedPositionWriter positionWriter;
    private final ILinkSequenceNumberExtractor iLinkSequenceNumberExtractor;
    private MappedFile writableFile;
    private MappedFile indexFile;
    private long nextRollPosition = -1L;
    private final EpochClock clock;
    private final long indexFileStateFlushTimeoutInMs;
    private long lastUpdatedFileTimeInMs;
    private boolean hasSavedRecordSinceFileUpdate = false;

    public SequenceNumberIndexWriter(AtomicBuffer inMemoryBuffer, MappedFile indexFile, ErrorHandler errorHandler, int streamId, RecordingIdLookup recordingIdLookup, long indexFileStateFlushTimeoutInMs, EpochClock clock, String metaDataDir, Long2LongHashMap connectionIdToILinkUuid) {
        this.inMemoryBuffer = inMemoryBuffer;
        this.indexFile = indexFile;
        this.errorHandler = errorHandler;
        this.streamId = streamId;
        this.fileCapacity = indexFile.buffer().capacity();
        this.indexFileStateFlushTimeoutInMs = indexFileStateFlushTimeoutInMs;
        this.clock = clock;
        this.iLinkSequenceNumberExtractor = new ILinkSequenceNumberExtractor(connectionIdToILinkUuid, errorHandler, (seqNum, uuid, messageSize, endPosition, aeronSessionId, possRetrans) -> this.saveRecord(seqNum, uuid, endPosition, -1000L, possRetrans));
        String indexFilePath = indexFile.file().getAbsolutePath();
        this.indexPath = indexFile.file().toPath();
        File writeableFile = SequenceNumberIndexDescriptor.writableFile(indexFilePath);
        this.writablePath = writeableFile.toPath();
        this.passingPlacePath = SequenceNumberIndexDescriptor.passingFile(indexFilePath).toPath();
        this.writableFile = MappedFile.map(writeableFile, this.fileCapacity);
        this.sequenceNumberExtractor = new SequenceNumberExtractor(errorHandler);
        this.indexedPositionsOffset = SequenceNumberIndexDescriptor.positionTableOffset(this.fileCapacity);
        this.checksumFramer = new ChecksumFramer(inMemoryBuffer, this.indexedPositionsOffset, errorHandler, 0, "SequenceNumberIndex");
        try {
            this.initialiseBuffer();
            this.positionWriter = new IndexedPositionWriter(SequenceNumberIndexDescriptor.positionsBuffer(inMemoryBuffer, this.indexedPositionsOffset), errorHandler, this.indexedPositionsOffset, "SequenceNumberIndex", recordingIdLookup);
            if (metaDataDir != null) {
                this.metaDataLocation = SequenceNumberIndexDescriptor.metaDataFile(metaDataDir);
                this.metaDataFile = this.openMetaDataFile(this.metaDataLocation);
            } else {
                this.metaDataLocation = null;
                this.metaDataFile = null;
            }
        }
        catch (Exception e) {
            CloseHelper.close((AutoCloseable)this.writableFile);
            indexFile.close();
            throw e;
        }
    }

    private RandomAccessFile openMetaDataFile(File metaDataLocation) {
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(metaDataLocation, "rw");
            if (file.length() == 0L) {
                this.writeMetaDataFileHeader(file);
            } else {
                long magicNumber = file.readLong();
                int fileVersion = file.readInt();
                if (magicNumber != 48879L) {
                    throw new IllegalStateException("Invalid magic number in metadata file: " + magicNumber);
                }
                if (fileVersion < 1) {
                    throw new IllegalStateException("Unreadable metadata file version: " + fileVersion);
                }
            }
            return file;
        }
        catch (IOException | IllegalStateException e) {
            if (file != null) {
                Exceptions.suppressingClose((AutoCloseable)file, (Exception)e);
            }
            LangUtil.rethrowUnchecked((Throwable)e);
            return null;
        }
    }

    private void writeMetaDataFileHeader(RandomAccessFile file) throws IOException {
        file.writeLong(48879L);
        file.writeInt(1);
        file.getFD().sync();
    }

    @Override
    public void onCatchup(DirectBuffer buffer, int offset, int length, Header header, long recordingId) {
        this.onFragment(buffer, offset, length, header, recordingId);
    }

    public void onFragment(DirectBuffer buffer, int srcOffset, int length, Header header) {
        int streamId = header.streamId();
        if (streamId == this.streamId) {
            this.onFragment(buffer, srcOffset, length, header, -1L);
        }
    }

    private void onFragment(DirectBuffer buffer, int srcOffset, int length, Header header, long recordingId) {
        long endPosition = header.position();
        int aeronSessionId = header.sessionId();
        int offset = srcOffset;
        this.messageHeader.wrap(buffer, offset);
        offset += this.messageHeader.encodedLength();
        int actingBlockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        int templateId = this.messageHeader.templateId();
        if ((header.flags() & 0x80) == 128) {
            switch (templateId) {
                case 1: {
                    if (this.onFixMessage(buffer, offset, actingBlockLength, version, endPosition)) break;
                    return;
                }
                case 36: {
                    this.resetSequenceNumbers();
                    break;
                }
                case 42: {
                    this.resetSequenceNumber.wrap(buffer, offset, actingBlockLength, version);
                    this.resetSequenceNumber(this.resetSequenceNumber.session(), endPosition);
                    break;
                }
                case 37: {
                    this.writeMetaData.wrap(buffer, offset, actingBlockLength, version);
                    this.onWriteMetaData();
                    break;
                }
                case 55: {
                    this.redactSequenceUpdate.wrap(buffer, offset, actingBlockLength, version);
                    this.onRedactSequenceUpdate();
                    break;
                }
                default: {
                    this.iLinkSequenceNumberExtractor.onFragment(buffer, srcOffset, length, header);
                }
            }
        }
        this.checkTermRoll(buffer, srcOffset, endPosition, length);
        this.positionWriter.update(aeronSessionId, templateId, endPosition, recordingId);
    }

    private void onRedactSequenceUpdate() {
        this.saveRecord(this.redactSequenceUpdate.correctSequenceNumber(), this.redactSequenceUpdate.session(), this.redactSequenceUpdate.position(), this.redactSequenceUpdate.position(), false);
    }

    private boolean onFixMessage(DirectBuffer buffer, int start, int actingBlockLength, int version, long messagePosition) {
        int metaDataOffset;
        int metaDataLength;
        int offset = start;
        this.messageFrame.wrap(buffer, offset, actingBlockLength, version);
        if (this.messageFrame.status() != MessageStatus.OK) {
            return false;
        }
        offset += actingBlockLength;
        if (version >= FixMessageDecoder.metaDataSinceVersion()) {
            metaDataLength = this.messageFrame.metaDataLength();
            metaDataOffset = this.messageFrame.metaDataUpdateOffset();
            this.resizeMetaDataBuffer(metaDataOffset + metaDataLength);
            this.messageFrame.getMetaData(this.metaDataWriteBuffer, metaDataOffset, metaDataLength);
            offset += FixMessageDecoder.metaDataHeaderLength() + metaDataLength;
        } else {
            metaDataLength = 0;
            metaDataOffset = 0;
        }
        long sessionId = this.messageFrame.session();
        int msgSeqNum = this.sequenceNumberExtractor.extract(buffer, offset += FixMessageDecoder.bodyHeaderLength(), this.messageFrame.bodyLength());
        if (msgSeqNum != -1) {
            int position = this.saveRecord(msgSeqNum, sessionId, messagePosition, -1000L, false);
            if (metaDataLength > 0 && position > 0) {
                this.writeMetaDataToFile(position, this.metaDataWriteBuffer, metaDataOffset, metaDataLength);
            }
        }
        return true;
    }

    private void resizeMetaDataBuffer(int metaDataLength) {
        if (this.metaDataWriteBuffer.length < metaDataLength) {
            this.metaDataWriteBuffer = new byte[metaDataLength];
        }
    }

    private void onWriteMetaData() {
        int libraryId = this.writeMetaData.libraryId();
        long sessionId = this.writeMetaData.session();
        long correlationId = this.writeMetaData.correlationId();
        int metaDataOffset = this.writeMetaData.metaDataOffset();
        if (this.framerContext == null || this.metaDataFile == null) {
            this.writeMetaDataResponse(libraryId, correlationId, MetaDataStatus.FILE_ERROR);
            return;
        }
        int sequenceNumberIndexFilePosition = (int)this.recordOffsets.get(sessionId);
        if ((long)sequenceNumberIndexFilePosition == -1L) {
            this.writeMetaDataResponse(libraryId, correlationId, MetaDataStatus.UNKNOWN_SESSION);
            return;
        }
        int metaDataLength = this.writeMetaData.metaDataLength();
        this.resizeMetaDataBuffer(metaDataOffset + metaDataLength);
        this.writeMetaData.getMetaData(this.metaDataWriteBuffer, metaDataOffset, metaDataLength);
        MetaDataStatus status = this.writeMetaDataToFile(sequenceNumberIndexFilePosition, this.metaDataWriteBuffer, metaDataOffset, metaDataLength);
        this.writeMetaDataResponse(libraryId, correlationId, status);
    }

    private MetaDataStatus writeMetaDataToFile(int sequenceNumberIndexFilePosition, byte[] metaDataValue, int metaDataUpdateOffset, int metaDataUpdateLength) {
        int oldMetaDataPosition = this.getMetaData(sequenceNumberIndexFilePosition);
        try {
            if (oldMetaDataPosition == -1) {
                if (metaDataUpdateOffset != 0) {
                    return MetaDataStatus.INVALID_OFFSET;
                }
                this.allocateMetaDataSlot(sequenceNumberIndexFilePosition, metaDataValue, metaDataUpdateLength);
            } else {
                this.metaDataFile.seek(oldMetaDataPosition);
                int oldMetaDataLength = this.metaDataFile.readInt();
                int newMetaDataMinLength = metaDataUpdateOffset + metaDataUpdateLength;
                if (newMetaDataMinLength <= oldMetaDataLength) {
                    this.metaDataFile.seek(oldMetaDataPosition + 4 + metaDataUpdateOffset);
                    this.metaDataFile.write(metaDataValue, metaDataUpdateOffset, metaDataUpdateLength);
                } else {
                    if (metaDataUpdateOffset > 0) {
                        this.metaDataFile.read(metaDataValue, 0, metaDataUpdateOffset);
                    }
                    this.allocateMetaDataSlot(sequenceNumberIndexFilePosition, metaDataValue, newMetaDataMinLength);
                }
            }
            return MetaDataStatus.OK;
        }
        catch (IOException e) {
            this.errorHandler.onError((Throwable)e);
            return MetaDataStatus.FILE_ERROR;
        }
    }

    private void allocateMetaDataSlot(int sequenceNumberIndexFilePosition, byte[] metaDataValue, int metaDataLength) throws IOException {
        int metaDataFileInitialLength = (int)this.metaDataFile.length();
        this.updateMetaDataFile(metaDataFileInitialLength, metaDataValue, metaDataLength);
        this.putMetaDataField(sequenceNumberIndexFilePosition, metaDataFileInitialLength);
        this.hasSavedRecordSinceFileUpdate = true;
    }

    private void updateMetaDataFile(int position, byte[] metaDataValue, int metaDataLength) throws IOException {
        this.metaDataFile.seek(position);
        this.metaDataFile.writeInt(metaDataValue.length);
        this.metaDataFile.write(metaDataValue, 0, metaDataLength);
    }

    private void writeMetaDataResponse(int libraryId, long correlationId, MetaDataStatus status) {
        WriteMetaDataResponse response = new WriteMetaDataResponse(libraryId, correlationId, status);
        if (!this.sendResponse(response)) {
            this.responsesToResend.add(response);
        }
    }

    @Override
    public int doWork() {
        long requiredUpdateTimeInMs;
        int work = this.positionWriter.checkRecordings();
        if (this.hasSavedRecordSinceFileUpdate && (requiredUpdateTimeInMs = this.lastUpdatedFileTimeInMs + this.indexFileStateFlushTimeoutInMs) < this.clock.time()) {
            this.updateFile();
            ++work;
        }
        return work + CollectionUtil.removeIf(this.responsesToResend, this.sendResponseFunc);
    }

    private boolean sendResponse(WriteMetaDataResponse response) {
        return this.framerContext.offer(response);
    }

    void resetSequenceNumber(long session, long endPosition) {
        this.saveRecord(0, session, endPosition, -1000L, false);
    }

    void resetSequenceNumbers() {
        this.inMemoryBuffer.setMemory(0, this.indexedPositionsOffset, (byte)0);
        this.initialiseBlankBuffer();
        this.recordOffsets.clear();
        this.resetMetaDataFile();
    }

    private void resetMetaDataFile() {
        if (this.metaDataLocation != null) {
            try {
                this.metaDataFile.seek(0L);
                this.metaDataFile.setLength(12L);
                this.writeMetaDataFileHeader(this.metaDataFile);
            }
            catch (IOException e) {
                this.errorHandler.onError((Throwable)e);
            }
        }
    }

    private void checkTermRoll(DirectBuffer buffer, int offset, long endPosition, int length) {
        long termBufferLength = buffer.capacity();
        if (this.nextRollPosition == -1L) {
            long startPosition = endPosition - (long)(length + 32);
            this.nextRollPosition = startPosition + termBufferLength - (long)offset;
        } else if (endPosition > this.nextRollPosition) {
            this.nextRollPosition += termBufferLength;
            this.updateFile();
        }
    }

    private void updateFile() {
        this.checksumFramer.updateChecksums();
        this.positionWriter.updateChecksums();
        this.saveFile();
        this.flipFiles();
        this.hasSavedRecordSinceFileUpdate = false;
        this.lastUpdatedFileTimeInMs = this.clock.time();
    }

    private void saveFile() {
        this.writableFile.buffer().putBytes(0, (DirectBuffer)this.inMemoryBuffer, 0, this.fileCapacity);
        this.writableFile.force();
        this.syncMetaDataFile();
    }

    private void syncMetaDataFile() {
        if (this.metaDataFile != null) {
            try {
                this.metaDataFile.getFD().sync();
            }
            catch (IOException e) {
                this.errorHandler.onError((Throwable)e);
            }
        }
    }

    private void flipFiles() {
        boolean flipsFiles;
        if (CommonConfiguration.RUNNING_ON_WINDOWS) {
            this.writableFile.close();
            this.indexFile.close();
        }
        boolean bl = flipsFiles = this.rename(this.indexPath, this.passingPlacePath) && this.rename(this.writablePath, this.indexPath) && this.rename(this.passingPlacePath, this.writablePath);
        if (CommonConfiguration.RUNNING_ON_WINDOWS) {
            this.writableFile.map();
            this.indexFile.map();
        } else if (flipsFiles) {
            MappedFile file = this.writableFile;
            this.writableFile = this.indexFile;
            this.indexFile = file;
        }
    }

    private boolean rename(Path src, Path dest) {
        try {
            Files.move(src, dest, StandardCopyOption.ATOMIC_MOVE);
            return true;
        }
        catch (IOException e) {
            this.errorHandler.onError((Throwable)e);
            return false;
        }
    }

    public Path passingPlace() {
        return this.passingPlacePath;
    }

    public boolean isOpen() {
        return this.writableFile.isOpen();
    }

    @Override
    public void close() {
        try {
            if (this.isOpen() && this.hasSavedRecordSinceFileUpdate) {
                this.updateFile();
            }
        }
        finally {
            this.indexFile.close();
            this.writableFile.close();
            if (this.metaDataFile != null) {
                try {
                    this.metaDataFile.close();
                }
                catch (IOException e) {
                    this.errorHandler.onError((Throwable)e);
                }
            }
        }
    }

    @Override
    public void readLastPosition(IndexedPositionConsumer consumer) {
        new IndexedPositionReader(this.positionWriter.buffer()).readLastPosition(consumer);
    }

    private int saveRecord(int newSequenceNumber, long sessionId, long messagePosition, long requiredPosition, boolean incrementRequired) {
        int position = (int)this.recordOffsets.get(sessionId);
        if ((long)position == -1L) {
            position = 8;
            while (true) {
                if ((position = this.checksumFramer.claim(position, 24)) == -1) {
                    this.errorHandler.onError((Throwable)new IllegalStateException("Sequence Number Index out of space, can't claim slot for " + sessionId));
                    return position;
                }
                this.lastKnownDecoder.wrap((DirectBuffer)this.inMemoryBuffer, position, 24, 6);
                if (this.lastKnownDecoder.sessionId() == 0L) {
                    if (requiredPosition == -1000L) {
                        this.createNewRecord(newSequenceNumber, sessionId, position, messagePosition);
                        this.hasSavedRecordSinceFileUpdate = true;
                    }
                    return position;
                }
                if (this.lastKnownDecoder.sessionId() == sessionId) {
                    this.recordOffsets.put(sessionId, (long)position);
                    this.updateSequenceNumber(newSequenceNumber, position, messagePosition, requiredPosition, incrementRequired);
                    return position;
                }
                position += 24;
            }
        }
        this.updateSequenceNumber(newSequenceNumber, position, messagePosition, requiredPosition, incrementRequired);
        return position;
    }

    private void updateSequenceNumber(int newSequenceNumber, int recordOffset, long messagePosition, long requiredPosition, boolean incrementRequired) {
        if (requiredPosition != -1000L && this.getMessagePosition(recordOffset) != requiredPosition) {
            return;
        }
        int oldSequenceNumber = this.getSequenceNumber(recordOffset);
        if (incrementRequired) {
            if (newSequenceNumber > oldSequenceNumber) {
                this.putMessagePosition(recordOffset, messagePosition);
                this.putSequenceNumber(recordOffset, newSequenceNumber);
                this.hasSavedRecordSinceFileUpdate = true;
            }
        } else {
            int oldMetaDataPosition;
            this.putMessagePosition(recordOffset, messagePosition);
            this.putSequenceNumber(recordOffset, newSequenceNumber);
            if (oldSequenceNumber > newSequenceNumber && (oldMetaDataPosition = this.getMetaData(recordOffset)) != -1) {
                this.putMetaDataField(recordOffset, -1);
                try {
                    this.metaDataFile.seek(oldMetaDataPosition);
                    int metaDataLength = this.metaDataFile.readInt();
                    this.updateMetaDataFile(oldMetaDataPosition, new byte[metaDataLength], metaDataLength);
                }
                catch (IOException e) {
                    this.errorHandler.onError((Throwable)e);
                }
            }
            this.hasSavedRecordSinceFileUpdate = true;
        }
    }

    private void createNewRecord(int sequenceNumber, long sessionId, int position, long messagePosition) {
        this.recordOffsets.put(sessionId, (long)position);
        this.lastKnownEncoder.wrap((MutableDirectBuffer)this.inMemoryBuffer, position).sessionId(sessionId).messagePosition(messagePosition);
        this.putSequenceNumber(position, sequenceNumber);
        this.putMetaDataField(position, -1);
    }

    private void initialiseBuffer() {
        this.validateBufferSizes();
        AtomicBuffer fileBuffer = this.indexFile.buffer();
        if (this.fileHasBeenInitialized(fileBuffer)) {
            this.readFile(fileBuffer);
        } else if (Files.exists(this.passingPlacePath, new LinkOption[0])) {
            if (this.rename(this.passingPlacePath, this.indexPath)) {
                this.indexFile.remap();
                this.initialiseBuffer();
            } else {
                this.errorHandler.onError((Throwable)new IllegalStateException(String.format("Unable to recover index file from %s to %s due to rename failure", this.passingPlacePath, this.indexPath)));
            }
        } else {
            this.initialiseBlankBuffer();
        }
    }

    private void initialiseBlankBuffer() {
        LoggerUtil.initialiseBuffer(this.inMemoryBuffer, this.fileHeaderEncoder, this.fileHeaderDecoder, this.lastKnownEncoder.sbeSchemaId(), this.lastKnownEncoder.sbeTemplateId(), this.lastKnownEncoder.sbeSchemaVersion(), this.lastKnownEncoder.sbeBlockLength(), this.errorHandler);
    }

    private boolean fileHasBeenInitialized(AtomicBuffer fileBuffer) {
        return fileBuffer.getShort(0) != 0 || fileBuffer.getInt(4092) != 0;
    }

    private void validateBufferSizes() {
        int inMemoryCapacity = this.inMemoryBuffer.capacity();
        if (this.fileCapacity != inMemoryCapacity) {
            throw new IllegalStateException(String.format("In memory buffer and disk file don't have the same size, disk: %d, memory: %d", this.fileCapacity, inMemoryCapacity));
        }
        if (this.fileCapacity < 4096) {
            throw new IllegalStateException(String.format("Cannot create sequence number of size < 1 sector: %d", this.fileCapacity));
        }
    }

    private void readFile(AtomicBuffer fileBuffer) {
        this.loadBuffer(fileBuffer);
        this.checksumFramer.validateCheckSums();
    }

    private void loadBuffer(AtomicBuffer fileBuffer) {
        this.inMemoryBuffer.putBytes(0, (DirectBuffer)fileBuffer, 0, this.fileCapacity);
    }

    private void putMessagePosition(int recordOffset, long value) {
        this.inMemoryBuffer.putLongOrdered(recordOffset + MESSAGE_POSITION_OFFSET, value);
    }

    private void putSequenceNumber(int recordOffset, int value) {
        this.inMemoryBuffer.putIntOrdered(recordOffset + SEQUENCE_NUMBER_OFFSET, value);
    }

    private int getSequenceNumber(int recordOffset) {
        return this.inMemoryBuffer.getIntVolatile(recordOffset + SEQUENCE_NUMBER_OFFSET);
    }

    private long getMessagePosition(int recordOffset) {
        return this.inMemoryBuffer.getLongVolatile(recordOffset + MESSAGE_POSITION_OFFSET);
    }

    private void putMetaDataField(int recordOffset, int value) {
        this.inMemoryBuffer.putIntOrdered(recordOffset + META_DATA_OFFSET, value);
    }

    private int getMetaData(int recordOffset) {
        return this.inMemoryBuffer.getIntVolatile(recordOffset + META_DATA_OFFSET);
    }

    public void framerContext(FramerContext framerContext) {
        this.framerContext = framerContext;
    }
}

