/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.Header;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.LongFunction;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.Long2ObjectCache;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.engine.SequenceNumberExtractor;
import uk.co.real_logic.artio.engine.logger.BufferFactory;
import uk.co.real_logic.artio.engine.logger.ILinkSequenceNumberExtractor;
import uk.co.real_logic.artio.engine.logger.Index;
import uk.co.real_logic.artio.engine.logger.IndexedPositionConsumer;
import uk.co.real_logic.artio.engine.logger.IndexedPositionReader;
import uk.co.real_logic.artio.engine.logger.IndexedPositionWriter;
import uk.co.real_logic.artio.engine.logger.RecordingIdLookup;
import uk.co.real_logic.artio.engine.logger.ReplayIndexDescriptor;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.RedactSequenceUpdateDecoder;
import uk.co.real_logic.artio.messages.ResetSequenceNumberDecoder;
import uk.co.real_logic.artio.storage.messages.ReplayIndexRecordEncoder;

public class ReplayIndex
implements Index {
    private final LongFunction<SessionIndex> newSessionIndex = x$0 -> new SessionIndex(x$0);
    private final MessageHeaderDecoder frameHeaderDecoder = new MessageHeaderDecoder();
    private final FixMessageDecoder messageFrame = new FixMessageDecoder();
    private final ResetSequenceNumberDecoder resetSequenceNumber = new ResetSequenceNumberDecoder();
    private final RedactSequenceUpdateDecoder redactSequenceUpdateDecoder = new RedactSequenceUpdateDecoder();
    private final ReplayIndexRecordEncoder replayIndexRecord = new ReplayIndexRecordEncoder();
    private final MessageHeaderEncoder indexHeaderEncoder = new MessageHeaderEncoder();
    private final IndexedPositionWriter positionWriter;
    private final IndexedPositionReader positionReader;
    private final SequenceNumberExtractor sequenceNumberExtractor;
    private final ILinkSequenceNumberExtractor iLinkSequenceNumberExtractor;
    private final Long2ObjectCache<SessionIndex> fixSessionIdToIndex;
    private final String logFileDir;
    private final int requiredStreamId;
    private final int indexFileSize;
    private final BufferFactory bufferFactory;
    private final AtomicBuffer positionBuffer;
    private final ErrorHandler errorHandler;
    private final RecordingIdLookup recordingIdLookup;
    private long continuedFixSessionId;
    private int continuedSequenceNumber;
    private int continuedSequenceIndex;

    public ReplayIndex(String logFileDir, int requiredStreamId, int indexFileSize, int cacheNumSets, int cacheSetSize, BufferFactory bufferFactory, AtomicBuffer positionBuffer, ErrorHandler errorHandler, RecordingIdLookup recordingIdLookup, Long2LongHashMap connectionIdToILinkUuid) {
        this.logFileDir = logFileDir;
        this.requiredStreamId = requiredStreamId;
        this.indexFileSize = indexFileSize;
        this.bufferFactory = bufferFactory;
        this.positionBuffer = positionBuffer;
        this.errorHandler = errorHandler;
        this.recordingIdLookup = recordingIdLookup;
        this.iLinkSequenceNumberExtractor = new ILinkSequenceNumberExtractor(connectionIdToILinkUuid, errorHandler, (sequenceNumber, uuid, messageSize, endPosition, aeronSessionId, possRetrans) -> this.sessionIndex(uuid).onRecord(endPosition, messageSize, sequenceNumber, 0, aeronSessionId, -1L));
        this.sequenceNumberExtractor = new SequenceNumberExtractor(errorHandler);
        ReplayIndexDescriptor.checkIndexFileSize(indexFileSize);
        this.fixSessionIdToIndex = new Long2ObjectCache(cacheNumSets, cacheSetSize, SessionIndex::close);
        String replayPositionPath = ReplayIndexDescriptor.replayPositionPath(logFileDir, requiredStreamId);
        this.positionWriter = new IndexedPositionWriter(positionBuffer, errorHandler, 0, replayPositionPath, recordingIdLookup);
        this.positionReader = new IndexedPositionReader(positionBuffer);
    }

    @Override
    public void onCatchup(DirectBuffer buffer, int offset, int length, Header header, long recordingId) {
        this.onFragment(buffer, offset, length, header, recordingId);
    }

    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        int streamId = header.streamId();
        if (streamId == this.requiredStreamId) {
            this.onFragment(buffer, offset, length, header, -1L);
        }
    }

    public void onFragment(DirectBuffer srcBuffer, int srcOffset, int srcLength, Header header, long recordingId) {
        boolean beginMessage;
        long endPosition = header.position();
        byte flags = header.flags();
        int length = BitUtil.align((int)srcLength, (int)32);
        int offset = srcOffset;
        this.frameHeaderDecoder.wrap(srcBuffer, offset);
        int templateId = this.frameHeaderDecoder.templateId();
        int blockLength = this.frameHeaderDecoder.blockLength();
        int version = this.frameHeaderDecoder.version();
        offset += this.frameHeaderDecoder.encodedLength();
        boolean bl = beginMessage = (flags & 0xFFFFFF80) == -128;
        if ((flags & 0xFFFFFFC0) == -64 || beginMessage) {
            if (templateId == 1) {
                this.messageFrame.wrap(srcBuffer, offset, blockLength, version);
                if (this.messageFrame.status() == MessageStatus.OK) {
                    offset += blockLength;
                    if (version >= FixMessageDecoder.metaDataSinceVersion()) {
                        offset += FixMessageDecoder.metaDataHeaderLength() + this.messageFrame.metaDataLength();
                        this.messageFrame.skipMetaData();
                    }
                    long fixSessionId = this.messageFrame.session();
                    int sequenceNumber = this.sequenceNumberExtractor.extract(srcBuffer, offset += FixMessageDecoder.bodyHeaderLength(), this.messageFrame.bodyLength());
                    int sequenceIndex = this.messageFrame.sequenceIndex();
                    if (sequenceNumber != -1) {
                        if (beginMessage) {
                            this.continuedFixSessionId = fixSessionId;
                            this.continuedSequenceNumber = sequenceNumber;
                            this.continuedSequenceIndex = sequenceIndex;
                        }
                        this.sessionIndex(fixSessionId).onRecord(endPosition, length, sequenceNumber, sequenceIndex, header.sessionId(), recordingId);
                    }
                }
            } else if (templateId == 58 || templateId == 57) {
                this.iLinkSequenceNumberExtractor.onFragment(srcBuffer, srcOffset, srcLength, header);
            } else if (templateId == 42) {
                this.resetSequenceNumber.wrap(srcBuffer, offset, blockLength, version);
                long fixSessionId = this.resetSequenceNumber.session();
                this.onResetSequenceNumber(fixSessionId);
            } else if (templateId == 55) {
                this.redactSequenceUpdateDecoder.wrap(srcBuffer, offset, blockLength, version);
                if (this.redactSequenceUpdateDecoder.correctSequenceNumber() <= 1) {
                    long fixSessionId = this.redactSequenceUpdateDecoder.session();
                    this.onResetSequenceNumber(fixSessionId);
                }
            }
        } else {
            this.sessionIndex(this.continuedFixSessionId).onRecord(endPosition, length, this.continuedSequenceNumber, this.continuedSequenceIndex, header.sessionId(), recordingId);
        }
        this.positionWriter.update(header.sessionId(), templateId, endPosition, recordingId);
        this.positionWriter.updateChecksums();
    }

    private void onResetSequenceNumber(long fixSessionId) {
        SessionIndex index = (SessionIndex)this.fixSessionIdToIndex.remove(fixSessionId);
        if (index != null) {
            index.reset();
        } else {
            File replayIndexFile = this.replayIndexFile(fixSessionId);
            if (replayIndexFile.exists()) {
                this.deleteFile(replayIndexFile);
            }
        }
    }

    private SessionIndex sessionIndex(long fixSessionId) {
        return (SessionIndex)this.fixSessionIdToIndex.computeIfAbsent(fixSessionId, this.newSessionIndex);
    }

    @Override
    public int doWork() {
        return this.positionWriter.checkRecordings();
    }

    @Override
    public void close() {
        this.positionWriter.close();
        this.fixSessionIdToIndex.clear();
        IoUtil.unmap((ByteBuffer)this.positionBuffer.byteBuffer());
    }

    @Override
    public void readLastPosition(IndexedPositionConsumer consumer) {
        this.positionReader.readLastPosition(consumer);
    }

    private File replayIndexFile(long fixSessionId) {
        return ReplayIndexDescriptor.replayIndexFile(this.logFileDir, fixSessionId, this.requiredStreamId);
    }

    private void deleteFile(File replayIndexFile) {
        if (!replayIndexFile.delete()) {
            this.errorHandler.onError((Throwable)new IOException("Unable to delete replay index file: " + replayIndexFile));
        }
    }

    private final class SessionIndex
    implements AutoCloseable {
        private final ByteBuffer wrappedBuffer;
        private final AtomicBuffer buffer;
        private final int recordCapacity;
        private final File replayIndexFile;

        SessionIndex(long fixSessionId) {
            this.replayIndexFile = ReplayIndex.this.replayIndexFile(fixSessionId);
            boolean exists = this.replayIndexFile.exists();
            this.wrappedBuffer = ReplayIndex.this.bufferFactory.map(this.replayIndexFile, ReplayIndex.this.indexFileSize);
            this.buffer = new UnsafeBuffer(this.wrappedBuffer);
            this.recordCapacity = ReplayIndexDescriptor.recordCapacity(this.buffer.capacity());
            if (!exists) {
                ReplayIndex.this.indexHeaderEncoder.wrap((MutableDirectBuffer)this.buffer, 0).blockLength(ReplayIndex.this.replayIndexRecord.sbeBlockLength()).templateId(ReplayIndex.this.replayIndexRecord.sbeTemplateId()).schemaId(ReplayIndex.this.replayIndexRecord.sbeSchemaId()).version(ReplayIndex.this.replayIndexRecord.sbeSchemaVersion());
            } else {
                long resetPosition = ReplayIndexDescriptor.beginChange(this.buffer);
                ReplayIndexDescriptor.endChangeOrdered(this.buffer, resetPosition);
            }
        }

        void onRecord(long endPosition, int length, int sequenceNumber, int sequenceIndex, int aeronSessionId, long knownRecordingId) {
            long beginChangePosition = ReplayIndexDescriptor.beginChange(this.buffer);
            long changePosition = beginChangePosition + 32L;
            long recordingId = knownRecordingId == -1L ? ReplayIndex.this.recordingIdLookup.getRecordingId(aeronSessionId) : knownRecordingId;
            long beginPosition = endPosition - (long)length;
            ReplayIndexDescriptor.beginChangeOrdered(this.buffer, changePosition);
            UnsafeAccess.UNSAFE.storeFence();
            int offset = ReplayIndexDescriptor.offset(beginChangePosition, this.recordCapacity);
            ReplayIndex.this.replayIndexRecord.wrap((MutableDirectBuffer)this.buffer, offset).position(beginPosition).sequenceNumber(sequenceNumber).sequenceIndex(sequenceIndex).recordingId(recordingId).length(length);
            ReplayIndexDescriptor.endChangeOrdered(this.buffer, changePosition);
        }

        void reset() {
            this.close();
            ReplayIndex.this.deleteFile(this.replayIndexFile);
        }

        @Override
        public void close() {
            IoUtil.unmap((ByteBuffer)this.wrappedBuffer);
        }
    }
}

