/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.SessionInfo;
import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.Session;

class SessionContext
implements SessionInfo {
    private final CompositeKey compositeKey;
    private final long sessionId;
    private final SessionContexts sessionContexts;
    private volatile int sequenceIndex;
    private final int initialSequenceIndex;
    private long lastLogonTime;
    private long lastSequenceResetTimeInNs;
    private FixDictionary lastFixDictionary;
    private int filePosition;

    SessionContext(CompositeKey compositeKey, long sessionId, int sequenceIndex, long lastLogonTime, long lastSequenceResetTimeInNs, SessionContexts sessionContexts, int filePosition, int initialSequenceIndex, FixDictionary lastFixDictionary) {
        this.compositeKey = compositeKey;
        this.sessionId = sessionId;
        this.sequenceIndex = sequenceIndex;
        this.initialSequenceIndex = initialSequenceIndex;
        this.lastLogonTime(lastLogonTime);
        this.lastSequenceResetTimeInNs = lastSequenceResetTimeInNs;
        this.sessionContexts = sessionContexts;
        this.filePosition = filePosition;
        this.lastFixDictionary = lastFixDictionary;
    }

    private void lastLogonTime(long lastLogonTime) {
        this.lastLogonTime = lastLogonTime;
    }

    void onSequenceReset(long resetTimeInNs) {
        this.lastSequenceResetTimeInNs = resetTimeInNs;
        this.sequenceIndex = this.sequenceIndex == -1 ? this.initialSequenceIndex : this.sequenceIndex + 1;
        this.save();
    }

    void updateAndSaveFrom(Session session) {
        this.updateFrom(session);
        this.save();
    }

    void ensureFixDictionary(FixDictionary fixDictionary) {
        if (this.lastFixDictionary != fixDictionary) {
            this.lastFixDictionary = fixDictionary;
            this.save();
        }
    }

    private void save() {
        this.sessionContexts.updateSavedData(this, this.filePosition);
    }

    void filePosition(int filePosition) {
        this.filePosition = filePosition;
    }

    void updateFrom(Session session) {
        this.sequenceIndex = session.sequenceIndex();
        this.lastLogonTime(session.lastLogonTime());
        this.lastSequenceResetTimeInNs = session.lastSequenceResetTime();
    }

    void onLogon(boolean resetSeqNum, long time, FixDictionary fixDictionary) {
        this.lastFixDictionary = fixDictionary;
        this.lastLogonTime(time);
        if (resetSeqNum || this.sequenceIndex == -1) {
            this.onSequenceReset(time);
        } else {
            this.save();
        }
    }

    @Override
    public int sequenceIndex() {
        return this.sequenceIndex;
    }

    @Override
    public long sessionId() {
        return this.sessionId;
    }

    @Override
    public CompositeKey sessionKey() {
        return this.compositeKey;
    }

    public long lastSequenceResetTime() {
        return this.lastSequenceResetTimeInNs;
    }

    public long lastLogonTime() {
        return this.lastLogonTime;
    }

    public FixDictionary lastFixDictionary() {
        return this.lastFixDictionary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionContext that = (SessionContext)o;
        return this.sessionId == that.sessionId;
    }

    public int hashCode() {
        return (int)(this.sessionId ^ this.sessionId >>> 32);
    }

    public String toString() {
        return "SessionContext{sessionId=" + this.sessionId + ", sequenceIndex=" + this.sequenceIndex + ", compositeKey=" + this.compositeKey + '}';
    }
}

