/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Objects;
import org.agrona.ErrorHandler;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public abstract class ReceiverEndPoint {
    protected static final int SOCKET_DISCONNECTED = -1;
    protected final GatewayPublication publication;
    protected final TcpChannel channel;
    protected final long connectionId;
    protected boolean hasDisconnected = false;
    protected final MutableAsciiBuffer buffer;
    protected final ByteBuffer byteBuffer;
    protected final ErrorHandler errorHandler;
    protected final Framer framer;
    protected int libraryId;
    protected int usedBufferData = 0;
    protected SelectionKey selectionKey;

    public ReceiverEndPoint(GatewayPublication publication, TcpChannel channel, long connectionId, int bufferSize, ErrorHandler errorHandler, Framer framer, int libraryId) {
        Objects.requireNonNull(publication, "publication");
        this.publication = publication;
        this.channel = channel;
        this.connectionId = connectionId;
        this.errorHandler = errorHandler;
        this.framer = framer;
        this.libraryId = libraryId;
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.buffer = new MutableAsciiBuffer(this.byteBuffer);
    }

    long connectionId() {
        return this.connectionId;
    }

    void register(Selector selector) throws IOException {
        this.selectionKey = this.channel.register(selector, 1, this);
    }

    void onDisconnectDetected() {
        this.completeDisconnect(DisconnectReason.REMOTE_DISCONNECT);
    }

    void close(DisconnectReason reason) {
        this.closeResources();
        if (!this.hasDisconnected) {
            this.disconnectEndpoint(reason);
        }
    }

    void completeDisconnect(DisconnectReason reason) {
        this.disconnectEndpoint(reason);
        this.removeEndpointFromFramer();
    }

    abstract void removeEndpointFromFramer();

    void disconnectEndpoint(DisconnectReason reason) {
        this.framer.schedule(() -> this.publication.saveDisconnect(this.libraryId, this.connectionId, reason));
        this.cleanupDisconnectState(reason);
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
        this.hasDisconnected = true;
    }

    abstract void cleanupDisconnectState(DisconnectReason var1);

    abstract int poll();

    abstract boolean retryFrameMessages();

    abstract boolean requiresAuthentication();

    abstract void closeResources();

    public void libraryId(int libraryId) {
        this.libraryId = libraryId;
    }

    public int libraryId() {
        return this.libraryId;
    }
}

