/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.logbuffer.ControlledFragmentHandler;
import org.agrona.DirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.engine.framer.ILink3SenderEndPoint;

public class ILink3SenderEndPoints {
    private final Long2ObjectHashMap<ILink3SenderEndPoint> connectionIdToSenderEndpoint = new Long2ObjectHashMap();

    public ControlledFragmentHandler.Action onMessage(long connectionId, DirectBuffer buffer, int offset) {
        ILink3SenderEndPoint senderEndPoint = (ILink3SenderEndPoint)this.connectionIdToSenderEndpoint.get(connectionId);
        if (senderEndPoint != null) {
            return senderEndPoint.onMessage(buffer, offset);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public void add(ILink3SenderEndPoint senderEndPoint) {
        this.connectionIdToSenderEndpoint.put(senderEndPoint.connectionId(), (Object)senderEndPoint);
    }

    void removeConnection(long connectionId) {
        this.connectionIdToSenderEndpoint.remove(connectionId);
    }

    public ControlledFragmentHandler.Action onReplayComplete(long connectionId) {
        ILink3SenderEndPoint senderEndPoint = (ILink3SenderEndPoint)this.connectionIdToSenderEndpoint.get(connectionId);
        if (senderEndPoint != null) {
            return senderEndPoint.onReplayComplete(connectionId);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public String toString() {
        return "ILink3SenderEndPoints{connectionIdToSenderEndpoint=" + this.connectionIdToSenderEndpoint + '}';
    }
}

