/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ExclusivePublication;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.ILink3Context;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.ilink.SimpleOpenFramingHeader;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.GatewayError;
import uk.co.real_logic.artio.messages.ILinkMessageEncoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

class ILink3ReceiverEndPoint
extends ReceiverEndPoint {
    public static final int ARTIO_HEADER_LENGTH = 24;
    private static final int NEGOTIATION_RESPONSE = 501;
    private static final int TEMPLATE_ID_OFFSET = 6;
    private final ILinkMessageEncoder iLinkMessage = new ILinkMessageEncoder();
    private final UnsafeBuffer headerBuffer = new UnsafeBuffer(new byte[24]);
    private final ExclusivePublication inboundPublication;
    private final boolean isBackup;
    private final ILink3Context context;
    private final EpochNanoClock epochNanoClock;
    private final long correlationId;

    ILink3ReceiverEndPoint(long connectionId, TcpChannel channel, int bufferSize, ErrorHandler errorHandler, Framer framer, GatewayPublication publication, int libraryId, boolean isBackup, ILink3Context context, EpochNanoClock epochNanoClock, long correlationId) {
        super(publication, channel, connectionId, bufferSize, errorHandler, framer, libraryId);
        this.inboundPublication = publication.dataPublication();
        this.isBackup = isBackup;
        this.context = context;
        this.epochNanoClock = epochNanoClock;
        this.correlationId = correlationId;
        this.makeHeader();
    }

    private void makeHeader() {
        MessageHeaderEncoder header = new MessageHeaderEncoder();
        this.iLinkMessage.wrapAndApplyHeader((MutableDirectBuffer)this.headerBuffer, 0, header).connection(this.connectionId);
    }

    @Override
    void removeEndpointFromFramer() {
        this.trackDisconnect();
        this.framer.onILink3Disconnect(this.connectionId, null);
    }

    private void trackDisconnect() {
        if (this.isBackup) {
            this.context.backupConnected(false);
        } else {
            this.context.primaryConnected(false);
        }
    }

    @Override
    void cleanupDisconnectState(DisconnectReason reason) {
    }

    @Override
    boolean retryFrameMessages() {
        return this.frameMessages();
    }

    private int readData() throws IOException {
        int dataRead = this.channel.read(this.byteBuffer);
        if (dataRead != -1) {
            if (dataRead > 0) {
                DebugLogger.logBytes(LogTag.FIX_MESSAGE_TCP, "Read     ", this.byteBuffer, this.usedBufferData, dataRead);
            }
            this.usedBufferData += dataRead;
        } else {
            this.onDisconnectDetected();
        }
        return dataRead;
    }

    @Override
    int poll() {
        try {
            int bytesRead = this.readData();
            if (bytesRead > 0 && !this.frameMessages()) {
                return -bytesRead;
            }
            return bytesRead;
        }
        catch (ClosedChannelException ex) {
            this.onDisconnectDetected();
        }
        catch (IllegalArgumentException ex) {
            this.errorHandler.onError((Throwable)ex);
            this.saveError(ex);
            this.completeDisconnect(DisconnectReason.INVALID_ILINK_MESSAGE);
        }
        catch (Exception ex) {
            if (!Exceptions.isJustDisconnect((Exception)ex)) {
                this.errorHandler.onError((Throwable)ex);
            }
            this.saveError(ex);
            this.onDisconnectDetected();
        }
        return 1;
    }

    private void saveError(Exception ex) {
        this.framer.saveError(GatewayError.EXCEPTION, this.libraryId, this.correlationId, ex.getMessage());
    }

    private boolean frameMessages() {
        MutableAsciiBuffer buffer = this.buffer;
        int offset = 0;
        while (this.usedBufferData > 4) {
            int messageSize = SimpleOpenFramingHeader.readSofh((DirectBuffer)buffer, (int)offset);
            if (messageSize > this.usedBufferData) {
                this.moveRemainingDataToBufferStart(offset);
                return true;
            }
            if (this.readTemplateId(buffer, offset) == 501) {
                this.context.confirmUuid();
            }
            this.iLinkMessage.enqueueTime(this.epochNanoClock.nanoTime());
            long position = this.inboundPublication.offer((DirectBuffer)this.headerBuffer, 0, 24, (DirectBuffer)buffer, offset, messageSize);
            if (position < 0L) {
                this.moveRemainingDataToBufferStart(offset);
                return false;
            }
            this.usedBufferData -= messageSize;
            offset += messageSize;
        }
        this.moveRemainingDataToBufferStart(offset);
        return true;
    }

    private int readTemplateId(MutableAsciiBuffer buffer, int offset) {
        return buffer.getShort(offset + 6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    private void moveRemainingDataToBufferStart(int offset) {
        if (this.usedBufferData > 0) {
            this.buffer.putBytes(0, (DirectBuffer)this.buffer, offset, this.usedBufferData);
        }
        ByteBufferUtil.position(this.byteBuffer, this.usedBufferData);
    }

    @Override
    boolean requiresAuthentication() {
        return false;
    }

    @Override
    void closeResources() {
        this.trackDisconnect();
        try {
            this.channel.close();
        }
        catch (Exception ex) {
            this.errorHandler.onError((Throwable)ex);
        }
    }
}

