/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.ConnectedSessionInfo;
import uk.co.real_logic.artio.engine.framer.BlockablePosition;
import uk.co.real_logic.artio.engine.framer.FixReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.FixSenderEndPoint;
import uk.co.real_logic.artio.engine.framer.SessionContext;
import uk.co.real_logic.artio.messages.ConnectionType;
import uk.co.real_logic.artio.messages.ReplayMessagesStatus;
import uk.co.real_logic.artio.messages.SlowStatus;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.DirectSessionProxy;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.session.SessionParser;
import uk.co.real_logic.artio.session.SessionProcessHandler;

class GatewaySession
implements ConnectedSessionInfo,
SessionProcessHandler {
    private static final int NO_TIMEOUT = -1;
    private final ConnectionType connectionType;
    private final boolean closedResendInterval;
    private final int resendRequestChunkSize;
    private final boolean sendRedundantResendRequests;
    private final boolean enableLastMsgSeqNumProcessed;
    private final long authenticationTimeoutInMs;
    private FixDictionary fixDictionary;
    private FixReceiverEndPoint receiverEndPoint;
    private FixSenderEndPoint senderEndPoint;
    private long sessionId;
    private long connectionId;
    private String address;
    private SessionContext context;
    private SessionParser sessionParser;
    private InternalSession session;
    private DirectSessionProxy proxy;
    private CompositeKey sessionKey;
    private String username;
    private String password;
    private int heartbeatIntervalInS;
    private long disconnectTimeInMs = -1L;
    private Consumer<GatewaySession> onGatewaySessionLogon;
    private boolean initialResetSeqNum;
    private boolean hasStartedAuthentication = false;
    private int logonReceivedSequenceNumber;
    private int logonSequenceIndex;
    private long lastSequenceResetTime = -1L;
    private long lastLogonTime = -1L;
    private int libraryId;

    GatewaySession(long connectionId, SessionContext context, String address, ConnectionType connectionType, CompositeKey sessionKey, FixReceiverEndPoint receiverEndPoint, FixSenderEndPoint senderEndPoint, Consumer<GatewaySession> onGatewaySessionLogon, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, FixDictionary fixDictionary, long authenticationTimeoutInMs) {
        this.connectionId = connectionId;
        this.sessionId = context.sessionId();
        this.context = context;
        this.address = address;
        this.connectionType = connectionType;
        this.sessionKey = sessionKey;
        this.receiverEndPoint = receiverEndPoint;
        this.senderEndPoint = senderEndPoint;
        this.onGatewaySessionLogon = onGatewaySessionLogon;
        this.closedResendInterval = closedResendInterval;
        this.resendRequestChunkSize = resendRequestChunkSize;
        this.sendRedundantResendRequests = sendRedundantResendRequests;
        this.enableLastMsgSeqNumProcessed = enableLastMsgSeqNumProcessed;
        this.fixDictionary = fixDictionary;
        this.authenticationTimeoutInMs = authenticationTimeoutInMs;
    }

    @Override
    public long connectionId() {
        return this.connectionId;
    }

    @Override
    public String address() {
        if (this.receiverEndPoint != null) {
            return this.receiverEndPoint.address();
        }
        return this.address;
    }

    @Override
    public long sessionId() {
        return this.sessionId;
    }

    @Override
    public CompositeKey sessionKey() {
        return this.sessionKey;
    }

    void manage(SessionParser sessionParser, InternalSession session, BlockablePosition blockablePosition, DirectSessionProxy proxy) {
        this.sessionParser = sessionParser;
        this.session = session;
        this.proxy = proxy;
        this.session.sessionProcessHandler(this);
        this.receiverEndPoint.libraryId(0);
        this.senderEndPoint.libraryId(0, blockablePosition);
    }

    void handoverManagementTo(int libraryId, BlockablePosition blockablePosition) {
        this.setManagementTo(libraryId, blockablePosition);
        this.sessionParser = null;
        this.session.sessionProcessHandler(null);
        this.context.updateAndSaveFrom(this.session);
        this.session.close();
        this.session = null;
        this.proxy = null;
    }

    void setManagementTo(int libraryId, BlockablePosition blockablePosition) {
        this.libraryId(libraryId);
        this.receiverEndPoint.libraryId(libraryId);
        this.receiverEndPoint.pause();
        this.senderEndPoint.libraryId(libraryId, blockablePosition);
    }

    void play() {
        if (this.receiverEndPoint != null) {
            this.receiverEndPoint.play();
        }
    }

    int poll(long timeInMs) {
        int events = this.session != null ? this.session.poll(timeInMs) : 0;
        return events + this.checkNoLogonDisconnect(timeInMs);
    }

    private int checkNoLogonDisconnect(long timeInMs) {
        if (this.disconnectTimeInMs == -1L) {
            return 0;
        }
        if (this.disconnectTimeInMs <= timeInMs && !this.receiverEndPoint.hasDisconnected()) {
            if (this.hasStartedAuthentication) {
                this.receiverEndPoint.onAuthenticationTimeoutDisconnect();
            } else {
                this.receiverEndPoint.onNoLogonDisconnect();
            }
            return 1;
        }
        return 0;
    }

    void startAuthentication(long timeInMs) {
        this.hasStartedAuthentication = true;
        this.disconnectTimeInMs = timeInMs + this.authenticationTimeoutInMs;
    }

    void onAuthenticationResult() {
        this.disconnectTimeInMs = -1L;
    }

    @Override
    public void onLogon(Session session) {
        this.context.updateFrom(session);
        this.onGatewaySessionLogon.accept(this);
    }

    @Override
    public Reply<ReplayMessagesStatus> replayReceivedMessages(long sessionId, int replayFromSequenceNumber, int replayFromSequenceIndex, int replayToSequenceNumber, int replayToSequenceIndex, long timeout) {
        throw new UnsupportedOperationException("Should never be invoked inside the Engine.");
    }

    @Override
    public void enqueueTask(BooleanSupplier task) {
        throw new UnsupportedOperationException("Should never be invoked inside the Engine.");
    }

    InternalSession session() {
        return this.session;
    }

    ConnectionType connectionType() {
        return this.connectionType;
    }

    public void onMessage(DirectBuffer buffer, int offset, int length, long messageType, long position) {
        if (this.sessionParser != null) {
            DebugLogger.log(LogTag.FIX_MESSAGE, "Gateway Received ", buffer, offset, length);
            this.session.messageInfo().isValid(true);
            this.sessionParser.onMessage(buffer, offset, length, messageType, position);
        }
    }

    void onLogon(String username, String password, int heartbeatIntervalInS) {
        this.username = username;
        this.password = password;
        this.heartbeatIntervalInS = heartbeatIntervalInS;
        if (this.session != null) {
            this.session.setupSession(this.sessionId, this.sessionKey);
            this.sessionParser.sessionKey(this.sessionKey);
            this.sessionParser.sequenceIndex(this.context.sequenceIndex());
            DebugLogger.log(LogTag.GATEWAY_MESSAGE, "Setup Session As: ", this.sessionKey.localCompId());
        }
        this.senderEndPoint.sessionId(this.sessionId);
    }

    public void onLogon(long sessionId, SessionContext context, CompositeKey sessionKey, String username, String password, int heartbeatIntervalInS, int logonReceivedSequenceNumber) {
        this.sessionId = sessionId;
        this.context = context;
        this.sessionKey = sessionKey;
        this.logonReceivedSequenceNumber = logonReceivedSequenceNumber;
        this.logonSequenceIndex = context.sequenceIndex();
        this.onLogon(username, password, heartbeatIntervalInS);
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    int heartbeatIntervalInS() {
        return this.heartbeatIntervalInS;
    }

    void acceptorSequenceNumbers(int retrievedSentSequenceNumber, int retrievedReceivedSequenceNumber) {
        if (this.session != null) {
            this.session.lastSentMsgSeqNum(GatewaySession.adjustLastSequenceNumber(retrievedSentSequenceNumber));
            int lastReceivedMsgSeqNum = GatewaySession.adjustLastSequenceNumber(retrievedReceivedSequenceNumber);
            this.session.initialLastReceivedMsgSeqNum(lastReceivedMsgSeqNum);
        }
    }

    void lastLogonWasSequenceReset() {
        this.lastSequenceResetTime(this.lastLogonTime);
    }

    static int adjustLastSequenceNumber(int lastSequenceNumber) {
        return lastSequenceNumber == -1 ? 0 : lastSequenceNumber;
    }

    public String toString() {
        return "GatewaySession{sessionId=" + this.sessionId + ", sessionKey=" + this.sessionKey + '}';
    }

    void disconnectAt(long disconnectTimeout) {
        this.disconnectTimeInMs = disconnectTimeout;
    }

    @Override
    public long bytesInBuffer() {
        return this.senderEndPoint.bytesInBuffer();
    }

    void close() {
        CloseHelper.close((AutoCloseable)this.session);
    }

    @Override
    public int sequenceIndex() {
        return this.context.sequenceIndex();
    }

    SlowStatus slowStatus() {
        return this.bytesInBuffer() > 0L ? SlowStatus.SLOW : SlowStatus.NOT_SLOW;
    }

    public boolean closedResendInterval() {
        return this.closedResendInterval;
    }

    public int resendRequestChunkSize() {
        return this.resendRequestChunkSize;
    }

    public boolean sendRedundantResendRequests() {
        return this.sendRedundantResendRequests;
    }

    public boolean enableLastMsgSeqNumProcessed() {
        return this.enableLastMsgSeqNumProcessed;
    }

    public SessionContext context() {
        return this.context;
    }

    boolean hasDisconnected() {
        return this.receiverEndPoint.hasDisconnected();
    }

    void initialResetSeqNum(boolean resetSeqNum) {
        this.initialResetSeqNum = resetSeqNum;
    }

    boolean initialResetSeqNum() {
        return this.initialResetSeqNum;
    }

    FixDictionary fixDictionary() {
        return this.fixDictionary;
    }

    void fixDictionary(FixDictionary fixDictionary) {
        this.fixDictionary = fixDictionary;
    }

    public int logonReceivedSequenceNumber() {
        return this.logonReceivedSequenceNumber;
    }

    public int logonSequenceIndex() {
        return this.logonSequenceIndex;
    }

    void updateSessionDictionary() {
        if (this.session != null) {
            this.session.fixDictionary(this.fixDictionary);
            this.sessionParser.fixDictionary(this.fixDictionary);
        }
    }

    long lastSequenceResetTime() {
        return this.lastSequenceResetTime;
    }

    void lastSequenceResetTime(long lastSequenceResetTime) {
        this.lastSequenceResetTime = lastSequenceResetTime;
        if (this.session != null) {
            this.session.lastSequenceResetTime(lastSequenceResetTime);
        }
    }

    long lastLogonTime() {
        return this.lastLogonTime;
    }

    void lastLogonTime(long lastLogonTime) {
        this.lastLogonTime = lastLogonTime;
        if (this.session != null) {
            this.session.lastLogonTime(lastLogonTime);
        }
    }

    public void libraryId(int libraryId) {
        this.libraryId = libraryId;
    }

    public int libraryId() {
        return this.libraryId;
    }

    public void consumeOfflineSession(GatewaySession oldGatewaySession) {
        this.libraryId(oldGatewaySession.libraryId());
    }

    public boolean isOffline() {
        return this.receiverEndPoint == null;
    }

    public void goOffline() {
        this.connectionId = -1L;
        this.address = ":-1";
        this.receiverEndPoint = null;
        this.senderEndPoint = null;
        this.onGatewaySessionLogon = null;
    }

    public long lastSentPosition() {
        return this.proxy.lastSentPosition();
    }
}

