/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import io.aeron.Aeron;
import io.aeron.archive.client.AeronArchive;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.agrona.collections.IntHashSet;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.ErrorConsumer;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.ErrorHandlerFactory;
import uk.co.real_logic.artio.MonitoringAgentFactory;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.DefaultEngineScheduler;
import uk.co.real_logic.artio.engine.EngineScheduler;
import uk.co.real_logic.artio.engine.ILink3RetransmitHandler;
import uk.co.real_logic.artio.engine.MappedFile;
import uk.co.real_logic.artio.engine.MessageTimingHandler;
import uk.co.real_logic.artio.engine.ReplayHandler;
import uk.co.real_logic.artio.engine.framer.DefaultTcpChannelSupplier;
import uk.co.real_logic.artio.engine.framer.TcpChannelSupplier;
import uk.co.real_logic.artio.messages.InitialAcceptedSessionOwner;
import uk.co.real_logic.artio.validation.AuthenticationStrategy;
import uk.co.real_logic.artio.validation.SessionPersistenceStrategy;

public final class EngineConfiguration
extends CommonConfiguration
implements AutoCloseable {
    public static final String LOG_FILE_DIR_PROP = "logging.dir";
    public static final String REPLAY_INDEX_FILE_SIZE_PROP = "logging.index.size";
    public static final String OUTBOUND_LIBRARY_FRAGMENT_LIMIT_PROP = "fix.core.outbound_fragment_limit";
    public static final String REPLAY_FRAGMENT_LIMIT_PROP = "fix.core.replay_fragment_limit";
    public static final String INBOUND_BYTES_RECEIVED_LIMIT_PROP = "fix.core.inbound_bytes_limit";
    public static final String RECEIVER_BUFFER_SIZE_PROP = "fix.core.receiver_buffer_size";
    public static final String RECEIVER_SOCKET_BUFFER_SIZE_PROP = "fix.core.receiver_socket_buffer_size";
    public static final String SENDER_SOCKET_BUFFER_SIZE_PROP = "fix.core.sender_socket_buffer_size";
    public static final String SEQUENCE_NUMBER_INDEX_SIZE_PROP = "fix.core.sequence_number_cache_size";
    public static final String SESSION_ID_BUFFER_SIZE_PROP = "fix.core.session_id_file_size";
    public static final String SENDER_MAX_BYTES_IN_BUFFER_PROP = "fix.core.sender_max_bytes_in_buffer";
    public static final String NO_LOGON_DISCONNECT_TIMEOUT_PROP = "fix.core.no_logon_disconnect";
    public static final String DEFAULT_LOG_FILE_DIR = "logs";
    public static final int DEFAULT_REPLAY_INDEX_FILE_SIZE = 2097176;
    public static final int DEFAULT_LOGGER_CACHE_NUM_SETS = 8;
    public static final int DEFAULT_LOGGER_CACHE_SET_SIZE = 4;
    public static final int DEFAULT_OUTBOUND_LIBRARY_FRAGMENT_LIMIT = 20;
    public static final int DEFAULT_REPLAY_FRAGMENT_LIMIT = 5;
    public static final int DEFAULT_INBOUND_BYTES_RECEIVED_LIMIT = 8192;
    public static final int DEFAULT_RECEIVER_BUFFER_SIZE = 16384;
    public static final int DEFAULT_RECEIVER_SOCKET_BUFFER_SIZE = 0x100000;
    public static final int DEFAULT_SENDER_SOCKET_BUFFER_SIZE = 0x100000;
    public static final int DEFAULT_SEQUENCE_NUMBER_INDEX_SIZE = 0x800000;
    public static final int DEFAULT_SESSION_ID_BUFFER_SIZE = 0x400000;
    public static final int DEFAULT_SENDER_MAX_BYTES_IN_BUFFER = 0x400000;
    public static final int DEFAULT_REPLAY_POSITION_BUFFER_SIZE = 4096;
    public static final int DEFAULT_NO_LOGON_DISCONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(5L);
    public static final String DEFAULT_SESSION_ID_FILE = "session_id_buffer";
    public static final String DEFAULT_ILINK3_ID_FILE = "ilink3_id_buffer";
    public static final String DEFAULT_SEQUENCE_NUMBERS_SENT_FILE = "sequence_numbers_sent";
    public static final String DEFAULT_SEQUENCE_NUMBERS_RECEIVED_FILE = "sequence_numbers_received";
    public static final long DEFAULT_SLOW_CONSUMER_TIMEOUT_IN_MS = 10000L;
    public static final ReplayHandler DEFAULT_REPLAY_HANDLER = (buffer, offset, length, libraryId, sessionId, sequenceIndex, messageType) -> {};
    public static final ILink3RetransmitHandler DEFAULT_ILINK3_RETRANSMIT_HANDLER = (templateId, buffer, offset, blockLength, version) -> {};
    public static final Set<String> DEFAULT_GAPFILL_ON_REPLAY_MESSAGE_TYPES;
    public static final long DEFAULT_INDEX_FILE_STATE_FLUSH_TIMEOUT_IN_MS = 10000L;
    public static final long DEFAULT_AUTHENTICATION_TIMEOUT_IN_MS = 60000L;
    public static final int DEFAULT_MAX_CONCURRENT_SESSION_REPLAYS = 5;
    public static final long DEFAULT_DUPLICATE_ENGINE_TIMEOUT_IN_MS;
    public static final int DEFAULT_OUTBOUND_REPLAY_STREAM = 3;
    public static final int DEFAULT_ARCHIVE_REPLAY_STREAM = 4;
    public static final int DEFAULT_ARCHIVE_SCANNER_STREAM = 5;
    public static final int DEFAULT_INITIAL_SEQUENCE_INDEX = 0;
    private String host = null;
    private int port;
    private int replayIndexFileSize = Integer.getInteger("logging.index.size", 2097176);
    private String logFileDir = System.getProperty("logging.dir", "logs");
    private int loggerCacheNumSets = 8;
    private int loggerCacheSetSize = 4;
    private boolean logInboundMessages = true;
    private boolean logOutboundMessages = true;
    private boolean printStartupWarnings = true;
    private IdleStrategy framerIdleStrategy = EngineConfiguration.backoffIdleStrategy();
    private IdleStrategy archiverIdleStrategy = EngineConfiguration.backoffIdleStrategy();
    private AtomicBuffer sentSequenceNumberBuffer;
    private AtomicBuffer receivedSequenceNumberBuffer;
    private MappedFile sentSequenceNumberIndex;
    private MappedFile receivedSequenceNumberIndex;
    private MappedFile sessionIdBuffer;
    private MappedFile iLink3IdBuffer;
    private Set<String> gapfillOnReplayMessageTypes = new HashSet<String>(DEFAULT_GAPFILL_ON_REPLAY_MESSAGE_TYPES);
    private IntHashSet gapfillOnRetransmitILinkTemplateIds = new IntHashSet();
    private final AeronArchive.Context archiveContext = new AeronArchive.Context();
    private AeronArchive.Context archiveContextClone;
    private Aeron.Context aeronContextClone;
    private int outboundLibraryFragmentLimit = Integer.getInteger("fix.core.outbound_fragment_limit", 20);
    private int replayFragmentLimit = Integer.getInteger("fix.core.replay_fragment_limit", 5);
    private int inboundBytesReceivedLimit = Integer.getInteger("fix.core.inbound_bytes_limit", 8192);
    private int receiverBufferSize = Integer.getInteger("fix.core.receiver_buffer_size", 16384);
    private int receiverSocketBufferSize = Integer.getInteger("fix.core.receiver_socket_buffer_size", 0x100000);
    private int senderSocketBufferSize = Integer.getInteger("fix.core.sender_socket_buffer_size", 0x100000);
    private final int sequenceNumberIndexSize = Integer.getInteger("fix.core.sequence_number_cache_size", 0x800000);
    private final int sessionIdBufferSize = Integer.getInteger("fix.core.session_id_file_size", 0x400000);
    private int senderMaxBytesInBuffer = Integer.getInteger("fix.core.sender_max_bytes_in_buffer", 0x400000);
    private int noLogonDisconnectTimeoutInMs = Integer.getInteger("fix.core.no_logon_disconnect", DEFAULT_NO_LOGON_DISCONNECT_TIMEOUT);
    private String libraryAeronChannel = null;
    private Function<EngineConfiguration, TcpChannelSupplier> channelSupplierFactory = DefaultTcpChannelSupplier::new;
    private SessionPersistenceStrategy sessionPersistenceStrategy;
    private long slowConsumerTimeoutInMs = 10000L;
    private EngineScheduler scheduler = new DefaultEngineScheduler();
    private ReplayHandler replayHandler = DEFAULT_REPLAY_HANDLER;
    private ILink3RetransmitHandler iLink3RetransmitHandler = DEFAULT_ILINK3_RETRANSMIT_HANDLER;
    private int outboundReplayStream = 3;
    private int archiveReplayStream = 4;
    private boolean acceptedSessionClosedResendInterval = false;
    private int acceptedSessionResendRequestChunkSize = 0;
    private boolean acceptedSessionSendRedundantResendRequests = false;
    private boolean acceptedEnableLastMsgSeqNumProcessed = false;
    private InitialAcceptedSessionOwner initialAcceptedSessionOwner = InitialAcceptedSessionOwner.ENGINE;
    private AuthenticationStrategy authenticationStrategy = AuthenticationStrategy.none();
    private long indexFileStateFlushTimeoutInMs = 10000L;
    private FixDictionary acceptorfixDictionary;
    private boolean lookupDefaultAcceptorfixDictionary = true;
    private final Map<String, FixDictionary> acceptorFixDictionaryOverrides = new HashMap<String, FixDictionary>();
    private boolean deleteLogFileDirOnStart = false;
    private long authenticationTimeoutInMs = 60000L;
    private boolean bindAtStartup = false;
    private int initialSequenceIndex = 0;
    private MessageTimingHandler messageTimingHandler = null;
    private int maxConcurrentSessionReplays = 5;
    private int replayPositionBufferSize = 4096;
    private long duplicateEngineTimeoutInMs = DEFAULT_DUPLICATE_ENGINE_TIMEOUT_IN_MS;
    private boolean errorIfDuplicateEngineDetected = true;
    private int inboundAdminStream = 21;
    private int outboundAdminStream = 22;

    public EngineConfiguration bindTo(String host, int port) {
        Objects.requireNonNull(host, "host");
        this.host = host;
        this.port = port;
        this.bindAtStartup(true);
        return this;
    }

    public EngineConfiguration bindAtStartup(boolean bindAtStartup) {
        this.bindAtStartup = bindAtStartup;
        return this;
    }

    public EngineConfiguration receiverBufferSize(int receiverBufferSize) {
        this.receiverBufferSize = receiverBufferSize;
        return this;
    }

    public EngineConfiguration receiverSocketBufferSize(int receiverSocketBufferSize) {
        this.receiverSocketBufferSize = receiverSocketBufferSize;
        return this;
    }

    public EngineConfiguration senderSocketBufferSize(int senderSocketBufferSize) {
        this.senderSocketBufferSize = senderSocketBufferSize;
        return this;
    }

    public EngineConfiguration logFileDir(String logFileDir) {
        this.logFileDir = logFileDir;
        return this;
    }

    public EngineConfiguration replayIndexFileSize(int indexFileSize) {
        this.replayIndexFileSize = indexFileSize;
        return this;
    }

    public EngineConfiguration loggerCacheSetSize(int loggerCacheSetSize) {
        this.loggerCacheSetSize = loggerCacheSetSize;
        return this;
    }

    public EngineConfiguration loggerCacheNumSets(int loggerCacheNumSets) {
        this.loggerCacheNumSets = loggerCacheNumSets;
        return this;
    }

    public EngineConfiguration logInboundMessages(boolean logInboundMessages) {
        this.logInboundMessages = logInboundMessages;
        return this;
    }

    public EngineConfiguration logOutboundMessages(boolean logOutboundMessages) {
        this.logOutboundMessages = logOutboundMessages;
        return this;
    }

    public EngineConfiguration printStartupWarnings(boolean printStartupWarnings) {
        this.printStartupWarnings = printStartupWarnings;
        return this;
    }

    public EngineConfiguration framerIdleStrategy(IdleStrategy framerIdleStrategy) {
        this.framerIdleStrategy = framerIdleStrategy;
        return this;
    }

    public EngineConfiguration archiverIdleStrategy(IdleStrategy archiverIdleStrategy) {
        this.archiverIdleStrategy = archiverIdleStrategy;
        return this;
    }

    public EngineConfiguration outboundLibraryFragmentLimit(int outboundLibraryFragmentLimit) {
        this.outboundLibraryFragmentLimit = outboundLibraryFragmentLimit;
        return this;
    }

    public EngineConfiguration replayFragmentLimit(int outboundReplayFragmentLimit) {
        this.replayFragmentLimit = outboundReplayFragmentLimit;
        return this;
    }

    public EngineConfiguration inboundBytesReceivedLimit(int inboundBytesReceivedLimit) {
        this.inboundBytesReceivedLimit = inboundBytesReceivedLimit;
        return this;
    }

    public EngineConfiguration senderMaxBytesInBuffer(int senderMaxBytesInBuffer) {
        this.senderMaxBytesInBuffer = senderMaxBytesInBuffer;
        return this;
    }

    public EngineConfiguration noLogonDisconnectTimeoutInMs(int noLogonDisconnectTimeout) {
        this.noLogonDisconnectTimeoutInMs = noLogonDisconnectTimeout;
        return this;
    }

    public EngineConfiguration channelSupplierFactory(Function<EngineConfiguration, TcpChannelSupplier> value) {
        this.channelSupplierFactory = value;
        return this;
    }

    public EngineConfiguration sessionPersistenceStrategy(SessionPersistenceStrategy sessionReplicationStrategy) {
        this.sessionPersistenceStrategy = sessionReplicationStrategy;
        return this;
    }

    public EngineConfiguration slowConsumerTimeoutInMs(long slowConsumerTimeoutInMs) {
        this.slowConsumerTimeoutInMs = slowConsumerTimeoutInMs;
        return this;
    }

    public EngineConfiguration scheduler(EngineScheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public EngineConfiguration gapfillOnReplayMessageTypes(Set<String> gapfillOnReplayMessageTypes) {
        this.gapfillOnReplayMessageTypes = gapfillOnReplayMessageTypes;
        return this;
    }

    public EngineConfiguration gapfillOnRetransmitILinkTemplateIds(IntHashSet gapfillOnRetransmitILinkTemplateIds) {
        this.gapfillOnRetransmitILinkTemplateIds = gapfillOnRetransmitILinkTemplateIds;
        return this;
    }

    public EngineConfiguration replayHandler(ReplayHandler replayHandler) {
        this.replayHandler = replayHandler;
        return this;
    }

    public EngineConfiguration iLink3RetransmitHandler(ILink3RetransmitHandler iLink3RetransmitHandler) {
        this.iLink3RetransmitHandler = iLink3RetransmitHandler;
        return this;
    }

    public EngineConfiguration outboundReplayStream(int outboundReplayStream) {
        this.outboundReplayStream = outboundReplayStream;
        return this;
    }

    public EngineConfiguration archiveReplayStream(int archiveReplayStream) {
        this.archiveReplayStream = archiveReplayStream;
        return this;
    }

    public EngineConfiguration acceptedSessionClosedResendInterval(boolean acceptedSessionClosedResendInterval) {
        this.acceptedSessionClosedResendInterval = acceptedSessionClosedResendInterval;
        return this;
    }

    public EngineConfiguration acceptedSessionResendRequestChunkSize(int acceptedSessionResendRequestChunkSize) {
        this.acceptedSessionResendRequestChunkSize = acceptedSessionResendRequestChunkSize;
        return this;
    }

    public EngineConfiguration acceptedSessionSendRedundantResendRequests(boolean acceptedSessionSendRedundantResendRequests) {
        this.acceptedSessionSendRedundantResendRequests = acceptedSessionSendRedundantResendRequests;
        return this;
    }

    public EngineConfiguration acceptedEnableLastMsgSeqNumProcessed(boolean acceptedEnableLastMsgSeqNumProcessed) {
        this.acceptedEnableLastMsgSeqNumProcessed = acceptedEnableLastMsgSeqNumProcessed;
        return this;
    }

    public EngineConfiguration initialAcceptedSessionOwner(InitialAcceptedSessionOwner initialAcceptedSessionOwner) {
        this.initialAcceptedSessionOwner = initialAcceptedSessionOwner;
        return this;
    }

    public EngineConfiguration libraryAeronChannel(String libraryAeronChannel) {
        this.libraryAeronChannel = libraryAeronChannel;
        return this;
    }

    public EngineConfiguration authenticationStrategy(AuthenticationStrategy authenticationStrategy) {
        this.authenticationStrategy = authenticationStrategy;
        return this;
    }

    public EngineConfiguration indexFileStateFlushTimeoutInMs(long indexFileStateFlushTimeoutInMs) {
        this.indexFileStateFlushTimeoutInMs = indexFileStateFlushTimeoutInMs;
        return this;
    }

    public EngineConfiguration acceptorfixDictionary(Class<? extends FixDictionary> acceptorfixDictionary) {
        this.acceptorfixDictionary = FixDictionary.of(acceptorfixDictionary);
        return this;
    }

    public EngineConfiguration lookupDefaultAcceptorfixDictionary(boolean lookupDefaultAcceptorfixDictionary) {
        this.lookupDefaultAcceptorfixDictionary = lookupDefaultAcceptorfixDictionary;
        return this;
    }

    public EngineConfiguration overrideAcceptorFixDictionary(Class<? extends FixDictionary> fixDictionaryClass) {
        FixDictionary dictionary = FixDictionary.of(fixDictionaryClass);
        this.acceptorFixDictionaryOverrides.put(dictionary.beginString(), dictionary);
        return this;
    }

    public EngineConfiguration deleteLogFileDirOnStart(boolean deleteLogFileDirOnStart) {
        this.deleteLogFileDirOnStart = deleteLogFileDirOnStart;
        return this;
    }

    public EngineConfiguration authenticationTimeoutInMs(long authenticationTimeoutInMs) {
        this.authenticationTimeoutInMs = authenticationTimeoutInMs;
        return this;
    }

    public EngineConfiguration messageTimingHandler(MessageTimingHandler messageTimingHandler) {
        this.messageTimingHandler = messageTimingHandler;
        return this;
    }

    public EngineConfiguration maxConcurrentSessionReplays(int maxConcurrentSessionReplays) {
        this.maxConcurrentSessionReplays = maxConcurrentSessionReplays;
        return this;
    }

    public EngineConfiguration initialSequenceIndex(int initialSequenceIndex) {
        this.initialSequenceIndex = initialSequenceIndex;
        return this;
    }

    public EngineConfiguration replayPositionBufferSize(int replayPositionBufferSize) {
        this.replayPositionBufferSize = replayPositionBufferSize;
        return this;
    }

    public EngineConfiguration duplicateEngineTimeoutInMs(long duplicateEngineTimeoutInMs) {
        this.duplicateEngineTimeoutInMs = duplicateEngineTimeoutInMs;
        return this;
    }

    public EngineConfiguration errorIfDuplicateEngineDetected(boolean errorIfDuplicateEngineDetected) {
        this.errorIfDuplicateEngineDetected = errorIfDuplicateEngineDetected;
        return this;
    }

    public int receiverBufferSize() {
        return this.receiverBufferSize;
    }

    public int receiverSocketBufferSize() {
        return this.receiverSocketBufferSize;
    }

    public int senderSocketBufferSize() {
        return this.senderSocketBufferSize;
    }

    public boolean hasBindAddress() {
        return this.host != null;
    }

    public InetSocketAddress bindAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public boolean bindAtStartup() {
        return this.bindAtStartup;
    }

    public String logFileDir() {
        return this.logFileDir;
    }

    public int replayIndexFileSize() {
        return this.replayIndexFileSize;
    }

    public int loggerCacheSetSize() {
        return this.loggerCacheSetSize;
    }

    public int loggerCacheNumSets() {
        return this.loggerCacheNumSets;
    }

    public boolean logInboundMessages() {
        return this.logInboundMessages;
    }

    public boolean logOutboundMessages() {
        return this.logOutboundMessages;
    }

    public boolean printStartupWarnings() {
        return this.printStartupWarnings;
    }

    boolean logAnyMessages() {
        return this.logInboundMessages || this.logOutboundMessages;
    }

    public boolean logAllMessages() {
        return this.logInboundMessages && this.logOutboundMessages;
    }

    public IdleStrategy framerIdleStrategy() {
        return this.framerIdleStrategy;
    }

    public IdleStrategy archiverIdleStrategy() {
        return this.archiverIdleStrategy;
    }

    public int outboundLibraryFragmentLimit() {
        return this.outboundLibraryFragmentLimit;
    }

    public int replayFragmentLimit() {
        return this.replayFragmentLimit;
    }

    public int inboundBytesReceivedLimit() {
        return this.inboundBytesReceivedLimit;
    }

    public MappedFile sentSequenceNumberIndex() {
        return this.sentSequenceNumberIndex;
    }

    public AtomicBuffer sentSequenceNumberBuffer() {
        return this.sentSequenceNumberBuffer;
    }

    public MappedFile receivedSequenceNumberIndex() {
        return this.receivedSequenceNumberIndex;
    }

    public AtomicBuffer receivedSequenceNumberBuffer() {
        return this.receivedSequenceNumberBuffer;
    }

    public MappedFile sessionIdBuffer() {
        return this.sessionIdBuffer;
    }

    public MappedFile iLink3IdBuffer() {
        if (this.iLink3IdBuffer == null) {
            this.iLink3IdBuffer = this.mapFile(DEFAULT_ILINK3_ID_FILE, this.sessionIdBufferSize);
        }
        return this.iLink3IdBuffer;
    }

    public Set<String> gapfillOnReplayMessageTypes() {
        return this.gapfillOnReplayMessageTypes;
    }

    public IntHashSet gapfillOnRetransmitILinkTemplateIds() {
        return this.gapfillOnRetransmitILinkTemplateIds;
    }

    public int senderMaxBytesInBuffer() {
        return this.senderMaxBytesInBuffer;
    }

    public int noLogonDisconnectTimeoutInMs() {
        return this.noLogonDisconnectTimeoutInMs;
    }

    public SessionPersistenceStrategy sessionPersistenceStrategy() {
        return this.sessionPersistenceStrategy;
    }

    public EngineScheduler scheduler() {
        return this.scheduler;
    }

    public long slowConsumerTimeoutInMs() {
        return this.slowConsumerTimeoutInMs;
    }

    public ReplayHandler replayHandler() {
        return this.replayHandler;
    }

    public ILink3RetransmitHandler iLink3RetransmitHandler() {
        return this.iLink3RetransmitHandler;
    }

    public InitialAcceptedSessionOwner initialAcceptedSessionOwner() {
        return this.initialAcceptedSessionOwner;
    }

    public AuthenticationStrategy authenticationStrategy() {
        return this.authenticationStrategy;
    }

    public long indexFileStateFlushTimeoutInMs() {
        return this.indexFileStateFlushTimeoutInMs;
    }

    public FixDictionary acceptorfixDictionary() {
        return this.acceptorfixDictionary;
    }

    public Map<String, FixDictionary> acceptorFixDictionaryOverrides() {
        return this.acceptorFixDictionaryOverrides;
    }

    public boolean deleteLogFileDirOnStart() {
        return this.deleteLogFileDirOnStart;
    }

    public long authenticationTimeoutInMs() {
        return this.authenticationTimeoutInMs;
    }

    public int initialSequenceIndex() {
        return this.initialSequenceIndex;
    }

    public int maxConcurrentSessionReplays() {
        return this.maxConcurrentSessionReplays;
    }

    public int replayPositionBufferSize() {
        return this.replayPositionBufferSize;
    }

    public long duplicateEngineTimeoutInMs() {
        return this.duplicateEngineTimeoutInMs;
    }

    public boolean errorIfDuplicateEngineDetected() {
        return this.errorIfDuplicateEngineDetected;
    }

    @Override
    public EngineConfiguration monitoringBuffersLength(Integer monitoringBuffersLength) {
        super.monitoringBuffersLength(monitoringBuffersLength);
        return this;
    }

    @Override
    public EngineConfiguration monitoringFile(String monitoringFile) {
        super.monitoringFile(monitoringFile);
        return this;
    }

    @Override
    public EngineConfiguration replyTimeoutInMs(long replyTimeoutInMs) {
        super.replyTimeoutInMs(replyTimeoutInMs);
        return this;
    }

    @Override
    public EngineConfiguration agentNamePrefix(String agentNamePrefix) {
        super.agentNamePrefix(agentNamePrefix);
        return this;
    }

    @Override
    public EngineConfiguration printAeronStreamIdentifiers(boolean printAeronStreamIdentifiers) {
        super.printAeronStreamIdentifiers(printAeronStreamIdentifiers);
        return this;
    }

    @Override
    public EngineConfiguration inboundLibraryStream(int inboundLibraryStream) {
        super.inboundLibraryStream(inboundLibraryStream);
        return this;
    }

    @Override
    public EngineConfiguration outboundLibraryStream(int outboundLibraryStream) {
        super.outboundLibraryStream(outboundLibraryStream);
        return this;
    }

    public EngineConfiguration inboundAdminStream(int inboundAdminStream) {
        this.inboundAdminStream = inboundAdminStream;
        return this;
    }

    public EngineConfiguration outboundAdminStream(int outboundAdminStream) {
        this.outboundAdminStream = outboundAdminStream;
        return this;
    }

    @Override
    @Deprecated
    public EngineConfiguration printErrorMessages(boolean printErrorMessages) {
        super.printErrorMessages(printErrorMessages);
        return this;
    }

    @Override
    @Deprecated
    public EngineConfiguration customErrorConsumer(ErrorConsumer customErrorConsumer) {
        super.customErrorConsumer(customErrorConsumer);
        return this;
    }

    @Override
    public EngineConfiguration errorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        super.errorHandlerFactory(errorHandlerFactory);
        return this;
    }

    @Override
    public EngineConfiguration monitoringAgentFactory(MonitoringAgentFactory monitoringAgentFactory) {
        super.monitoringAgentFactory(monitoringAgentFactory);
        return this;
    }

    @Override
    public EngineConfiguration defaultHeartbeatIntervalInS(int value) {
        super.defaultHeartbeatIntervalInS(value);
        return this;
    }

    public AeronArchive.Context aeronArchiveContext() {
        return this.archiveContext;
    }

    public Aeron.Context aeronContextClone() {
        return this.aeronContextClone;
    }

    public AeronArchive.Context archiveContextClone() {
        return this.archiveContextClone;
    }

    public int outboundReplayStream() {
        return this.outboundReplayStream;
    }

    public int archiveReplayStream() {
        return this.archiveReplayStream;
    }

    public boolean acceptedSessionClosedResendInterval() {
        return this.acceptedSessionClosedResendInterval;
    }

    public int acceptedSessionResendRequestChunkSize() {
        return this.acceptedSessionResendRequestChunkSize;
    }

    public boolean acceptedSessionSendRedundantResendRequests() {
        return this.acceptedSessionSendRedundantResendRequests;
    }

    public boolean acceptedEnableLastMsgSeqNumProcessed() {
        return this.acceptedEnableLastMsgSeqNumProcessed;
    }

    public MessageTimingHandler messageTimingHandler() {
        return this.messageTimingHandler;
    }

    public int inboundAdminStream() {
        return this.inboundAdminStream;
    }

    public int outboundAdminStream() {
        return this.outboundAdminStream;
    }

    public EngineConfiguration conclude() {
        File logFileDir;
        super.conclude("engine");
        if (this.libraryAeronChannel() == null) {
            throw new IllegalArgumentException("Missing required configuration: library aeron channel");
        }
        if (this.bindAtStartup() && !this.hasBindAddress()) {
            throw new IllegalArgumentException("If you're setting EngineConfiguration.bindAtStartup() then you must also specify an address to bind to using EngineConfiguration.bindTo(host,port)");
        }
        if (this.receiverBufferSize() < this.sessionBufferSize()) {
            throw new IllegalArgumentException(String.format("You cannot set the receiverBufferSize(%d) < sessionBufferSize(%d).this would allow you to encode messages that are larger than you can read.", this.receiverBufferSize(), this.sessionBufferSize()));
        }
        if (this.deleteLogFileDirOnStart() && (logFileDir = new File(this.logFileDir())).exists()) {
            IoUtil.delete((File)logFileDir, (boolean)false);
        }
        if (this.sentSequenceNumberIndex() == null) {
            this.sentSequenceNumberIndex = this.mapFile(DEFAULT_SEQUENCE_NUMBERS_SENT_FILE, this.sequenceNumberIndexSize);
        }
        if (this.sentSequenceNumberBuffer() == null) {
            this.sentSequenceNumberBuffer = new UnsafeBuffer(new byte[this.sequenceNumberIndexSize]);
        }
        if (this.receivedSequenceNumberIndex() == null) {
            this.receivedSequenceNumberIndex = this.mapFile(DEFAULT_SEQUENCE_NUMBERS_RECEIVED_FILE, this.sequenceNumberIndexSize);
        }
        if (this.receivedSequenceNumberBuffer() == null) {
            this.receivedSequenceNumberBuffer = new UnsafeBuffer(new byte[this.sequenceNumberIndexSize]);
        }
        if (this.sessionIdBuffer() == null) {
            this.sessionIdBuffer = this.mapFile(DEFAULT_SESSION_ID_FILE, this.sessionIdBufferSize);
        }
        if (this.sessionPersistenceStrategy() == null) {
            this.sessionPersistenceStrategy(SessionPersistenceStrategy.alwaysTransient());
        }
        if (this.lookupDefaultAcceptorfixDictionary && this.acceptorfixDictionary() == null) {
            this.acceptorfixDictionary(FixDictionary.findDefault());
        }
        this.aeronContextClone = this.aeronContext().clone();
        this.archiveContextClone = this.archiveContext.clone();
        return this;
    }

    private MappedFile mapFile(String file, int size) {
        return MappedFile.map(this.logFileDir() + File.separator + file, size);
    }

    public String libraryAeronChannel() {
        return this.libraryAeronChannel;
    }

    public TcpChannelSupplier channelSupplier() {
        return this.channelSupplierFactory.apply(this);
    }

    public boolean isRelevantStreamId(int streamId) {
        return streamId == this.outboundLibraryStream() && this.logOutboundMessages() || streamId == this.inboundLibraryStream() && this.logInboundMessages();
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.sentSequenceNumberIndex);
        CloseHelper.close((AutoCloseable)this.receivedSequenceNumberIndex);
        CloseHelper.close((AutoCloseable)this.sessionIdBuffer);
        CloseHelper.close((AutoCloseable)this.iLink3IdBuffer);
    }

    static {
        DEFAULT_DUPLICATE_ENGINE_TIMEOUT_IN_MS = TimeUnit.SECONDS.toMillis(10L);
        HashSet<String> defaultGapFillOnReplayMessageTypes = new HashSet<String>();
        defaultGapFillOnReplayMessageTypes.add("A");
        defaultGapFillOnReplayMessageTypes.add("5");
        defaultGapFillOnReplayMessageTypes.add("2");
        defaultGapFillOnReplayMessageTypes.add("0");
        defaultGapFillOnReplayMessageTypes.add("1");
        defaultGapFillOnReplayMessageTypes.add("4");
        DEFAULT_GAPFILL_ON_REPLAY_MESSAGE_TYPES = Collections.unmodifiableSet(defaultGapFillOnReplayMessageTypes);
    }
}

