/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.admin;

import java.util.Scanner;
import uk.co.real_logic.artio.admin.ArtioAdmin;
import uk.co.real_logic.artio.admin.ArtioAdminConfiguration;

public final class ArtioAdminTool {
    private static final String RESET_SEQUENCE_NUMBERS = "resetSequenceNumbers ";
    private static final String DISCONNECT = "disconnect ";

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        ArtioAdmin artioAdmin = ArtioAdmin.launch(new ArtioAdminConfiguration());
        Throwable throwable = null;
        try {
            try {
                System.out.println("Please type 'help' in order to see a list of available commands");
                while (true) {
                    String inputLine = scanner.nextLine();
                    try {
                        if (inputLine.equals("help")) {
                            ArtioAdminTool.printHelp();
                            continue;
                        }
                        if (inputLine.equals("printAllSessions")) {
                            artioAdmin.allFixSessions().forEach(System.out::println);
                            continue;
                        }
                        if (inputLine.equals("exit")) {
                            System.out.println("Bye");
                            System.exit(0);
                            continue;
                        }
                        if (inputLine.startsWith(RESET_SEQUENCE_NUMBERS)) {
                            ArtioAdminTool.resetSequenceNumbers(artioAdmin, inputLine);
                            continue;
                        }
                        if (inputLine.startsWith(DISCONNECT)) {
                            ArtioAdminTool.disconnectSession(artioAdmin, inputLine);
                            continue;
                        }
                        ArtioAdminTool.printUnknownCommand(inputLine);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (artioAdmin != null) {
                if (throwable != null) {
                    try {
                        artioAdmin.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    artioAdmin.close();
                }
            }
            throw throwable3;
        }
    }

    private static void disconnectSession(ArtioAdmin artioAdmin, String inputLine) {
        int sessionId = Integer.parseInt(inputLine.substring(DISCONNECT.length()));
        artioAdmin.disconnectSession(sessionId);
        System.out.println("Disconnected " + sessionId);
    }

    private static void resetSequenceNumbers(ArtioAdmin artioAdmin, String inputLine) {
        int sessionId = Integer.parseInt(inputLine.substring(RESET_SEQUENCE_NUMBERS.length()));
        artioAdmin.resetSequenceNumbers(sessionId);
        System.out.println("Reset sequence numbers for " + sessionId);
    }

    private static void printUnknownCommand(String inputLine) {
        System.out.println("Unknown command: '" + inputLine + '\'');
        ArtioAdminTool.printHelp();
    }

    private static void printHelp() {
        System.out.println("'help'                     - prints this output");
        System.out.println("'printAllSessions'         - prints a list of all the known FIX sessions");
        System.out.println("'resetSequenceNumbers <N>' - reset the sequence numbers of the session with sessionId=<N>");
        System.out.println("'disconnect <N>'           - disconnect the session with sessionId=<N>");
        System.out.println("'exit'                     - exit the tool");
    }
}

