/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.admin;

import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.admin.AdminEndPointHandler;
import uk.co.real_logic.artio.messages.AllFixSessionsReplyDecoder;
import uk.co.real_logic.artio.messages.GenericAdminReplyDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;

class AdminApiProtocolSubscription
implements FragmentHandler {
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final AllFixSessionsReplyDecoder allFixSessionsReply = new AllFixSessionsReplyDecoder();
    private final GenericAdminReplyDecoder genericAdminReply = new GenericAdminReplyDecoder();
    private final AdminEndPointHandler handler;

    AdminApiProtocolSubscription(AdminEndPointHandler handler) {
        this.handler = handler;
    }

    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        MessageHeaderDecoder messageHeader = this.messageHeader;
        messageHeader.wrap(buffer, offset);
        int blockLength = messageHeader.blockLength();
        int version = messageHeader.version();
        offset += messageHeader.encodedLength();
        switch (messageHeader.templateId()) {
            case 63: {
                this.onAllFixSessionsReply(buffer, offset, blockLength, version);
                return;
            }
            case 65: {
                this.onGenericAdminReply(buffer, offset, blockLength, version);
                return;
            }
        }
    }

    private void onAllFixSessionsReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        AllFixSessionsReplyDecoder allFixSessionsReply = this.allFixSessionsReply;
        allFixSessionsReply.wrap(buffer, offset, blockLength, version);
        this.handler.onAllFixSessionsReply(allFixSessionsReply.correlationId(), allFixSessionsReply.sessions());
    }

    private void onGenericAdminReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        GenericAdminReplyDecoder genericAdminReply = this.genericAdminReply;
        genericAdminReply.wrap(buffer, offset, blockLength, version);
        this.handler.onGenericAdminReply(genericAdminReply.correlationId(), genericAdminReply.errorType(), genericAdminReply.message());
    }
}

