/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import java.util.concurrent.locks.LockSupport;

public interface Reply<T> {
    public static <T> Reply<T> await(Reply<T> reply) {
        while (reply.isExecuting()) {
            LockSupport.parkNanos(1000000L);
        }
        return reply;
    }

    default public boolean isExecuting() {
        return this.state() == State.EXECUTING;
    }

    default public boolean hasTimedOut() {
        return this.state() == State.TIMED_OUT;
    }

    default public boolean hasErrored() {
        return this.state() == State.ERRORED;
    }

    default public boolean hasCompleted() {
        return this.state() == State.COMPLETED;
    }

    public Exception error();

    public T resultIfPresent();

    public State state();

    public static enum State {
        EXECUTING,
        TIMED_OUT,
        ERRORED,
        COMPLETED;

    }
}

