/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.protocol;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.framer.MessageTypeExtractor;
import uk.co.real_logic.artio.messages.DisconnectDecoder;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.ILinkMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.protocol.ProtocolHandler;
import uk.co.real_logic.artio.util.CharFormatter;

public final class ProtocolSubscription
implements ControlledFragmentHandler {
    private static final ControlledFragmentHandler.Action UNKNOWN_TEMPLATE = null;
    private final CharFormatter disconnectFormatter = new CharFormatter("FixSubscription Disconnect: %s [%s]%n");
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final DisconnectDecoder disconnect = new DisconnectDecoder();
    private final FixMessageDecoder messageFrame = new FixMessageDecoder();
    private final ILinkMessageDecoder iLinkMessage = new ILinkMessageDecoder();
    private final ProtocolHandler protocolHandler;
    private final ControlledFragmentHandler.Action defaultAction;

    public static ProtocolSubscription of(ProtocolHandler protocolHandler) {
        return new ProtocolSubscription(protocolHandler, ControlledFragmentHandler.Action.CONTINUE);
    }

    public static ControlledFragmentHandler of(ProtocolHandler protocolHandler, ControlledFragmentHandler other) {
        ProtocolSubscription subscription = new ProtocolSubscription(protocolHandler, UNKNOWN_TEMPLATE);
        return (buffer, offset, length, header) -> {
            ControlledFragmentHandler.Action action = subscription.onFragment(buffer, offset, length, header);
            if (action == UNKNOWN_TEMPLATE) {
                return other.onFragment(buffer, offset, length, header);
            }
            return action;
        };
    }

    private ProtocolSubscription(ProtocolHandler protocolHandler, ControlledFragmentHandler.Action defaultAction) {
        this.protocolHandler = protocolHandler;
        this.defaultAction = defaultAction;
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        return this.onFragment(buffer, offset, length, header.position());
    }

    private ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, long position) {
        this.messageHeader.wrap(buffer, offset);
        int blockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        offset += 8;
        switch (this.messageHeader.templateId()) {
            case 1: {
                return this.onFixMessage(buffer, offset, blockLength, version, position);
            }
            case 7: {
                return this.onDisconnect(buffer, offset, blockLength, version);
            }
            case 58: {
                return this.onILinkMessage(buffer, offset, blockLength, version);
            }
        }
        return this.defaultAction;
    }

    private ControlledFragmentHandler.Action onILinkMessage(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.iLinkMessage.wrap(buffer, offset, blockLength, version);
        long connectionId = this.iLinkMessage.connection();
        return this.protocolHandler.onILinkMessage(connectionId, buffer, offset + 16);
    }

    private ControlledFragmentHandler.Action onDisconnect(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.disconnect.wrap(buffer, offset, blockLength, version);
        int libraryId = this.disconnect.libraryId();
        long connectionId = this.disconnect.connection();
        DisconnectReason reason = this.disconnect.reason();
        if (DebugLogger.isEnabled(LogTag.FIX_CONNECTION)) {
            DebugLogger.log(LogTag.FIX_CONNECTION, this.disconnectFormatter.clear().with(connectionId).with(reason.toString()));
        }
        return this.protocolHandler.onDisconnect(libraryId, connectionId, reason);
    }

    private ControlledFragmentHandler.Action onFixMessage(DirectBuffer buffer, int offset, int blockLength, int version, long position) {
        this.messageFrame.wrap(buffer, offset, blockLength, version);
        int metaDataLength = this.messageFrame.skipMetaData();
        int messageLength = this.messageFrame.bodyLength();
        long messageType = MessageTypeExtractor.getMessageType(this.messageFrame);
        return this.protocolHandler.onMessage(buffer, offset + GatewayPublication.FRAME_SIZE + metaDataLength, messageLength, this.messageFrame.libraryId(), this.messageFrame.connection(), this.messageFrame.session(), this.messageFrame.sequenceIndex(), messageType, this.messageFrame.timestamp(), this.messageFrame.status(), this.messageFrame.sequenceNumber(), position, metaDataLength);
    }
}

