/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.logger.MessageTracker;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.util.CharFormatter;

public class FixMessageTracker
extends MessageTracker {
    private final FixMessageDecoder messageDecoder = new FixMessageDecoder();
    private final long sessionId;

    public FixMessageTracker(LogTag logTag, ControlledFragmentHandler messageHandler, long sessionId) {
        super(logTag, messageHandler);
        this.sessionId = sessionId;
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        if (this.messageHeaderDecoder.templateId() == 1) {
            ControlledFragmentHandler.Action action;
            int messageOffset = offset + 8;
            if (this.sessionId != -1L) {
                this.messageDecoder.wrap(buffer, messageOffset, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                if (this.messageDecoder.session() != this.sessionId) {
                    return ControlledFragmentHandler.Action.CONTINUE;
                }
            }
            if (DebugLogger.isEnabled(this.logTag)) {
                this.messageDecoder.skipMetaData();
                int bodyLength = this.messageDecoder.bodyLength();
                int bodyOffset = this.messageDecoder.limit();
                CharFormatter formatter = (CharFormatter)FOUND_REPLAY_MESSAGE.get();
                formatter.clear();
                DebugLogger.log(this.logTag, formatter, buffer, bodyOffset, bodyLength);
            }
            if ((action = this.messageHandler.onFragment(buffer, offset, length, header)) != ControlledFragmentHandler.Action.ABORT) {
                ++this.count;
            }
            return action;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

