/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Aeron;
import io.aeron.FragmentAssembler;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.logbuffer.FragmentHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.agrona.collections.IntHashSet;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.engine.logger.FixMessageConsumer;
import uk.co.real_logic.artio.engine.logger.StreamTimestampZipper;
import uk.co.real_logic.artio.ilink.ILinkMessageConsumer;

public class FixArchiveScanner
implements AutoCloseable {
    private static final int FRAGMENT_LIMIT = 10;
    private static final ReversePositionComparator BY_REVERSE_POSITION = new ReversePositionComparator();
    private final Aeron aeron;
    private final AeronArchive aeronArchive;
    private final IdleStrategy idleStrategy;
    private final int compactionSize;

    public FixArchiveScanner(Configuration configuration) {
        this.idleStrategy = configuration.idleStrategy();
        this.compactionSize = configuration.compactionSize;
        Aeron.Context aeronContext = new Aeron.Context().aeronDirectoryName(configuration.aeronDirectoryName());
        this.aeron = Aeron.connect((Aeron.Context)aeronContext);
        this.aeronArchive = AeronArchive.connect((AeronArchive.Context)new AeronArchive.Context().aeron(this.aeron).ownsAeronClient(true));
    }

    public void scan(String aeronChannel, int queryStreamId, FixMessageConsumer handler, boolean follow, int archiveScannerStreamId) {
        this.scan(aeronChannel, queryStreamId, handler, null, follow, archiveScannerStreamId);
    }

    public void scan(String aeronChannel, int queryStreamId, FixMessageConsumer fixHandler, ILinkMessageConsumer iLinkHandler, boolean follow, int archiveScannerStreamId) {
        IntHashSet queryStreamIds = new IntHashSet();
        queryStreamIds.add(queryStreamId);
        this.scan(aeronChannel, queryStreamIds, fixHandler, iLinkHandler, follow, archiveScannerStreamId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scan(String aeronChannel, IntHashSet queryStreamIds, FixMessageConsumer fixHandler, ILinkMessageConsumer iLinkHandler, boolean follow, int archiveScannerStreamId) {
        try (Subscription replaySubscription = this.aeron.addSubscription("aeron:ipc", archiveScannerStreamId);){
            StreamTimestampZipper.Poller[] pollers = (RecordingPoller[])queryStreamIds.stream().map(id -> this.makePoller((int)id, replaySubscription, follow, aeronChannel)).toArray(RecordingPoller[]::new);
            StreamTimestampZipper timestampZipper = new StreamTimestampZipper(fixHandler, iLinkHandler, this.compactionSize, pollers);
            while (true) {
                int received;
                if (0 == (received = timestampZipper.poll()) && !follow && this.checkCompletion((RecordingPoller[])pollers)) {
                    timestampZipper.onClose();
                    this.idleStrategy.reset();
                    return;
                }
                this.idleStrategy.idle(received);
                continue;
                break;
            }
        }
    }

    private boolean checkCompletion(RecordingPoller[] pollers) {
        for (RecordingPoller poller : pollers) {
            if (poller.isComplete()) continue;
            return false;
        }
        return true;
    }

    private RecordingPoller makePoller(int queryStreamId, Subscription replaySubscription, boolean follow, String aeronChannel) {
        ArrayList<ArchiveLocation> archiveLocations = new ArrayList<ArchiveLocation>();
        this.aeronArchive.listRecordingsForUri(0L, Integer.MAX_VALUE, aeronChannel, queryStreamId, (controlSessionId, correlationId, recordingId, startTimestamp, stopTimestamp, startPosition, stopPosition, initialTermId, segmentFileLength, termBufferLength, mtuLength, sessionId, streamId, strippedChannel, originalChannel, sourceIdentity) -> archiveLocations.add(new ArchiveLocation(recordingId, startPosition, stopPosition)));
        if (!follow) {
            for (ArchiveLocation location : archiveLocations) {
                if (location.stopPosition != -1L) continue;
                location.stopPosition = this.aeronArchive.getRecordingPosition(location.recordingId);
            }
        }
        archiveLocations.sort(BY_REVERSE_POSITION);
        return new RecordingPoller(replaySubscription, queryStreamId, archiveLocations);
    }

    @Override
    public void close() {
        this.aeronArchive.close();
    }

    class RecordingPoller
    implements StreamTimestampZipper.Poller {
        private final List<ArchiveLocation> archiveLocations;
        private final Subscription replaySubscription;
        private final int streamId;
        long stopPosition;
        Image image;

        RecordingPoller(Subscription replaySubscription, int streamId, List<ArchiveLocation> archiveLocations) {
            this.replaySubscription = replaySubscription;
            this.streamId = streamId;
            this.archiveLocations = archiveLocations;
        }

        boolean isComplete() {
            return this.stopPosition != -1L && this.image == null && this.archiveLocations.isEmpty();
        }

        @Override
        public int poll(FragmentAssembler fragmentAssembler) {
            if (this.image == null) {
                if (this.archiveLocations.isEmpty()) {
                    return 0;
                }
                ArchiveLocation archiveLocation = this.archiveLocations.remove(this.archiveLocations.size() - 1);
                if (archiveLocation.length() != 0L) {
                    int sessionId = (int)FixArchiveScanner.this.aeronArchive.startReplay(archiveLocation.recordingId, archiveLocation.startPosition, archiveLocation.length(), "aeron:ipc", this.replaySubscription.streamId());
                    this.image = this.lookupImage(sessionId);
                    this.stopPosition = archiveLocation.stopPosition;
                }
                return 1;
            }
            if (this.image.position() >= this.stopPosition) {
                this.image = null;
                return 1;
            }
            return this.image.poll((FragmentHandler)fragmentAssembler, 10);
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        private Image lookupImage(int sessionId) {
            Image image = null;
            while (image == null) {
                FixArchiveScanner.this.idleStrategy.idle();
                image = this.replaySubscription.imageBySessionId(sessionId);
            }
            FixArchiveScanner.this.idleStrategy.reset();
            return image;
        }
    }

    static class ArchiveLocation {
        final long recordingId;
        final long startPosition;
        long stopPosition;

        ArchiveLocation(long recordingId, long startPosition, long stopPosition) {
            this.recordingId = recordingId;
            this.startPosition = startPosition;
            this.stopPosition = stopPosition;
        }

        public long stopPosition() {
            return this.stopPosition;
        }

        public long length() {
            return this.startPosition == -1L ? -1L : this.stopPosition - this.startPosition;
        }

        public String toString() {
            return "ArchiveReplayInfo{recordingId=" + this.recordingId + ", startPosition=" + this.startPosition + ", stopPosition=" + this.stopPosition + '}';
        }
    }

    static class ReversePositionComparator
    implements Comparator<ArchiveLocation> {
        ReversePositionComparator() {
        }

        @Override
        public int compare(ArchiveLocation archiveLocation1, ArchiveLocation archiveLocation2) {
            return -1 * Long.compare(this.getStopPosition(archiveLocation1), this.getStopPosition(archiveLocation2));
        }

        long getStopPosition(ArchiveLocation archiveLocation) {
            long stopPosition = archiveLocation.stopPosition;
            return stopPosition == -1L ? Long.MAX_VALUE : stopPosition;
        }
    }

    public static class Configuration {
        private String aeronDirectoryName;
        private IdleStrategy idleStrategy;
        private int compactionSize = 65536;

        public Configuration aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Configuration idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Configuration compactionSize(int compactionSize) {
            this.compactionSize = compactionSize;
            return this;
        }

        public int compactionSize() {
            return this.compactionSize;
        }
    }
}

