/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.MessageTimingHandler;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.ilink.AbstractILink3Offsets;
import uk.co.real_logic.artio.ilink.SimpleOpenFramingHeader;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.ReplayCompleteEncoder;

public class ILink3SenderEndPoint {
    private static final int NO_REATTEMPT = 0;
    private static final int REPLAY_COMPLETE_LENGTH = 20;
    private final MessageHeaderEncoder messageHeader = new MessageHeaderEncoder();
    private final ReplayCompleteEncoder replayComplete = new ReplayCompleteEncoder();
    private final BufferClaim bufferClaim = new BufferClaim();
    private final long connectionId;
    private final TcpChannel channel;
    private final ErrorHandler errorHandler;
    private final ExclusivePublication inboundPublication;
    private final int libraryId;
    private final MessageTimingHandler messageTimingHandler;
    private int reattemptBytesWritten = 0;

    public ILink3SenderEndPoint(long connectionId, TcpChannel channel, ErrorHandler errorHandler, ExclusivePublication inboundPublication, int libraryId, MessageTimingHandler messageTimingHandler) {
        this.connectionId = connectionId;
        this.channel = channel;
        this.errorHandler = errorHandler;
        this.inboundPublication = inboundPublication;
        this.libraryId = libraryId;
        this.messageTimingHandler = messageTimingHandler;
    }

    public ControlledFragmentHandler.Action onMessage(DirectBuffer directBuffer, int offset) {
        int messageSize = SimpleOpenFramingHeader.readSofhMessageSize((DirectBuffer)directBuffer, (int)offset);
        int reattemptBytesWritten = this.reattemptBytesWritten;
        ByteBuffer buffer = directBuffer.byteBuffer();
        int startLimit = buffer.limit();
        int startPosition = buffer.position();
        ByteBufferUtil.limit(buffer, offset + messageSize);
        ByteBufferUtil.position(buffer, reattemptBytesWritten + offset);
        try {
            int sbeHeaderOffset;
            long sequenceNumber;
            int totalWritten;
            int written = this.channel.write(buffer);
            if (written > 0) {
                ByteBufferUtil.position(buffer, offset);
                DebugLogger.logBytes(LogTag.FIX_MESSAGE_TCP, "Written  ", buffer, startPosition, written);
                buffer.limit(startLimit).position(startPosition);
            }
            if ((totalWritten = reattemptBytesWritten + written) < messageSize) {
                this.reattemptBytesWritten = totalWritten;
                return ControlledFragmentHandler.Action.ABORT;
            }
            if (this.messageTimingHandler != null && (sequenceNumber = AbstractILink3Offsets.clientSeqNum((DirectBuffer)directBuffer, (int)(sbeHeaderOffset = offset + 4))) != -1L) {
                this.messageTimingHandler.onMessage(sequenceNumber, this.connectionId);
            }
            this.reattemptBytesWritten = 0;
        }
        catch (IOException e) {
            this.errorHandler.onError((Throwable)e);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public long connectionId() {
        return this.connectionId;
    }

    public ControlledFragmentHandler.Action onReplayComplete(long connectionId) {
        BufferClaim bufferClaim = this.bufferClaim;
        long position = this.inboundPublication.tryClaim(20, bufferClaim);
        if (Pressure.isBackPressured(position)) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.replayComplete.wrapAndApplyHeader(bufferClaim.buffer(), bufferClaim.offset(), this.messageHeader).connection(connectionId).libraryId(this.libraryId);
        bufferClaim.commit();
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

