/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.engine.MappedFile;
import uk.co.real_logic.artio.engine.framer.ILink3Context;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.storage.messages.ILink3ContextDecoder;
import uk.co.real_logic.artio.storage.messages.ILink3ContextEncoder;

class ILink3Contexts {
    private final Map<ILink3Key, ILink3Context> keyToContext = new HashMap<ILink3Key, ILink3Context>();
    private final MappedFile mappedFile;
    private final AtomicBuffer buffer;
    private final ErrorHandler errorHandler;
    private final EpochNanoClock epochNanoClock;
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final ILink3ContextEncoder contextEncoder = new ILink3ContextEncoder();
    private final ILink3ContextDecoder contextDecoder = new ILink3ContextDecoder();
    private final int actingBlockLength = this.contextEncoder.sbeBlockLength();
    private final int actingVersion = this.contextEncoder.sbeSchemaVersion();
    private int offset;

    ILink3Contexts(MappedFile mappedFile, ErrorHandler errorHandler, EpochNanoClock epochNanoClock) {
        this.mappedFile = mappedFile;
        this.buffer = mappedFile.buffer();
        this.errorHandler = errorHandler;
        this.epochNanoClock = epochNanoClock;
        this.loadBuffer();
    }

    private void loadBuffer() {
        if (LoggerUtil.initialiseBuffer(this.buffer, this.headerEncoder, this.headerDecoder, this.contextEncoder.sbeSchemaId(), this.contextEncoder.sbeTemplateId(), this.actingVersion, this.actingBlockLength, this.errorHandler)) {
            this.mappedFile.force();
        }
        this.offset = 8;
        int capacity = this.buffer.capacity();
        while (this.offset < capacity) {
            this.contextDecoder.wrap((DirectBuffer)this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
            long uuid = this.contextDecoder.uuid();
            if (uuid == 0L) break;
            int port = this.contextDecoder.port();
            String host = this.contextDecoder.host();
            String accessKeyId = this.contextDecoder.accessKeyId();
            this.keyToContext.put(new ILink3Key(port, host, accessKeyId), new ILink3Context(this, uuid, 0L, uuid, 0L, false, this.offset));
            this.offset = this.contextDecoder.limit();
        }
    }

    ILink3Context calculateUuid(int port, String host, String accessKeyId, boolean reestablishConnection) {
        ILink3Key key = new ILink3Key(port, host, accessKeyId);
        ILink3Context context = this.keyToContext.get(key);
        if (context != null) {
            long connectLastUuid = context.uuid();
            context.connectLastUuid(connectLastUuid);
            boolean newlyAllocated = !reestablishConnection || connectLastUuid == 0L;
            context.newlyAllocated(newlyAllocated);
            if (newlyAllocated) {
                long newUuid = this.microSecondTimestamp();
                context.connectUuid(newUuid);
            } else {
                context.connectUuid(connectLastUuid);
            }
            return context;
        }
        return this.allocateUuid(key);
    }

    private ILink3Context allocateUuid(ILink3Key key) {
        ILink3Context context = this.newUuid();
        this.keyToContext.put(key, context);
        return context;
    }

    private ILink3Context newUuid() {
        long newUuid = this.microSecondTimestamp();
        return new ILink3Context(this, 0L, 0L, newUuid, 0L, true, this.offset);
    }

    void updateUuid(ILink3Context context) {
        this.contextEncoder.wrap((MutableDirectBuffer)this.buffer, context.offset()).uuid(context.uuid());
    }

    void saveNewUuid(ILink3Context context) {
        ILink3Key key = null;
        for (Map.Entry<ILink3Key, ILink3Context> entry : this.keyToContext.entrySet()) {
            if (entry.getValue() != context) continue;
            key = entry.getKey();
            break;
        }
        if (null == key) {
            throw new IllegalStateException("expected to find key");
        }
        this.contextEncoder.wrap((MutableDirectBuffer)this.buffer, this.offset).uuid(context.uuid()).port(key.port).host(key.host).accessKeyId(key.accessKeyId);
        this.offset = this.contextEncoder.limit();
    }

    private long microSecondTimestamp() {
        return this.epochNanoClock.nanoTime();
    }

    int offset() {
        return this.offset;
    }

    public void close() {
        this.mappedFile.close();
    }

    private static final class ILink3Key {
        private final int port;
        private final String host;
        private final String accessKeyId;

        private ILink3Key(int port, String host, String accessKeyId) {
            this.port = port;
            this.host = host;
            this.accessKeyId = accessKeyId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ILink3Key iLink3Key = (ILink3Key)o;
            if (this.port != iLink3Key.port) {
                return false;
            }
            if (!Objects.equals(this.host, iLink3Key.host)) {
                return false;
            }
            return Objects.equals(this.accessKeyId, iLink3Key.accessKeyId);
        }

        public int hashCode() {
            int result = this.port;
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + (this.accessKeyId != null ? this.accessKeyId.hashCode() : 0);
            return result;
        }
    }
}

