/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.Image;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.agrona.concurrent.QueuedPipe;
import org.agrona.concurrent.SystemEpochClock;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.EngineContext;
import uk.co.real_logic.artio.engine.RecordingCoordinator;
import uk.co.real_logic.artio.engine.SessionInfo;
import uk.co.real_logic.artio.engine.framer.AdminCommand;
import uk.co.real_logic.artio.engine.framer.BindCommand;
import uk.co.real_logic.artio.engine.framer.DisconnectAllCommand;
import uk.co.real_logic.artio.engine.framer.EndPointFactory;
import uk.co.real_logic.artio.engine.framer.FinalImagePositions;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.LibraryInfo;
import uk.co.real_logic.artio.engine.framer.LookupSessionIdCommand;
import uk.co.real_logic.artio.engine.framer.QueryLibrariesCommand;
import uk.co.real_logic.artio.engine.framer.ResetSequenceNumberCommand;
import uk.co.real_logic.artio.engine.framer.ResetSessionIdsCommand;
import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.engine.framer.UnbindCommand;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.protocol.Streams;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.timing.EngineTimers;

public class FramerContext {
    private static final int ADMIN_COMMAND_CAPACITY = 64;
    private final QueuedPipe<AdminCommand> adminCommands = new ManyToOneConcurrentArrayQueue(64);
    private final SystemEpochClock epochClock = new SystemEpochClock();
    private final Framer framer;
    private final EngineConfiguration configuration;
    private final GatewaySessions gatewaySessions;
    private final SequenceNumberIndexReader sentSequenceNumberIndex;
    private final SequenceNumberIndexReader receivedSequenceNumberIndex;
    private final GatewayPublication outboundPublication;
    private final GatewayPublication inboundPublication;
    private final SessionContexts sessionContexts;

    public FramerContext(EngineConfiguration configuration, FixCounters fixCounters, EngineContext engineContext, ErrorHandler errorHandler, Image replayImage, Image slowReplayImage, EngineTimers timers, AgentInvoker conductorAgentInvoker, RecordingCoordinator recordingCoordinator) {
        this.configuration = configuration;
        SessionIdStrategy sessionIdStrategy = configuration.sessionIdStrategy();
        IdleStrategy idleStrategy = configuration.framerIdleStrategy();
        Streams outboundLibraryStreams = engineContext.outboundLibraryStreams();
        this.sessionContexts = new SessionContexts(configuration.sessionIdBuffer(), sessionIdStrategy, configuration.initialSequenceIndex(), errorHandler);
        this.inboundPublication = engineContext.inboundPublication();
        this.outboundPublication = outboundLibraryStreams.gatewayPublication(idleStrategy, outboundLibraryStreams.dataPublication("outboundPublication"));
        this.sentSequenceNumberIndex = new SequenceNumberIndexReader(configuration.sentSequenceNumberBuffer(), errorHandler, recordingCoordinator.framerOutboundLookup(), configuration.logFileDir());
        this.receivedSequenceNumberIndex = new SequenceNumberIndexReader(configuration.receivedSequenceNumberBuffer(), errorHandler, recordingCoordinator.framerInboundLookup(), null);
        this.gatewaySessions = new GatewaySessions((EpochClock)this.epochClock, this.inboundPublication, this.outboundPublication, sessionIdStrategy, configuration.sessionCustomisationStrategy(), fixCounters, configuration, errorHandler, this.sessionContexts, configuration.sessionPersistenceStrategy(), this.sentSequenceNumberIndex, this.receivedSequenceNumberIndex, configuration.sessionEpochFractionFormat());
        EndPointFactory endPointFactory = new EndPointFactory(configuration, this.sessionContexts, this.inboundPublication, fixCounters, errorHandler, this.gatewaySessions, engineContext.senderSequenceNumbers(), configuration.messageTimingHandler());
        FinalImagePositions finalImagePositions = new FinalImagePositions();
        this.framer = new Framer((EpochClock)this.epochClock, timers.outboundTimer(), timers.sendTimer(), configuration, endPointFactory, engineContext.outboundLibrarySubscription("outboundLibrarySubscription", finalImagePositions), engineContext.outboundLibrarySubscription("outboundSlowSubscription", null), replayImage, slowReplayImage, engineContext.inboundReplayQuery(), this.outboundPublication, this.inboundPublication, this.adminCommands, sessionIdStrategy, this.sessionContexts, this.sentSequenceNumberIndex, this.receivedSequenceNumberIndex, this.gatewaySessions, errorHandler, configuration.agentNamePrefix(), engineContext.inboundCompletionPosition(), engineContext.outboundLibraryCompletionPosition(), finalImagePositions, conductorAgentInvoker, recordingCoordinator);
    }

    public Agent framer() {
        return this.framer;
    }

    public Reply<List<LibraryInfo>> libraries() {
        QueryLibrariesCommand reply = new QueryLibrariesCommand();
        if (this.adminCommands.offer((Object)reply)) {
            return reply;
        }
        return null;
    }

    public Reply<?> resetSequenceNumber(long sessionId) {
        ResetSequenceNumberCommand reply = new ResetSequenceNumberCommand(sessionId, this.gatewaySessions, this.sessionContexts, this.receivedSequenceNumberIndex, this.sentSequenceNumberIndex, this.inboundPublication, this.outboundPublication, this.epochClock.time());
        if (this.adminCommands.offer((Object)reply)) {
            return reply;
        }
        return null;
    }

    public Reply<?> resetSessionIds(File backupLocation) {
        ResetSessionIdsCommand command;
        if (backupLocation != null && !backupLocation.exists()) {
            try {
                if (!backupLocation.createNewFile()) {
                    throw new IllegalStateException("Could not create: " + backupLocation);
                }
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        }
        if (this.adminCommands.offer((Object)(command = new ResetSessionIdsCommand(backupLocation)))) {
            return command;
        }
        return null;
    }

    public void startClose() {
        IdleStrategy idleStrategy = CommonConfiguration.backoffIdleStrategy();
        DisconnectAllCommand command = new DisconnectAllCommand();
        while (!this.adminCommands.offer((Object)command)) {
            idleStrategy.idle();
        }
        idleStrategy.reset();
        while (!command.hasCompleted()) {
            idleStrategy.idle();
        }
        idleStrategy.reset();
        if (command.hasErrored()) {
            LangUtil.rethrowUnchecked((Throwable)command.error());
        }
    }

    public Reply<Long> lookupSessionId(String localCompId, String remoteCompId, String localSubId, String remoteSubId, String localLocationId, String remoteLocationId) {
        LookupSessionIdCommand command = new LookupSessionIdCommand(localCompId, remoteCompId, localSubId, remoteSubId, localLocationId, remoteLocationId);
        if (this.adminCommands.offer((Object)command)) {
            return command;
        }
        return null;
    }

    public Reply<?> bind() {
        BindCommand command = new BindCommand();
        if (!this.configuration.hasBindAddress()) {
            command.onError(new IllegalStateException("Missing address: EngineConfiguration.bindTo()"));
            return command;
        }
        if (this.adminCommands.offer((Object)command)) {
            return command;
        }
        return null;
    }

    public Reply<?> unbind(boolean disconnect) {
        UnbindCommand command = new UnbindCommand(disconnect);
        if (this.adminCommands.offer((Object)command)) {
            return command;
        }
        return null;
    }

    public boolean offer(AdminCommand command) {
        return this.adminCommands.offer((Object)command);
    }

    public List<SessionInfo> allSessions() {
        return this.sessionContexts.allSessions();
    }
}

