/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import uk.co.real_logic.artio.AbstractDebugAppender;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;

public class PrintingDebugAppender
extends AbstractDebugAppender {
    private static final int DEFAULT_BUFFER_SIZE = 10;
    private final PrintWriter output = this.makeOutputStream();

    private PrintWriter makeOutputStream() {
        if (CommonConfiguration.DEBUG_FILE == null) {
            return new PrintWriter(System.out);
        }
        try {
            return new PrintWriter(new FileOutputStream(CommonConfiguration.DEBUG_FILE));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to configure DebugLogger, please check fix.core.debug.file", ex);
        }
    }

    @Override
    public AbstractDebugAppender.ThreadLocalAppender makeLocalAppender() {
        return new PrintingThreadLocalAppender();
    }

    class PrintingThreadLocalAppender
    extends AbstractDebugAppender.ThreadLocalAppender {
        private final StringBuilder builder = new StringBuilder();
        private final char[] threadName = (":" + DebugLogger.threadName()).toCharArray();
        private char[] buffer = new char[this.threadName.length + 10];

        PrintingThreadLocalAppender() {
        }

        @Override
        public void log(LogTag tag, StringBuilder stringBuilder) {
            int messageLength = stringBuilder.length();
            int prefixLength = this.appendStart(tag, messageLength);
            char[] buffer = this.buffer;
            stringBuilder.getChars(0, messageLength, buffer, prefixLength);
            PrintingDebugAppender.this.output.write(buffer, 0, prefixLength + messageLength);
            PrintingDebugAppender.this.output.flush();
        }

        private int appendStart(LogTag tag, int messageLength) {
            StringBuilder builder = this.builder;
            builder.setLength(0);
            builder.append(System.currentTimeMillis());
            builder.append(this.threadName);
            builder.append(tag.logStr());
            int prefixLength = builder.length();
            char[] buffer = this.acquireBuffer(prefixLength + messageLength);
            builder.getChars(0, prefixLength, buffer, 0);
            return prefixLength;
        }

        private char[] acquireBuffer(int length) {
            char[] buffer = this.buffer;
            if (buffer.length < length) {
                this.buffer = buffer = new char[length];
            }
            return buffer;
        }
    }
}

