/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.AbstractDebugAppender;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.PrintingDebugAppender;
import uk.co.real_logic.artio.messages.ApplicationHeartbeatDecoder;
import uk.co.real_logic.artio.messages.ApplicationHeartbeatEncoder;
import uk.co.real_logic.artio.messages.ConnectDecoder;
import uk.co.real_logic.artio.messages.ConnectEncoder;
import uk.co.real_logic.artio.messages.ControlNotificationDecoder;
import uk.co.real_logic.artio.messages.ControlNotificationEncoder;
import uk.co.real_logic.artio.messages.DisconnectDecoder;
import uk.co.real_logic.artio.messages.DisconnectEncoder;
import uk.co.real_logic.artio.messages.EndOfDayDecoder;
import uk.co.real_logic.artio.messages.EndOfDayEncoder;
import uk.co.real_logic.artio.messages.ErrorDecoder;
import uk.co.real_logic.artio.messages.ErrorEncoder;
import uk.co.real_logic.artio.messages.FollowerSessionReplyDecoder;
import uk.co.real_logic.artio.messages.FollowerSessionReplyEncoder;
import uk.co.real_logic.artio.messages.FollowerSessionRequestDecoder;
import uk.co.real_logic.artio.messages.FollowerSessionRequestEncoder;
import uk.co.real_logic.artio.messages.ILinkConnectDecoder;
import uk.co.real_logic.artio.messages.ILinkConnectEncoder;
import uk.co.real_logic.artio.messages.InitiateConnectionDecoder;
import uk.co.real_logic.artio.messages.InitiateConnectionEncoder;
import uk.co.real_logic.artio.messages.InitiateILinkConnectionDecoder;
import uk.co.real_logic.artio.messages.InitiateILinkConnectionEncoder;
import uk.co.real_logic.artio.messages.LibraryConnectDecoder;
import uk.co.real_logic.artio.messages.LibraryConnectEncoder;
import uk.co.real_logic.artio.messages.LibraryExtendPositionDecoder;
import uk.co.real_logic.artio.messages.LibraryExtendPositionEncoder;
import uk.co.real_logic.artio.messages.LibraryTimeoutDecoder;
import uk.co.real_logic.artio.messages.LibraryTimeoutEncoder;
import uk.co.real_logic.artio.messages.ManageSessionDecoder;
import uk.co.real_logic.artio.messages.ManageSessionEncoder;
import uk.co.real_logic.artio.messages.MidConnectionDisconnectDecoder;
import uk.co.real_logic.artio.messages.MidConnectionDisconnectEncoder;
import uk.co.real_logic.artio.messages.ReadMetaDataDecoder;
import uk.co.real_logic.artio.messages.ReadMetaDataEncoder;
import uk.co.real_logic.artio.messages.ReadMetaDataReplyDecoder;
import uk.co.real_logic.artio.messages.ReadMetaDataReplyEncoder;
import uk.co.real_logic.artio.messages.RedactSequenceUpdateDecoder;
import uk.co.real_logic.artio.messages.RedactSequenceUpdateEncoder;
import uk.co.real_logic.artio.messages.ReleaseSessionDecoder;
import uk.co.real_logic.artio.messages.ReleaseSessionEncoder;
import uk.co.real_logic.artio.messages.ReleaseSessionReplyDecoder;
import uk.co.real_logic.artio.messages.ReleaseSessionReplyEncoder;
import uk.co.real_logic.artio.messages.ReplayMessagesDecoder;
import uk.co.real_logic.artio.messages.ReplayMessagesEncoder;
import uk.co.real_logic.artio.messages.ReplayMessagesReplyDecoder;
import uk.co.real_logic.artio.messages.ReplayMessagesReplyEncoder;
import uk.co.real_logic.artio.messages.RequestDisconnectDecoder;
import uk.co.real_logic.artio.messages.RequestDisconnectEncoder;
import uk.co.real_logic.artio.messages.RequestSessionDecoder;
import uk.co.real_logic.artio.messages.RequestSessionEncoder;
import uk.co.real_logic.artio.messages.RequestSessionReplyDecoder;
import uk.co.real_logic.artio.messages.RequestSessionReplyEncoder;
import uk.co.real_logic.artio.messages.ResetLibrarySequenceNumberDecoder;
import uk.co.real_logic.artio.messages.ResetLibrarySequenceNumberEncoder;
import uk.co.real_logic.artio.messages.ResetSequenceNumberDecoder;
import uk.co.real_logic.artio.messages.ResetSequenceNumberEncoder;
import uk.co.real_logic.artio.messages.ResetSessionIdsDecoder;
import uk.co.real_logic.artio.messages.ResetSessionIdsEncoder;
import uk.co.real_logic.artio.messages.SlowStatusNotificationDecoder;
import uk.co.real_logic.artio.messages.SlowStatusNotificationEncoder;
import uk.co.real_logic.artio.messages.ValidResendRequestDecoder;
import uk.co.real_logic.artio.messages.ValidResendRequestEncoder;
import uk.co.real_logic.artio.messages.WriteMetaDataDecoder;
import uk.co.real_logic.artio.messages.WriteMetaDataEncoder;
import uk.co.real_logic.artio.messages.WriteMetaDataReplyDecoder;
import uk.co.real_logic.artio.messages.WriteMetaDataReplyEncoder;
import uk.co.real_logic.artio.util.CharFormatter;

public final class DebugLogger {
    private static final AbstractDebugAppender APPENDER;
    private static final ThreadLocal<ThreadLocalLogger> THREAD_LOCAL;

    public static void log(LogTag tag, CharFormatter formatter) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().log(tag, formatter);
        }
    }

    public static void log(LogTag tag, CharFormatter formatter, int value, DirectBuffer buffer, int offset, int length) {
        if (DebugLogger.isEnabled(tag)) {
            formatter.clear().with(value);
            THREAD_LOCAL.get().log(tag, formatter, buffer, offset, length);
        }
    }

    public static void log(LogTag tag, CharFormatter formatter, long first, String second, DirectBuffer buffer, int offset, int length) {
        if (DebugLogger.isEnabled(tag)) {
            formatter.clear().with(first).with(second);
            THREAD_LOCAL.get().log(tag, formatter, buffer, offset, length);
        }
    }

    public static void log(LogTag tag, CharFormatter formatter, DirectBuffer buffer, int offset, int length) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().log(tag, formatter, buffer, offset, length);
        }
    }

    public static void logSbeMessage(LogTag tag, RedactSequenceUpdateEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ManageSessionEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, DisconnectEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ConnectEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ResetSessionIdsEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ResetSequenceNumberEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ResetLibrarySequenceNumberEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, RequestDisconnectEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, MidConnectionDisconnectEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, InitiateConnectionEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ErrorEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ApplicationHeartbeatEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, LibraryConnectEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ReleaseSessionEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ReleaseSessionReplyEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, RequestSessionEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, RequestSessionReplyEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, LibraryTimeoutEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ControlNotificationEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, SlowStatusNotificationEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, FollowerSessionRequestEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, FollowerSessionReplyEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, EndOfDayEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, WriteMetaDataEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, WriteMetaDataReplyEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ReadMetaDataEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ReadMetaDataReplyEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ReplayMessagesEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ReplayMessagesReplyEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, InitiateILinkConnectionEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ILinkConnectEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, LibraryExtendPositionEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeMessage(LogTag tag, ValidResendRequestEncoder encoder) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeMessage(tag, encoder);
        }
    }

    public static void logSbeDecoder(LogTag tag, String prefix, Consumer<StringBuilder> appendTo) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logSbeDecoder(tag, prefix, appendTo);
        }
    }

    public static void log(LogTag tag, String prefixString, DirectBuffer buffer, int offset, int length) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().log(tag, prefixString, buffer, offset, length);
        }
    }

    public static void logBytes(LogTag tag, String prefixString, ByteBuffer buffer, int offset, int length) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().logBytes(tag, prefixString, buffer, offset, length);
        }
    }

    public static void log(LogTag tag, String prefixString, ByteBuffer byteBuffer, int length) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().log(tag, prefixString, byteBuffer, length);
        }
    }

    public static void log(LogTag tag, String message) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().log(tag, message);
        }
    }

    public static void log(LogTag tag, String prefixString, String suffixString) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().log(tag, prefixString, suffixString);
        }
    }

    public static void log(LogTag tag, CharFormatter formatter, long first, String second) {
        if (DebugLogger.isEnabled(tag)) {
            formatter.clear().with(first).with(second);
            THREAD_LOCAL.get().log(tag, formatter);
        }
    }

    public static void log(LogTag tag, CharFormatter formatter, long first) {
        if (DebugLogger.isEnabled(tag)) {
            formatter.clear().with(first);
            THREAD_LOCAL.get().log(tag, formatter);
        }
    }

    public static void log(LogTag tag, CharFormatter formatter, long first, long second) {
        if (DebugLogger.isEnabled(tag)) {
            formatter.clear().with(first).with(second);
            THREAD_LOCAL.get().log(tag, formatter);
        }
    }

    public static void log(LogTag tag, CharFormatter formatter, long first, long second, long third) {
        if (DebugLogger.isEnabled(tag)) {
            formatter.clear().with(first).with(second).with(third);
            THREAD_LOCAL.get().log(tag, formatter);
        }
    }

    public static void log(LogTag tag, CharFormatter formatter, String first, long second, long third) {
        if (DebugLogger.isEnabled(tag)) {
            formatter.clear().with(first).with(second).with(third);
            THREAD_LOCAL.get().log(tag, formatter);
        }
    }

    public static void log(LogTag tag, CharFormatter formatter, long first, long second, String third) {
        if (DebugLogger.isEnabled(tag)) {
            formatter.clear().with(first).with(second).with(third);
            THREAD_LOCAL.get().log(tag, formatter);
        }
    }

    public static void log(LogTag tag, CharFormatter formatter, long first, long second, long third, long fourth) {
        if (DebugLogger.isEnabled(tag)) {
            formatter.clear().with(first).with(second).with(third).with(fourth);
            THREAD_LOCAL.get().log(tag, formatter);
        }
    }

    public static void log(LogTag tag, CharFormatter formatter, String first, long second, long third, long fourth) {
        if (DebugLogger.isEnabled(tag)) {
            formatter.clear().with(first).with(second).with(third).with(fourth);
            THREAD_LOCAL.get().log(tag, formatter);
        }
    }

    public static void log(LogTag tag, String formatString, Object first, Object second) {
        if (DebugLogger.isEnabled(tag)) {
            THREAD_LOCAL.get().log(tag, String.format(formatString, first, second));
        }
    }

    static String threadName() {
        return Thread.currentThread().getName();
    }

    private static void substituteSeparator(byte[] data) {
        if (DebugLogger.needsSeparatorSubstitution()) {
            int size = data.length;
            for (int i = 0; i < size; ++i) {
                if (data[i] != 1) continue;
                data[i] = CommonConfiguration.DEBUG_LOGGING_SEPARATOR;
            }
        }
    }

    private static boolean needsSeparatorSubstitution() {
        return CommonConfiguration.DEBUG_LOGGING_SEPARATOR != 1;
    }

    public static boolean isEnabled(LogTag tag) {
        return CommonConfiguration.DEBUG_PRINT_MESSAGES && CommonConfiguration.DEBUG_TAGS.contains((Object)tag);
    }

    static {
        THREAD_LOCAL = ThreadLocal.withInitial(ThreadLocalLogger::new);
        ServiceLoader<AbstractDebugAppender> loader = ServiceLoader.load(AbstractDebugAppender.class);
        Iterator<AbstractDebugAppender> it = loader.iterator();
        APPENDER = it.hasNext() ? it.next() : new PrintingDebugAppender();
    }

    static class ThreadLocalLogger {
        private final InitiateConnectionDecoder initiateConnection = new InitiateConnectionDecoder();
        private final RequestDisconnectDecoder requestDisconnect = new RequestDisconnectDecoder();
        private final MidConnectionDisconnectDecoder midConnectionDisconnect = new MidConnectionDisconnectDecoder();
        private final LibraryConnectDecoder libraryConnect = new LibraryConnectDecoder();
        private final ReleaseSessionDecoder releaseSession = new ReleaseSessionDecoder();
        private final RequestSessionDecoder requestSession = new RequestSessionDecoder();
        private final FollowerSessionRequestDecoder followerSessionRequest = new FollowerSessionRequestDecoder();
        private final WriteMetaDataDecoder writeMetaData = new WriteMetaDataDecoder();
        private final ReadMetaDataDecoder readMetaData = new ReadMetaDataDecoder();
        private final ReplayMessagesDecoder replayMessages = new ReplayMessagesDecoder();
        private final ConnectDecoder connect = new ConnectDecoder();
        private final ResetSessionIdsDecoder resetSessionIds = new ResetSessionIdsDecoder();
        private final LibraryTimeoutDecoder libraryTimeout = new LibraryTimeoutDecoder();
        private final InitiateILinkConnectionDecoder initiateILinkConnection = new InitiateILinkConnectionDecoder();
        private final ErrorDecoder error = new ErrorDecoder();
        private final ReleaseSessionReplyDecoder releaseSessionReply = new ReleaseSessionReplyDecoder();
        private final RequestSessionReplyDecoder requestSessionReply = new RequestSessionReplyDecoder();
        private final WriteMetaDataReplyDecoder writeMetaDataReply = new WriteMetaDataReplyDecoder();
        private final ReadMetaDataReplyDecoder readMetaDataReply = new ReadMetaDataReplyDecoder();
        private final ControlNotificationDecoder controlNotification = new ControlNotificationDecoder();
        private final SlowStatusNotificationDecoder slowStatusNotification = new SlowStatusNotificationDecoder();
        private final ResetLibrarySequenceNumberDecoder resetLibrarySequenceNumber = new ResetLibrarySequenceNumberDecoder();
        private final ResetSequenceNumberDecoder resetSequenceNumber = new ResetSequenceNumberDecoder();
        private final ManageSessionDecoder manageSession = new ManageSessionDecoder();
        private final FollowerSessionReplyDecoder followerSessionReply = new FollowerSessionReplyDecoder();
        private final EndOfDayDecoder endOfDay = new EndOfDayDecoder();
        private final ReplayMessagesReplyDecoder replayMessagesReply = new ReplayMessagesReplyDecoder();
        private final ValidResendRequestDecoder validResendRequest = new ValidResendRequestDecoder();
        private final LibraryExtendPositionDecoder libraryExtendPosition = new LibraryExtendPositionDecoder();
        private final ILinkConnectDecoder iLinkConnect = new ILinkConnectDecoder();
        private final ApplicationHeartbeatDecoder applicationHeartbeat = new ApplicationHeartbeatDecoder();
        private final DisconnectDecoder disconnect = new DisconnectDecoder();
        private final RedactSequenceUpdateDecoder redactSequenceUpdate = new RedactSequenceUpdateDecoder();
        private final StringBuilder builder = new StringBuilder();
        private byte[] bytes = new byte[0];
        private final AsciiSequenceView asciiView = new AsciiSequenceView();
        private final UnsafeBuffer buffer = new UnsafeBuffer(this.bytes);
        private final AbstractDebugAppender.ThreadLocalAppender appender;
        final boolean isThreadEnabled;

        ThreadLocalLogger() {
            String threadName = DebugLogger.threadName();
            this.isThreadEnabled = CommonConfiguration.DEBUG_PRINT_THREAD == null || CommonConfiguration.DEBUG_PRINT_THREAD.equals(threadName);
            this.appender = APPENDER.makeLocalAppender();
        }

        public void logSbeMessage(LogTag tag, RedactSequenceUpdateEncoder encoder) {
            this.appendStart();
            this.redactSequenceUpdate.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 20, 13);
            this.redactSequenceUpdate.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ManageSessionEncoder encoder) {
            this.appendStart();
            this.manageSession.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 94, 13);
            this.manageSession.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, DisconnectEncoder encoder) {
            this.appendStart();
            this.disconnect.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 13, 13);
            this.disconnect.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ConnectEncoder encoder) {
            this.appendStart();
            this.connect.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 8, 13);
            this.connect.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ResetSessionIdsEncoder encoder) {
            this.appendStart();
            this.resetSessionIds.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 0, 13);
            this.resetSessionIds.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ResetSequenceNumberEncoder encoder) {
            this.appendStart();
            this.resetSequenceNumber.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 8, 13);
            this.resetSequenceNumber.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ResetLibrarySequenceNumberEncoder encoder) {
            this.appendStart();
            this.resetLibrarySequenceNumber.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 12, 13);
            this.resetLibrarySequenceNumber.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, RequestDisconnectEncoder encoder) {
            this.appendStart();
            this.requestDisconnect.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 21, 13);
            this.requestDisconnect.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, MidConnectionDisconnectEncoder encoder) {
            this.appendStart();
            this.midConnectionDisconnect.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 12, 13);
            this.midConnectionDisconnect.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, InitiateConnectionEncoder encoder) {
            this.appendStart();
            this.initiateConnection.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 37, 13);
            this.initiateConnection.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ErrorEncoder encoder) {
            this.appendStart();
            this.error.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 14, 13);
            this.error.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ApplicationHeartbeatEncoder encoder) {
            this.appendStart();
            this.applicationHeartbeat.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 12, 13);
            this.applicationHeartbeat.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, LibraryConnectEncoder encoder) {
            this.appendStart();
            this.libraryConnect.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 12, 13);
            this.libraryConnect.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ReleaseSessionEncoder encoder) {
            this.appendStart();
            this.releaseSession.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 46, 13);
            this.releaseSession.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ReleaseSessionReplyEncoder encoder) {
            this.appendStart();
            this.releaseSessionReply.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 13, 13);
            this.releaseSessionReply.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, RequestSessionEncoder encoder) {
            this.appendStart();
            this.requestSession.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 28, 13);
            this.requestSession.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, RequestSessionReplyEncoder encoder) {
            this.appendStart();
            this.requestSessionReply.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 13, 13);
            this.requestSessionReply.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, LibraryTimeoutEncoder encoder) {
            this.appendStart();
            this.libraryTimeout.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 12, 13);
            this.libraryTimeout.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ControlNotificationEncoder encoder) {
            this.appendStart();
            this.controlNotification.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 5, 13);
            this.controlNotification.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, SlowStatusNotificationEncoder encoder) {
            this.appendStart();
            this.slowStatusNotification.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 13, 13);
            this.slowStatusNotification.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, FollowerSessionRequestEncoder encoder) {
            this.appendStart();
            this.followerSessionRequest.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 12, 13);
            this.followerSessionRequest.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, FollowerSessionReplyEncoder encoder) {
            this.appendStart();
            this.followerSessionReply.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 20, 13);
            this.followerSessionReply.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, EndOfDayEncoder encoder) {
            this.appendStart();
            this.endOfDay.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 4, 13);
            this.endOfDay.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, WriteMetaDataEncoder encoder) {
            this.appendStart();
            this.writeMetaData.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 24, 13);
            this.writeMetaData.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, WriteMetaDataReplyEncoder encoder) {
            this.appendStart();
            this.writeMetaDataReply.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 13, 13);
            this.writeMetaDataReply.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ReadMetaDataEncoder encoder) {
            this.appendStart();
            this.readMetaData.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 20, 13);
            this.readMetaData.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ReadMetaDataReplyEncoder encoder) {
            this.appendStart();
            this.readMetaDataReply.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 13, 13);
            this.readMetaDataReply.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ReplayMessagesEncoder encoder) {
            this.appendStart();
            this.replayMessages.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 44, 13);
            this.replayMessages.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ReplayMessagesReplyEncoder encoder) {
            this.appendStart();
            this.replayMessagesReply.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 13, 13);
            this.replayMessagesReply.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ValidResendRequestEncoder encoder) {
            this.appendStart();
            this.validResendRequest.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 28, 13);
            this.validResendRequest.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, LibraryExtendPositionEncoder encoder) {
            this.appendStart();
            this.libraryExtendPosition.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 36, 13);
            this.libraryExtendPosition.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, InitiateILinkConnectionEncoder encoder) {
            this.appendStart();
            this.initiateILinkConnection.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 18, 13);
            this.initiateILinkConnection.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeMessage(LogTag tag, ILinkConnectEncoder encoder) {
            this.appendStart();
            this.iLinkConnect.wrap((DirectBuffer)encoder.buffer(), encoder.initialOffset(), 53, 13);
            this.iLinkConnect.appendTo(this.builder);
            this.finish(tag);
        }

        public void logSbeDecoder(LogTag tag, String prefix, Consumer<StringBuilder> appendTo) {
            this.appendStart();
            this.builder.append(prefix);
            appendTo.accept(this.builder);
            this.finish(tag);
        }

        private void appendStart() {
            StringBuilder builder = this.builder;
            builder.setLength(0);
        }

        public void log(LogTag tag, String prefixString, ByteBuffer byteBuffer, int length) {
            byte[] data = this.getByteArray(length);
            byteBuffer.get(data, 0, length);
            DebugLogger.substituteSeparator(data);
            this.appendStart();
            StringBuilder builder = this.builder;
            builder.append(prefixString);
            AsciiSequenceView asciiView = this.asciiView;
            asciiView.wrap((DirectBuffer)this.buffer, 0, length);
            builder.append((CharSequence)asciiView);
            this.finish(tag);
        }

        public void logBytes(LogTag tag, String prefixString, ByteBuffer byteBuffer, int offset, int length) {
            this.appendStart();
            StringBuilder builder = this.builder;
            builder.append(prefixString);
            if (length == 0) {
                builder.append("{}");
            } else {
                builder.append('{');
                for (int i = 0; i < length; ++i) {
                    builder.append(byteBuffer.get(offset + i));
                    if (i == length - 1) {
                        builder.append('}');
                        continue;
                    }
                    builder.append(", ");
                }
            }
            this.finish(tag);
        }

        private byte[] getByteArray(int length) {
            byte[] data = this.bytes;
            if (data.length < length) {
                this.bytes = data = new byte[length];
                this.buffer.wrap(data);
            }
            return data;
        }

        public void log(LogTag tag, String message) {
            this.appendStart();
            this.builder.append(message);
            this.finish(tag);
        }

        public void log(LogTag tag, String prefixString, DirectBuffer buffer, int offset, int length) {
            this.appendStart();
            this.builder.append(prefixString);
            if (DebugLogger.needsSeparatorSubstitution()) {
                byte[] data = this.getByteArray(length);
                buffer.getBytes(offset, data, 0, length);
                DebugLogger.substituteSeparator(data);
                this.asciiView.wrap((DirectBuffer)this.buffer, 0, length);
            } else {
                this.asciiView.wrap(buffer, offset, length);
            }
            this.builder.append((CharSequence)this.asciiView);
            this.finish(tag);
        }

        public void log(LogTag tag, CharFormatter formatter, DirectBuffer buffer, int bufferOffset, int bufferLength) {
            byte[] data = this.getByteArray(bufferLength);
            buffer.getBytes(bufferOffset, data, 0, bufferLength);
            DebugLogger.substituteSeparator(data);
            formatter.with(data, bufferLength);
            this.log(tag, formatter);
        }

        public void log(LogTag tag, String prefixString, String suffixString) {
            this.appendStart();
            StringBuilder builder = this.builder;
            builder.append(prefixString);
            builder.append(suffixString);
            this.finish(tag);
        }

        public void log(LogTag tag, CharFormatter formatter) {
            this.appendStart();
            formatter.appendTo(this.builder);
            this.finish(tag);
        }

        private void finish(LogTag tag) {
            StringBuilder builder = this.builder;
            builder.append(System.lineSeparator());
            this.appender.log(tag, builder);
        }
    }
}

