/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.timing;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.HdrHistogram.Histogram;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.SigInt;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.timing.HistogramLogHandler;

public class HistogramLogReader
implements AutoCloseable {
    private final Int2ObjectHashMap<String> idToName = new Int2ObjectHashMap();
    private FileChannel channel;
    private MappedByteBuffer buffer;

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("Usage: HistogramLogReader <logFile>");
            System.err.println("Where <logFile> is the path to histogram log file");
            System.exit(-1);
        }
        String path = args[0];
        File file = new File(path);
        double scalingFactor = TimeUnit.MICROSECONDS.toNanos(1L);
        BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(0L, 0L, TimeUnit.MILLISECONDS.toNanos(1L), TimeUnit.MINUTES.toNanos(1L));
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        try (HistogramLogReader logReader = new HistogramLogReader(file);){
            do {
                int sampleCount = logReader.read((recordedAtTime, name, histogram) -> HistogramLogReader.prettyPrint(recordedAtTime, histogram, name, scalingFactor));
                idleStrategy.idle(sampleCount);
            } while (running.get());
        }
    }

    public HistogramLogReader(File file) {
        this.openFile(file);
        this.readHeader();
    }

    private void openFile(File file) {
        IoUtil.checkFileExists((File)file, (String)file.getName());
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            this.channel = randomAccessFile.getChannel();
            this.map(this.channel.size());
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    private void remapIfExpanded() throws IOException {
        long size = this.channel.size();
        if (size != (long)this.buffer.capacity()) {
            int previousPosition = this.buffer.position();
            this.map(size);
            ByteBufferUtil.position(this.buffer, previousPosition);
        }
    }

    private void map(long size) throws IOException {
        this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
    }

    private void readHeader() {
        int timerCount = this.buffer.getInt();
        for (int i = 0; i < timerCount; ++i) {
            int id = this.buffer.getInt();
            byte[] nameBytes = new byte[this.buffer.getInt()];
            this.buffer.get(nameBytes);
            String name = new String(nameBytes, StandardCharsets.UTF_8);
            this.idToName.put(id, (Object)name);
        }
    }

    public int read(HistogramLogHandler handler) throws IOException {
        this.remapIfExpanded();
        int timerCount = this.idToName.size();
        int samplesRead = 0;
        while (this.buffer.remaining() >= 8) {
            this.buffer.mark();
            long timeStamp = this.buffer.getLong();
            if (timeStamp == 0L) {
                this.buffer.reset();
                return samplesRead;
            }
            for (int i = 0; i < timerCount; ++i) {
                int id = this.buffer.getInt();
                String name = (String)this.idToName.get(id);
                Histogram histogram = Histogram.decodeFromByteBuffer((ByteBuffer)this.buffer, (long)0L);
                handler.onHistogram(timeStamp, name, histogram);
            }
            ++samplesRead;
        }
        return samplesRead;
    }

    @Override
    public void close() {
        IoUtil.unmap((MappedByteBuffer)this.buffer);
        CloseHelper.close((AutoCloseable)this.channel);
    }

    public static void prettyPrint(long timestampInMs, Histogram histogram, String name, double scalingFactor) {
        System.out.printf("%s Histogram @ %d millis%n----------%nMean: %G%n1:    %G%n50:   %G%n90:   %G%n99:   %G%n99.9: %G%n99.99: %G%n100:  %G%n----------%n", name, timestampInMs, histogram.getMean() / scalingFactor, HistogramLogReader.scaledPercentile(histogram, scalingFactor, 1.0), HistogramLogReader.scaledPercentile(histogram, scalingFactor, 50.0), HistogramLogReader.scaledPercentile(histogram, scalingFactor, 90.0), HistogramLogReader.scaledPercentile(histogram, scalingFactor, 99.0), HistogramLogReader.scaledPercentile(histogram, scalingFactor, 99.9), HistogramLogReader.scaledPercentile(histogram, scalingFactor, 99.99), HistogramLogReader.scaledPercentile(histogram, scalingFactor, 100.0));
    }

    private static double scaledPercentile(Histogram histogram, double scalingFactor, double percentile) {
        return (double)histogram.getValueAtPercentile(percentile) / scalingFactor;
    }
}

