/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.protocol;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.messages.ApplicationHeartbeatDecoder;
import uk.co.real_logic.artio.messages.AwaitingResend;
import uk.co.real_logic.artio.messages.Bool;
import uk.co.real_logic.artio.messages.FollowerSessionRequestDecoder;
import uk.co.real_logic.artio.messages.InitiateConnectionDecoder;
import uk.co.real_logic.artio.messages.InitiateILinkConnectionDecoder;
import uk.co.real_logic.artio.messages.LibraryConnectDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MidConnectionDisconnectDecoder;
import uk.co.real_logic.artio.messages.ReadMetaDataDecoder;
import uk.co.real_logic.artio.messages.ReleaseSessionDecoder;
import uk.co.real_logic.artio.messages.ReplayMessagesDecoder;
import uk.co.real_logic.artio.messages.RequestDisconnectDecoder;
import uk.co.real_logic.artio.messages.RequestSessionDecoder;
import uk.co.real_logic.artio.messages.ResetSequenceNumber;
import uk.co.real_logic.artio.messages.WriteMetaDataDecoder;
import uk.co.real_logic.artio.protocol.EngineEndPointHandler;

public final class EngineProtocolSubscription
implements ControlledFragmentHandler {
    private static final int FOLLOWER_SESSION_REQUEST_LENGTH = 12 + FollowerSessionRequestDecoder.headerHeaderLength();
    private static final int WRITE_META_DATA_DATA_LENGTH = 24 + WriteMetaDataDecoder.metaDataHeaderLength();
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final InitiateConnectionDecoder initiateConnection = new InitiateConnectionDecoder();
    private final RequestDisconnectDecoder requestDisconnect = new RequestDisconnectDecoder();
    private final MidConnectionDisconnectDecoder midConnectionDisconnect = new MidConnectionDisconnectDecoder();
    private final ApplicationHeartbeatDecoder applicationHeartbeat = new ApplicationHeartbeatDecoder();
    private final LibraryConnectDecoder libraryConnect = new LibraryConnectDecoder();
    private final ReleaseSessionDecoder releaseSession = new ReleaseSessionDecoder();
    private final RequestSessionDecoder requestSession = new RequestSessionDecoder();
    private final FollowerSessionRequestDecoder followerSessionRequest = new FollowerSessionRequestDecoder();
    private final WriteMetaDataDecoder writeMetaData = new WriteMetaDataDecoder();
    private final ReadMetaDataDecoder readMetaData = new ReadMetaDataDecoder();
    private final ReplayMessagesDecoder replayMessages = new ReplayMessagesDecoder();
    private final InitiateILinkConnectionDecoder initiateILinkConnection = new InitiateILinkConnectionDecoder();
    private final EngineEndPointHandler handler;

    public EngineProtocolSubscription(EngineEndPointHandler handler) {
        this.handler = handler;
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeader.wrap(buffer, offset);
        int blockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        offset += this.messageHeader.encodedLength();
        switch (this.messageHeader.templateId()) {
            case 12: {
                return this.onRequestDisconnect(buffer, offset, blockLength, version, header);
            }
            case 11: {
                return this.onInitiateConnection(buffer, offset, blockLength, version, header);
            }
            case 16: {
                return this.onApplicationHeartbeat(buffer, offset, blockLength, version, header);
            }
            case 17: {
                return this.onLibraryConnect(buffer, offset, blockLength, version, header);
            }
            case 29: {
                return this.onReleaseSession(buffer, offset, blockLength, version, header);
            }
            case 31: {
                return this.onRequestSession(buffer, offset, blockLength, version, header);
            }
            case 46: {
                return this.onMidConnectionDisconnect(buffer, offset, blockLength, version, header);
            }
            case 47: {
                return this.onFollowerSessionRequest(buffer, offset, blockLength, version, header);
            }
            case 37: {
                return this.onWriteMetaData(buffer, offset, blockLength, version, header);
            }
            case 51: {
                return this.onReadMetaData(buffer, offset, blockLength, version, header);
            }
            case 53: {
                return this.onReplayMessages(buffer, offset, blockLength, version, header);
            }
            case 56: {
                return this.onInitiateILinkConnection(buffer, offset, blockLength, version, header);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onApplicationHeartbeat(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.applicationHeartbeat.wrap(buffer, offset, blockLength, version);
        this.handler.onApplicationHeartbeat(this.applicationHeartbeat.libraryId(), header.sessionId());
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onLibraryConnect(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.libraryConnect.wrap(buffer, offset, blockLength, version);
        int libraryId = this.libraryConnect.libraryId();
        String libraryName = this.libraryConnect.libraryName();
        return this.handler.onLibraryConnect(libraryId, libraryName, this.libraryConnect.correlationId(), header.sessionId());
    }

    private ControlledFragmentHandler.Action onReleaseSession(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.releaseSession.wrap(buffer, offset, blockLength, version);
        int libraryId = this.releaseSession.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId());
        if (action != null) {
            return action;
        }
        return this.handler.onReleaseSession(libraryId, this.releaseSession.connection(), this.releaseSession.sessionId(), this.releaseSession.correlationId(), this.releaseSession.state(), this.releaseSession.awaitingResend() == AwaitingResend.YES, this.releaseSession.heartbeatIntervalInMs(), this.releaseSession.lastSentSequenceNumber(), this.releaseSession.lastReceivedSequenceNumber(), this.releaseSession.username(), this.releaseSession.password(), header);
    }

    private ControlledFragmentHandler.Action onRequestSession(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.requestSession.wrap(buffer, offset, blockLength, version);
        int libraryId = this.requestSession.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId());
        if (action != null) {
            return action;
        }
        return this.handler.onRequestSession(libraryId, this.requestSession.sessionId(), this.requestSession.correlationId(), this.requestSession.lastReceivedSequenceNumber(), this.requestSession.sequenceIndex());
    }

    private ControlledFragmentHandler.Action onInitiateConnection(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.initiateConnection.wrap(buffer, offset, blockLength, version);
        int libraryId = this.initiateConnection.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId());
        if (action != null) {
            return action;
        }
        return this.handler.onInitiateConnection(libraryId, this.initiateConnection.port(), this.initiateConnection.host(), this.initiateConnection.senderCompId(), this.initiateConnection.senderSubId(), this.initiateConnection.senderLocationId(), this.initiateConnection.targetCompId(), this.initiateConnection.targetSubId(), this.initiateConnection.targetLocationId(), this.initiateConnection.sequenceNumberType(), this.initiateConnection.requestedInitialReceivedSequenceNumber(), this.initiateConnection.requestedInitialSentSequenceNumber(), this.initiateConnection.resetSequenceNumber() == ResetSequenceNumber.YES, this.initiateConnection.closedResendInterval() == Bool.TRUE, this.initiateConnection.resendRequestChunkSize(), this.initiateConnection.sendRedundantResendRequests() == Bool.TRUE, this.initiateConnection.enableLastMsgSeqNumProcessed() == Bool.TRUE, this.initiateConnection.username(), this.initiateConnection.password(), FixDictionary.find((String)this.initiateConnection.fixDictionary()), this.initiateConnection.heartbeatIntervalInS(), this.initiateConnection.correlationId(), header);
    }

    private ControlledFragmentHandler.Action onRequestDisconnect(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.requestDisconnect.wrap(buffer, offset, blockLength, version);
        int libraryId = this.requestDisconnect.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId());
        if (action != null) {
            return action;
        }
        return this.handler.onRequestDisconnect(libraryId, this.requestDisconnect.connection(), this.requestDisconnect.reason());
    }

    private ControlledFragmentHandler.Action onMidConnectionDisconnect(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.midConnectionDisconnect.wrap(buffer, offset, blockLength, version);
        int libraryId = this.midConnectionDisconnect.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId());
        if (action != null) {
            return action;
        }
        return this.handler.onMidConnectionDisconnect(libraryId, this.midConnectionDisconnect.correlationId());
    }

    private ControlledFragmentHandler.Action onFollowerSessionRequest(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.followerSessionRequest.wrap(buffer, offset, blockLength, version);
        int libraryId = this.followerSessionRequest.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId());
        if (action != null) {
            return action;
        }
        int messageLength = this.followerSessionRequest.headerLength();
        return this.handler.onFollowerSessionRequest(libraryId, this.followerSessionRequest.correlationId(), buffer, offset + FOLLOWER_SESSION_REQUEST_LENGTH, messageLength, header);
    }

    private ControlledFragmentHandler.Action onWriteMetaData(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.writeMetaData.wrap(buffer, offset, blockLength, version);
        int libraryId = this.writeMetaData.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId());
        if (action != null) {
            return action;
        }
        int metaDataLength = this.writeMetaData.metaDataLength();
        return this.handler.onWriteMetaData(libraryId, this.writeMetaData.session(), this.writeMetaData.correlationId(), this.writeMetaData.metaDataOffset(), buffer, offset + WRITE_META_DATA_DATA_LENGTH, metaDataLength);
    }

    private ControlledFragmentHandler.Action onReadMetaData(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.readMetaData.wrap(buffer, offset, blockLength, version);
        int libraryId = this.readMetaData.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId());
        if (action != null) {
            return action;
        }
        return this.handler.onReadMetaData(libraryId, this.readMetaData.session(), this.readMetaData.correlationId());
    }

    private ControlledFragmentHandler.Action onReplayMessages(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.replayMessages.wrap(buffer, offset, blockLength, version);
        int libraryId = this.replayMessages.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId());
        if (action != null) {
            return action;
        }
        return this.handler.onReplayMessages(libraryId, this.replayMessages.session(), this.replayMessages.correlationId(), this.replayMessages.replayFromSequenceNumber(), this.replayMessages.replayToSequenceIndex(), this.replayMessages.replayToSequenceNumber(), this.replayMessages.replayToSequenceIndex(), this.replayMessages.latestReplyArrivalTimeInMs());
    }

    private ControlledFragmentHandler.Action onInitiateILinkConnection(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.initiateILinkConnection.wrap(buffer, offset, blockLength, version);
        int libraryId = this.initiateILinkConnection.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId());
        if (action != null) {
            return action;
        }
        return this.handler.onInitiateILinkConnection(libraryId, this.initiateILinkConnection.port(), this.initiateILinkConnection.correlationId(), this.initiateILinkConnection.reestablishConnection() == Bool.TRUE, this.initiateILinkConnection.useBackupHost() == Bool.TRUE, this.initiateILinkConnection.host(), this.initiateILinkConnection.accessKeyId(), this.initiateILinkConnection.backupHost());
    }
}

