/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.protocol;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import java.util.Objects;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.protocol.NotConnectedException;

class ClaimablePublication
implements AutoCloseable {
    static final int HEADER_LENGTH = 8;
    private final long maxClaimAttempts;
    private final AtomicCounter fails;
    protected final MessageHeaderEncoder header = new MessageHeaderEncoder();
    protected final BufferClaim bufferClaim = new BufferClaim();
    protected ExclusivePublication dataPublication;
    private long initialPosition;
    protected final IdleStrategy idleStrategy;

    ClaimablePublication(int maxClaimAttempts, IdleStrategy idleStrategy, AtomicCounter fails, ExclusivePublication dataPublication) {
        this.maxClaimAttempts = maxClaimAttempts;
        this.idleStrategy = idleStrategy;
        this.fails = fails;
        this.dataPublication(dataPublication);
    }

    protected long claim(int framedLength) {
        return this.claim(framedLength, this.bufferClaim);
    }

    public long claim(int framedLength, BufferClaim bufferClaim) {
        long position;
        long i = 0L;
        do {
            if ((position = this.dataPublication.tryClaim(framedLength, bufferClaim)) > 0L) {
                return position;
            }
            this.idleStrategy.idle();
            this.fails.increment();
        } while (++i <= this.maxClaimAttempts);
        this.idleStrategy.reset();
        if (position == -4L || position == -5L) {
            throw new NotConnectedException(position);
        }
        return position;
    }

    public long offer(DirectBuffer buffer, int offset, int length) {
        return this.dataPublication.offer(buffer, offset, length);
    }

    public ExclusivePublication dataPublication() {
        return this.dataPublication;
    }

    public void dataPublication(ExclusivePublication dataPublication) {
        Objects.requireNonNull(dataPublication, "dataPublication");
        CloseHelper.close((AutoCloseable)this.dataPublication);
        this.dataPublication = dataPublication;
        this.initialPosition = dataPublication.position();
    }

    public long initialPosition() {
        return this.initialPosition;
    }

    @Override
    public void close() {
        this.dataPublication.close();
    }
}

