/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.ExclusivePublication;
import io.aeron.Subscription;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.IntHashSet;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.decoder.AbstractResendRequestDecoder;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.engine.ILink3RetransmitHandler;
import uk.co.real_logic.artio.engine.ReplayHandler;
import uk.co.real_logic.artio.engine.ReplayerCommandQueue;
import uk.co.real_logic.artio.engine.SenderSequenceNumbers;
import uk.co.real_logic.artio.engine.logger.EnqueuedReplay;
import uk.co.real_logic.artio.engine.logger.FixReplayerCodecs;
import uk.co.real_logic.artio.engine.logger.FixReplayerSession;
import uk.co.real_logic.artio.engine.logger.FixSessionCodecsFactory;
import uk.co.real_logic.artio.engine.logger.GapFillEncoder;
import uk.co.real_logic.artio.engine.logger.ILinkReplayerSession;
import uk.co.real_logic.artio.engine.logger.ReplayChannel;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.engine.logger.ReplayerSession;
import uk.co.real_logic.artio.fields.EpochFractionFormat;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.ilink.AbstractILink3Offsets;
import uk.co.real_logic.artio.ilink.AbstractILink3Parser;
import uk.co.real_logic.artio.ilink.AbstractILink3Proxy;
import uk.co.real_logic.artio.messages.DisconnectDecoder;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.ILinkConnectDecoder;
import uk.co.real_logic.artio.messages.ILinkMessageEncoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.ReplayCompleteEncoder;
import uk.co.real_logic.artio.messages.ReplayerTimestampEncoder;
import uk.co.real_logic.artio.messages.RequestDisconnectDecoder;
import uk.co.real_logic.artio.messages.ValidResendRequestDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.CharFormatter;
import uk.co.real_logic.artio.util.Lazy;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class Replayer
implements Agent,
ControlledFragmentHandler {
    public static final int MOST_RECENT_MESSAGE = 0;
    private static final long TIMESTAMP_MESSAGE_INTERVAL = TimeUnit.SECONDS.toNanos(10L);
    static final int MESSAGE_FRAME_BLOCK_LENGTH = 65 + FixMessageDecoder.bodyHeaderLength();
    static final int SIZE_OF_LENGTH_FIELD = FixMessageDecoder.bodyHeaderLength();
    private static final int POLL_LIMIT = 10;
    private final AsciiBuffer asciiBuffer = new MutableAsciiBuffer();
    private final BufferClaim bufferClaim;
    final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    final ReplayCompleteEncoder replayCompleteEncoder = new ReplayCompleteEncoder();
    private final LongHashSet gapFillMessageTypes;
    private final FixSessionCodecsFactory fixSessionCodecsFactory;
    private final CharFormatter receivedResendFormatter = new CharFormatter("Received Resend Request for range: [%s, %s]%n");
    private final CharFormatter alreadyDisconnectedFormatter = new CharFormatter("Not processing Resend Request for %s because it has already disconnected %n");
    final CharFormatter completeNotRecentFormatter = new CharFormatter("ReplayerSession: completeReplay-!upToMostRecent replayedMessages=%s endSeqNo=%s beginSeqNo=%s expectedCount=%s%n");
    final CharFormatter completeReplayGapfillFormatter = new CharFormatter("ReplayerSession: completeReplay-sendGapFill action=%s, replayedMessages=%s, beginGapFillSeqNum=%s, newSequenceNumber=%s%n");
    private final IntHashSet gapfillOnRetransmitILinkTemplateIds;
    private final Lazy<AbstractILink3Parser> iLink3Parser;
    private final Lazy<AbstractILink3Proxy> iLink3Proxy;
    private final Lazy<AbstractILink3Offsets> iLink3Offsets;
    private final LongHashSet iLinkConnectionIds = new LongHashSet();
    private final ILinkConnectDecoder iLinkConnect = new ILinkConnectDecoder();
    private final ILinkMessageEncoder iLinkMessageEncoder = new ILinkMessageEncoder();
    private final UnsafeBuffer timestampBuffer = new UnsafeBuffer(new byte[16]);
    private final ReplayerTimestampEncoder replayerTimestampEncoder = new ReplayerTimestampEncoder();
    private long nextTimestampMessageInNs;
    private final Long2ObjectHashMap<ReplayChannel> connectionIdToReplayerChannel = new Long2ObjectHashMap();
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final ValidResendRequestDecoder validResendRequest = new ValidResendRequestDecoder();
    private final RequestDisconnectDecoder requestDisconnect = new RequestDisconnectDecoder();
    private final DisconnectDecoder disconnect = new DisconnectDecoder();
    private final int maxBytesInBuffer;
    private final ReplayerCommandQueue replayerCommandQueue;
    private final AtomicCounter currentReplayCount;
    private final int maxConcurrentSessionReplays;
    private final EpochNanoClock nanoClock;
    private final ReplayQuery outboundReplayQuery;
    private final ExclusivePublication publication;
    private final IdleStrategy idleStrategy;
    private final ErrorHandler errorHandler;
    private final int maxClaimAttempts;
    private final Subscription inboundSubscription;
    private final String agentNamePrefix;
    private final EpochClock clock;
    private final ReplayHandler replayHandler;
    private final ILink3RetransmitHandler iLink3RetransmitHandler;
    private final SenderSequenceNumbers senderSequenceNumbers;
    private final UtcTimestampEncoder utcTimestampEncoder;

    public Replayer(ReplayQuery outboundReplayQuery, ExclusivePublication publication, BufferClaim bufferClaim, IdleStrategy idleStrategy, ErrorHandler errorHandler, int maxClaimAttempts, Subscription inboundSubscription, String agentNamePrefix, EpochClock clock, Set<String> gapfillOnReplayMessageTypes, IntHashSet gapfillOnRetransmitILinkTemplateIds, ReplayHandler replayHandler, ILink3RetransmitHandler iLink3RetransmitHandler, SenderSequenceNumbers senderSequenceNumbers, FixSessionCodecsFactory fixSessionCodecsFactory, int maxBytesInBuffer, ReplayerCommandQueue replayerCommandQueue, EpochFractionFormat epochFractionFormat, AtomicCounter currentReplayCount, int maxConcurrentSessionReplays, EpochNanoClock nanoClock) {
        this.outboundReplayQuery = outboundReplayQuery;
        this.publication = publication;
        this.bufferClaim = bufferClaim;
        this.idleStrategy = idleStrategy;
        this.errorHandler = errorHandler;
        this.maxClaimAttempts = maxClaimAttempts;
        this.inboundSubscription = inboundSubscription;
        this.agentNamePrefix = agentNamePrefix;
        this.clock = clock;
        this.gapfillOnRetransmitILinkTemplateIds = gapfillOnRetransmitILinkTemplateIds;
        this.replayHandler = replayHandler;
        this.iLink3RetransmitHandler = iLink3RetransmitHandler;
        this.senderSequenceNumbers = senderSequenceNumbers;
        this.fixSessionCodecsFactory = fixSessionCodecsFactory;
        this.maxBytesInBuffer = maxBytesInBuffer;
        this.replayerCommandQueue = replayerCommandQueue;
        this.currentReplayCount = currentReplayCount;
        this.maxConcurrentSessionReplays = maxConcurrentSessionReplays;
        this.nanoClock = nanoClock;
        this.gapFillMessageTypes = new LongHashSet();
        gapfillOnReplayMessageTypes.forEach(messageTypeAsString -> this.gapFillMessageTypes.add(GenerationUtil.packMessageType((String)messageTypeAsString)));
        this.utcTimestampEncoder = new UtcTimestampEncoder(epochFractionFormat);
        this.iLink3Parser = new Lazy(() -> AbstractILink3Parser.make(null, (ErrorHandler)errorHandler));
        this.iLink3Proxy = new Lazy(() -> AbstractILink3Proxy.make((ExclusivePublication)publication, (ErrorHandler)errorHandler, (EpochNanoClock)nanoClock));
        this.iLink3Offsets = new Lazy(() -> AbstractILink3Offsets.make((ErrorHandler)errorHandler));
        this.nextTimestampMessageInNs = nanoClock.nanoTime() + this.nextTimestampMessageInNs;
        this.replayerTimestampEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.timestampBuffer, 0, this.messageHeaderEncoder);
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int start, int length, Header header) {
        this.messageHeader.wrap(buffer, start);
        int templateId = this.messageHeader.templateId();
        int offset = start + 8;
        int blockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        switch (templateId) {
            case 59: {
                this.validResendRequest.wrap(buffer, offset, blockLength, version);
                long sessionId = this.validResendRequest.session();
                long connectionId = this.validResendRequest.connection();
                long beginSeqNo = this.validResendRequest.beginSequenceNumber();
                long endSeqNo = this.validResendRequest.endSequenceNumber();
                int sequenceIndex = this.validResendRequest.sequenceIndex();
                this.validResendRequest.wrapBody((DirectBuffer)this.asciiBuffer);
                return this.onResendRequest(sessionId, connectionId, beginSeqNo, endSeqNo, sequenceIndex, this.asciiBuffer);
            }
            case 57: {
                this.iLinkConnect.wrap(buffer, offset, blockLength, version);
                this.iLinkConnectionIds.add(this.iLinkConnect.connection());
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            case 12: {
                this.requestDisconnect.wrap(buffer, offset, blockLength, version);
                long connectionId = this.requestDisconnect.connection();
                this.onDisconnect(connectionId);
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            case 7: {
                this.disconnect.wrap(buffer, offset, blockLength, version);
                long connectionId = this.disconnect.connection();
                this.onDisconnect(connectionId);
                return ControlledFragmentHandler.Action.CONTINUE;
            }
        }
        return this.fixSessionCodecsFactory.onFragment(buffer, start, length, header);
    }

    private void onDisconnect(long connectionId) {
        this.iLinkConnectionIds.remove(connectionId);
        ReplayChannel replayChannel = (ReplayChannel)this.connectionIdToReplayerChannel.remove(connectionId);
        if (replayChannel != null) {
            this.currentReplayCount.decrement();
            replayChannel.close();
        }
    }

    ControlledFragmentHandler.Action onResendRequest(long sessionId, long connectionId, long beginSeqNo, long endSeqNo, int sequenceIndex, AsciiBuffer asciiBuffer) {
        if (this.senderSequenceNumbers.hasDisconnected(connectionId)) {
            DebugLogger.log(LogTag.REPLAY, this.alreadyDisconnectedFormatter, connectionId);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        ReplayChannel replayChannel = (ReplayChannel)this.connectionIdToReplayerChannel.get(connectionId);
        if (replayChannel != null) {
            int enqueuedReplayCount = replayChannel.enqueuedReplayCount();
            if (enqueuedReplayCount >= this.maxConcurrentSessionReplays) {
                this.errorHandler.onError((Throwable)new FixGatewayException(String.format("Ignore resend request for sessionId=%d,connectionId=%d as %d requests in flight", sessionId, connectionId, enqueuedReplayCount)));
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            int length = asciiBuffer.capacity();
            MutableAsciiBuffer copiedBuffer = new MutableAsciiBuffer(new byte[length]);
            copiedBuffer.putBytes(0, (DirectBuffer)asciiBuffer, 0, length);
            replayChannel.enqueueReplay(new EnqueuedReplay(sessionId, connectionId, beginSeqNo, endSeqNo, sequenceIndex, (AsciiBuffer)copiedBuffer));
            return ControlledFragmentHandler.Action.COMMIT;
        }
        try {
            ReplayerSession session = this.processResendRequest(sessionId, connectionId, beginSeqNo, endSeqNo, sequenceIndex, asciiBuffer);
            if (session == null) {
                return ControlledFragmentHandler.Action.ABORT;
            }
            ReplayChannel channel = new ReplayChannel(session);
            this.connectionIdToReplayerChannel.put(connectionId, (Object)channel);
            this.currentReplayCount.increment();
            return ControlledFragmentHandler.Action.COMMIT;
        }
        catch (IllegalStateException e) {
            this.errorHandler.onError((Throwable)e);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
    }

    private ReplayerSession processResendRequest(long sessionId, long connectionId, long beginSeqNo, long endSeqNo, int sequenceIndex, AsciiBuffer asciiBuffer) {
        FixReplayerCodecs sessionCodecs = this.fixSessionCodecsFactory.get(sessionId);
        if (sessionCodecs != null) {
            return this.processFixResendRequest(sessionId, connectionId, (int)beginSeqNo, (int)endSeqNo, sequenceIndex, asciiBuffer, sessionCodecs);
        }
        if (this.iLinkConnectionIds.contains(connectionId)) {
            DebugLogger.log(LogTag.REPLAY, this.receivedResendFormatter, beginSeqNo, endSeqNo);
            ILinkReplayerSession session = new ILinkReplayerSession(connectionId, this.bufferClaim, this.idleStrategy, this.maxClaimAttempts, this.publication, this.outboundReplayQuery, (int)beginSeqNo, (int)endSeqNo, sessionId, this, this.gapfillOnRetransmitILinkTemplateIds, this.iLinkMessageEncoder, (AbstractILink3Parser)this.iLink3Parser.get(), (AbstractILink3Proxy)this.iLink3Proxy.get(), (AbstractILink3Offsets)this.iLink3Offsets.get(), this.iLink3RetransmitHandler, this.nanoClock);
            session.query();
            return session;
        }
        throw new IllegalStateException("Unknown session: sessionId=" + sessionId + ",connectionId=" + connectionId);
    }

    private FixReplayerSession processFixResendRequest(long sessionId, long connectionId, int beginSeqNo, int endSeqNo, int sequenceIndex, AsciiBuffer asciiBuffer, FixReplayerCodecs sessionCodecs) {
        AtomicCounter bytesInBuffer = this.senderSequenceNumbers.bytesInBufferCounter(connectionId);
        if (bytesInBuffer == null) {
            return null;
        }
        DebugLogger.log(LogTag.REPLAY, this.receivedResendFormatter, (long)beginSeqNo, (long)endSeqNo);
        AbstractResendRequestDecoder resendRequest = sessionCodecs.resendRequest();
        resendRequest.reset();
        resendRequest.decode(asciiBuffer, 0, asciiBuffer.capacity());
        GapFillEncoder encoder = sessionCodecs.makeGapFillEncoder();
        encoder.setupMessage(resendRequest.header());
        String message = asciiBuffer.getAscii(0, asciiBuffer.capacity());
        FixReplayerSession fixReplayerSession = new FixReplayerSession(this.bufferClaim, this.idleStrategy, this.replayHandler, this.maxClaimAttempts, this.gapFillMessageTypes, this.publication, this.clock, beginSeqNo, endSeqNo, connectionId, sessionId, sequenceIndex, this.outboundReplayQuery, message, this.errorHandler, encoder, bytesInBuffer, this.maxBytesInBuffer, this.utcTimestampEncoder, this);
        fixReplayerSession.query();
        return fixReplayerSession;
    }

    public int doWork() {
        this.sendTimestampMessage();
        int work = this.replayerCommandQueue.poll();
        return (work += this.pollReplayerChannels()) + this.inboundSubscription.controlledPoll((ControlledFragmentHandler)this, 10);
    }

    private void sendTimestampMessage() {
        long timeInNs = this.nanoClock.nanoTime();
        if (this.nextTimestampMessageInNs > timeInNs) {
            this.replayerTimestampEncoder.timestamp(timeInNs);
            long position = this.publication.offer((DirectBuffer)this.timestampBuffer);
            if (position > 0L) {
                this.nextTimestampMessageInNs = timeInNs + TIMESTAMP_MESSAGE_INTERVAL;
            }
        }
    }

    private int pollReplayerChannels() {
        Long2ObjectHashMap.EntryIterator replayerChannels = this.connectionIdToReplayerChannel.entrySet().iterator();
        int size = this.connectionIdToReplayerChannel.size();
        while (replayerChannels.hasNext()) {
            ReplayChannel channel = (ReplayChannel)replayerChannels.next().getValue();
            if (!channel.attemptReplay()) continue;
            EnqueuedReplay enqueuedReplay = channel.pollReplay();
            if (enqueuedReplay == null) {
                this.currentReplayCount.decrementOrdered();
                replayerChannels.remove();
                continue;
            }
            try {
                ReplayerSession session = this.processResendRequest(enqueuedReplay.sessionId(), enqueuedReplay.connectionId(), enqueuedReplay.beginSeqNo(), enqueuedReplay.endSeqNo(), enqueuedReplay.sequenceIndex(), enqueuedReplay.asciiBuffer());
                channel.startReplay(session);
            }
            catch (IllegalStateException e) {
                this.errorHandler.onError((Throwable)e);
            }
        }
        return size;
    }

    public void onClose() {
        this.connectionIdToReplayerChannel.values().forEach(ReplayChannel::close);
        this.connectionIdToReplayerChannel.clear();
        this.currentReplayCount.set(0L);
        this.currentReplayCount.close();
        this.publication.close();
        this.outboundReplayQuery.close();
    }

    public String roleName() {
        return this.agentNamePrefix + "Replayer";
    }
}

